/*	$NetBSD: mach_semaphore.h,v 1.7 2008/04/28 20:23:44 martin Exp $ */

/*-
 * Copyright (c) 2002-2003 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Emmanuel Dreyfus
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	_MACH_SEMAPHORE_H_
#define	_MACH_SEMAPHORE_H_

#include <sys/rwlock.h>
#include <sys/queue.h>

extern int mach_semaphore_cold;

struct mach_waiting_lwp {
	TAILQ_ENTRY(mach_waiting_lwp) mwl_list;
	struct lwp *mwl_l;
};

struct mach_semaphore {
	int ms_value;
	int ms_policy;
	LIST_ENTRY(mach_semaphore) ms_list;
	TAILQ_HEAD(ms_waiting, mach_waiting_lwp) ms_waiting;
	krwlock_t ms_lock;
};

/* semaphore_create */

#define MACH_SYNC_POLICY_FIFO 0
#define MACH_SYNC_POLICY_FIXED_PRIORITY 1

typedef struct {
	mach_msg_header_t req_msgh;
	mach_ndr_record_t req_ndr;
	int req_policy;
	int req_value;
} mach_semaphore_create_request_t;

typedef struct {
	mach_msg_header_t rep_msgh;
	mach_msg_body_t rep_body;
	mach_msg_port_descriptor_t rep_sem;
	mach_msg_trailer_t rep_trailer;
} mach_semaphore_create_reply_t;

/* semaphore_destroy */

typedef struct {
	mach_msg_header_t req_msgh;
	mach_msg_body_t req_body;
	mach_msg_port_descriptor_t req_sem;
} mach_semaphore_destroy_request_t;

typedef struct {
	mach_msg_header_t rep_msgh;
	mach_ndr_record_t rep_ndr;
	mach_kern_return_t rep_retval;
	mach_msg_trailer_t rep_trailer;
} mach_semaphore_destroy_reply_t;

void mach_semaphore_init(void);
void mach_semaphore_cleanup(struct lwp *);

#endif /* _MACH_SEMAPHORE_H_ */

