| file: putimage.S
| author: Yasha(itohy@NetBSD.org)
|
| $NetBSD: putimage.S,v 1.3 2005/12/11 12:19:45 christos Exp $

#include <machine/asm.h>
#include "iocscall.h"

# define IMGWIDTH	56
# define IMGHEIGHT	52
|
|	display title image
|
ENTRY_NOPROFILE(put_image)
		link	%a6,#-(IMGWIDTH*IMGHEIGHT/8*2+8)| make local buffer
		moveal	%sp,%a1				| buffer (plane #0) top
		moveml	%d2-%d7/%a2-%a4,%sp@-

		lea	%a1@(IMGWIDTH*IMGHEIGHT/8+4),%a4| buffer (plane #1) top
		movel	#IMGWIDTH*0x10000+IMGHEIGHT,%a1@| image size
		movel	%a1@+,%a4@+

		lea	%pc@(img_title),%a2
		moveaw	%a2@+,%a3		| only the lower word is valid

1:		tstb	%a2@+			| skip human readable comment
		jne	1b
		lea	%a2@(4),%a0		| image data here

		moveq	#0,%d2			| (b) now have 0bit
		moveq	#0,%d3			| (w) input bit buffer

		moveq	#16,%d4			| (b) output bit count
		moveq	#IMGWIDTH*IMGHEIGHT/16+0xffffff00,%d7

		| d2.b: # bits in input buffer
		| d3.w: input buffer
		| d4.b: # bits in output buffer
		| d5.w: output buffer for plane 0
		| d6.w: output buffer for plane 1
		| d7.b: size count
		| a0: input data pointer

Lrunlen:	| a run entry:
		|	value	 (2bit)
		|	length-1 (3bit)
		subqb	#5,%d2		| have enough bits?
		jcc	Lhave5b		| yes
		| fill byte
		cmpaw	%a0,%a3		| the register order is significant
					| for word comparison
		beq	Lrxabort
1:		moveb	%a0@+,%d0
		addqb	#8,%d2		| d2: 3: have 0bit, ..., 7: have 4bit
		lslw	#8,%d0		| clear unused bits
		lsrw	%d2,%d0
		orw	%d0,%d3

Lhave5b:	| field# 19 20 21 22 23 24 25 26 27 28 29 30 31
		| d3: ... v  v  l  l  l  ?  ?  ?  ?  ?  ?  ?  0
		bfexts	%d3{#19,#2},%d0	| value
		bfextu	%d3{#21,#3},%d1	| length - 1
		lslw	#5,%d3

Lrxloop:	lslw	#2,%d6
		bfins	%d0,%d6{#30,#2}
		roxrw	#1,%d6
		roxlw	#1,%d5
		subqb	#1,%d4
		jne	1f
		moveq	#16,%d4
		movew	%d5,%a1@+
		movew	%d6,%a4@+
		subqb	#1,%d7		| end?
1:		dbeq	%d1,Lrxloop	| fall down if end
		jne	Lrunlen		| fall down if end

		moveq	#1,%d1
		movew	%a2@+,%d2
		IOCS(__TPALET2)
		moveq	#2,%d1
		movew	%a2@,%d2
		IOCS(__TPALET2)

|		moveq	#0x02,%d1	| plane 1 (already have it)
		IOCS(__TCOLOR)
		movel	%a6@(8),%d1
		movel	%a6@(12),%d2
		IOCS(__TEXTPUT)
		moveq	#0x01,%d1	| plane 0
		IOCS(__TCOLOR)
		movel	%a6@(8),%d1
		lea	%a6@(-(IMGWIDTH*IMGHEIGHT/8*2+8)),%a1
		IOCS(__TEXTPUT)

Lrxabort:	moveml	%sp@+,%d2-%d7/%a2-%a4
		unlk	%a6
		rts

img_title:
	.word	imgend1
	| compressed image data

	| BSD Daemon Image, used for NetBSD boot by permission.
	| (Thanks for permission!)

	| BSD Daemon Copyright 1988 by Marshall Kirk McKusick.
	| All Rights Reserved.
	|
	| Permission to use the daemon may be obtained from:
	|     Marshall Kirk McKusick
	|     1614 Oxford St
	|     Berkeley, CA 94709-1608
	|     USA
	| or via email at mckusick@mckusick.com

	| Human readable copyright notice to be found with strings(1).
	| Terminate with a nul character.

	.asciz	"\nBSD Daemon Copyright 1988 by Marshall Kirk McKusick."

	.word	0x5295,0xAD6A		| palet1, palet2
	.word	0x39c3,0x0c1c,0xd039,0xce71,0xa327,0x3830,0x739c,0xe146
	.word	0x6073,0x8227,0x39ce,0x0865,0x0738,0x2184,0x1ce7,0x3233
	.word	0x049c,0xe88a,0x0e73,0x9618,0x8271,0x0486,0x6646,0x2093
	.word	0x9ce4,0xcc12,0x1461,0x1622,0x3104,0x9ce7,0x2653,0x10e2
	.word	0x4158,0x91a8,0x24e7,0x38d1,0x9807,0x00c8,0x7216,0x6a29
	.word	0x39ce,0x4440,0x1906,0x4190,0xe031,0xe452,0x739c,0x9006
	.word	0x8180,0xec18,0x0221,0xc8a0,0xe739,0xb60c,0x0380,0xdc35
	.word	0x149c,0xe724,0x01b0,0x601d,0x062c,0x939c,0xe6c8,0x700c
	.word	0x0b60,0xcc58,0x739c,0xf81e,0x09a0,0x6a49,0x39ce,0x6803
	.word	0x00c0,0x701c,0x0740,0xd4d0,0x739c,0xd806,0x0100,0xe038
	.word	0x0e81,0xb924,0xe726,0x0d0c,0x20e2,0xc839,0x249c,0xe4c4
	.word	0x0ba4,0x0b42,0xc811,0xc920,0xe73c,0x070e,0x0383,0x44b5
	.word	0x241c,0xe3c8,0x6228,0x701b,0x023f,0x8924,0xe726,0x0501
	.word	0xc301,0xc8d3,0xfc49,0x0739,0xa01c,0x1219,0x0fc9,0x8924
	.word	0xe716,0x2028,0x64a8,0xc441,0xc147,0x3249,0xce4c,0x0e38
	.word	0x2a24,0x58ea,0x4939,0xcd00,0xe208,0x860a,0x8bea,0x0c39
	.word	0xce09,0x0608,0x8e10,0x3449,0x1aa2,0x4e73,0x9d3a,0x4111
	.word	0xfc45,0x2739,0xcb0c,0xa308,0x0205,0x0fea,0x2939,0xce4d
	.word	0x2030,0x4823,0xfdc1,0x4739,0xc68c,0x4100,0x4490,0x0c8f
	.word	0x70cc,0x5473,0x9ce0,0x8a22,0x1866,0x078a,0x4e72,0x6c7b
	.word	0x0260,0x9e03,0xc148,0x780f,0xc090,0xc970,0x04c5,0x5c06
	.word	0x45a1,0x641a,0x0e47,0xa1ec,0x7903,0xd03c,0x8310,0x0643
	.word	0x91e0,0x3926,0x47b1,0xe408,0x3e05,0x9044,0x190e,0x4780
	.word	0xe49a,0x0c38,0x2c1c,0x390e,0x8100,0x683a,0x2689,0xa0c3
	.word	0x00d0,0x722d,0x0780,0xc8b4,0x2d8f,0x25d0,0x721c,0x8720
	.word	0xc872,0x1c8b,0xa5d8,0xb25d,0x0721,0xd032,0x0c87,0x21c8
	.word	0xb22c,0x8141,0xd872,0x5c86,0x1916,0xc190,0xe43a,0x0e81
	.word	0x0403,0x2188,0x740d,0x1341,0xc8f6,0x0d8f,0x22d0,0x220c
	.word	0x8300,0x9032,0x0c97,0x300e,0x49a0,0x6478,0x0645,0x91e8
	.word	0x1816,0x0190,0x647b,0x1649,0x90e8,0x380e,0x4180,0x645a
	.word	0x0e83,0x90e4,0x3b1e,0xc981,0x6c79,0x07c5,0xd0f8,0x2939
	.word	0xc523,0x8946,0x820d,0x0c45,0x070f,0x6192,0xde08,0x3832
	.word	0x0572,0x083c,0x3920,0x721a,0x9ac8,0x8868,0xf889,0xc160
	.word	0x4377,0x8a84,0x88ee,0xd891,0xc2b0,0x2200,0xb2a2,0xa1c3
	.word	0x10dc,0x1564,0x1ce3,0x79c6,0x9022,0x2258,0x1073,0x9ce7
	.word	0x2a20,0x701c
	.even
imgend1:
