/*	$NetBSD: bebox_bootrec.h,v 1.2 2008/05/24 17:34:03 kiyohara Exp $	*/

#define	BEBOX_HEADER_SIZE		0x6400
#define	BEBOX_BLOCK_SIZE		0x200
#define	BEBOX_FILE_BLOCK_SIZE		0x100
#define	BEBOX_FILE_SIZE_OFFSET	0x00004494
#define	BEBOX_FILE_SIZE_ALIGN_OFFSET	0x00004498
#define	BEBOX_FILE_BLOCK_MAP_START	0x00000200
#define	BEBOX_FILE_BLOCK_MAP_END	0x00000368

u_char bebox_image_data0[] = {
	0x00, 0x03, 0x00, 0x00, 0xde, 0xad, 0xbe, 0xef,	/* mtime */
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0b, 0x40,	/* avail size */
	0x00, 0x00, 0x02, 0x00, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x0b, 0x40,	/* used block */
	0x01, 0x00, 0x00, 0x00, 0x66, 0x64, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x41, 0xc0,
	0xbe, 0x00, 0xbe, 0x01, 0xbe, 0x02, 0xbe, 0x03,
	0xbe, 0x04, 0xbe, 0x05, 0xbe, 0x06, 0xbe, 0x07,
	0xbe, 0x08, 0xbe, 0x09, 0xbe, 0x0a, 0xbe, 0x0b,
	0xbe, 0x0c, 0xbe, 0x0d, 0xbe, 0x0e, 0xbe, 0x0f,
	0xbe, 0x10, 0xbe, 0x11, 0xbe, 0x12, 0xbe, 0x13,
	0xbe, 0x14, 0xbe, 0x15, 0xbe, 0x16, 0xbe, 0x17,
	0xbe, 0x18, 0xbe, 0x19, 0xbe, 0x1a, 0xbe, 0x1b,
	0xbe, 0x1c, 0xbe, 0x1d, 0xbe, 0x1e, 0xbe, 0x1f,
	0xbe, 0x20, 0xbe, 0x21, 0xbe, 0x22, 0xbe, 0x23,
	0xbe, 0x24, 0xbe, 0x25, 0xbe, 0x26, 0xbe, 0x27,
	0xbe, 0x28, 0xbe, 0x29, 0xbe, 0x2a, 0xbe, 0x2b,
	0xbe, 0x2c, 0xbe, 0x2d, 0xbe, 0x2e, 0xbe, 0x2f,
	0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x33,
	0xbe, 0x34, 0xbe, 0x35, 0xbe, 0x36, 0xbe, 0x37,
	0xbe, 0x38, 0xbe, 0x39, 0xbe, 0x3a, 0xbe, 0x3b,
	0xbe, 0x3c, 0xbe, 0x3d, 0xbe, 0x3e, 0xbe, 0x3f,
	0xbe, 0x40, 0xbe, 0x41, 0xbe, 0x42, 0xbe, 0x43,
	0xbe, 0x44, 0xbe, 0x45, 0xbe, 0x46, 0xbe, 0x47,
	0xbe, 0x48, 0xbe, 0x49, 0xbe, 0x4a, 0xbe, 0x4b,
	0xbe, 0x4c, 0xbe, 0x4d, 0xbe, 0x4e, 0xbe, 0x4f,
	0xbe, 0x50, 0xbe, 0x51, 0xbe, 0x52, 0xbe, 0x53,
	0xbe, 0x54, 0xbe, 0x55, 0xbe, 0x56, 0xbe, 0x57,
	0xbe, 0x58, 0xbe, 0x59, 0xbe, 0x5a, 0xbe, 0x5b,
	0xbe, 0x5c, 0xbe, 0x5d, 0xbe, 0x5e, 0xbe, 0x5f,
	0xbe, 0x60, 0xbe, 0x61, 0xbe, 0x62, 0xbe, 0x63,
	0xbe, 0x64, 0xbe, 0x65, 0xbe, 0x66, 0xbe, 0x67,
	0xbe, 0x68, 0xbe, 0x69, 0xbe, 0x6a, 0xbe, 0x6b,
	0xbe, 0x6c, 0xbe, 0x6d, 0xbe, 0x6e, 0xbe, 0x6f,
	0xbe, 0x70, 0xbe, 0x71, 0xbe, 0x72, 0xbe, 0x73,
	0xbe, 0x74, 0xbe, 0x75, 0xbe, 0x76, 0xbe, 0x77,
	0xbe, 0x78, 0xbe, 0x79, 0xbe, 0x7a, 0xbe, 0x7b,
	0xbe, 0x7c, 0xbe, 0x7d, 0xbe, 0x7e, 0xbe, 0x7f,
	0xbe, 0x80, 0xbe, 0x81, 0xbe, 0x82, 0xbe, 0x83,
	0xbe, 0x84, 0xbe, 0x85, 0xbe, 0x86, 0xbe, 0x87,
	0xbe, 0x88, 0xbe, 0x89, 0xbe, 0x8a, 0xbe, 0x8b,
	0xbe, 0x8c, 0xbe, 0x8d, 0xbe, 0x8e, 0xbe, 0x8f,
	0xbe, 0x90, 0xbe, 0x91, 0xbe, 0x92, 0xbe, 0x93,
	0xbe, 0x94, 0xbe, 0x95, 0xbe, 0x96, 0xbe, 0x97,
	0xbe, 0x98, 0xbe, 0x99, 0xbe, 0x9a, 0xbe, 0x9b,
	0xbe, 0x9c, 0xbe, 0x9d, 0xbe, 0x9e, 0xbe, 0x9f,
	0xbe, 0xa0, 0xbe, 0xa1, 0xbe, 0xa2, 0xbe, 0xa3,
	0xbe, 0xa4, 0xbe, 0xa5, 0xbe, 0xa6, 0xbe, 0xa7,
	0xbe, 0xa8, 0xbe, 0xa9, 0xbe, 0xaa, 0xbe, 0xab,
	0xbe, 0xac, 0xbe, 0xad, 0xbe, 0xae, 0xbe, 0xaf,
	0xbe, 0xb0, 0xbe, 0xb1, 0xbe, 0xb2, 0xbe, 0xb3,
	0xbe, 0xb4, 0xbe, 0xb5, 0xbe, 0xb6, 0xbe, 0xb7,
	0xbe, 0xb8, 0xbe, 0xb9, 0xbe, 0xba, 0xbe, 0xbb,
	0xbe, 0xbc, 0xbe, 0xbd, 0xbe, 0xbe, 0xbe, 0xbf,
	0xbe, 0xc0, 0xbe, 0xc1, 0xbe, 0xc2, 0xbe, 0xc3,
	0xbe, 0xc4, 0xbe, 0xc5, 0xbe, 0xc6, 0xbe, 0xc7,
	0xbe, 0xc8, 0xbe, 0xc9, 0xbe, 0xca, 0xbe, 0xcb,
	0xbe, 0xcc, 0xbe, 0xcd, 0xbe, 0xce, 0xbe, 0xcf,
	0xbe, 0xd0, 0xbe, 0xd1, 0xbe, 0xd2, 0xbe, 0xd3,
};

u_char bebox_image_data1[] = {
	0x54, 0x72, 0x61, 0x73, 0x68, 0x00, 0x00, 0x00,
};

u_char bebox_image_data2[] = {
	0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xde, 0xad, 0xbe, 0xef,	/* mtime */
	0xde, 0xad, 0xbe, 0xef, 0x00, 0x00, 0x00, 0x00, /* mtime */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x41, 0xff,
};

u_char bebox_image_data3[] = {
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x00, 0x00,
};

u_char bebox_image_data4[] = {
	0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xde, 0xad, 0xbe, 0xef,	/* mtime */
	0xde, 0xad, 0xbe, 0xef, 0x00, 0x00, 0x00, 0x00,	/* mtime */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x41, 0xff,
};

u_char bebox_image_data5[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
};

u_char bebox_image_data6[] = {
	0x00, 0x72, 0x61, 0x73, 0x68, 0x00, 0x00, 0x00,
};

u_char bebox_image_data7[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xff,
};

u_char bebox_image_data8[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
};

u_char bebox_image_data9[] = {
	0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x00, 0x00,
};

u_char bebox_image_data10[] = {
	0x80, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x65,
	0x00, 0x00, 0x00, 0x00, 0xde, 0xad, 0xbe, 0xef,	/* mtime */
	0xde, 0xad, 0xbe, 0xef, 0xde, 0xad, 0xbe, 0xef,	/* mtime/filesize */
	0xde, 0xea, 0xbe, 0xef, 0x00, 0x00, 0x00, 0x00,	/* filesize(aligned) */
	0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x81, 0xb6,
};

u_char bebox_image_data11[] = {
	0x00, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x00, 0x00,
};

u_char bebox_image_data12[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xff,
};

struct bebox_image_block {
	long offset;
	u_char *data;
	int size;
};

#define	BEBOX_IMG(x)		__CONCAT(bebox_image_data,x)
#define	BEBOX_IMG_DATA_SIZE(x)	BEBOX_IMG(x), \
    (sizeof (BEBOX_IMG(x)) / sizeof (BEBOX_IMG(x)[0]))

struct bebox_image_block bebox_image_block[] = {
	{ 0x00000000, BEBOX_IMG_DATA_SIZE(0) },
	{ 0x00000440, BEBOX_IMG_DATA_SIZE(1) },
	{ 0x00000480, BEBOX_IMG_DATA_SIZE(2) },
	{ 0x000004c0, BEBOX_IMG_DATA_SIZE(3) },
	{ 0x00000500, BEBOX_IMG_DATA_SIZE(4) },
	{ 0x00002400, BEBOX_IMG_DATA_SIZE(5) },
	{ 0x00002440, BEBOX_IMG_DATA_SIZE(6) },
	{ 0x000024a0, BEBOX_IMG_DATA_SIZE(7) },
	{ 0x00004400, BEBOX_IMG_DATA_SIZE(8) },
	{ 0x00004440, BEBOX_IMG_DATA_SIZE(9) },
	{ 0x00004480, BEBOX_IMG_DATA_SIZE(10) },
	{ 0x000044c0, BEBOX_IMG_DATA_SIZE(11) },
	{ 0x00004520, BEBOX_IMG_DATA_SIZE(12) },
	{ -1 }
};

long bebox_mtime_offset[] = {
	0x00000004,
	0x0000048c,
	0x00000490,
	0x0000050c,
	0x00000510,
	0x0000448c,
	0x00004490,
	-1
};
