/* $NetBSD: extern.h,v 1.1 2009/03/23 21:03:56 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _FSU_CONSOLE_EXTERN_H_
#define _FSU_CONSOLE_EXTERN_H_

struct ukfs;

typedef struct command_s {
        const char *c_name;
	const char *c_help;
        int (*c_fun)(int, char **);
} command_t;

typedef struct alias_s {
	struct alias_s *al_next;
	char *al_name;
	char *al_args;
	int al_argc;
	char **al_argv;
} alias_t;

int fsu_alias_main(int, char **);
int fsu_cd_main(int, char **);
int fsu_exit_main(int, char **);
int fsu_help_main(int, char **);
int fsu_pwd_main(int, char **);
int fsu_umask_main(int, char **);
int fsu_unalias_main(int, char **);

#endif /* !_FSU_CONSOLE_EXTERN_H_ */
