/* $Id: fsu_dir.h,v 1.2 2008/09/04 16:09:47 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _FSU_DIR_H_
#define _FSU_DIR_H_

struct ukfs;

typedef struct {
	struct ukfs *dd_ukfs;
	char *dd_path;		/* dirname */
	uint8_t dd_buf[8192];	/* current buffer */
	off_t dd_off;		/* position in the directory */
	int dd_size;		/* size returned by last ukfs_getdents */
	struct dirent *dd_dent; /* current dir entry */
} FSU_DIR;

FSU_DIR		*fsu_opendir(struct ukfs *, const char *);
struct dirent	*fsu_readdir(FSU_DIR *);
void		fsu_closedir(FSU_DIR *);
void		fsu_rewinddir(FSU_DIR *);
char		*fsu_getcwd(struct ukfs *);

#endif /* !_FSU_DIR_H_ */
