/* $Id: fsu_find.c,v 1.5 2008/09/23 16:20:41 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <dirent.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <rump/ukfs.h>

#include <fsu_fts.h>

#ifndef FSU_CONSOLE
#include <fsu_mount.h>

static struct ukfs *ukfs;

static void	unmount_ukfs(void);
#else /* !FSU_CONSOLE */

#define main(a, b) fsu_find_main(struct ukfs *ukfs, a, b)

int fsu_find_main(struct ukfs *, int, char *[]);
#endif /* !FSU_CONSOLE */

static int	fsu_find(struct ukfs *, const char *, const char *);
static void	usage(char *);

int
main(int argc, char *argv[])
{
	char *comname;

	comname = argv[0];
	setprogname(argv[0]);

#ifndef FSU_CONSOLE
	if (argc < 2)
		usage(comname);

	ukfs = fsu_mount(&argc, &argv, NULL, NULL);
	if (ukfs == NULL) {
		warn("fsu_mount");
		usage(comname);
		/* NOTREACHED */
	}
	atexit(unmount_ukfs);
#endif

	if (argc != 2 && argc != 3) {
		usage(comname);
		return -1;
	}

	if (argc == 2)
		return fsu_find(ukfs, ".", argv[1]);
	else
		return fsu_find(ukfs, argv[1], argv[2]);
}

static int
fsu_find(struct ukfs *fs, const char *dname, const char *fname)
{
	FSU_FTS *ftsp;
	FSU_FTSENT *cur;
	char *const fts_arg[] = {
		strdup(dname), NULL
	};

	ftsp = fsu_fts_open(fs, fts_arg, FTS_LOGICAL, NULL);
	if (ftsp == NULL)
		return -1;

	while ((cur = fsu_fts_read(ftsp)) != NULL) {
		if (cur->fts_info ==  FTS_DP)
			continue;
		if (strcmp(cur->fts_name, fname) == 0)
			printf("%s\n", cur->fts_accpath);
	}
	fsu_fts_close(ftsp);
	free(fts_arg[0]);
	return 0;
}

static void
usage(char *progname)
{

#ifdef FSU_CONSOLE
	fprintf(stderr, "usage: %s [dirname] filename\n", progname);
#else
	fprintf(stderr,
	 "usage: %s [MNT_OPTIONS] [fstype] fsdevice [dirname] filename\n",
		getprogname());
	exit(EXIT_FAILURE);
#endif
}

#ifndef FSU_CONSOLE
void
unmount_ukfs(void)
{
	
	ukfs_release(ukfs, 0);
}
#endif
