/* $Id: lkminit_launder_netbsd.c,v 1.1.1.1 1999/01/22 03:32:43 proff Exp $
 * $Copyright:$
 */

#include "kernel_netbsd.h"
#include "launder_netbsd.h"

#define NLAUNDER 8

#if NLAUNDER < 1
#  error NLAUNDER < 1. Why bother?
#endif

/* we `should' use MOD_DEV etc, but the MOD_FOO lkm api, is in my view
 * the work of engineering psychopathy, and should be depreciated */

MOD_MISC ("launder_mod");

static int launder_cmaj = 0;

cdev_decl(launder);

static struct cdevsw launder_cdevsw = cdev_disk_init(1, launder), launder_cdevsw_old;

static int launder_load()
{
    int i;
    printf("launder: loading\n");
    for (i=0; i<nchrdev; i++)
	if (cdevsw[i].d_open == (dev_type_open((*)))lkmenodev)
	    {
		launder_cmaj = i;
		break;
	    }
    if (launder_cmaj == 0)
	{
	    printf("launder: No free cdevsw slots\n");
	    return ENODEV;
	}
    printf("launder: loading into character device slots %d\n", launder_cmaj);

    launder_cdevsw_old = cdevsw[launder_cmaj];
    cdevsw[launder_cmaj] = launder_cdevsw;
    launderattach(NLAUNDER);
    return 0;
}

static int launder_unload()
{
    
    printf("launder: unloading from cdevsw slot %d\n", launder_cmaj);
    /* we chould just zero out these slots with bdev_notdef() but restoring the slots to
       their original values should survive kernel future-rot a little better */
    cdevsw[launder_cmaj] = launder_cdevsw_old;
    launderdetach();
    launder_cmaj = 0;
    return 0;
}
 
/* give launder a little action */
static int launder_action(struct lkm_table *lkmtp, int cmd)
{
    int err = 0;
    switch (cmd)
	{
	case LKM_E_LOAD:
	    if (lkmexists(lkmtp))
		err = EEXIST;
	    else
		err = launder_load();
	    break;
	case LKM_E_UNLOAD:
	    err = launder_unload();
	    break;
	case LKM_E_STAT:
	    err = EIO;
	    break;
	}
    return err;
}

int
launder_lkmentry(struct lkm_table *lkmtp, int cmd, int ver)
{
    if (ver != LKM_VERSION)
	return EINVAL;
    DISPATCH(lkmtp, cmd, ver, launder_action, launder_action, launder_action);
}
