#include "standard.h"
#include "network.h"
#include "assert.h"

static void
usage(char **argv)
{
    fprintf(stderr, "usage: %s [-lu] [-b blocks] [-h host] [-p port] [-s packet_size]\n",
	    argv[0]);
    fprintf(stderr, "\n
-b blocks\n\
-l             listen mode\n\
-h host        host to connect to / interface to bind to\n\
-p port\n\
-s packet_size\n\
-u             udp mode\n");
    exit(1);
}

int
main(int argc, char **argv)
{
    int c;
    int opt_size = 128*1024;
    int opt_blocks = 10;
    char *opt_host = "localhost";
    int opt_port = 6666;
    int opt_udp = FALSE;

    int sock;
    struct sockaddr_in in;
    struct hostent *h;
	
    bool opt_listen = FALSE;
    while ((c = getopt(argc, argv, "b:h:lp:s:u")) != -1)
	switch(c)
	    {
	    case 'b':
		opt_blocks = atoi(optarg);
		break;
	    case 'h':
		opt_host = optarg;
		break;
	    case 'l':
		opt_listen = TRUE;
		break;
	    case 's':
		opt_size = atoi(optarg);
		break;
	    case 'u':
		opt_udp = TRUE;
		break;
	    default:
		usage(argv);
		NOTREACHED;
	    }
    sock = socket(AF_INET, opt_udp? SOCK_DGRAM: SOCK_STREAM, 0);
    if (sock<0)
	err(1, "socket");
    h = gethostbyname(opt_host);
    if (!h)
	err(1, opt_host);
    bzero(&in, sizeof in);
    in.sin_family = AF_INET;
    in.sin_addr = *(struct in_addr*)h->h_addr_list[0];
    in.sin_port = htons(opt_port);
    if (opt_listen)
	{
	    int fd;
	    int in_len = sizeof(in);
	    if (bind(sock, (struct sockaddr*)&in, sizeof in) != 0)
		err(1, "bind");
	    if (!opt_udp && listen(sock, 5) !=0)
		err(1, "listen");
	    while (opt_udp || (fd=accept(sock, (struct sockaddr*)&in, &in_len))>=0)
		{
		    if (!opt_udp)
			fprintf(stderr, "connect on fd %d %s:%d\n", sock, inet_ntoa(in.sin_addr), ntohs(in.sin_port));
		    do
			{
			    char buf[opt_size];
			    int cc = read(fd, buf, opt_size);
			    if (cc<0)
				err(1, "read");
			    if (cc == 0)
				break;
			}
		    while (1);
		    close(fd);
		}
	}
    else
	{
	    int bn;
	    struct timeval tv, tv2;
	    double secs;
	    if (connect(sock, (struct sockaddr*)&in, sizeof in) != 0)
		err(1, "connect");
	    gettimeofday(&tv, NULL);
	    for (bn=0; bn<opt_blocks; bn++)
		{
		    char buf[opt_size];
		    if (write(sock, buf, opt_size)!= opt_size)
			err(1, "write");
		}
	    close(sock);
	    gettimeofday(&tv2, NULL);
	    secs = (tv2.tv_sec - tv.tv_sec) +
		(tv2.tv_usec - tv.tv_usec)/1000000.0;
	    printf("%f Kb/s\n", (opt_size * opt_blocks) / 1024.0 / secs);
	}    
    exit(0);
}
