#!/bin/sh
# $Id: stop-pgsql-node.sh,v 1.1 2014/04/10 08:42:18 asau Exp asau $
set -e

usage="usage: ${0##*/} [root]"

while getopts "" opt; do
    case $opt in
	\?) echo "$usage" 1>&2; exit 1;;
    esac
done
shift $(expr $OPTIND - 1)

if [ $# -gt 1 ]; then echo "$usage" 1>&2; exit 1; fi

JAIL="$1"

: ${JAILNAME:=test}
: ${JAILBASE:=/usr/jail}
: ${JAIL:=${JAILBASE}/${JAILNAME}}

chroot "${JAIL}" /usr/pkg/share/examples/rc.d/pgsql onestop
stop-root "${JAIL}"
