#!/bin/sh
# $Id: create-pgsql-node.sh,v 1.1 2014/04/10 08:42:18 asau Exp asau $
set -e

usage="usage: ${0##*/} [root]"

while getopts "" opt; do
    case $opt in
	\?) echo "$usage" 1>&2; exit 1;;
    esac
done
shift $(expr $OPTIND - 1)

if [ $# -gt 1 ]; then echo "$usage" 1>&2; exit 1; fi

JAIL="$1"

: ${JAILNAME:=test}
: ${JAILBASE:=/usr/jail}
: ${JAIL:=${JAILBASE}/${JAILNAME}}

create-root "${JAIL}"
pkg_add -P "${JAIL}" postgresql91-server
chroot "${JAIL}" /bin/sh -c "pw useradd -n pgsql -d /var/pgsql"
