#!/bin/sh
# $Id: pbulk-root.sh,v 2.5 2014/04/09 09:16:42 asau Exp $
set -e

usage="usage: ${0##*/} [-n] [-c mk.conf.fragment] [-l packages.list]"

while getopts "c:nl:" opt; do
    case $opt in
	c) mk_fragment="${OPTARG}";;
	n) native=yes;;
	l) limited_list="${OPTARG}";;
	\?) echo "$usage" 1>&2; exit 1;;
    esac
done
shift $(expr $OPTIND - 1)

if [ $# != 0 ]; then echo "$usage" 1>&2; exit 1; fi

: ${JAILNAME:=pbulk}
: ${JAILBASE:=/usr/jail}
: ${JAIL:=${JAILBASE}/${JAILNAME}}

if [ ! -x ${JAIL}/usr/pbulk/bin/bulkbuild ]; then
if [ ! -x ${JAIL}/bin/sh ]; then
create-root ${JAIL}
fi
cp pbulk.sh ${JAIL}/root/pbulk.sh
if [ -n "$mk_fragment" ]; then cp "$mk_fragment" ${JAIL}/root/mk.conf.frag; fi
(cd ${JAIL}/usr/ && cvs -Q -z3 -d anoncvs@anoncvs.netbsd.org:/cvsroot get -P pkgsrc)
cp /etc/resolv.conf ${JAIL}/etc/resolv.conf
start-root ${JAIL}
chroot ${JAIL} /bin/sh /root/pbulk.sh ${native:+-n} ${limited_list:+-l} ${mk_fragment:+-c /root/mk.conf.frag}
if [ -n "$limited_list" ]; then cat "$limited_list" > ${JAIL}/usr/pbulk/etc/pbulk.list; fi
else
if [ -n "$limited_list" ]; then cat "$limited_list" > ${JAIL}/usr/pbulk/etc/pbulk.list; fi
cp /etc/resolv.conf ${JAIL}/etc/resolv.conf
start-root ${JAIL}
fi
(set +e; unset TMP; unset TEMP; unset TMPDIR; set -e; exec chroot ${JAIL} /usr/pbulk/bin/bulkbuild) ||:
stop-root ${JAIL}
