#!/bin/sh
set -e
image="${1:?image not found}" # openSUSE-13.1-DVD-i586.iso
setsdir="${2:-$(pwd)}" # path to a directory to populate

dev=$(mdconfig -a -t vnode "${image}")
mnt=${TMPDIR:-/tmp}/opensuse-dvd.$$
mkdir "${mnt}"
mount -t cd9660 /dev/"${dev}" "${mnt}"
mkdir -p "${setsdir}"
(cd "${mnt}"/images && pax -vrw . "${setsdir}")
umount "${mnt}"
rmdir "${mnt}"
mdconfig -d -u "${dev}"
