/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Steps {
    private static final Logger LOG = Logger.getLogger(Steps.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("Steps");
    private static Steps instance = null;

    public static synchronized Steps getDefault() {
        if (instance == null) {
            instance = new Steps();
        }
        return instance;
    }

    public CompletableFuture<Values> executeMultistep(AbstractStep firstStep, Lookup lookup) {
        DialogDisplayer dd = DialogDisplayer.getDefault();
        CompletableFuture<Values> future = new CompletableFuture<Values>();
        RP.post(() -> {
            try {
                Multistep multistep = new Multistep(firstStep, lookup);
                NotifyDescriptor.ComposedInput ci = new NotifyDescriptor.ComposedInput(Bundle.AddSuggestedItem(), 3, multistep.createInput());
                dd.notifyFuture((NotifyDescriptor)ci).handle((result, exception) -> {
                    if (exception != null) {
                        future.completeExceptionally((Throwable)exception);
                    } else {
                        future.complete(multistep.getResult());
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static <T extends OCIItem> NotifyDescriptor.QuickPick createQuickPick(Map<String, T> ociItems, String title) {
        ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>();
        for (Map.Entry<String, T> entry : ociItems.entrySet()) {
            String description = ((OCIItem)entry.getValue()).getDescription();
            if (description == null || description.isBlank()) {
                description = ((OCIItem)entry.getValue()).getName();
            }
            items.add(new NotifyDescriptor.QuickPick.Item(entry.getKey(), description));
        }
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    private static class Multistep {
        private final LinkedList<AbstractStep> steps = new LinkedList();
        private final Lookup lookup;
        private final Values values;

        Multistep(AbstractStep firstStep, Lookup lookup) {
            this.steps.add(firstStep);
            this.values = new MultistepValues(this.steps);
            this.lookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.values}), lookup});
        }

        NotifyDescriptor.ComposedInput.Callback createInput() {
            return new NotifyDescriptor.ComposedInput.Callback(){
                private int lastNumber = 0;

                private void readValue(AbstractStep step, NotifyDescriptor desc) {
                    String selected = null;
                    if (!step.onlyOneChoice()) {
                        if (desc instanceof NotifyDescriptor.QuickPick) {
                            for (NotifyDescriptor.QuickPick.Item item : ((NotifyDescriptor.QuickPick)desc).getItems()) {
                                if (!item.isSelected()) continue;
                                selected = item.getLabel();
                                break;
                            }
                        } else if (desc instanceof NotifyDescriptor.InputLine) {
                            selected = ((NotifyDescriptor.InputLine)desc).getInputText();
                        }
                        step.setValue(selected);
                    }
                }

                public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                    if (number == 1) {
                        while (steps.size() > 1) {
                            steps.removeLast();
                        }
                        this.prepare(steps.getLast());
                    } else {
                        if (this.lastNumber > number) {
                            steps.removeLast();
                            while (steps.getLast().onlyOneChoice() && steps.size() > 1) {
                                steps.removeLast();
                            }
                            this.lastNumber = number;
                            return steps.getLast().createInput();
                        }
                        this.readValue(steps.getLast(), input.getInputs()[number - 2]);
                        steps.add(this.getNextFor(steps.getLast()));
                    }
                    this.lastNumber = number;
                    while (steps.getLast() != null && steps.getLast().onlyOneChoice()) {
                        steps.add(this.getNextFor(steps.getLast()));
                    }
                    if (steps.getLast() == null) {
                        steps.removeLast();
                        return null;
                    }
                    return steps.getLast().createInput();
                }

                private void prepare(AbstractStep step) {
                    ProgressHandle h = ProgressHandle.createHandle((String)Bundle.LoadingItems());
                    h.start();
                    try {
                        h.progress(Bundle.LoadingItems());
                        step.prepare(h, values);
                    }
                    finally {
                        h.finish();
                    }
                }

                private AbstractStep getNextFor(AbstractStep step) {
                    AbstractStep ns;
                    NextStepProvider nsProvider = (NextStepProvider)lookup.lookup(NextStepProvider.class);
                    if (nsProvider != null && (ns = nsProvider.nextStepFor(step)) != null) {
                        this.prepare(ns);
                        return ns;
                    }
                    return null;
                }
            };
        }

        public Values getResult() {
            return this.values;
        }

        private static class MultistepValues
        implements Values {
            private final List<AbstractStep> steps;

            public MultistepValues(List<AbstractStep> steps) {
                this.steps = steps;
            }

            @Override
            public <T> T getValueForStep(Class<? extends AbstractStep<T>> forStep) {
                for (AbstractStep step : this.steps) {
                    if (!step.getClass().equals(forStep)) continue;
                    return (T)step.getValue();
                }
                return null;
            }
        }
    }

    public static interface Values {
        public <T> T getValueForStep(Class<? extends AbstractStep<T>> var1);
    }

    public static class NextStepProvider {
        private final Map<Class<? extends AbstractStep>, Function<AbstractStep, AbstractStep>> steps;

        private NextStepProvider(Map<Class<? extends AbstractStep>, Function<AbstractStep, AbstractStep>> steps) {
            this.steps = steps;
        }

        public AbstractStep nextStepFor(AbstractStep currentStep) {
            Function<AbstractStep, AbstractStep> nextStep = this.steps.get(currentStep.getClass());
            return nextStep != null ? nextStep.apply(currentStep) : null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Map<Class<? extends AbstractStep>, Function<AbstractStep, AbstractStep>> steps = new HashMap<Class<? extends AbstractStep>, Function<AbstractStep, AbstractStep>>();

            private Builder() {
            }

            public Builder stepForClass(Class<? extends AbstractStep> clazz, Function<AbstractStep, AbstractStep> stepFunction) {
                this.steps.put(clazz, stepFunction);
                return this;
            }

            public NextStepProvider build() {
                return new NextStepProvider(this.steps);
            }
        }
    }
}

