/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.netbeans.modules.refactoring.spi.ui.ScopeProvider;
import org.netbeans.modules.refactoring.spi.ui.ScopeReference;
import org.netbeans.modules.refactoring.spi.ui.ScopeReferences;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedAnnotationTypes(value={"org.netbeans.modules.refactoring.spi.ui.ScopeDescription", "org.netbeans.modules.refactoring.spi.ui.ScopeReference", "org.netbeans.modules.refactoring.spi.ui.ScopeReferences"})
public class ScopeAnnotationProcessor
extends LayerGeneratingProcessor {
    private static final String ERR_SUPER_TYPE = "The class must extend org.netbeans.modules.refactoring.api.AbstractAnnotatedRefactoring";
    private static final String ERR_ID_NEEDED = "This annotation needs to be used together with ScopeDescription, or you need to specify the id.";

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (!roundEnv.processingOver()) {
            this.generateTypeList(roundEnv);
        }
        return false;
    }

    private void generateTypeList(RoundEnvironment roundEnv) throws LayerGenerationException {
        TypeElement scopeRegistration = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.modules.refactoring.spi.ui.ScopeProvider.Registration");
        TypeElement scopeReference = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.modules.refactoring.spi.ui.ScopeReference");
        TypeElement scopeReferences = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.modules.refactoring.spi.ui.ScopeReferences");
        TypeMirror customProvider = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.modules.refactoring.spi.ui.ScopeProvider.CustomScopeProvider").asType();
        TypeMirror provider = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.modules.refactoring.spi.ui.ScopeProvider").asType();
        if (scopeRegistration == null || scopeReference == null || scopeReferences == null) {
            return;
        }
        Types typeUtils = this.processingEnv.getTypeUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(scopeRegistration)) {
            boolean custom;
            if (typeUtils.isSubtype(element.asType(), customProvider)) {
                custom = true;
            } else if (typeUtils.isSubtype(element.asType(), provider)) {
                custom = false;
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ERR_SUPER_TYPE, element);
                continue;
            }
            ScopeProvider.Registration ar = element.getAnnotation(ScopeProvider.Registration.class);
            LayerBuilder builder = this.layer(new Element[]{element});
            LayerBuilder.File f = builder.file("Scopes/ScopeDescriptions/" + ar.id() + ".instance");
            f.bundlevalue("displayName", ar.displayName(), (Annotation)ar, "displayName");
            f.stringvalue("id", ar.id());
            f.stringvalue("iconBase", ar.iconBase());
            f.intvalue("position", ar.position());
            f.newvalue("delegate", this.getFQN((TypeElement)element));
            f.stringvalue("instanceClass", "org.netbeans.modules.refactoring.spi.ui.ScopeProvider");
            if (custom) {
                f.methodvalue("instanceCreate", "org.netbeans.modules.refactoring.spi.impl.DelegatingCustomScopeProvider", "create");
            } else {
                f.methodvalue("instanceCreate", "org.netbeans.modules.refactoring.spi.impl.DelegatingScopeProvider", "create");
            }
            f.write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ScopeReferences.class)) {
            LayerBuilder builder = this.layer(new Element[]{element});
            ScopeReferences refs = element.getAnnotation(ScopeReferences.class);
            if (refs == null) continue;
            for (ScopeReference ar : refs.value()) {
                this.processReference(ar, element, builder);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(scopeReference)) {
            ScopeReference ar = element.getAnnotation(ScopeReference.class);
            this.processReference(ar, element, this.layer(new Element[]{element}));
        }
    }

    private String getFQN(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
    }

    private void processReference(ScopeReference ar, Element annotated, LayerBuilder builder) {
        String id = ar.id();
        if (id.isEmpty()) {
            ScopeProvider.Registration desc = annotated.getAnnotation(ScopeProvider.Registration.class);
            if (desc == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ERR_ID_NEEDED, annotated);
            } else {
                id = desc.id();
            }
        }
        LayerBuilder.File f = builder.file("Scopes/" + ar.path() + "/" + id + ".shadow");
        f.stringvalue("originalFile", "Scopes/ScopeDescriptions/" + id + ".instance");
        f.write();
    }
}

