/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.common.spi.support.serverplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.DeploymentStatus;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.DeploymentStatusImpl;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.TargetImpl;

public class ProgressObjectImpl
implements ProgressObject {
    private DeploymentStatusImpl status;
    private static final Logger LOG = Logger.getLogger(ProgressObjectImpl.class.getSimpleName());
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private String url;

    public ProgressObjectImpl(String message, boolean completed) {
        this.setStatus(new DeploymentStatusImpl(CommandType.DISTRIBUTE, completed ? StateType.COMPLETED : StateType.RUNNING, ActionType.EXECUTE, message));
    }

    public synchronized javax.enterprise.deploy.spi.status.DeploymentStatus getDeploymentStatus() {
        return this.status;
    }

    private synchronized void setStatus(DeploymentStatusImpl status) {
        this.status = status;
        LOG.log(Level.INFO, "status: {0}", status);
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{new TargetModuleIDImpl(this.url, "some-id", TargetImpl.SOME, new TargetModuleIDImpl(this.url, "some-id-child", TargetImpl.SOME, null))};
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID tmid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void updateDepoymentStage(String message) {
        DeploymentStatusImpl st = new DeploymentStatusImpl(CommandType.DISTRIBUTE, StateType.RUNNING, ActionType.EXECUTE, message);
        this.setStatus(st);
        this.fireChange(st);
    }

    public void updateDepoymentResult(DeploymentStatus result, String url) {
        StateType st = StateType.FAILED;
        if (result == DeploymentStatus.SUCCESS) {
            st = StateType.COMPLETED;
            this.url = url;
        } else if (result == DeploymentStatus.FAILED || result == DeploymentStatus.EXCEPTION || result == DeploymentStatus.UNKNOWN) {
            st = StateType.FAILED;
        }
        DeploymentStatusImpl st2 = new DeploymentStatusImpl(CommandType.DISTRIBUTE, st, ActionType.EXECUTE, "Deployment finished.");
        this.setStatus(st2);
        this.fireChange(st2);
    }

    private void fireChange(final DeploymentStatusImpl st) {
        final ArrayList<ProgressListener> ls = new ArrayList<ProgressListener>(this.listeners);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ProgressObjectImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (ProgressListener listener : ls) {
                    listener.handleProgressEvent(new ProgressEvent((Object)this, null, (javax.enterprise.deploy.spi.status.DeploymentStatus)st));
                }
            }
        });
    }

    private static class TargetModuleIDImpl
    implements TargetModuleID {
        private String url;
        private String id;
        private Target target;
        private TargetModuleID child;

        public TargetModuleIDImpl(String url, String id, Target target, TargetModuleID child) {
            this.url = url;
            this.id = id;
            this.target = target;
            this.child = child;
        }

        public Target getTarget() {
            return this.target;
        }

        public String getModuleID() {
            return this.id;
        }

        public String getWebURL() {
            return this.url;
        }

        public TargetModuleID getParentTargetModuleID() {
            return null;
        }

        public TargetModuleID[] getChildTargetModuleID() {
            if (this.child == null) {
                return null;
            }
            return new TargetModuleID[]{this.child};
        }
    }
}

