/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationsComboModel;

public class ConfigurationRenderer
extends JLabel
implements ListCellRenderer,
UIResource {
    private boolean bordersInitialized;
    private Border originalBorder;
    private Border separatorBorder;

    public ConfigurationRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            if (value instanceof Configuration) {
                this.setText(((Configuration)value).getDisplayName());
            } else {
                this.setText(value.toString());
            }
        }
        if (!this.bordersInitialized) {
            this.originalBorder = this.getBorder();
            Separator separator = new Separator(list.getForeground());
            this.separatorBorder = this.originalBorder != null ? new CompoundBorder(this.originalBorder, separator) : separator;
            this.bordersInitialized = true;
        }
        if (index == list.getModel().getSize() - 5 && ((ConfigurationsComboModel)list.getModel()).canModify()) {
            this.setBorder(this.separatorBorder);
        } else {
            this.setBorder(this.originalBorder);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setName("ComboBox.listRenderer");
        return this;
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name == null ? "ComboBox.renderer" : name;
    }

    private class Separator
    implements Border {
        private Color fgColor;

        Separator(Color color) {
            this.fgColor = color;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics gr = g.create();
            if (gr != null) {
                try {
                    gr.translate(x, y);
                    gr.setColor(this.fgColor);
                    gr.drawLine(0, height - 1, width - 1, height - 1);
                }
                finally {
                    gr.dispose();
                }
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 1, 0);
        }
    }
}

