/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JaxRsConfigurationPanel
extends JPanel
implements ChangeListener,
AbstractPanel.Settings {
    private static final long serialVersionUID = 5841706512529345806L;
    private static final Logger LOGGER = Logger.getLogger(JaxRsConfigurationPanel.class.getName());
    private static final String JAX_RS_LIBRARY_NAME = "jax-rs";
    private String parentPackageName = null;
    private JSeparator jSeparator1;
    private JTextField restAppClass;
    private JLabel restAppClassLbl;
    private JComboBox restAppPackage;
    private JLabel restAppPckgLbl;
    private JCheckBox useJersey;
    private SourcePanel sourcePanel;
    private SourceGroup sourceGroup;
    private List<ChangeListener> listeners;

    public JaxRsConfigurationPanel(SourcePanel sourcePanel) {
        this.initComponents();
        this.listeners = new ArrayList<ChangeListener>(1);
        this.sourcePanel = sourcePanel;
        this.updatePackageName();
        this.useJersey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (JaxRsConfigurationPanel.this.useJersey.isSelected()) {
                    JaxRsConfigurationPanel.this.setEnabledAppConfig(false);
                } else {
                    JaxRsConfigurationPanel.this.setEnabledAppConfig(true);
                }
                JaxRsConfigurationPanel.this.fireChange();
            }
        });
        this.restAppPackage.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JaxRsConfigurationPanel.this.fireChange();
            }
        });
        this.restAppPackage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JaxRsConfigurationPanel.this.fireChange();
            }
        });
        this.restAppClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JaxRsConfigurationPanel.this.fireChange();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        SourceGroup group = this.getSourceGroup();
        if (group != null && !group.equals((Object)this.sourceGroup)) {
            this.sourceGroup = group;
            this.updateSourceGroupPackages();
        }
        this.updatePackageName();
    }

    @Override
    public void read(WizardDescriptor wizard) {
        String appClass;
        String appPackage;
        this.sourceGroup = this.getSourceGroup();
        this.restAppPackage.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (Boolean.TRUE.equals(wizard.getProperty("useJersey"))) {
            this.useJersey.setSelected(true);
        }
        Project project = Templates.getProject((WizardDescriptor)wizard);
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        boolean hasJersey1 = restSupport.hasJersey1(true);
        boolean hasJersey2 = restSupport.hasJersey2(true);
        if (hasJersey1 && !hasJersey2) {
            this.configureJaxRsLibrary(project);
        }
        boolean showJerseyChoice = restSupport.isEE6() && hasJersey1 && !restSupport.hasJersey2(true);
        this.useJersey.setVisible(showJerseyChoice);
        if (!showJerseyChoice) {
            this.jSeparator1.setVisible(false);
            this.restAppClass.setVisible(false);
            this.restAppClassLbl.setVisible(false);
            this.restAppPackage.setVisible(false);
            this.restAppPckgLbl.setVisible(false);
        }
        if ((appPackage = (String)wizard.getProperty("restApplicationConfigPackage")) != null) {
            ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).setText(appPackage);
        }
        if ((appClass = (String)wizard.getProperty("restApplicatoin")) != null) {
            this.restAppClass.setText(appClass);
        }
    }

    @Override
    public void store(WizardDescriptor wizard) {
        wizard.putProperty("restApplicationConfigPackage", (Object)this.getPackage());
        wizard.putProperty("restApplicatoin", (Object)this.restAppClass.getText().trim());
        wizard.putProperty("useJersey", (Object)this.useJersey.isSelected());
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        if (this.useJersey.isSelected()) {
            return true;
        }
        String packageName = this.getPackage();
        String className = this.restAppClass.getText().trim();
        if (className.length() == 0 || !Utilities.isJavaIdentifier((String)className)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidApplicationClassName");
            return false;
        }
        if (!Util.isValidPackageName(packageName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidPackageName");
            return false;
        }
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public double getRenderedHeight() {
        return this.restAppClass.getLocation().getY() + (double)this.restAppClass.getHeight() + this.getGap();
    }

    private double getGap() {
        double gap = this.restAppClass.getLocation().getY();
        return gap -= this.restAppPackage.getLocation().getY() + (double)this.restAppPackage.getHeight();
    }

    private SourceGroup getSourceGroup() {
        return this.sourcePanel.getSourceGroup();
    }

    private void updateSourceGroupPackages() {
        SourceGroup sg = this.getSourceGroup();
        if (sg != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sg);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            String oldValue = ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).getText();
            this.restAppPackage.setModel(model);
            if (oldValue.length() > 0) {
                ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).setText(oldValue);
            }
        }
    }

    private String getPackage() {
        return ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).getText();
    }

    private void setEnabledAppConfig(boolean enable) {
        this.restAppClass.setEnabled(enable);
        this.restAppClassLbl.setEnabled(enable);
        this.restAppPackage.setEnabled(enable);
        this.restAppPckgLbl.setEnabled(enable);
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void configureJaxRsLibrary(Project project) {
        block7: {
            ServerInstance serverInstance;
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            String serverInstanceID = provider.getServerInstanceID();
            if (serverInstanceID != null && (serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID)) != null) {
                try {
                    ServerInstance.LibraryManager libraryManager = serverInstance.getLibraryManager();
                    if (libraryManager == null) break block7;
                    for (ServerLibrary lib : libraryManager.getDeployedLibraries()) {
                        Version specVersion;
                        if (!JAX_RS_LIBRARY_NAME.equals(lib.getName()) || (specVersion = lib.getSpecificationVersion()) == null || !specVersion.isAboveOrEqual(Version.fromDottedNotationWithFallback((String)"2.0"))) continue;
                        String libraryDisplayName = lib.getName().toUpperCase() + " " + specVersion.toString();
                        NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"MSG_Jersey2AvailableOnServer", (Object[])new Object[]{libraryDisplayName, serverInstance.getServerDisplayName()}), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                            try {
                                provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)lib.getName(), (Version)lib.getSpecificationVersion(), (Version)lib.getImplementationVersion()));
                            }
                            catch (ConfigurationException ex) {
                                LOGGER.log(Level.WARNING, "Exception during JAX-RS library configuration", ex);
                            }
                        }
                        break;
                    }
                }
                catch (InstanceRemovedException ex) {
                    LOGGER.log(Level.INFO, "Server Instance was removed", ex);
                }
            }
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.useJersey = new JCheckBox();
        this.restAppPckgLbl = new JLabel();
        this.restAppPackage = new JComboBox();
        this.restAppClassLbl = new JLabel();
        this.restAppClass = new JTextField();
        this.setPreferredSize(new Dimension(450, 115));
        Mnemonics.setLocalizedText((AbstractButton)this.useJersey, (String)NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"LBL_UseJersey"));
        this.useJersey.setActionCommand(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"JaxRsConfigurationPanel.useJersey.actionCommand"));
        this.restAppPckgLbl.setLabelFor(this.restAppPackage);
        Mnemonics.setLocalizedText((JLabel)this.restAppPckgLbl, (String)NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"LBL_AppConfigPackage"));
        this.restAppPackage.setEditable(true);
        this.restAppClassLbl.setLabelFor(this.restAppClass);
        Mnemonics.setLocalizedText((JLabel)this.restAppClassLbl, (String)NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"LBL_AppConfigClass"));
        this.restAppClass.setText(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"JaxRsConfigurationPanel.restAppClass.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useJersey).addGroup(layout.createSequentialGroup().addComponent(this.restAppPckgLbl).addGap(25, 25, 25).addComponent(this.restAppPackage, 0, 235, Short.MAX_VALUE))).addGap(0, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.restAppClassLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.restAppClass, -1, 285, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useJersey).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restAppPckgLbl).addComponent(this.restAppPackage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restAppClassLbl).addComponent(this.restAppClass, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.useJersey.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSN_UseJersey"));
        this.useJersey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSD_UseJersey"));
        this.restAppPckgLbl.getAccessibleContext().setAccessibleName(this.restAppPackage.getAccessibleContext().getAccessibleName());
        this.restAppPckgLbl.getAccessibleContext().setAccessibleDescription(this.restAppPackage.getAccessibleContext().getAccessibleDescription());
        this.restAppPackage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSN_AppConfigPackage"));
        this.restAppPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSD_AppConfigPackage"));
        this.restAppClassLbl.getAccessibleContext().setAccessibleName(this.restAppClass.getAccessibleContext().getAccessibleName());
        this.restAppClassLbl.getAccessibleContext().setAccessibleDescription(this.restAppClass.getAccessibleContext().getAccessibleDescription());
        this.restAppClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSN_AppConfigClass"));
        this.restAppClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsConfigurationPanel.class, (String)"ACSD_AppConfigClass"));
    }

    private void updatePackageName() {
        String pkg = this.sourcePanel.getPackageName();
        if (this.parentPackageName == null || !this.parentPackageName.equals(pkg)) {
            this.parentPackageName = pkg;
            ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).setText(pkg);
        }
    }
}

