/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public abstract class BasePanel
extends JPanel {
    protected abstract String getPrefix();

    protected abstract List<Component> getDataComponents();

    public final void initializeUI() {
        for (Component c : this.getDataComponents()) {
            c.setEnabled(false);
        }
    }

    public void initializeData(final String name, final Map<String, String> data) {
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ BasePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (Component c : this.this$0.getDataComponents()) {
                    c.setEnabled(true);
                    String compName = c.getName();
                    if (compName == null) continue;
                    String key = this.this$0.getPrefix() + name + "." + compName;
                    String value = (String)data.get(key);
                    if (null == value) {
                        value = NbBundle.getMessage(this.getClass(), (String)"ERR_DATA_NOT_FOUND", (Object)key);
                    } else {
                        c.setName(key);
                    }
                    if (c instanceof JComboBox) {
                        JComboBox jcb = (JComboBox)c;
                        new ComboBoxSetter(jcb, value, data).run();
                        continue;
                    }
                    if (c instanceof JTextComponent) {
                        JTextComponent jtc = (JTextComponent)c;
                        new TextFieldSetter(jtc, value).run();
                        continue;
                    }
                    if (c instanceof AbstractButton) {
                        AbstractButton ab = (AbstractButton)c;
                        new ButtonSetter(ab, value).run();
                        continue;
                    }
                    if (!(c instanceof JTable)) continue;
                    JTable table = (JTable)c;
                    new TableSetter(name, table, data).run();
                }
            }
        });
    }

    public final Map<String, String> getData() {
        HashMap<String, String> retVal = new HashMap<String, String>(this.getDataComponents().size());
        for (Component c : this.getDataComponents()) {
            TableModel tm;
            String compName = c.getName();
            if (compName == null) continue;
            String key = compName;
            if (c instanceof JComboBox) {
                JComboBox jcb = (JComboBox)c;
                retVal.put(key, (String)jcb.getSelectedItem());
                continue;
            }
            if (c instanceof JTextComponent) {
                JTextComponent jtc = (JTextComponent)c;
                retVal.put(key, jtc.getText());
                continue;
            }
            if (c instanceof AbstractButton) {
                AbstractButton ab = (AbstractButton)c;
                retVal.put(key, Boolean.toString(ab.isSelected()));
                continue;
            }
            if (!(c instanceof JTable)) continue;
            JTable table = (JTable)c;
            TableCellEditor tce = table.getCellEditor();
            if (null != tce) {
                tce.stopCellEditing();
            }
            if (!((tm = table.getModel()) instanceof DataTableModel)) continue;
            DataTableModel model = (DataTableModel)tm;
            retVal.putAll(model.getData());
        }
        return retVal;
    }

    static abstract class DataTableModel
    extends AbstractTableModel {
        private String[][] rowData;
        private String pushPrefix;
        private String[] names;
        private String[] specComp;

        public abstract Map<String, String> getData();

        DataTableModel(String[][] rowData, String[] specComp, String pushPrefix) {
            this.rowData = rowData;
            this.specComp = specComp;
            this.pushPrefix = pushPrefix;
            if (rowData.length > 0) {
                int colCount = rowData[0].length;
                this.names = new String[colCount];
                for (int i = 0; i < colCount; ++i) {
                    try {
                        this.names[i] = NbBundle.getMessage(this.getClass(), (String)("column-title." + specComp[0] + "." + specComp[i + 1]));
                        continue;
                    }
                    catch (MissingResourceException mre) {
                        this.names[i] = specComp[i + 1];
                    }
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.rowData.length == 0 ? 0 : this.rowData[0].length;
        }

        @Override
        public String getColumnName(int i) {
            if (i > -1 && i < this.getColumnCount()) {
                return this.names[i];
            }
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
            super.setValueAt(arg0, arg1, arg2);
            this.rowData[arg1][arg2] = (String)arg0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public String getPushPrefix() {
            return this.pushPrefix;
        }

        public String getSpecComp(int i) {
            return this.specComp[i];
        }
    }

    public static class Error
    extends BasePanel {
        @Override
        protected String getPrefix() {
            return "";
        }

        @Override
        protected List<Component> getDataComponents() {
            return Collections.emptyList();
        }

        @Override
        public void initializeData(String name, Map<String, String> data) {
        }
    }

    static class NameValueTableModel
    extends DataTableModel {
        NameValueTableModel(String[][] rowData, String[] specComp, String pushPrefix) {
            super(rowData, specComp, pushPrefix);
        }

        @Override
        public Map<String, String> getData() {
            HashMap<String, String> retVal = new HashMap<String, String>(this.getRowCount() * (this.getColumnCount() - 1));
            for (int i = 0; i < this.getRowCount(); ++i) {
                String key = this.getPushPrefix() + this.getSpecComp(0) + "." + this.getValueAt(i, 0);
                retVal.put(key, (String)this.getValueAt(i, 1));
            }
            return retVal;
        }
    }

    static class AttributedPropertyTableModel
    extends DataTableModel {
        AttributedPropertyTableModel(String[][] rowData, String[] specComp, String pushPrefix) {
            super(rowData, specComp, pushPrefix);
        }

        @Override
        public Map<String, String> getData() {
            HashMap<String, String> retVal = new HashMap<String, String>(this.getRowCount() * (this.getColumnCount() - 1));
            for (int i = 0; i < this.getRowCount(); ++i) {
                String key = this.getPushPrefix() + this.getSpecComp(0) + "." + this.getValueAt(i, 0) + ".";
                for (int j = 1; j < this.getColumnCount(); ++j) {
                    key = key + this.getSpecComp(j + 1);
                    retVal.put(key, (String)this.getValueAt(i, j));
                }
            }
            return retVal;
        }
    }

    static class TableSetter
    implements Runnable {
        private JTable table;
        private Map<String, String> data;
        private String name;

        TableSetter(String name, JTable table, Map<String, String> data) {
            this.table = table;
            this.data = data;
            this.name = name;
        }

        @Override
        public void run() {
            int dex;
            String[] aRow;
            Matcher test;
            String[] specComp = this.table.getName().split("\\.");
            int colCount = specComp.length - 1;
            if (0 >= colCount) {
                return;
            }
            ArrayList<String[]> l = new ArrayList<String[]>();
            Pattern pattern = Pattern.compile(".*\\." + this.name + "\\." + specComp[0] + "\\..*\\." + specComp[1]);
            Set<String> keys = this.data.keySet();
            String pushPrefix = null;
            for (String k : keys) {
                test = pattern.matcher(k);
                if (!test.matches()) continue;
                if (null == pushPrefix) {
                    int dex2 = k.lastIndexOf(specComp[0]);
                    pushPrefix = k.substring(0, dex2);
                }
                aRow = new String[colCount];
                dex = k.lastIndexOf(".");
                String partialKey = k.substring(0, dex);
                aRow[0] = this.data.get(k);
                for (int i = 2; i < colCount + 1; ++i) {
                    aRow[i - 1] = this.data.get(partialKey + "." + specComp[i]);
                    if (null != aRow[i - 1]) continue;
                    aRow[i - 1] = "";
                }
                l.add(aRow);
            }
            if (l.size() > 0) {
                this.table.setModel(new AttributedPropertyTableModel((String[][])l.toArray((T[])new String[0][]), specComp, pushPrefix));
            } else {
                pattern = Pattern.compile(".*\\." + this.name + "\\." + specComp[0] + "\\..*");
                pushPrefix = null;
                for (String k : keys) {
                    String propName;
                    test = pattern.matcher(k);
                    if (!test.matches()) continue;
                    if (null == pushPrefix) {
                        int dex3 = k.lastIndexOf(specComp[0]);
                        pushPrefix = k.substring(0, dex3);
                    }
                    aRow = new String[colCount];
                    dex = k.lastIndexOf(".");
                    aRow[0] = propName = k.substring(dex + 1);
                    aRow[1] = this.data.get(k);
                    l.add(aRow);
                }
                if (l.size() > 0) {
                    this.table.setModel(new NameValueTableModel((String[][])l.toArray((T[])new String[0][]), specComp, pushPrefix));
                }
            }
        }
    }

    static class ButtonSetter
    implements Runnable {
        private AbstractButton button;
        private String value;

        ButtonSetter(AbstractButton button, String value) {
            this.button = button;
            this.value = value;
        }

        @Override
        public void run() {
            this.button.setSelected(Boolean.parseBoolean(this.value));
        }
    }

    static class TextFieldSetter
    implements Runnable {
        private JTextComponent jtc;
        private String value;

        TextFieldSetter(JTextComponent jtc, String value) {
            this.jtc = jtc;
            this.value = value;
        }

        @Override
        public void run() {
            this.jtc.setText(this.value);
        }
    }

    static class ComboBoxSetter
    implements Runnable {
        private JComboBox jcb;
        private Map<String, String> data;
        private String value;

        private ComboBoxSetter(JComboBox jcb, String value, Map<String, String> data) {
            this.jcb = jcb;
            this.data = data;
            this.value = value;
        }

        @Override
        public void run() {
            String allowedRegEx = this.jcb.getActionCommand();
            DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
            Pattern p = Pattern.compile(allowedRegEx);
            Set<String> keys = this.data.keySet();
            for (String k : keys) {
                Matcher test = p.matcher(k);
                if (!test.matches()) continue;
                dcbm.addElement(this.data.get(k));
            }
            this.jcb.setModel(dcbm);
            this.jcb.setSelectedItem(this.value);
        }
    }
}

