/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    private boolean areBreakpointsPersisted() {
        Properties p = Properties.getDefault().getProperties("debugger");
        p = p.getProperties("persistence");
        return p.getBoolean("breakpoints", true);
    }

    public Breakpoint[] initBreakpoints() {
        if (!this.areBreakpointsPersisted()) {
            return new Breakpoint[0];
        }
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        Breakpoint[] breakpoints = (Breakpoint[])p.getArray("cpplite", (Object[])new Breakpoint[0]);
        for (int i = 0; i < breakpoints.length; ++i) {
            if (breakpoints[i] == null) {
                Breakpoint[] b2 = new Breakpoint[breakpoints.length - 1];
                System.arraycopy(breakpoints, 0, b2, 0, i);
                if (i < breakpoints.length - 1) {
                    System.arraycopy(breakpoints, i + 1, b2, i, breakpoints.length - i - 1);
                }
                breakpoints = b2;
                --i;
                continue;
            }
            breakpoints[i].addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return breakpoints;
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!this.areBreakpointsPersisted()) {
            return;
        }
        if (breakpoint instanceof CPPLiteBreakpoint) {
            Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
            p.setArray("cpplite", (Object[])PersistenceManager.getBreakpoints());
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!this.areBreakpointsPersisted()) {
            return;
        }
        if (breakpoint instanceof CPPLiteBreakpoint) {
            Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
            p.setArray("cpplite", (Object[])PersistenceManager.getBreakpoints());
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Breakpoint) {
            Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray("cpplite", (Object[])PersistenceManager.getBreakpoints());
        }
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private static Breakpoint[] getBreakpoints() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> bb = new ArrayList<Breakpoint>();
        for (Breakpoint b : bs) {
            if (!(b instanceof CPPLiteBreakpoint) || ((CPPLiteBreakpoint)b).isHidden()) continue;
            bb.add(b);
        }
        bs = new Breakpoint[bb.size()];
        return bb.toArray(bs);
    }
}

