/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateAuthenticationPolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAuthenticationPolicyRequest
extends BmcRequest<UpdateAuthenticationPolicyDetails> {
    private String compartmentId;
    private UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails;
    private String ifMatch;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateAuthenticationPolicyDetails getUpdateAuthenticationPolicyDetails() {
        return this.updateAuthenticationPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateAuthenticationPolicyDetails getBody$() {
        return this.updateAuthenticationPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).updateAuthenticationPolicyDetails(this.updateAuthenticationPolicyDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateAuthenticationPolicyDetails=").append(String.valueOf((Object)this.updateAuthenticationPolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAuthenticationPolicyRequest)) {
            return false;
        }
        UpdateAuthenticationPolicyRequest other = (UpdateAuthenticationPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateAuthenticationPolicyDetails, (Object)other.updateAuthenticationPolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateAuthenticationPolicyDetails == null ? 43 : this.updateAuthenticationPolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails = null;
        private String ifMatch = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateAuthenticationPolicyDetails(UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails) {
            this.updateAuthenticationPolicyDetails = updateAuthenticationPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAuthenticationPolicyRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateAuthenticationPolicyDetails(o.getUpdateAuthenticationPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAuthenticationPolicyRequest build() {
            UpdateAuthenticationPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAuthenticationPolicyDetails body) {
            this.updateAuthenticationPolicyDetails(body);
            return this;
        }

        public UpdateAuthenticationPolicyRequest buildWithoutInvocationCallback() {
            UpdateAuthenticationPolicyRequest request = new UpdateAuthenticationPolicyRequest();
            request.compartmentId = this.compartmentId;
            request.updateAuthenticationPolicyDetails = this.updateAuthenticationPolicyDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

