/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;

public class CompletionSupport
implements CompletionItem {
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private String text;
    private String filledPrefix;
    private String description;
    private String rightText;
    private String icon;
    private int priority;
    private int processKeyEventOffset;
    private String confirmChars;
    private CompletionItem.Type type;

    private static ImageIcon getCIcon(String resourceName) {
        if (resourceName == null) {
            resourceName = "org/netbeans/modules/languages/resources/node.gif";
        }
        if (!icons.containsKey(resourceName)) {
            ImageIcon icon = ImageUtilities.loadImageIcon((String)resourceName, (boolean)false);
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/languages/resources/node.gif", (boolean)false);
            }
            icons.put(resourceName, icon);
        }
        return icons.get(resourceName);
    }

    CompletionSupport(org.netbeans.api.languages.CompletionItem item, String prefix) {
        this.text = item.getText();
        this.filledPrefix = prefix;
        this.rightText = item.getLibrary();
        this.priority = item.getPriority();
        String color = "000000";
        this.type = item.getType();
        if (this.type == null) {
            this.type = CompletionItem.Type.FIELD;
        }
        boolean bold = false;
        String key = item.getText();
        switch (this.type) {
            case KEYWORD: {
                color = "000099";
                this.icon = "/org/netbeans/modules/languages/resources/keyword.jpg";
                bold = true;
                break;
            }
            case INTERFACE: {
                color = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/interface.png";
                break;
            }
            case CLASS: {
                color = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/class_16.png ";
                break;
            }
            case FIELD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_16.png";
                break;
            }
            case METHOD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/method_16.png";
                bold = true;
                key = key + "()";
                break;
            }
            case CONSTRUCTOR: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/constructor_16.png";
                bold = true;
                key = key + "()";
                break;
            }
            case CONSTANT: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_static_16.png";
                break;
            }
            case LOCAL: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
                break;
            }
            case PARAMETER: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
            }
        }
        this.description = item.getDescription() == null ? "<html>" + (bold ? "<b>" : "") + "<font color=#" + color + ">" + key + "</font>" + (bold ? "</b>" : "") + "</html>" : "<html>" + (bold ? "<b>" : "") + "<font color=#" + color + ">" + key + ": </font>" + (bold ? "</b>" : "") + "<font color=#000000> " + item.getDescription() + "</font></html>";
    }

    CompletionSupport(String text, String prefix, String description, String rightText, String icon, int priority) {
        this.text = text;
        this.filledPrefix = prefix;
        this.description = description;
        this.rightText = rightText;
        this.icon = icon;
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultAction(JTextComponent component) {
        NbEditorDocument doc = (NbEditorDocument)component.getDocument();
        int offset = component.getCaret().getDot();
        boolean isMethod = this.type == CompletionItem.Type.METHOD || this.type == CompletionItem.Type.CONSTRUCTOR;
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            if (doc instanceof NbEditorDocument) {
                doc.readLock();
            }
            String t = null;
            try {
                TokenSequence sequence = tokenHierarchy.tokenSequence();
                while (true) {
                    TokenSequence embedded;
                    sequence.move(offset - 1);
                    if (!sequence.moveNext() || (embedded = sequence.embedded()) == null) break;
                    sequence = embedded;
                }
                Token token = sequence.token();
                String tokenType = token != null ? token.id().name() : "";
                String mimeType = sequence.language().mimeType();
                Language l = LanguagesManager.getDefault().getLanguage(mimeType);
                List<Feature> features = l.getFeatureList().getFeatures("COMPLETION", tokenType);
                Iterator<Feature> it = features.iterator();
                t = isMethod ? this.text + "()" : this.text;
                boolean found = false;
                while (it.hasNext()) {
                    Feature feature = it.next();
                    String completionType = CompletionSupport.getCompletionType(feature, tokenType);
                    if (completionType != "complete") continue;
                    t = t.substring(offset - sequence.offset());
                    found = true;
                    break;
                }
                if (!found && this.filledPrefix != null) {
                    t = t.substring(this.filledPrefix.length());
                }
            }
            finally {
                if (doc instanceof NbEditorDocument) {
                    doc.readUnlock();
                }
            }
            doc.insertString(offset, t, null);
            if (isMethod) {
                component.setCaretPosition(component.getCaret().getDot() - 1);
            }
            this.processKeyEventOffset = offset + t.length();
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            char c = evt.getKeyChar();
            JTextComponent component = (JTextComponent)evt.getSource();
            if (this.confirmChars == null) {
                this.confirmChars = this.getConfirmChars(component);
            }
            if (this.confirmChars.indexOf(c) != -1) {
                if (c != '.') {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }
                NbEditorDocument doc = (NbEditorDocument)component.getDocument();
                try {
                    this.defaultAction(component);
                    doc.insertString(this.processKeyEventOffset, Character.toString(c), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (c == '.') {
                    Completion.get().showCompletion();
                }
                evt.consume();
            }
        }
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.description, (String)this.rightText, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)CompletionSupport.getCIcon(this.icon), (String)this.description, (String)this.rightText, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.text;
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfirmChars(JTextComponent component) {
        NbEditorDocument doc = (NbEditorDocument)component.getDocument();
        StringBuffer buf = new StringBuffer();
        int offset = component.getCaret().getDot();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            if (doc instanceof NbEditorDocument) {
                doc.readLock();
            }
            try {
                TokenSequence sequence = tokenHierarchy.tokenSequence();
                if (sequence.isEmpty()) {
                    String string = "";
                    return string;
                }
                while (true) {
                    sequence.move(offset - 1);
                    if (!sequence.moveNext()) {
                        String string = "";
                        return string;
                    }
                    TokenSequence embedded = sequence.embedded();
                    if (embedded == null) break;
                    sequence = embedded;
                }
                Token token = sequence.token();
                String tokenType = token.id().name();
                String mimeType = sequence.language().mimeType();
                Language l = LanguagesManager.getDefault().getLanguage(mimeType);
                List<Feature> features = l.getFeatureList().getFeatures("COMPLETION", tokenType);
                Iterator<Feature> it = features.iterator();
                while (it.hasNext()) {
                    Feature feature = it.next();
                    String confChars = (String)feature.getValue("confirmChars");
                    if (confChars == null) continue;
                    buf.append(confChars);
                }
                return buf.toString();
            }
            finally {
                if (doc instanceof NbEditorDocument) {
                    doc.readUnlock();
                }
            }
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        return buf.toString();
    }

    private static String getCompletionType(Feature feature, String tokenType) {
        String completionType = (String)feature.getValue("type");
        if (completionType != null) {
            return completionType;
        }
        if (tokenType.indexOf("whitespace") >= 0 || tokenType.indexOf("operator") >= 0 || tokenType.indexOf("separator") >= 0) {
            return "insert";
        }
        if (tokenType.indexOf("comment") >= 0) {
            return "append";
        }
        return "complete";
    }
}

