/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyVetoException;
import java.util.Set;
import org.netbeans.modules.ide.ergonomics.Utilities;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.actions.CookieAction;

public final class OpenAdvancedAction
extends CookieAction {
    private static Set<FileObject> candidates = new WeakSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCandidate(FileObject fo) {
        Set<FileObject> set = candidates;
        synchronized (set) {
            candidates.add(fo);
        }
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return;
        }
        final DataObject obj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        FileObject mimeDefinition = FileUtil.getConfigFile((String)("Loaders/" + obj.getPrimaryFile().getMIMEType() + "/Factories/Ergonomics.instance"));
        if (mimeDefinition == null) {
            return;
        }
        final FeatureInfo info = FoDLayersProvider.getInstance().whichProvides(mimeDefinition);
        if (info == null || info.isEnabled()) {
            return;
        }
        RequestProcessor.Task task = FeatureManager.getInstance().create(new Runnable(){
            final /* synthetic */ OpenAdvancedAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean success = Utilities.featureNotFoundDialog(info, NbBundle.getMessage(OpenAdvancedAction.class, (String)"CTL_OpenAdvanced"));
                if (success) {
                    try {
                        OpenCookie oc;
                        obj.setValid(false);
                        DataObject newO = DataObject.find((FileObject)obj.getPrimaryFile());
                        if (newO != obj && (oc = (OpenCookie)newO.getLookup().lookup(OpenCookie.class)) != null) {
                            oc.open();
                        }
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        task.schedule(0);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes) || activatedNodes.length != 1) {
            return false;
        }
        DataObject obj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        return candidates.contains(obj.getPrimaryFile());
    }

    protected int mode() {
        return 1;
    }

    public String getName() {
        return NbBundle.getMessage(OpenAdvancedAction.class, (String)"CTL_OpenAdvancedAction");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

