/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.actions;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import java.awt.GraphicsEnvironment;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PauseInGraalScriptActionProvider
extends JPDADebuggerActionProvider {
    private static final Logger LOG = Logger.getLogger(PauseInGraalScriptActionProvider.class.getName());
    public static final String NAME = "pauseInGraalScript";
    private static final String ACCESSOR_SUSPEND_NEXT_EXECUTION = "suspendNextExecution";
    private static final String ACCESSOR_SUSPEND_NEXT_EXECUTION_SIGNAT = "()V";
    private static WeakReference<Action> actionReference = new WeakReference<Object>(null);
    private static final ThreadLocal<Boolean> AVOID_REENTRANT = new ThreadLocal();
    private boolean suspendState = false;

    public PauseInGraalScriptActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    protected void checkEnabled(int debuggerState) {
        if (AVOID_REENTRANT.get() != null) {
            return;
        }
        try {
            AVOID_REENTRANT.set(true);
            this.checkEnabledImpl(debuggerState);
        }
        finally {
            AVOID_REENTRANT.set(null);
        }
    }

    private void checkEnabledImpl(int debuggerState) {
        ClassObjectReference serviceClass = RemoteServices.getServiceClass((JPDADebugger)this.getDebuggerImpl());
        boolean hasServiceClass = serviceClass != null;
        this.setEnabled(NAME, hasServiceClass);
        if (hasServiceClass) {
            JPDAThread currentThread = this.debugger.getCurrentThread();
            if (currentThread != null && TruffleAccess.getCurrentGuestPCInfo(currentThread) != null) {
                this.suspendState = false;
            }
            PauseInGraalScriptActionProvider.updateActionState(true, this.suspendState);
        } else {
            PauseInGraalScriptActionProvider.updateActionState(false, false);
        }
    }

    public void doAction(Object actionName) {
        assert (NAME.equals(actionName));
        boolean bl = this.suspendState = !this.suspendState;
        if (this.suspendState) {
            this.scheduleSuspend();
        } else {
            this.cancelSuspend();
        }
        PauseInGraalScriptActionProvider.updateActionState(true, this.suspendState);
    }

    public Set getActions() {
        return Collections.singleton(NAME);
    }

    private void scheduleSuspend() {
        LOG.fine("scheduleSuspend()");
        final ClassType debugAccessor = TruffleDebugManager.getDebugAccessorClass((JPDADebugger)this.debugger);
        try {
            final Method suspendNextExecutionMethod = ClassTypeWrapper.concreteMethodByName((ClassType)debugAccessor, (String)ACCESSOR_SUSPEND_NEXT_EXECUTION, (String)ACCESSOR_SUSPEND_NEXT_EXECUTION_SIGNAT);
            TruffleAccess.methodCallingAccess((JPDADebugger)this.debugger, new TruffleAccess.MethodCallsAccess(){
                final /* synthetic */ PauseInGraalScriptActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void callMethods(JPDAThread thread) throws InvocationException {
                    ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                    try {
                        ClassTypeWrapper.invokeMethod((ClassType)debugAccessor, (ThreadReference)tr, (Method)suspendNextExecutionMethod, Collections.emptyList(), (int)1);
                    }
                    catch (InvocationException iex) {
                        InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, this.this$0.debugger).preload((JPDAThreadImpl)thread);
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)"suspendNextExecution()"));
                    }
                    catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)"suspendNextExecution()"));
                    }
                }
            });
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
    }

    private void cancelSuspend() {
        LOG.fine("cancelSuspend()");
    }

    public static Action createAction(Map<String, ?> params) {
        assert (params.get("action").equals(NAME));
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> debuggerActionClass = classLoader.loadClass("org.netbeans.modules.debugger.ui.actions.DebuggerAction");
            java.lang.reflect.Method createActionMethod = debuggerActionClass.getDeclaredMethod("createAction", Map.class);
            Action action = (Action)createActionMethod.invoke(null, params);
            action.putValue("openide.awt.actionToggle", Boolean.TRUE);
            action.putValue("SwingSelectedKey", false);
            actionReference = new WeakReference<Action>(action);
            return action;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void updateActionState(boolean active, boolean suspendState) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Action action = (Action)actionReference.get();
        if (action != null) {
            SwingUtilities.invokeLater(() -> action.putValue("SwingSelectedKey", active & suspendState));
        }
    }
}

