/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;

public abstract class VectorIcon
implements Icon,
Serializable {
    private final int width;
    private final int height;

    protected VectorIcon(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    private static Graphics2D createGraphicsWithRenderingHintsConfigured(Graphics basedOn) {
        Graphics2D ret = (Graphics2D)basedOn.create();
        Object desktopHints = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        LinkedHashMap<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
        if (desktopHints instanceof Map) {
            hints.putAll((Map)desktopHints);
        }
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ret.addRenderingHints(hints);
        return ret;
    }

    protected static final void setAntiAliasing(Graphics2D g, boolean enabled) {
        LinkedHashMap<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, enabled ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.addRenderingHints(hints);
    }

    protected static final int round(double d) {
        int ret = (int)Math.round(d);
        return d > 0.0 && ret == 0 ? 1 : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component c, Graphics g0, int x, int y) {
        Graphics2D g2 = VectorIcon.createGraphicsWithRenderingHintsConfigured(g0);
        try {
            g2.clipRect(x, y, this.getIconWidth(), this.getIconHeight());
            g2.translate(x, y);
            AffineTransform tx = g2.getTransform();
            int txType = tx.getType();
            if (txType != 2 && txType != 3) {
                this.paintIcon(c, g2, this.getIconWidth(), this.getIconHeight(), 1.0);
                return;
            }
            double scaling = tx.getScaleX();
            double previousDevicePosX = tx.getTranslateX();
            double previousDevicePosY = tx.getTranslateY();
            double alignedDevicePosX = Math.ceil(previousDevicePosX);
            double alignedDevicePosY = Math.ceil(previousDevicePosY);
            g2.setTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, alignedDevicePosX, alignedDevicePosY));
            double transDeviceAdjX = alignedDevicePosX - previousDevicePosX;
            double transDeviceAdjY = alignedDevicePosY - previousDevicePosY;
            int deviceWidth = (int)Math.floor((double)this.getIconWidth() * scaling - transDeviceAdjX);
            int deviceHeight = (int)Math.floor((double)this.getIconHeight() * scaling - transDeviceAdjY);
            this.paintIcon(c, g2, deviceWidth, deviceHeight, scaling);
        }
        finally {
            g2.dispose();
        }
    }

    protected abstract void paintIcon(Component var1, Graphics2D var2, int var3, int var4, double var5);
}

