/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.impl.ModuleToUnnamedBridge;
import org.graalvm.word.UnsignedWord;

final class ModuleToUnnamedLogHandlerGen
extends ModuleToUnnamedBridge.ModuleToUnnamedLogHandler {
    private static final Handles HANDLES;
    final Object receiver;

    public ModuleToUnnamedLogHandlerGen(Object receiver) {
        this.receiver = Objects.requireNonNull(receiver);
    }

    public void fatalError() {
        try {
            ModuleToUnnamedLogHandlerGen.HANDLES.fatalError_.invoke(this.receiver);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedLogHandlerGen.handleException_(t);
        }
    }

    public void flush() {
        try {
            ModuleToUnnamedLogHandlerGen.HANDLES.flush_.invoke(this.receiver);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedLogHandlerGen.handleException_(t);
        }
    }

    public void log(CCharPointer bytes_, UnsignedWord length_) {
        try {
            ModuleToUnnamedLogHandlerGen.HANDLES.log_.invoke(this.receiver, bytes_, length_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedLogHandlerGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = ModuleToUnnamedLogHandlerGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle fatalError_;
        private final MethodHandle flush_;
        private final MethodHandle log_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeLogHandler = lookup.findClass(LogHandler.class.getName());
            this.fatalError_ = lookup.findVirtual(typeLogHandler, "fatalError", MethodType.methodType(Void.TYPE, List.of()));
            this.flush_ = lookup.findVirtual(typeLogHandler, "flush", MethodType.methodType(Void.TYPE, List.of()));
            this.log_ = lookup.findVirtual(typeLogHandler, "log", MethodType.methodType(Void.TYPE, List.of(CCharPointer.class, UnsignedWord.class)));
        }
    }
}

