/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;

public class UnifierTest {
    @Test
    public void testUnificationCase() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        PatternToken elLower = new PatternToken("\\p{Ll}+", true, true, false);
        PatternToken elUpper = new PatternToken("\\p{Lu}\\p{Ll}+", true, true, false);
        PatternToken elAllUpper = new PatternToken("\\p{Lu}+$", true, true, false);
        unifierConfig.setEquivalence("case-sensitivity", "lowercase", elLower);
        unifierConfig.setEquivalence("case-sensitivity", "uppercase", elUpper);
        unifierConfig.setEquivalence("case-sensitivity", "alluppercase", elAllUpper);
        AnalyzedToken lower1 = new AnalyzedToken("lower", "JJR", "lower");
        AnalyzedToken lower2 = new AnalyzedToken("lowercase", "JJ", "lowercase");
        AnalyzedToken upper1 = new AnalyzedToken("Uppercase", "JJ", "Uppercase");
        AnalyzedToken upper2 = new AnalyzedToken("John", "NNP", "John");
        AnalyzedToken upperAll1 = new AnalyzedToken("JOHN", "NNP", "John");
        AnalyzedToken upperAll2 = new AnalyzedToken("JAMES", "NNP", "James");
        Unifier uni = unifierConfig.createUnifier();
        HashMap equiv = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("lowercase");
        equiv.put("case-sensitivity", list1);
        boolean satisfied = uni.isSatisfied(lower1, equiv);
        satisfied &= uni.isSatisfied(lower2, equiv);
        uni.startUnify();
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        satisfied = uni.isSatisfied(upper2, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(lower2, equiv);
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        satisfied = uni.isSatisfied(upper1, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(lower1, equiv);
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        satisfied = uni.isSatisfied(upper2, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(upper1, equiv);
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        equiv.clear();
        list1.clear();
        list1.add("uppercase");
        equiv.put("case-sensitivity", list1);
        satisfied = uni.isSatisfied(upper2, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(upper1, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        equiv.clear();
        list1.clear();
        list1.add("alluppercase");
        equiv.put("case-sensitivity", list1);
        satisfied = uni.isSatisfied(upper2, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(upper1, equiv);
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        satisfied = uni.isSatisfied(upperAll2, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(upperAll1, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
    }

    @Test
    public void testUnificationNumber() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        unifierConfig.setEquivalence("number", "singular", this.preparePOSElement(".*[\\.:]sg:.*"));
        unifierConfig.setEquivalence("number", "plural", this.preparePOSElement(".*[\\.:]pl:.*"));
        Unifier uni = unifierConfig.createUnifier();
        AnalyzedToken sing1 = new AnalyzedToken("ma\u0142y", "adj:sg:blahblah", "ma\u0142y");
        AnalyzedToken sing2 = new AnalyzedToken("cz\u0142owiek", "subst:sg:blahblah", "cz\u0142owiek");
        HashMap equiv = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("singular");
        equiv.put("number", list1);
        boolean satisfied = uni.isSatisfied(sing1, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        AnalyzedToken sing1a = new AnalyzedToken("ma\u0142y", "adj:pl:blahblah", "ma\u0142y");
        satisfied = uni.isSatisfied(sing1, equiv);
        satisfied |= uni.isSatisfied(sing1a, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        list1.add("plural");
        equiv.clear();
        equiv.put("number", list1);
        sing1a = new AnalyzedToken("ma\u0142y", "adj:pl:blahblah", "ma\u0142y");
        satisfied = uni.isSatisfied(sing1, equiv);
        satisfied |= uni.isSatisfied(sing1a, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        sing1a = new AnalyzedToken("ma\u0142y", "adj:pl:blahblah", "ma\u0142y");
        equiv.clear();
        equiv.put("number", null);
        satisfied = uni.isSatisfied(sing1, equiv);
        satisfied |= uni.isSatisfied(sing1a, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        satisfied = uni.isSatisfied(sing1a, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
    }

    @Test
    public void testUnificationNumberGender() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        PatternToken sgPatternToken = new PatternToken("", false, false, false);
        sgPatternToken.setPosToken(new PatternToken.PosToken(".*[\\.:]sg:.*", true, false));
        unifierConfig.setEquivalence("number", "singular", sgPatternToken);
        PatternToken plPatternToken = new PatternToken("", false, false, false);
        plPatternToken.setPosToken(new PatternToken.PosToken(".*[\\.:]pl:.*", true, false));
        unifierConfig.setEquivalence("number", "plural", plPatternToken);
        PatternToken femPatternToken = new PatternToken("", false, false, false);
        femPatternToken.setPosToken(new PatternToken.PosToken(".*[\\.:]f", true, false));
        unifierConfig.setEquivalence("gender", "feminine", femPatternToken);
        PatternToken mascPatternToken = new PatternToken("", false, false, false);
        mascPatternToken.setPosToken(new PatternToken.PosToken(".*[\\.:]m", true, false));
        unifierConfig.setEquivalence("gender", "masculine", mascPatternToken);
        Unifier uni = unifierConfig.createUnifier();
        AnalyzedToken sing1 = new AnalyzedToken("ma\u0142y", "adj:sg:blahblah:m", "ma\u0142y");
        AnalyzedToken sing1a = new AnalyzedToken("ma\u0142a", "adj:sg:blahblah:f", "ma\u0142y");
        AnalyzedToken sing1b = new AnalyzedToken("ma\u0142e", "adj:pl:blahblah:m", "ma\u0142y");
        AnalyzedToken sing2 = new AnalyzedToken("cz\u0142owiek", "subst:sg:blahblah:m", "cz\u0142owiek");
        HashMap<String, Object> equiv = new HashMap<String, Object>();
        equiv.put("number", null);
        equiv.put("gender", null);
        boolean satisfied = uni.isSatisfied(sing1, equiv);
        satisfied |= uni.isSatisfied(sing1a, equiv);
        satisfied |= uni.isSatisfied(sing1b, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        uni.startNextToken();
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        Assert.assertEquals((Object)"[ma\u0142y[ma\u0142y/adj:sg:blahblah:m*], cz\u0142owiek[cz\u0142owiek/subst:sg:blahblah:m*]]", (Object)Arrays.toString(uni.getUnifiedTokens()));
        uni.reset();
    }

    @Test
    public void testMultipleFeats() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        unifierConfig.setEquivalence("number", "singular", this.preparePOSElement(".*[\\.:]sg:.*"));
        unifierConfig.setEquivalence("number", "plural", this.preparePOSElement(".*[\\.:]pl:.*"));
        unifierConfig.setEquivalence("gender", "feminine", this.preparePOSElement(".*[\\.:]f([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*[\\.:]m([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "neutral", this.preparePOSElement(".*[\\.:]n([\\.:].*)?"));
        Unifier uni = unifierConfig.createUnifier();
        AnalyzedToken sing1 = new AnalyzedToken("ma\u0142y", "adj:sg:blahblah:m", "ma\u0142y");
        AnalyzedToken sing1a = new AnalyzedToken("ma\u0142y", "adj:pl:blahblah:f", "ma\u0142y");
        AnalyzedToken sing1b = new AnalyzedToken("ma\u0142y", "adj:pl:blahblah:f", "ma\u0142y");
        AnalyzedToken sing2 = new AnalyzedToken("zgarbiony", "adj:pl:blahblah:f", "zgarbiony");
        AnalyzedToken sing3 = new AnalyzedToken("cz\u0142owiek", "subst:sg:blahblah:m", "cz\u0142owiek");
        HashMap<String, Object> equiv = new HashMap<String, Object>();
        equiv.put("number", null);
        equiv.put("gender", null);
        boolean satisfied = uni.isSatisfied(sing1, equiv);
        satisfied |= uni.isSatisfied(sing1a, equiv);
        satisfied |= uni.isSatisfied(sing1b, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing2, equiv);
        uni.startNextToken();
        satisfied &= uni.isSatisfied(sing3, equiv);
        uni.startNextToken();
        Assert.assertEquals((Object)false, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        uni.isUnified(sing1, equiv, false);
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1b, equiv, true);
        uni.isUnified(sing2, equiv, true);
        Assert.assertEquals((Object)false, (Object)uni.isUnified(sing3, equiv, true));
        uni.reset();
        sing1a = new AnalyzedToken("osobiste", "adj:pl:nom.acc.voc:f.n.m2.m3:pos:aff", "osobisty");
        sing1b = new AnalyzedToken("osobiste", "adj:sg:nom.acc.voc:n:pos:aff", "osobisty");
        sing2 = new AnalyzedToken("god\u0142o", "subst:sg:nom.acc.voc:n", "god\u0142o");
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1b, equiv, true);
        Assert.assertEquals((Object)true, (Object)uni.isUnified(sing2, equiv, true));
        Assert.assertEquals((Object)"[osobiste[osobisty/adj:sg:nom.acc.voc:n:pos:aff*], god\u0142o[god\u0142o/subst:sg:nom.acc.voc:n*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        uni.reset();
        sing1a = new AnalyzedToken("osobiste", "adj:pl:nom.acc.voc:f.n.m2.m3:pos:aff", "osobisty");
        sing1b = new AnalyzedToken("osobiste", "adj:sg:nom.acc.voc:n:pos:aff", "osobisty");
        AnalyzedToken sing2a = new AnalyzedToken("god\u0142o", "subst:sg:nom.acc.voc:n", "god\u0142o");
        AnalyzedToken sing2b = new AnalyzedToken("god\u0142o", "indecl", "god\u0142o");
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1b, equiv, true);
        uni.isUnified(sing2a, equiv, false);
        Assert.assertEquals((Object)true, (Object)uni.isUnified(sing2b, equiv, true));
        Assert.assertEquals((Object)"[osobiste[osobisty/adj:sg:nom.acc.voc:n:pos:aff*], god\u0142o[god\u0142o/subst:sg:nom.acc.voc:n*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        uni.reset();
        AnalyzedToken plur1 = new AnalyzedToken("zgarbieni", "adj:pl:foobar:m", "zgarbiony");
        AnalyzedToken plur2 = new AnalyzedToken("zgarbieni", "adj:pl:blabla:m", "zgarbiony");
        AnalyzedToken plur3 = new AnalyzedToken("ludzie", "subst:pl:blabla:m", "cz\u0142owiek");
        AnalyzedToken plur4 = new AnalyzedToken("ludzie", "subst:pl:pampam:m", "cz\u0142owiek");
        uni.isUnified(plur1, equiv, false);
        uni.isUnified(plur2, equiv, true);
        uni.isUnified(plur3, equiv, false);
        Assert.assertTrue((boolean)uni.isUnified(plur4, equiv, true));
        Assert.assertEquals((Object)"[zgarbieni[zgarbiony/adj:pl:foobar:m*,zgarbiony/adj:pl:blabla:m*], ludzie[cz\u0142owiek/subst:pl:blabla:m*,cz\u0142owiek/subst:pl:pampam:m*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        uni.reset();
        AnalyzedToken case1a = new AnalyzedToken("xx", "abc:sg:f", "xx");
        AnalyzedToken case1b = new AnalyzedToken("xx", "cde:pl:f", "xx");
        AnalyzedToken case2a = new AnalyzedToken("yy", "abc:pl:f", "yy");
        AnalyzedToken case2b = new AnalyzedToken("yy", "cde:as:f", "yy");
        AnalyzedToken case2c = new AnalyzedToken("yy", "cde:pl:c", "yy");
        AnalyzedToken case2d = new AnalyzedToken("yy", "abc:sg:f", "yy");
        AnalyzedToken case2e = new AnalyzedToken("yy", "efg:aa:e", "yy");
        uni.isUnified(case1a, equiv, false);
        uni.isUnified(case1b, equiv, true);
        uni.isUnified(case2a, equiv, false);
        uni.isUnified(case2b, equiv, false);
        uni.isUnified(case2c, equiv, false);
        uni.isUnified(case2d, equiv, false);
        Assert.assertTrue((boolean)uni.isUnified(case2e, equiv, true));
        Assert.assertEquals((Object)"[xx[xx/abc:sg:f*,xx/cde:pl:f*], yy[yy/abc:pl:f*,yy/abc:sg:f*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        uni.reset();
        AnalyzedToken tokenComplex1_1 = new AnalyzedToken("xx", "abc:sg:f", "xx1");
        AnalyzedToken tokenComplex1_2 = new AnalyzedToken("xx", "cde:pl:f", "xx2");
        AnalyzedToken tokenComplex2_1 = new AnalyzedToken("yy", "abc:sg:f", "yy1");
        AnalyzedToken tokenComplex2_2 = new AnalyzedToken("yy", "cde:pl:f", "yy2");
        AnalyzedToken tokenComplex3 = new AnalyzedToken("zz", "cde:sg:f", "zz");
        uni.isUnified(tokenComplex1_1, equiv, false);
        uni.isUnified(tokenComplex1_2, equiv, true);
        uni.isUnified(tokenComplex2_1, equiv, false);
        uni.isUnified(tokenComplex2_2, equiv, true);
        Assert.assertEquals((Object)"[xx[xx1/abc:sg:f*,xx2/cde:pl:f*], yy[yy1/abc:sg:f*,yy2/cde:pl:f*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        Assert.assertTrue((boolean)uni.isUnified(tokenComplex3, equiv, true));
        Assert.assertEquals((Object)"[xx[xx1/abc:sg:f*], yy[yy1/abc:sg:f*], zz[zz/cde:sg:f*]]", (Object)Arrays.toString(uni.getFinalUnified()));
    }

    @Test
    public void testMultipleFeatsWithMultipleTypes() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        unifierConfig.setEquivalence("number", "singular", this.preparePOSElement(".*[\\.:]sg:.*"));
        unifierConfig.setEquivalence("number", "plural", this.preparePOSElement(".*[\\.:]pl:.*"));
        unifierConfig.setEquivalence("gender", "feminine", this.preparePOSElement(".*[\\.:]f([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*[\\.:]m1([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*[\\.:]m2([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*[\\.:]m3([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "neutral1", this.preparePOSElement(".*[\\.:]n1(?:[\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "neutral2", this.preparePOSElement(".*[\\.:]n2(?:[\\.:].*)?"));
        unifierConfig.setEquivalence("case", "nominativus", this.preparePOSElement(".*[\\.:]nom[\\.:]?.*"));
        unifierConfig.setEquivalence("case", "accusativus", this.preparePOSElement(".*[\\.:]acc[\\.:]?.*"));
        unifierConfig.setEquivalence("case", "dativus", this.preparePOSElement(".*[\\.:]dat[\\.:]?.*"));
        unifierConfig.setEquivalence("case", "vocativus", this.preparePOSElement(".*[\\.:]voc[\\.:]?.*"));
        Unifier uni = unifierConfig.createUnifier();
        AnalyzedToken sing1 = new AnalyzedToken("niezgorsze", "adj:sg:acc:n1.n2:pos", "niezgorszy");
        AnalyzedToken sing1a = new AnalyzedToken("niezgorsze", "adj:pl:acc:m2.m3.f.n1.n2.p2.p3:pos", "niezgorszy");
        AnalyzedToken sing1b = new AnalyzedToken("niezgorsze", "adj:pl:nom.voc:m2.m3.f.n1.n2.p2.p3:pos", "niezgorszy");
        AnalyzedToken sing1c = new AnalyzedToken("niezgorsze", "adj:sg:nom.voc:n1.n2:pos", "niezgorszy");
        AnalyzedToken sing2 = new AnalyzedToken("lekarstwo", "subst:sg:acc:n2", "lekarstwo");
        AnalyzedToken sing2b = new AnalyzedToken("lekarstwo", "subst:sg:nom:n2", "lekarstwo");
        AnalyzedToken sing2c = new AnalyzedToken("lekarstwo", "subst:sg:voc:n2", "lekarstwo");
        HashMap<String, Object> equiv = new HashMap<String, Object>();
        equiv.put("number", null);
        equiv.put("gender", null);
        equiv.put("case", null);
        uni.isUnified(sing1, equiv, false);
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1b, equiv, false);
        uni.isUnified(sing1c, equiv, true);
        uni.isUnified(sing2, equiv, false);
        uni.isUnified(sing2b, equiv, false);
        Assert.assertEquals((Object)true, (Object)uni.isUnified(sing2c, equiv, true));
        Assert.assertEquals((Object)"[niezgorsze[niezgorszy/adj:sg:acc:n1.n2:pos*,niezgorszy/adj:sg:nom.voc:n1.n2:pos*], lekarstwo[lekarstwo/subst:sg:acc:n2*,lekarstwo/subst:sg:nom:n2*,lekarstwo/subst:sg:voc:n2*]]", (Object)Arrays.toString(uni.getUnifiedTokens()));
        uni.reset();
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1, equiv, false);
        uni.isUnified(sing1c, equiv, false);
        uni.isUnified(sing1b, equiv, true);
        uni.isUnified(sing2b, equiv, false);
        uni.isUnified(sing2c, equiv, false);
        Assert.assertEquals((Object)true, (Object)uni.isUnified(sing2, equiv, true));
        Assert.assertEquals((Object)"[niezgorsze[niezgorszy/adj:sg:acc:n1.n2:pos*,niezgorszy/adj:sg:nom.voc:n1.n2:pos*], lekarstwo[lekarstwo/subst:sg:nom:n2*,lekarstwo/subst:sg:voc:n2*,lekarstwo/subst:sg:acc:n2*]]", (Object)Arrays.toString(uni.getUnifiedTokens()));
        uni.reset();
    }

    private PatternToken preparePOSElement(String posString) {
        PatternToken pToken = new PatternToken("", false, false, false);
        pToken.setPosToken(new PatternToken.PosToken(posString, true, false));
        return pToken;
    }

    @Test
    public void testNegation() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        unifierConfig.setEquivalence("number", "singular", this.preparePOSElement(".*[\\.:]sg:.*"));
        unifierConfig.setEquivalence("number", "plural", this.preparePOSElement(".*[\\.:]pl:.*"));
        unifierConfig.setEquivalence("gender", "feminine", this.preparePOSElement(".*:f"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*:m"));
        Unifier uni = unifierConfig.createUnifier();
        AnalyzedToken sing_masc = new AnalyzedToken("parvus", "adj:sg:blahblah:m", "parvus");
        AnalyzedToken plur_masc = new AnalyzedToken("parvi", "adj:sg:blahblah:m", "parvus");
        AnalyzedToken plur_fem = new AnalyzedToken("parvae", "adj:pl:blahblah:f", "parvus");
        AnalyzedToken sing_fem = new AnalyzedToken("parva", "adj:sg:blahblah:f", "parvus");
        AnalyzedToken det_sing_fem = new AnalyzedToken("una", "det:sg:blahblah:f", "unus");
        AnalyzedToken det_plur_fem = new AnalyzedToken("unae", "det:pl:blahblah:f", "unus");
        AnalyzedToken det_sing_masc = new AnalyzedToken("unus", "det:sg:blahblah:m", "unus");
        AnalyzedToken det_plur_masc = new AnalyzedToken("uni", "det:sg:blahblah:m", "unus");
        AnalyzedToken subst_sing_fem = new AnalyzedToken("discrepatio", "subst:sg:blahblah:f", "discrepatio");
        AnalyzedToken subst_plur_fem = new AnalyzedToken("discrepationes", "subst:sg:blahblah:f", "discrepatio");
        AnalyzedToken subst_sing_masc = new AnalyzedToken("homo", "sg:sg:blahblah:m", "homo");
        AnalyzedToken subst_plur_masc = new AnalyzedToken("homines", "sg:sg:blahblah:m", "homo");
        HashMap<String, Object> equiv = new HashMap<String, Object>();
        equiv.put("number", null);
        equiv.put("gender", null);
        boolean satisfied = uni.isSatisfied(det_sing_masc, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing_masc, equiv);
        uni.startNextToken();
        satisfied &= uni.isSatisfied(subst_sing_masc, equiv);
        uni.startNextToken();
        Assert.assertEquals((Object)true, (Object)(satisfied &= uni.getFinalUnificationValue(equiv)));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(sing_masc, equiv, true);
        Assert.assertEquals((Object)true, (Object)uni.isUnified(subst_sing_masc, equiv, true));
        uni.reset();
        satisfied = uni.isSatisfied(det_sing_masc, equiv);
        uni.startUnify();
        satisfied &= uni.isSatisfied(sing_masc, equiv);
        uni.startNextToken();
        satisfied &= uni.isSatisfied(subst_sing_masc, equiv);
        uni.startNextToken();
        Assert.assertEquals((Object)false, (Object)(!(satisfied &= uni.getFinalUnificationValue(equiv)) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(sing_masc, equiv, true);
        Assert.assertEquals((Object)false, (Object)(!uni.isUnified(subst_sing_masc, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_fem, equiv, true);
        uni.isUnified(sing_masc, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_masc, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(sing_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_masc, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(sing_masc, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_fem, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(plur_masc, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_fem, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_masc, equiv, true);
        uni.isUnified(plur_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_fem, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_plur_fem, equiv, true);
        uni.isUnified(plur_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_sing_fem, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_fem, equiv, true);
        uni.isUnified(plur_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_plur_fem, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_sing_fem, equiv, true);
        uni.isUnified(plur_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_plur_masc, equiv, true) ? 1 : 0));
        uni.reset();
        uni.isUnified(det_plur_masc, equiv, true);
        uni.isUnified(plur_fem, equiv, true);
        Assert.assertEquals((Object)true, (Object)(!uni.isUnified(subst_plur_masc, equiv, true) ? 1 : 0));
        uni.reset();
    }

    @Test
    public void testAddNeutralElement() {
        UnifierConfiguration unifierConfig = new UnifierConfiguration();
        unifierConfig.setEquivalence("number", "singular", this.preparePOSElement(".*[\\.:]sg:.*"));
        unifierConfig.setEquivalence("number", "plural", this.preparePOSElement(".*[\\.:]pl:.*"));
        unifierConfig.setEquivalence("gender", "feminine", this.preparePOSElement(".*[\\.:]f([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "masculine", this.preparePOSElement(".*[\\.:]m([\\.:].*)?"));
        unifierConfig.setEquivalence("gender", "neutral", this.preparePOSElement(".*[\\.:]n([\\.:].*)?"));
        Unifier uni = unifierConfig.createUnifier();
        HashMap<String, Object> equiv = new HashMap<String, Object>();
        equiv.put("number", null);
        equiv.put("gender", null);
        AnalyzedToken sing1a = new AnalyzedToken("osobiste", "adj:pl:nom.acc.voc:f.n.m2.m3:pos:aff", "osobisty");
        AnalyzedToken sing1b = new AnalyzedToken("osobiste", "adj:sg:nom.acc.voc:n:pos:aff", "osobisty");
        AnalyzedToken sing2 = new AnalyzedToken("god\u0142o", "subst:sg:nom.acc.voc:n", "god\u0142o");
        AnalyzedToken comma = new AnalyzedToken(",", "comma", ",");
        uni.isUnified(sing1a, equiv, false);
        uni.isUnified(sing1b, equiv, true);
        uni.addNeutralElement(new AnalyzedTokenReadings(comma, 0));
        Assert.assertEquals((Object)true, (Object)uni.isUnified(sing2, equiv, true));
        Assert.assertEquals((Object)"[osobiste[osobisty/adj:sg:nom.acc.voc:n:pos:aff*], ,[,/comma*], god\u0142o[god\u0142o/subst:sg:nom.acc.voc:n*]]", (Object)Arrays.toString(uni.getFinalUnified()));
        uni.reset();
    }
}

