/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class LanguageLister {
    LanguageLister() {
    }

    public static void main(String[] args) throws IOException {
        List<String> languages = LanguageLister.readFilesFromClassPathFolder("languages/.");
        for (String lang : languages) {
            System.out.println("names.add(\"" + lang + "\");");
        }
        System.out.println("--------------------------------");
        List<String> shortText = LanguageLister.readFilesFromClassPathFolder("languages.shorttext/.");
        for (String text : shortText) {
            System.out.println("texts.add(\"" + text + "\");");
        }
    }

    private static List<String> readFilesFromClassPathFolder(String resourceNameFolder) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        ClassLoader loader = LanguageLister.class.getClassLoader();
        try (InputStream in = loader.getResourceAsStream(resourceNameFolder);){
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            while ((line = rdr.readLine()) != null) {
                files.add(line);
            }
            rdr.close();
        }
        return files;
    }
}

