/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%b\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"I!\u000b\u0001BC\u0002\u0013\u0005\u0011e\u0015\u0005\t5\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011I\u0004!\u0011!Q\u0001\nMDQa\u001e\u0001\u0005\u0002aD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u0013Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005E\u0002\u0001\"\u0011\u0002*!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!!+\u0001\t\u0003\nY\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\r\u0001\u0011%!1\u0004\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0005Q\u0011V-\\8uK2+\u0017\rZ3s\u000b:$\u0007k\\5oi*\u0011!eI\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0011\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001O=J\u0004C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A:T\"A\u0019\u000b\u0005\t\u0012$B\u0001\u00134\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\n$A\u0004'fC\u0012,'/\u00128e!>Lg\u000e\u001e\t\u0003uuj\u0011a\u000f\u0006\u0003y\r\nQ!\u001e;jYNL!AP\u001e\u0003\u000f1{wmZ5oO\u0006IAn\\4Qe\u00164\u0017\u000e\u001f\t\u0003\u0003*s!A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015+\u0013A\u0002\u001fs_>$hHC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIe)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%G\u00039\u0011Gn\\2lS:<7+\u001a8eKJ\u0004\"a\u0014)\u000e\u0003\u0005J!!U\u0011\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002'\u0019,Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u001a\u0002\u000f\rd\u0017.\u001a8ug&\u0011\u0011L\u0016\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u0001\u0015M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0011\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005=k\u0016B\u00010\"\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011q*Y\u0005\u0003E\u0006\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\r\u0005\u0002PK&\u0011a-\t\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u00042!\u001b6m\u001b\u00051\u0015BA6G\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002na6\taN\u0003\u0002pc\u000511m\\7n_:L!!\u001d8\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f1C\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ\u00042!\u001b6u!\tIW/\u0003\u0002w\r\n!Aj\u001c8h\u0003\u0019a\u0014N\\5u}QY\u0011P_>}{z|\u0018\u0011AA\u0002!\ty\u0005\u0001C\u0003@\u0015\u0001\u0007\u0001\tC\u0003N\u0015\u0001\u0007a\nC\u0003S\u0015\u0001\u0007A\u000bC\u0003\\\u0015\u0001\u0007A\fC\u0003`\u0015\u0001\u0007\u0001\rC\u0003d\u0015\u0001\u0007A\rC\u0003h\u0015\u0001\u0007\u0001\u000eC\u0003s\u0015\u0001\u00071/A\u0004nCb<\u0016-\u001b;\u0016\u0005\u0005%\u0001c\u0001\u0015\u0002\f%\u0019\u0011QB\u0015\u0003\u000f%sG/Z4fe\u0006AQ.\u0019=XC&$\b%\u0001\u0005nS:\u0014\u0015\u0010^3t\u0003%i\u0017N\u001c\"zi\u0016\u001c\b%\u0001\u0005nCb\u0014\u0015\u0010^3t\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%A\u0005gKR\u001c\u0007nU5{K\u0006Qa-\u001a;dQNK'0\u001a\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIR\u0011\u0011\u0011\u0005\t\u0004S\u0006\r\u0012bAA\u0013\r\n9!i\\8mK\u0006t\u0017!D5oSRL\u0017\r^3DY>\u001cX\r\u0006\u0002\u0002,A\u0019\u0011.!\f\n\u0007\u0005=bI\u0001\u0003V]&$\u0018!B2m_N,\u0017A\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\t\u0014a\u00028fi^|'o[\u0005\u0005\u0003\u0003\nYD\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u000b\u0019,Go\u00195\u0015\t\u0005\u001d\u0013\u0011\u000f\t\t\u0003\u0013\ny%a\u0015\u0002^5\u0011\u00111\n\u0006\u0004\u0003\u001bZ\u0013\u0001B;uS2LA!!\u0015\u0002L\t\u0019Q*\u00199\u0011\t\u0005U\u0013\u0011L\u0007\u0003\u0003/R!a\u001c\u001a\n\t\u0005m\u0013q\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty&a\u001b\u000f\t\u0005\u0005\u0014qM\u0007\u0003\u0003GRA!!\u001a\u0002X\u00059Q.Z:tC\u001e,\u0017\u0002BA5\u0003G\n\u0011CR3uG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\ti'a\u001c\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\tI'a\u0019\t\u000f\u0005Mt\u00031\u0001\u0002v\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u0011qOAB\u001d\u0011\tI(a \u000e\u0005\u0005m$\u0002BA?\u0003/\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u0003\u000bY(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002\u0006\u0006\u001d%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0003\u000bY(A\ngKR\u001c\u0007.R1sY&,7\u000f^(gMN,G\u000f\u0006\u0004\u0002\u000e\u0006M\u0015q\u0013\t\u0004[\u0006=\u0015bAAI]\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBAK1\u0001\u0007\u00111K\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tI\n\u0007a\u0001\u00037\u000b!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQB\u0019\u0011.!(\n\u0007\u0005}eIA\u0002J]R\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\ti)!*\u0002(\"9\u0011QS\rA\u0002\u0005M\u0003bBAM3\u0001\u0007\u00111T\u0001\u0019M\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$HCBAG\u0003[\u000by\u000bC\u0004\u0002\u0016j\u0001\r!a\u0015\t\u000f\u0005e%\u00041\u0001\u0002\u001c\u0006Ya-\u001a;dQ>3gm]3u)!\ti)!.\u00028\u0006e\u0006bBAK7\u0001\u0007\u00111\u000b\u0005\b\u00033[\u0002\u0019AAN\u0011\u0019\tYl\u0007a\u0001i\u0006IA/[7fgR\fW\u000e]\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005\u0005\u0017Q\u001d\t\t\u0003\u0013\ny%a\u0015\u0002DB!\u0011QYAp\u001d\u0011\t9-a7\u000f\t\u0005%\u0017\u0011\u001c\b\u0005\u0003\u0017\f9N\u0004\u0003\u0002N\u0006Ug\u0002BAh\u0003't1aQAi\u0013\u00051\u0014B\u0001\u001b6\u0013\t!3'\u0003\u0002pe%!\u0011QMA,\u0013\u0011\ti.a\u0019\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003C\f\u0019O\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\u000b\t\u0005u\u00171\r\u0005\b\u0003Od\u0002\u0019AAu\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\t\u0003\u0013\ny%a\u0015\u0002lB!\u0011Q^Az\u001d\u0011\t\t'a<\n\t\u0005E\u00181M\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f\u0017\u0002BA{\u0003o\u0014\u0001d\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d)beRLG/[8o\u0015\u0011\t\t0a\u0019\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0002~\n=\u0001#\u0002\u0019\u0002\u0000\n\r\u0011b\u0001B\u0001c\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N\u0004b!!\u0013\u0003\u0006\t%\u0011\u0002\u0002B\u0004\u0003\u0017\u0012\u0001b\u00149uS>t\u0017\r\u001c\t\u0004a\t-\u0011b\u0001B\u0007c\ta!+\u001a9mS\u000e\fg)\u001a;dQ\"9\u0011q]\u000fA\u0002\tE\u0001\u0003CA%\u0003\u001f\n\u0019Fa\u0005\u0011\u0007A\u0012)\"C\u0002\u0003\u0018E\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\fac\u001d5pk2$gi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u000b\t\u0003C\u0011iBa\b\u0003$!)1M\ba\u0001I\"9!\u0011\u0005\u0010A\u0002\tM\u0011A\u00034fi\u000eD7\u000b^1uK\"9\u0011Q\u0013\u0010A\u0002\u0005M\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0001\u0003")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Function0<Object> brokerEpochSupplier;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    public boolean isTruncationOnFetchSupported() {
        return true;
    }

    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    public void close() {
        this.blockingSender.close();
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    public java.util.Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return java.util.Map.of();
        }
        return fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion());
    }

    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
    }

    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
    }

    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -4L);
    }

    private OffsetAndEpoch fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder requestBuilder = ListOffsetsRequest.Builder.forReplica((short)((MetadataVersion)this.metadataVersionSupplier.apply()).listOffsetRequestVersion(), (int)this.brokerConfig.brokerId()).setTargetTimes(Collections.singletonList(topic));
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$1))).get()).partitions()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$2))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            return new OffsetAndEpoch(responsePartition.offset(), responsePartition.leaderEpoch());
        }
        throw errors.exception();
    }

    public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return java.util.Map.of();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        partitions.forEach((topicPartition, epochData) -> {
            OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics.find(topicPartition.topic());
            if (topic == null) {
                topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
                topics.add((ImplicitLinkedHashCollection.Element)topic);
            }
            topic.partitions().add(epochData);
        });
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)topics, (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Sending offset for leader epoch request " + epochRequest);
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Received leaderEpoch response " + response);
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responseBody.data().topics()).asScala().flatMap((Function1 & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1 & Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Error when sending leader epoch request for " + partitions, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                }
                throw new MatchError(null);
            })).asJava();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultWithPartitions<Optional<ReplicaFetch>> buildFetch(java.util.Map<TopicPartition, PartitionFetchState> partitions) {
        Optional<Object> optional;
        Set partitionsWithError = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        partitions.forEach((topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? fetchState.lastFetchedEpoch() : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.topicId().orElse(Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    partitionsWithError.$plus$eq(topicPartition);
                    return;
                }
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            optional = Optional.empty();
        } else {
            void forReplica_fetchData;
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaEpoch;
            MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
            short version = !fetchData.canUseTopicIds() ? (short)12 : (short)metadataVersion.fetchRequestVersion();
            java.util.Map map = fetchData.toSend();
            int n = Predef$.MODULE$.Integer2int(this.minBytes());
            int n2 = Predef$.MODULE$.Integer2int(this.maxWait());
            long l = this.brokerEpochSupplier.apply$mcJ$sp();
            int forReplica_replicaId = this.brokerConfig.brokerId();
            map = null;
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(version, version, forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, (java.util.Map)forReplica_fetchData).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).removed(fetchData.toForget()).replaced(fetchData.toReplace()).metadata(fetchData.metadata());
            optional = Optional.of(new ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        Optional fetchRequestOpt = optional;
        return new ResultWithPartitions(fetchRequestOpt, CollectionConverters$.MODULE$.MutableSetHasAsJava(partitionsWithError).asJava());
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public String toString() {
        return "RemoteLeaderEndPoint(blockingSender=" + this.blockingSender + ")";
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$1) {
        String string = x$1.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$2) {
        return x$2.partitionIndex() == topicPartition$1.partition();
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier, Function0<Object> brokerEpochSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.logIdent_$eq(logPrefix);
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

