/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter is an implementation of a Canny edge detector for scalar-
valued images.


Based on John Canny's paper "A Computational Approach to Edge
Detection"(IEEE Transactions on Pattern Analysis and Machine
Intelligence, Vol. PAMI-8, No.6, November 1986), there are four major
steps used in the edge-detection scheme: (1) Smooth the input image
with Gaussian filter. (2) Calculate the second directional derivatives
of the smoothed image. (3) Non-Maximum Suppression: the zero-crossings
of 2nd derivative are found, and the sign of third derivative is used
to find the correct extrema. (4) The hysteresis thresholding is
applied to the gradient magnitude (multiplied with zero-crossings) of
the smoothed image to find and link edges.

Inputs and Outputs
The input to this filter should be a scalar, real-valued Itk image of
arbitrary dimension. The output should also be a scalar, real-value
Itk image of the same dimensionality.
Parameters
There are four parameters for this filter that control the sub-filters
used by the algorithm.

Variance and Maximum error are used in the Gaussian smoothing of the
input image. See itkDiscreteGaussianImageFilter for information on
these parameters.

Threshold is the lowest allowed value in the output image. Its data
type is the same as the data type of the output image. Any values
below the Threshold level will be replaced with the OutsideValue
parameter value, whose default is zero.
 TodoEdge-linking will be added when an itk connected component
labeling algorithm is available.


See:
 DiscreteGaussianImageFilter

 ZeroCrossingImageFilter

 ThresholdImageFilter

 itk::simple::CannyEdgeDetection for the procedural interface

 itk::CannyEdgeDetectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCannyEdgeDetectionImageFilter.h
*/
public class CannyEdgeDetectionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CannyEdgeDetectionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CannyEdgeDetectionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CannyEdgeDetectionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CannyEdgeDetectionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CannyEdgeDetectionImageFilter::~CannyEdgeDetectionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CannyEdgeDetectionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CannyEdgeDetectionImageFilter::CannyEdgeDetectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CannyEdgeDetectionImageFilter() {
    this(SimpleITKJNI.new_CannyEdgeDetectionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetLowerThreshold(double LowerThreshold)

Set the lower threshold value for detected edges.

*/
public  void setLowerThreshold(double LowerThreshold) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setLowerThreshold(swigCPtr, this, LowerThreshold);
  }

  /**
double itk::simple::CannyEdgeDetectionImageFilter::GetLowerThreshold() const
*/
public  double getLowerThreshold() {
    return SimpleITKJNI.CannyEdgeDetectionImageFilter_getLowerThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetUpperThreshold(double UpperThreshold)

Set the upper threshold value for detected edges.

*/
public  void setUpperThreshold(double UpperThreshold) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setUpperThreshold(swigCPtr, this, UpperThreshold);
  }

  /**
double itk::simple::CannyEdgeDetectionImageFilter::GetUpperThreshold() const
*/
public  double getUpperThreshold() {
    return SimpleITKJNI.CannyEdgeDetectionImageFilter_getUpperThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetVariance(std::vector&lt; double &gt; Variance)

Set/Get the variance of the Gaussian smoothing filter.

*/
public  void setVariance(VectorDouble Variance) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setVariance__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Variance), Variance);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetVariance(std::vector&lt; double &gt; Variance)

Set/Get the variance of the Gaussian smoothing filter.

*/
public  void setVariance(double value) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setVariance__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::CannyEdgeDetectionImageFilter::GetVariance() const

Set/Get the variance of the Gaussian smoothing filter.

*/
public  VectorDouble getVariance() {
    return new VectorDouble(SimpleITKJNI.CannyEdgeDetectionImageFilter_getVariance(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError(std::vector&lt; double &gt; MaximumError)

Set/Get the MaximumError parameter used by the Gaussian smoothing
filter in this algorithm

*/
public  void setMaximumError(VectorDouble MaximumError) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setMaximumError__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(MaximumError), MaximumError);
  }

  /**
Self&amp; itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError(std::vector&lt; double &gt; MaximumError)

Set/Get the MaximumError parameter used by the Gaussian smoothing
filter in this algorithm

*/
public  void setMaximumError(double value) {
    SimpleITKJNI.CannyEdgeDetectionImageFilter_setMaximumError__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::CannyEdgeDetectionImageFilter::GetMaximumError() const

Set/Get the maximum error of the Gaussian smoothing kernel in each
dimensional direction.

*/
public  VectorDouble getMaximumError() {
    return new VectorDouble(SimpleITKJNI.CannyEdgeDetectionImageFilter_getMaximumError(swigCPtr, this), true);
  }

  /**
std::string itk::simple::CannyEdgeDetectionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CannyEdgeDetectionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CannyEdgeDetectionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CannyEdgeDetectionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CannyEdgeDetectionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CannyEdgeDetectionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
