/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.util.Assert;
import reactor.core.publisher.Mono;

public class McpAsyncServerExchange {
    private final McpServerSession session;
    private final McpSchema.ClientCapabilities clientCapabilities;
    private final McpSchema.Implementation clientInfo;
    private volatile McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.INFO;
    private static final TypeReference<McpSchema.CreateMessageResult> CREATE_MESSAGE_RESULT_TYPE_REF = new TypeReference<McpSchema.CreateMessageResult>(){};
    private static final TypeReference<McpSchema.ListRootsResult> LIST_ROOTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListRootsResult>(){};

    public McpAsyncServerExchange(McpServerSession session, McpSchema.ClientCapabilities clientCapabilities, McpSchema.Implementation clientInfo) {
        this.session = session;
        this.clientCapabilities = clientCapabilities;
        this.clientInfo = clientInfo;
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
        if (this.clientCapabilities == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be initialized. Call the initialize method first!"));
        }
        if (this.clientCapabilities.sampling() == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be configured with sampling capabilities"));
        }
        return this.session.sendRequest("sampling/createMessage", createMessageRequest, CREATE_MESSAGE_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ListRootsResult> listRoots() {
        return this.listRoots(null);
    }

    public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
        return this.session.sendRequest("roots/list", new McpSchema.PaginatedRequest(cursor), LIST_ROOTS_RESULT_TYPE_REF);
    }

    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
        }
        return Mono.defer(() -> {
            if (this.isNotificationForLevelAllowed(loggingMessageNotification.level())) {
                return this.session.sendNotification("notifications/message", loggingMessageNotification);
            }
            return Mono.empty();
        });
    }

    void setMinLoggingLevel(McpSchema.LoggingLevel minLoggingLevel) {
        Assert.notNull((Object)minLoggingLevel, "minLoggingLevel must not be null");
        this.minLoggingLevel = minLoggingLevel;
    }

    private boolean isNotificationForLevelAllowed(McpSchema.LoggingLevel loggingLevel) {
        return loggingLevel.level() >= this.minLoggingLevel.level();
    }
}

