/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.io;

import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class MapMarshalledProvenance
implements FlatMarshalledProvenance,
Iterable<Pair<String, FlatMarshalledProvenance>> {
    private final Map<String, FlatMarshalledProvenance> map;

    public MapMarshalledProvenance(Map<String, FlatMarshalledProvenance> map) {
        this.map = Collections.unmodifiableMap(new HashMap<String, FlatMarshalledProvenance>(map));
    }

    public MapMarshalledProvenance() {
        this.map = Collections.emptyMap();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<Pair<String, FlatMarshalledProvenance>> iterator() {
        return new MapMarshalledProvenanceIterator(this.map.entrySet().iterator());
    }

    public String toString() {
        return "MapMarshalledProvenance" + this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapMarshalledProvenance)) {
            return false;
        }
        MapMarshalledProvenance that = (MapMarshalledProvenance)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    private static class MapMarshalledProvenanceIterator
    implements Iterator<Pair<String, FlatMarshalledProvenance>> {
        private final Iterator<Map.Entry<String, FlatMarshalledProvenance>> itr;

        public MapMarshalledProvenanceIterator(Iterator<Map.Entry<String, FlatMarshalledProvenance>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Pair<String, FlatMarshalledProvenance> next() {
            Map.Entry<String, FlatMarshalledProvenance> item = this.itr.next();
            return new Pair<String, FlatMarshalledProvenance>(item.getKey(), item.getValue());
        }
    }
}

