/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableDataset;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.sequence.SequenceExample;

public abstract class SequenceDataset<T extends Output<T>>
implements Iterable<SequenceExample<T>>,
Provenancable<DatasetProvenance>,
Serializable {
    private static final Logger logger = Logger.getLogger(SequenceDataset.class.getName());
    private static final long serialVersionUID = 2L;
    protected final OutputFactory<T> outputFactory;
    protected final List<SequenceExample<T>> data = new ArrayList<SequenceExample<T>>();
    protected final DataProvenance sourceProvenance;

    protected SequenceDataset(DataProvenance sourceProvenance, OutputFactory<T> outputFactory) {
        this.sourceProvenance = sourceProvenance;
        this.outputFactory = outputFactory;
    }

    public String getSourceDescription() {
        return "SequenceDataset(source=" + this.sourceProvenance.toString() + ")";
    }

    public List<SequenceExample<T>> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public DataProvenance getSourceProvenance() {
        return this.sourceProvenance;
    }

    public abstract Set<T> getOutputs();

    public SequenceExample<T> getExample(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Example index " + index + " is out of bounds.");
        }
        return this.data.get(index);
    }

    public Dataset<T> getFlatDataset() {
        return new FlatDataset(this);
    }

    public int size() {
        return this.data.size();
    }

    public abstract ImmutableOutputInfo<T> getOutputIDInfo();

    public abstract OutputInfo<T> getOutputInfo();

    public abstract ImmutableFeatureMap getFeatureIDMap();

    public abstract FeatureMap getFeatureMap();

    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    @Override
    public Iterator<SequenceExample<T>> iterator() {
        return this.data.iterator();
    }

    public String toString() {
        return "SequenceDataset(source=" + this.sourceProvenance.toString() + ")";
    }

    private static class FlatDataset<T extends Output<T>>
    extends ImmutableDataset<T> {
        private static final long serialVersionUID = 1L;

        public FlatDataset(SequenceDataset<T> sequenceDataset) {
            super(sequenceDataset.sourceProvenance, sequenceDataset.outputFactory, sequenceDataset.getFeatureIDMap(), sequenceDataset.getOutputIDInfo());
            for (SequenceExample<T> seq : sequenceDataset) {
                for (Example<T> e : seq) {
                    this.data.add(e);
                }
            }
        }
    }
}

