/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.ingest.GetPipelineAction;
import org.opensearch.action.ingest.GetPipelineRequest;
import org.opensearch.action.search.GetSearchPipelineAction;
import org.opensearch.action.search.GetSearchPipelineRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.utils.AgentModelsSearcher;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteModelTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelTransportAction.class);
    static final String TIMEOUT_MSG = "Timeout while deleting model of ";
    static final String BULK_FAILURE_MSG = "Bulk failure while deleting model of ";
    static final String SEARCH_FAILURE_MSG = "Search failure while deleting model of ";
    static final String OS_STATUS_EXCEPTION_MESSAGE = "Failed to delete all model chunks";
    static final String PIPELINE_TARGET_MODEL_KEY = "model_id";
    private Boolean isSafeDelete;
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private Settings settings;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final AgentModelsSearcher agentModelsSearcher;

    @Inject
    public DeleteModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, Settings settings, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, AgentModelsSearcher agentModelsSearcher, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/models/delete", transportService, actionFilters, MLModelDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.agentModelsSearcher = agentModelsSearcher;
        this.settings = settings;
        this.isSafeDelete = (Boolean)MLCommonsSettings.ML_COMMONS_SAFE_DELETE_WITH_USAGE_CHECK.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_SAFE_DELETE_WITH_USAGE_CHECK, it -> {
            this.isSafeDelete = it;
        });
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelDeleteRequest.getModelId();
        String tenantId = mlModelDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        MLModelGetRequest mlModelGetRequest = new MLModelGetRequest(modelId, false, false, tenantId);
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block25: {
                    if (throwable == null) {
                        try {
                            GetResponse gr = r.getResponse();
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    MLModel mlModel;
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    String algorithmName = "";
                                    Map source = r.source();
                                    if (source != null) {
                                        if (source.get("function_name") != null) {
                                            algorithmName = source.get("function_name").toString();
                                        } else if (source.get("algorithm") != null) {
                                            algorithmName = source.get("algorithm").toString();
                                        }
                                    }
                                    if (!TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, (mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName)).getTenantId(), actionListener)) {
                                        return;
                                    }
                                    Boolean isHidden = (Boolean)r.source().get("is_hidden");
                                    MLModelState mlModelState = mlModel.getModelState();
                                    if (isHidden != null && isHidden.booleanValue()) {
                                        if (!isSuperAdmin) {
                                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                        } else if (this.isModelNotDeployed(mlModelState).booleanValue()) {
                                            this.deleteModel(modelId, tenantId, algorithmName, isHidden, actionListener);
                                        } else {
                                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Model cannot be deleted in deploying or deployed state. Try undeploy model first then delete", RestStatus.BAD_REQUEST, new Object[0]));
                                        }
                                    } else {
                                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                                            if (!access.booleanValue()) {
                                                wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                            } else if (this.isModelNotDeployed(mlModelState).booleanValue()) {
                                                if (this.isSafeDelete.booleanValue()) {
                                                    this.checkDownstreamTaskBeforeDeleteModel(modelId, tenantId, mlModel.getAlgorithm().name(), isHidden, actionListener);
                                                } else {
                                                    this.deleteModel(modelId, tenantId, mlModel.getAlgorithm().name(), isHidden, actionListener);
                                                }
                                            } else {
                                                wrappedListener.onFailure((Exception)new OpenSearchStatusException("Model cannot be deleted in deploying or deployed state. Try undeploy model first then delete", RestStatus.BAD_REQUEST, new Object[0]));
                                            }
                                        }, e -> {
                                            log.error(StringUtils.getErrorMessage((String)"Failed to validate Access", (String)modelId, (Boolean)isHidden), (Throwable)e);
                                            wrappedListener.onFailure(e);
                                        }));
                                    }
                                    break block25;
                                }
                                catch (Exception e2) {
                                    log.error("Failed to parse ml model {}", (Object)r.id(), (Object)e2);
                                    wrappedListener.onFailure(e2);
                                }
                                break block25;
                            }
                            this.deleteModelChunksAndController((ActionListener<DeleteResponse>)wrappedListener, modelId, null, false, null);
                        }
                        catch (Exception e3) {
                            wrappedListener.onFailure(e3);
                        }
                    } else {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML model {}", (Object)modelId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    @VisibleForTesting
    void deleteModelChunks(String modelId, Boolean isHidden, ActionListener<Boolean> actionListener) {
        DeleteByQueryRequest deleteModelsRequest = new DeleteByQueryRequest(new String[]{".plugins-ml-model"});
        deleteModelsRequest.setQuery((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new TermsQueryBuilder(PIPELINE_TARGET_MODEL_KEY, new String[]{modelId})).mustNot((QueryBuilder)new TermQueryBuilder("_id", modelId)));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteModelsRequest, ActionListener.wrap(r -> {
            if ((r.getBulkFailures() == null || r.getBulkFailures().isEmpty()) && (r.getSearchFailures() == null || r.getSearchFailures().isEmpty())) {
                log.debug(StringUtils.getErrorMessage((String)"All model chunks are deleted for the provided model.", (String)modelId, (Boolean)isHidden));
                actionListener.onResponse((Object)true);
            } else {
                this.returnFailure((BulkByScrollResponse)r, modelId, actionListener);
            }
        }, e -> {
            log.error(StringUtils.getErrorMessage((String)"Failed to delete model chunks for the provided model", (String)modelId, (Boolean)isHidden), (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void returnFailure(BulkByScrollResponse response, String modelId, ActionListener<Boolean> actionListener) {
        String errorMessage = response.isTimedOut() ? "Failed to delete all model chunks, Timeout while deleting model of " + modelId : (!response.getBulkFailures().isEmpty() ? "Failed to delete all model chunks, Bulk failure while deleting model of " + modelId : "Failed to delete all model chunks, Search failure while deleting model of " + modelId);
        log.debug(response.toString());
        actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    private void deleteModel(String modelId, String tenantId, String functionName, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        DeleteDataObjectRequest deleteDataObjectRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).build();
        this.sdkClient.deleteDataObjectAsync(deleteDataObjectRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                try {
                    DeleteResponse deleteResponse = r.deleteResponse();
                    this.deleteModelChunksAndController(actionListener, modelId, functionName, isHidden, deleteResponse);
                }
                catch (Exception e) {
                    actionListener.onFailure(e);
                }
            } else {
                Exception e = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{ResourceNotFoundException.class}) != null) {
                    this.deleteModelChunksAndController(actionListener, modelId, functionName, isHidden, null);
                } else {
                    log.error(StringUtils.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (Boolean)isHidden), (Throwable)e);
                    actionListener.onFailure(e);
                }
            }
        });
    }

    private void checkDownstreamTaskBeforeDeleteModel(String modelId, String tenantId, String algorithm, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        CountDownLatch countDownLatch = new CountDownLatch(3);
        AtomicBoolean noneBlocked = new AtomicBoolean(true);
        ConcurrentLinkedQueue errorMessages = new ConcurrentLinkedQueue();
        ActionListener countDownActionListener = ActionListener.wrap(b -> {
            countDownLatch.countDown();
            noneBlocked.compareAndSet(true, (boolean)b);
            if (countDownLatch.getCount() == 0L && noneBlocked.get()) {
                this.deleteModel(modelId, tenantId, algorithm, isHidden, actionListener);
            }
        }, e -> {
            countDownLatch.countDown();
            noneBlocked.set(false);
            errorMessages.add(e.getMessage());
            actionListener.onFailure((Exception)new OpenSearchStatusException(e.getMessage(), RestStatus.CONFLICT, new Object[0]));
        });
        this.checkAgentBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
        this.checkIngestPipelineBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
        this.checkSearchPipelineBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
    }

    private void checkAgentBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        SearchRequest searchAgentRequest = this.agentModelsSearcher.constructQueryRequestToSearchModelIdInsideAgent(modelId);
        this.client.search(searchAgentRequest, ActionListener.wrap(searchResponse -> {
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            if (searchHits.length == 0) {
                actionListener.onResponse((Object)true);
            } else {
                String errorMessage = this.formatAgentErrorMessage(searchHits);
                actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.CONFLICT, new Object[0]));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                actionListener.onResponse((Object)true);
                return;
            }
            log.error("Failed to delete ML Model: " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void checkIngestPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        this.checkPipelineBeforeDeleteModel(modelId, actionListener, "ingest", () -> new GetPipelineRequest(new String[0]), (ActionType)GetPipelineAction.INSTANCE);
    }

    private void checkSearchPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        this.checkPipelineBeforeDeleteModel(modelId, actionListener, "search", GetSearchPipelineRequest::new, (ActionType)GetSearchPipelineAction.INSTANCE);
    }

    private void checkPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener, String pipelineType, Supplier<ActionRequest> requestSupplier, ActionType actionType) {
        ActionRequest request = requestSupplier.get();
        this.client.execute(actionType, request, ActionListener.wrap(pipelineResponse -> {
            Map allConfigMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)pipelineResponse.toString(), (boolean)true);
            List<String> allDependentPipelineIds = this.findDependentPipelinesEasy(allConfigMap, modelId);
            if (allDependentPipelineIds.isEmpty()) {
                actionListener.onResponse((Object)true);
            } else {
                actionListener.onFailure((Exception)new OpenSearchStatusException(String.format(Locale.ROOT, "%d %s pipelines are still using this model, please delete or update the pipelines first: %s", allDependentPipelineIds.size(), pipelineType, Arrays.toString(allDependentPipelineIds.toArray(new String[0]))), RestStatus.CONFLICT, new Object[0]));
            }
        }, e -> {
            log.error("Failed to delete ML Model: " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void deleteModelChunksAndController(ActionListener<DeleteResponse> actionListener, String modelId, String functionName, Boolean isHidden, DeleteResponse deleteResponse) {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        AtomicBoolean bothDeleted = new AtomicBoolean(true);
        ActionListener countDownActionListener = ActionListener.wrap(b -> {
            countDownLatch.countDown();
            bothDeleted.compareAndSet(true, (boolean)b);
            if (countDownLatch.getCount() == 0L) {
                if (bothDeleted.get()) {
                    log.debug(StringUtils.getErrorMessage((String)"model chunks and model controller for the provided model deleted successfully", (String)modelId, (Boolean)isHidden));
                    if (deleteResponse != null) {
                        actionListener.onResponse((Object)deleteResponse);
                    } else {
                        actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                    }
                } else {
                    actionListener.onFailure((Exception)new IllegalStateException(StringUtils.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (Boolean)isHidden)));
                }
            }
        }, e -> {
            countDownLatch.countDown();
            bothDeleted.compareAndSet(true, false);
            if (countDownLatch.getCount() == 0L) {
                actionListener.onFailure((Exception)new IllegalStateException(StringUtils.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (Boolean)isHidden), (Throwable)e));
            }
        });
        if (!Objects.equals(functionName, FunctionName.REMOTE.name())) {
            this.deleteModelChunks(modelId, isHidden, (ActionListener<Boolean>)countDownActionListener);
        } else {
            countDownLatch.countDown();
        }
        this.deleteController(modelId, isHidden, (ActionListener<Boolean>)countDownActionListener);
    }

    private void deleteController(final String modelId, final Boolean isHidden, final ActionListener<Boolean> actionListener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-controller", modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){

            public void onResponse(DeleteResponse deleteResponse) {
                log.info(StringUtils.getErrorMessage((String)"Model controller for the provided model successfully deleted from index, result: {}.", (String)modelId, (Boolean)isHidden), (Object)deleteResponse.getResult());
                actionListener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    log.info(StringUtils.getErrorMessage((String)"Model controller not deleted due to no model controller found for the given model.", (String)modelId, (Boolean)isHidden));
                    actionListener.onResponse((Object)true);
                } else {
                    log.error(StringUtils.getErrorMessage((String)"Failed to delete model controller for the given model.", (String)modelId, (Boolean)isHidden), (Throwable)e);
                    actionListener.onFailure(e);
                }
            }
        });
    }

    private Boolean isModelNotDeployed(MLModelState mlModelState) {
        return !mlModelState.equals((Object)MLModelState.LOADED) && !mlModelState.equals((Object)MLModelState.LOADING) && !mlModelState.equals((Object)MLModelState.PARTIALLY_LOADED) && !mlModelState.equals((Object)MLModelState.DEPLOYED) && !mlModelState.equals((Object)MLModelState.DEPLOYING) && !mlModelState.equals((Object)MLModelState.PARTIALLY_DEPLOYED);
    }

    private List<String> findDependentPipelinesEasy(Map<String, Object> allConfigMap, String candidateModelId) {
        ArrayList<String> dependentPipelineConfigurations = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : allConfigMap.entrySet()) {
            String id = entry.getKey();
            Map config = (Map)entry.getValue();
            if (!this.searchThroughConfig(config, candidateModelId).booleanValue()) continue;
            dependentPipelineConfigurations.add(id);
        }
        return dependentPipelineConfigurations;
    }

    private Boolean searchThroughConfig(Object searchCandidate, String candidateId) {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.push(Pair.of((Object)"", (Object)searchCandidate));
        while (!stack.isEmpty()) {
            Pair current = (Pair)stack.pop();
            String currentKey = (String)current.getLeft();
            Object currentCandidate = current.getRight();
            if (currentCandidate instanceof String && candidateId.equals(currentCandidate)) {
                if (!PIPELINE_TARGET_MODEL_KEY.equals(currentKey)) continue;
                return true;
            }
            if (currentCandidate instanceof List) {
                for (Object e : (List)currentCandidate) {
                    stack.push(Pair.of((Object)currentKey, e));
                }
                continue;
            }
            if (!(currentCandidate instanceof Map)) continue;
            for (Map.Entry entry : ((Map)currentCandidate).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                stack.push(Pair.of((Object)key, value));
            }
        }
        return false;
    }

    private String formatAgentErrorMessage(SearchHit[] hits) {
        ArrayList<String> agentIds = new ArrayList<String>();
        for (SearchHit hit : hits) {
            Map sourceAsMap = hit.getSourceAsMap();
            agentIds.add(hit.getId());
        }
        return String.format(Locale.ROOT, "%d agents are still using this model, please delete or update the agents first, all visible agents are: %s", hits.length, Arrays.toString(agentIds.toArray(new String[0])));
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

