/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInsightsAccessScopesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkInsightsAccessScopesRequest> {
    private static final SdkField<List<String>> NETWORK_INSIGHTS_ACCESS_SCOPE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInsightsAccessScopeIds").getter(DescribeNetworkInsightsAccessScopesRequest.getter(DescribeNetworkInsightsAccessScopesRequest::networkInsightsAccessScopeIds)).setter(DescribeNetworkInsightsAccessScopesRequest.setter(Builder::networkInsightsAccessScopeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("NetworkInsightsAccessScopeId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeNetworkInsightsAccessScopesRequest.getter(DescribeNetworkInsightsAccessScopesRequest::filters)).setter(DescribeNetworkInsightsAccessScopesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeNetworkInsightsAccessScopesRequest.getter(DescribeNetworkInsightsAccessScopesRequest::maxResults)).setter(DescribeNetworkInsightsAccessScopesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeNetworkInsightsAccessScopesRequest.getter(DescribeNetworkInsightsAccessScopesRequest::dryRun)).setter(DescribeNetworkInsightsAccessScopesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInsightsAccessScopesRequest.getter(DescribeNetworkInsightsAccessScopesRequest::nextToken)).setter(DescribeNetworkInsightsAccessScopesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, DRY_RUN_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNetworkInsightsAccessScopesRequest.memberNameToFieldInitializer();
    private final List<String> networkInsightsAccessScopeIds;
    private final List<Filter> filters;
    private final Integer maxResults;
    private final Boolean dryRun;
    private final String nextToken;

    private DescribeNetworkInsightsAccessScopesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeIds = builder.networkInsightsAccessScopeIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInsightsAccessScopeIds() {
        return this.networkInsightsAccessScopeIds != null && !(this.networkInsightsAccessScopeIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInsightsAccessScopeIds() {
        return this.networkInsightsAccessScopeIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInsightsAccessScopeIds() ? this.networkInsightsAccessScopeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAccessScopesRequest)) {
            return false;
        }
        DescribeNetworkInsightsAccessScopesRequest other = (DescribeNetworkInsightsAccessScopesRequest)((Object)obj);
        return this.hasNetworkInsightsAccessScopeIds() == other.hasNetworkInsightsAccessScopeIds() && Objects.equals(this.networkInsightsAccessScopeIds(), other.networkInsightsAccessScopeIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInsightsAccessScopesRequest").add("NetworkInsightsAccessScopeIds", this.hasNetworkInsightsAccessScopeIds() ? this.networkInsightsAccessScopeIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("DryRun", (Object)this.dryRun()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeIds": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkInsightsAccessScopeId", NETWORK_INSIGHTS_ACCESS_SCOPE_IDS_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAccessScopesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAccessScopesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> networkInsightsAccessScopeIds = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private Boolean dryRun;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAccessScopesRequest model) {
            super(model);
            this.networkInsightsAccessScopeIds(model.networkInsightsAccessScopeIds);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.dryRun(model.dryRun);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNetworkInsightsAccessScopeIds() {
            if (this.networkInsightsAccessScopeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInsightsAccessScopeIds;
        }

        public final void setNetworkInsightsAccessScopeIds(Collection<String> networkInsightsAccessScopeIds) {
            this.networkInsightsAccessScopeIds = NetworkInsightsAccessScopeIdListCopier.copy(networkInsightsAccessScopeIds);
        }

        @Override
        public final Builder networkInsightsAccessScopeIds(Collection<String> networkInsightsAccessScopeIds) {
            this.networkInsightsAccessScopeIds = NetworkInsightsAccessScopeIdListCopier.copy(networkInsightsAccessScopeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsAccessScopeIds(String ... networkInsightsAccessScopeIds) {
            this.networkInsightsAccessScopeIds(Arrays.asList(networkInsightsAccessScopeIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInsightsAccessScopesRequest build() {
            return new DescribeNetworkInsightsAccessScopesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInsightsAccessScopesRequest> {
        public Builder networkInsightsAccessScopeIds(Collection<String> var1);

        public Builder networkInsightsAccessScopeIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

