/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;

public class FilterQueryImpl
extends AbstractQueryImpl {
    private final FilterBuilder builder;
    private final Filter filter;
    private Parameters[] parameters;
    private String name;

    public FilterQueryImpl(FilterBuilder filterBuilder, Filter filter) {
        this.filter = filter;
        this.builder = filterBuilder;
        this.name = filter.getName();
        this.updateParameters();
    }

    public final void updateParameters() {
        FilterProperty[] properties = this.filter.getProperties();
        this.parameters = new Parameters[properties == null ? 0 : properties.length];
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                this.parameters[i] = new Parameters(i, properties[i].getValue());
            }
        }
    }

    @Override
    public int getChildrenSlotsCount() {
        return 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getPropertiesCount() {
        return this.parameters.length;
    }

    @Override
    public String getPropertyName(int index) {
        return this.parameters[index].getKey();
    }

    @Override
    public Object getPropertyValue(int index) {
        return this.parameters[index].getValue();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public FilterBuilder getBuilder() {
        return this.builder;
    }

    private class Parameters {
        private final int index;
        private final Object value;

        public Parameters(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public String getKey() {
            return FilterQueryImpl.this.filter.getProperties()[this.index].getName();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

