/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import com.jgoodies.common.base.Objects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.ArrowIcon;
import org.freeplane.view.swing.map.BubblePainter;
import org.freeplane.view.swing.map.ContentPane;
import org.freeplane.view.swing.map.DetailsView;
import org.freeplane.view.swing.map.ForkPainter;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MainViewPainter;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NarrowHexagonPainter;
import org.freeplane.view.swing.map.NodeTooltipManager;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NoteViewMouseListener;
import org.freeplane.view.swing.map.OvalPainter;
import org.freeplane.view.swing.map.RectanglePainter;
import org.freeplane.view.swing.map.SelectableLayout;
import org.freeplane.view.swing.map.ShapedPainter;
import org.freeplane.view.swing.map.WideHexagonPainter;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;
import org.freeplane.view.swing.ui.DetailsViewMouseListener;

class NodeViewFactory {
    private static NodeViewFactory factory;
    private static final IMouseListener DETAILS_MOUSE_LISTENER;
    private static final IMouseListener NOTE_MOUSE_LISTENER;

    static NodeViewFactory getInstance() {
        if (factory == null) {
            factory = new NodeViewFactory();
        }
        return factory;
    }

    private NodeViewFactory() {
    }

    private void fireNodeViewCreated(NodeView newView) {
        newView.getMap().getModeController().onViewCreated(newView);
    }

    JComponent newContentPane(NodeView view) {
        return new ContentPane();
    }

    MainView newMainView(NodeView node) {
        MainView view = new MainView();
        NodeGeometryModel shapeConfiguration = this.shapeConfiguration(node, node.getStyleOption());
        MainView oldView = node.getMainView();
        if (oldView != null && oldView.getShapeConfiguration().equals(shapeConfiguration)) {
            return oldView;
        }
        MainViewPainter shape = this.createViewPainter(view, shapeConfiguration);
        view.setPainter(shape);
        ModeController modeController = node.getMap().getModeController();
        NodeTooltipManager toolTipManager = NodeTooltipManager.getSharedInstance(modeController);
        toolTipManager.registerComponent(view);
        return view;
    }

    void updateViewPainter(NodeView node) {
        NodeGeometryModel shapeConfiguration = this.shapeConfiguration(node, node.getStyleOption());
        MainView mainView = node.getMainView();
        MainViewPainter painter = this.createViewPainter(mainView, shapeConfiguration);
        mainView.setPainter(painter);
    }

    private MainViewPainter createViewPainter(MainView view, NodeGeometryModel shapeConfiguration) {
        ShapedPainter shape;
        switch (shapeConfiguration.getShape()) {
            case fork: {
                shape = new ForkPainter(view);
                break;
            }
            case bubble: {
                shape = new BubblePainter(view, shapeConfiguration);
                break;
            }
            case oval: {
                shape = new OvalPainter(view, shapeConfiguration);
                break;
            }
            case rectangle: {
                shape = new RectanglePainter(view, shapeConfiguration);
                break;
            }
            case wide_hexagon: {
                shape = new WideHexagonPainter(view, shapeConfiguration);
                break;
            }
            case narrow_hexagon: {
                shape = new NarrowHexagonPainter(view, shapeConfiguration);
                break;
            }
            default: {
                System.err.println("Tried to create a NodeView of unknown Style " + String.valueOf((Object)shapeConfiguration.getShape()));
                shape = new ForkPainter(view);
            }
        }
        return shape;
    }

    private NodeGeometryModel shapeConfiguration(NodeView node, LogicalStyleController.StyleOption styleOption) {
        ModeController modeController = node.getMap().getModeController();
        NodeModel model = node.getNode();
        NodeStyleController styleController = NodeStyleController.getController(modeController);
        NodeGeometryModel shapeConfiguration = styleController.getShapeConfiguration(model, styleOption);
        if (shapeConfiguration.getShape().equals((Object)NodeStyleShape.combined)) {
            shapeConfiguration = node.isFolded() ? shapeConfiguration.withShape(NodeStyleShape.bubble) : NodeGeometryModel.FORK;
        } else if (shapeConfiguration.getShape().equals((Object)NodeStyleShape.as_parent)) {
            NodeView parent = node.getParentNodeView();
            if (parent == null) {
                shapeConfiguration = NodeGeometryModel.DEFAULT_ROOT_OVAL;
            } else {
                shapeConfiguration = parent.isSelected() ? this.shapeConfiguration(parent, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : parent.getMainView().getShapeConfiguration();
                if (shapeConfiguration == NodeGeometryModel.DEFAULT_ROOT_OVAL) {
                    shapeConfiguration = NodeGeometryModel.FORK;
                }
            }
        }
        return shapeConfiguration;
    }

    NodeView newNodeView(NodeModel model, MapView map) {
        return this.newNodeView(model, map, null, 0);
    }

    NodeView newNodeView(NodeModel model, MapView map, Container parent, int index) {
        NodeView newView = new NodeView(model, map);
        if (parent != null) {
            parent.add((Component)newView, map.calculateComponentIndex(parent, index));
        }
        newView.setMainView(this.newMainView(newView));
        if (map.isDisplayable()) {
            this.updateNewView(newView);
        } else {
            newView.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    NodeView view = (NodeView)e.getComponent();
                    if (this.displayed(view, e)) {
                        view.removeHierarchyListener(this);
                        NodeViewFactory.this.updateNewView(view);
                    } else if (this.removed(view, e)) {
                        view.removeHierarchyListener(this);
                    }
                }

                private boolean removed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 1L) && view.getParent() == null;
                }

                private boolean displayed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 2L) && view.isDisplayable();
                }
            });
        }
        return newView;
    }

    private void updateNewView(NodeView newView) {
        newView.getNode().addViewer(newView);
        newView.setLayout(SelectableLayout.getInstance());
        newView.update();
        this.fireNodeViewCreated(newView);
        newView.addChildViews();
    }

    public ZoomableLabel createNoteViewer() {
        ZoomableLabel label = new ZoomableLabel();
        label.addMouseListener(NOTE_MOUSE_LISTENER);
        label.addMouseMotionListener(NOTE_MOUSE_LISTENER);
        label.setIcon(NoteController.bwNoteIcon);
        label.setVerticalTextPosition(1);
        return label;
    }

    void updateNoteViewer(NodeView nodeView, int minNodeWidth, int maxNodeWidth) {
        ZoomableLabel noteView;
        String text;
        NodeModel model;
        NoteModel note;
        String newText = null;
        Icon newIcon = null;
        MapView map = nodeView.getMap();
        if (map.showNotes() && (note = NoteModel.getNote(model = nodeView.getNode())) != null && (text = note.getText()) != null) {
            try {
                TextController textController = map.getModeController().getExtension(TextController.class);
                Object transformedContent = textController.getTransformedObject(model, note, text);
                newIcon = textController.getIcon(transformedContent);
                newText = newIcon == null ? transformedContent.toString() : "";
            }
            catch (Throwable e) {
                LogUtils.warn(e.getMessage());
                newText = TextUtils.format("MainView.errorUpdateText", text, e.getLocalizedMessage());
            }
        }
        if ((noteView = (ZoomableLabel)nodeView.getContent(10)) == null && newText == null && newIcon == null || noteView != null && newIcon == null && Objects.equals(newText, (Object)noteView.getText()) && noteView.getTextRenderingIcon() == null) {
            return;
        }
        if (noteView != null && newText == null && newIcon == null) {
            nodeView.removeContent(10);
            return;
        }
        if (noteView == null && (newText != null || newIcon != null)) {
            noteView = NodeViewFactory.getInstance().createNoteViewer();
            nodeView.addContent(noteView, 10);
        }
        noteView.setFont(map.getNoteFont());
        noteView.setForeground(map.getNoteForeground());
        Color noteBackground = map.getNoteBackground();
        noteView.setBackground(noteBackground != null ? noteBackground : map.getBackground());
        noteView.setHorizontalAlignment(map.getNoteHorizontalAlignment());
        noteView.updateText(newText);
        noteView.setTextRenderingIcon(newIcon);
        noteView.setMinimumWidth(minNodeWidth);
        noteView.setMaximumWidth(maxNodeWidth);
        NodeCss noteCss = map.getNoteCss();
        noteView.setStyleSheet(noteCss.css, noteCss.getStyleSheet());
        noteView.revalidate();
        map.repaint();
    }

    void updateDetails(NodeView nodeView, int minNodeWidth, int maxNodeWidth) {
        NodeModel node = nodeView.getNode();
        String detailTextText = DetailModel.getDetailText(node);
        if (detailTextText == null) {
            nodeView.removeContent(2);
            return;
        }
        DetailModel detailText = DetailModel.getDetail(node);
        DetailsView detailContent = (DetailsView)nodeView.getContent(2);
        if (detailContent == null) {
            detailContent = this.createDetailView();
            nodeView.addContent(detailContent, 2);
        }
        MapView map = nodeView.getMap();
        if (detailText.isHidden()) {
            ArrowIcon icon = new ArrowIcon(nodeView, true);
            detailContent.setIcon(icon);
            detailContent.updateText("");
            detailContent.setTextRenderingIcon(null);
        } else {
            String text;
            detailContent.setFont(map.getDetailFont());
            detailContent.setHorizontalAlignment(map.getDetailHorizontalAlignment());
            detailContent.setComponentOrientation(nodeView.getMainView().getComponentOrientation());
            detailContent.setIcon(new ArrowIcon(nodeView, false));
            try {
                TextController textController = map.getModeController().getExtension(TextController.class);
                Object transformedContent = textController.getTransformedObject(node, detailText, detailTextText);
                Icon icon = textController.getIcon(transformedContent);
                detailContent.setTextRenderingIcon(icon);
                text = icon == null ? transformedContent.toString() : "";
            }
            catch (Throwable e) {
                LogUtils.warn(e.getMessage());
                text = TextUtils.format("MainView.errorUpdateText", detailTextText, e.getLocalizedMessage());
            }
            detailContent.updateText(text);
        }
        detailContent.setForeground(map.getDetailForeground());
        detailContent.setBackground(map.getDetailBackground());
        detailContent.setMinimumWidth(minNodeWidth);
        detailContent.setMaximumWidth(maxNodeWidth);
        NodeCss detailCss = map.getDetailCss();
        detailContent.setStyleSheet(detailCss.css, detailCss.getStyleSheet());
        detailContent.revalidate();
        map.repaint();
    }

    private DetailsView createDetailView() {
        DetailsView detailContent = new DetailsView();
        DefaultMapMouseListener mouseListener = new DefaultMapMouseListener();
        detailContent.addMouseMotionListener(mouseListener);
        detailContent.addMouseMotionListener(DETAILS_MOUSE_LISTENER);
        detailContent.addMouseListener(DETAILS_MOUSE_LISTENER);
        return detailContent;
    }

    static {
        DETAILS_MOUSE_LISTENER = new DetailsViewMouseListener();
        NOTE_MOUSE_LISTENER = new NoteViewMouseListener();
    }
}

