/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.net.URL;
import java.util.Hashtable;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.format.ContentTypeFormat;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.ConditionalContentTransformer;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.plugin.latex.DeleteLatexAction;
import org.freeplane.plugin.latex.EditLatexAction;
import org.freeplane.plugin.latex.InsertLatexAction;
import org.freeplane.plugin.latex.LatexNodeHook;
import org.freeplane.plugin.latex.LatexRenderer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String PREFERENCES_RESOURCE = "preferences.xml";
    static final String TOGGLE_PARSE_LATEX = "parse_latex";

    public void start(BundleContext context) throws Exception {
        this.registerMindMapModeExtension(context);
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"MindMap", "StyleMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController, CommandLineOptions options) {
                LatexNodeHook nodeHook = new LatexNodeHook();
                MTextController textController = (MTextController)modeController.getExtension(TextController.class);
                textController.addDetailContentType("latex");
                MNoteController noteController = (MNoteController)modeController.getExtension(NoteController.class);
                noteController.addNoteContentType("latex");
                textController.addTextTransformer((IContentTransformer)new ConditionalContentTransformer((IContentTransformer)new LatexRenderer(), Activator.TOGGLE_PARSE_LATEX));
                ((FormatController)modeController.getController().getExtension(FormatController.class)).addPatternFormat((PatternFormat)new ContentTypeFormat("latexPatternFormat"));
                ((FormatController)modeController.getController().getExtension(FormatController.class)).addPatternFormat((PatternFormat)new ContentTypeFormat("unparsedLatexPatternFormat"));
                if (modeController.getModeName().equals("MindMap")) {
                    modeController.addAction((AFreeplaneAction)new InsertLatexAction());
                    modeController.addAction((AFreeplaneAction)new EditLatexAction(nodeHook));
                    modeController.addAction((AFreeplaneAction)new DeleteLatexAction(nodeHook));
                    this.addPreferencesToOptionPanel();
                }
            }

            private void addPreferencesToOptionPanel() {
                URL preferences = this.getClass().getResource(Activator.PREFERENCES_RESOURCE);
                if (preferences == null) {
                    throw new RuntimeException("cannot open preferences");
                }
                Controller controller = Controller.getCurrentController();
                MModeController modeController = (MModeController)controller.getModeController();
                modeController.getOptionPanelBuilder().load(preferences);
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

