/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import net.infonode.gui.layout.LayoutUtil;

public class StretchLayout
implements LayoutManager {
    public static final StretchLayout BOTH = new StretchLayout();
    private boolean horizontal;
    private boolean vertical;

    public StretchLayout() {
        this(true, true);
    }

    public StretchLayout(boolean horizontal, boolean vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension innerSize = LayoutUtil.getInteriorSize(parent);
        Insets insets = parent.getInsets();
        Component[] components = LayoutUtil.getVisibleChildren(parent);
        int i = 0;
        while (i < components.length) {
            Dimension size = new Dimension(this.horizontal ? innerSize.width : components[i].getPreferredSize().width, this.vertical ? innerSize.height : components[i].getPreferredSize().height);
            components[i].setBounds((int)((float)insets.left + (float)(innerSize.width - size.width) * components[i].getAlignmentX()), (int)((float)insets.top + (float)(innerSize.height - size.height) * components[i].getAlignmentY()), size.width, size.height);
            ++i;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return LayoutUtil.add(LayoutUtil.getMaxMinimumSize(LayoutUtil.getVisibleChildren(parent)), parent.getInsets());
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return LayoutUtil.add(LayoutUtil.getMaxPreferredSize(LayoutUtil.getVisibleChildren(parent)), parent.getInsets());
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

