# Power Descriptions
Note that every power, unless otherwise specified, is affected by Intelligence scaling and Nether Attunement scaling. Intelligence scaling is normalized at 10 with +/- 5% per point in either direction—-Intelligence 9 makes powers 95% as effective, Intelligence 12 makes powers 110% as effective, and so on. 

A (C) after a power name indicates that it can be maintained by concentration.

# Biokinesis
**Note**: No biokinetic powers have a target listed because they only affect the psion. 

**Passive Power: Efficient System**: Reduces hunger, thirst, and metabolic burn rate by 3% plus 1.5% times the highest single biokinetic power the psion knows.

## Overcome Pain (C)
*Difficulty*: 1<br />
*Duration*: 5 minutes to 21 minutes 40 seconds, plus 20 to 75 seconds per level<br />
*Stamina Cost*: 1750, minus 75 per level to a minimum of 800<br />
*Channeling Time*: 125 moves, minus 7 moves per level to a minimum of 50<br />
*Effects*: Adds pkill to the psion, scaling every 4 levels.<br /> 
Level | Pkill Min | Pkill Tick | Pkill Max
——-|——-|——-|———
0 | 1 | 12 | 15
4 | 2 | 10 | 30
8 | 3 | 10 | 50
12| 4 | 8 | 75
16| 5 | 8 | 100
20| 6 | 6 | 130
This is natural painkiller and so has natural effects (reduces speed slightly)<br />
*Prerequisites*: Starting power.

## Physical Enhancement (C)
*Difficulty*: 2<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 120 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Adds +1 Strength and +1 Dexterity, with an additional point of each every 5 power levels.  It also makes the psion immune to Weakening Poison.<br />
*Prerequisites*: Starting power.<br />

## Oxygen Absorption 
*Difficulty*: 2<br />
*Duration*: 3 minutes to 9 minutes, plus 36 to 72 seconds per level<br />
*Stamina Cost*: 2500, minus 85 per level to a minimum of 1200<br />
*Channeling Time*: 70 moves, minus 6 moves per level to a minimum of 25<br />
*Effects*: Allows the psion to breathe underwater.  This is the same as a rebreather, so it reduces the hidden oxygen stat by a significant amount, making Stamina recovery harder.<br />
*Prerequisites*: Physical Enhancement 4, Overcome Pain 3.<br />

## Burst of Speed 
*Difficulty*: 3<br />
*Duration*: Instant<br />
*Stamina Cost*: 3000, minus 190 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 15<br />
*Effects*: Dash up to 1 square plus 1 square per two levels, to a maximum of 12 squares.  This is normal movement and will subject you to tile hazards.<br />
*Prerequisites*: Physical Enhancement 9 *or* Enhance Mobility 5.<br />

## Flexibility 
*Difficulty*: 3<br />
*Duration*: 2 to 5 seconds<br />
*Stamina Cost*: 2500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 50 moves, minus 2.5 moves per level to a minimum of 15<br />
*Effects*: Greatly increases the psion’s reaction (2x), block (1.2x) and crawl (1.5) limb scores, as well as rendering them immune to being grabbed and making it easier to recover from being downed.  It reduces fall damage by 20% plus 2% per level.<br />
*Prerequisites*: Physical Enhancement 6<br />

## Hardened Skin 
*Difficulty*: 4
*Duration*: 45 to 90 seconds, plus 8 to 15 seconds per level.<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 50.<br />
*Effects*: Increases piercing armor by 3, bashing armor by 6, and cutting armor by 4.  Also makes the psion immune to bleeding from wounds received during its duration (previous bleeding is unaffected) and reduces incoming pain by 2% per level.<br />
*Prerequisites*: Overcome Pain 6 *or* Physical Enhancement 8, Flexibility 7 *or* Temperature Adaptability 6.<br />

## Adrenaline Trigger 
*Difficulty*: 4<br />
*Duration*: 15 minutes<br />
*Stamina Cost*: 3500, minus 165 per level to a minimum of 1800<br />
*Channeling Time*: 100 moves, minus 5.5 moves per level to a minimum of 35<br />
*Effects*: Cause an adrenaline surge. This provides a burst of speed and strength and high tolerance for pain for the duration but the psion will crash when the surge ends.<br />
*Prerequisites*: Overcome Pain 7, Burst of Speed 8 *or* Enhance Mobility 6. 

## Temperature Adaptability (C) 
*Difficulty*: 4<br />
*Duration*: 5 minutes to 10 minutes, plus 3 minutes to 6 minutes per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 250 moves, minus 8.5 moves per level to a minimum of 150<br />
*Effects*: Increases temperature tolerance in both directions by 15 degrees plus 7.5 degrees per level.<br />
*Prerequisites*: Oxygen Absorption 5, Physical Enhancement 9 *or* Metabolic Hyperefficiency 6<br />

## Enhance Mobility (C) 
*Difficulty*: 5<br />
*Duration*: 5 minutes to 15 minutes, plus 45 seconds to 120 seconds per level<br />
*Stamina Cost*: 4500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 275 moves, minus 15 moves per level to a minimum of 50.<br />
*Effects*: Reduces encumbrance on every body part, improving every 4 levels.  Other than -2 at level 0 through 3, encumbrance reduction is equal to power threshold level: -4 from levels 4 to 7, -8 from levels 8 to 11, and so on.<br />
*Prerequisites*: Overcome Pain 4,  Heightened Reflexes 6 *or* Flexibility 9, Burst of Speed 10 *or* Combat Dance 4 *or* Physical Enhancement 10.<br />

## Hammerhand (C) 
*Difficulty*: 5<br />
*Duration*: 30 minutes to 90 minutes, plus 7 minutes 30 seconds to 12 minutes 30 seconds per level.<br />
*Stamina Cost*: 4500, minus 225 per level to a minimum of 2250<br />
*Channeling Time*: 350 moves, minus 12.5 moves per level to a minimum of 150<br />
*Effects*: Allows the psion to replicate a number of common tools with their own body: it provides the Bolt Turning 1, Screw Driving 1, Hammering 3, Fine Hammering 1, Soft Hammering 1, Wood Chiseling 1, Prying 2, and Nail Prying 1 qualities.<br />
*Prerequisites*: Physical Enhancement 6, Hardened Skin 6<br />

## Heightened Reflexes (C) 
*Difficulty*: 6<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 5500, minus 205 per level to a minimum of 2250<br />
*Channeling Time*: 175 moves, minus 5.5 moves per level to a minimum of 100<br />
*Effects*: Adds +1 Perception and +5 Speed, plus 1 Perception per 5 levels and plus 1 Speed per level (to a maximum bonus of +30 speed).<br />
*Prerequisites*: Flexibility 8 *or* Burst of Speed 8, Physical Enhancement 6, Adrenaline Trigger 6<br />

## Sealed System
*Difficulty*: 7<br />
*Duration*: 60 seconds to 5 minutes, plus 8 to 25 seconds per level<br />
*Stamina Cost*: 5500, minus 175 per level to a minimum of 2750<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 100<br />
*Effects*: Prevents the psion from having to breath and seals off their body against outside danger.  They become immune to the Smoke, Teargas, Boomer Bile, Mi-go Atmosphere, Fetid Goop, Relaxation Gas, Triffid Pollen, Fungal Spores, Dermatik parasitization, Poison, and Bad Poison effects, as well as electrical damage.  They have no scent and receive 75% less radiation. Finally, their wounds stop bleeding and wounds received while the power is in effect will not bleed.<br />
*Prerequisites*: Hardened Skin 9 *or* Oxygen Absorption 9, Temperature Adaptability 10 *or* Hammerhand 7<br />

## Metabolic Hyperefficiency (C) 
*Difficulty*: 7<br />
*Duration*: 45 minutes to 112 minutes and 30 seconds, plus 4 minutes 10 seconds to 8 minutes 20 seconds per level<br />
*Stamina Cost*: 8000, minus 250 per level to a minimum of 4000<br />
*Channeling Time*: 250 moves, minus 13 moves per level to a minimum of 50<br />
*Effects*: Greatly increases the psion’s metabolic efficiency.  Hunger, thirst, fatigue grow 25% more slowly and the basal metabolic rate is reduced by 25%.  All of these bonuses increase by 2% per level to a maximum of 70% increase.<br />
*Prerequisites*: Temperature Adaptability 8, Adrenaline Trigger 6 *or* Physical Enhancement 12<br />

## Combat Dance
*Difficulty*: 8<br />
*Duration*: 40 seconds to 3 minutes and 20 seconds, plus 5 to 11 seconds per level<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2250<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 40<br />
*Effects*: Provides a myriad of combat bonuses. Move cost is reduced by 10% and recoil reduced by 30.  In addition, pain is reduced by 3% per power level, and melee damage and attack speed are increased by 2% per power level. The psion is immune to the Stunned and Dazed effects.<br />
*Prerequisites*: Heightened Reflexes 10, Physical Enhancement 10, Adrenaline Trigger 9 *or* Burst of Speed 6<br />

## Perfected Motion
*Difficulty*: 9<br />
*Duration*: 5 seconds to 30 seconds, plus 0.5 to 1.1 seconds per level<br />
*Stamina Cost*: 8000, minus 175 per level to a minimum of 3500<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 15<br />
*Effects*: Increases the psion’s movement rate to an inhuman degree.  Move cost is reduced by 50% plus 1.5% per level, to a maximum of 96% reduced move cost. The psion is also immune to slippery terrain.<br />
*Prerequisites*: Combat Dance 6, Burst of Speed 12<br />  

## Hurricane Blow
*Difficulty*: 10<br />
*Duration*: 1 second<br />
*Stamina Cost*: 4500, minus 75 per level to a minimum of 2500<br />
*Channeling Time*: 65 moves, minus 3 moves per level to a minimum of 15<br />
*Effects*: Allows the psion to strike multiple times in less than a second.  Speed is increased by 400 plus 75 per power level and the psion attacks 25% faster and does 10% more melee damage plus 1.5% per power level, but cannot use ranged attacks or other psionic powers, and the power ends immediately if the psion moves.<br />
*Prerequisites*: Combat Dance 10, Reflex Enhance 14 *or* Adrenaline Trigger 12<br />

# Electrokinesis

**Passive Power: Galvanic Armor**: Reduces incoming electrical damage by 1 per four levels of the psion's highest-leveled electrokinetic power and reduces incoming pain by 0.7% times the level of the psion's highest-level electrokinetic power.

## Spark Sight (C)
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 15 minutes to 30 minutes, plus 2 minutes 30 seconds to 5 minutes per level<br />
*Stamina Cost*: 2000, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 80<br />
*Effects*: Allows the psion to see electrical creatures (electrical zombies, robots, and cyborgs) from further away, up to 6 squares + 1.5 squares per power level.<br />
*Prerequisites*: Starting power<br />

## Static Touch
*Difficulty*: 1<br />
*Target*: One target within Range 1<br />
*Duration*: 1 to 3 seconds<br />
*Stamina Cost*: 1500, minus 65 per level to a minimum of 450<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 35<br />
*Effects*: Zap a single target with a jolt of electricity, doing 2 to 7 plus 1 to 1.5 per power level electrical damage, as well as dazing them for the power's duration.<br />
*Prerequisites*: Starting power<br />

## Electrical Discharge
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 5 minutes to 13 minutes and 20 seconds, plus 1 minute and 20 seconds to 3 minutes and 45 seconds per power level<br />
*Stamina Cost*: 3500, minus 120 per level to a minimum of 1100<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 45<br />
*Effects*: Build up a charge in the psion's body, zapping anyone who attacks them 50% of the time for 1 to 5 damage, plus 1/4 (i.e., one point per four levels) to 1/2 damage per power level.  The power also renders the psion's gear and bionic power immune to EMP attacks.<br />
*Prerequisites*: Static Touch 4<br />

## Voltaic Strikes
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 4 minutes to 10 minutes, plus 55 seconds to 1 minute 30 seconds per power level.<br />
*Stamina Cost*: 3750, minus 115 per level to a minimum of 1450<br />
*Channeling Time*: 85 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Build up a charge in the psion's body, zapping their targets 50% of the time for 3 to 10 damage, plus 1/3 (i.e., one point per three levels) to 1/1.5 damage per power level, and leaves a lightning field of intensity 1 to 4 at the enemy's location 50% of the time.  The power also provides electrical armor equal to the power level.<br />
*Prerequisites*: Static Touch 5, Electrical Discharge 5<br />

## Electron Overflow (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 10 minutes to 30 minutes, plus 45 seconds to 90 seconds per power level<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 3500<br />
*Channeling Time*: 350 moves, minus 9 moves per level to a minimum of 150<br />
*Effects*: Passively recharge any UPS-compatible devices on the psion's person.<br /> 
*Prerequisites*: Spark Sight 5, Electrical Discharge 8<br />

## Neural Spasms
*Difficulty*: 4<br />
*Target*: One target within 1 square plus 0.6 squares per power level<br />
*Duration*: Diminishing returns--stuns the target for 46.2 moves to 76.9 moves at level 1, 170.5 to 264.7 moves at level 5, 272.7 to 454.5 moves at level 10, and so on, following the formula ( (power level * 0.25) * 6) / ((power level * 0.25) + 3 ) to ( (power level * 0.25) * 10 ) / ((power level * 0.25) + 3 )<br />
*Stamina Cost*: 5500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 150 moves, minus 5 moves per level to a minimum of 75<br />
*Effects*: Stuns the target by overloading their nervous system.  It cannot affect targets without a biological nervous system--plants, robots, Nether creatures, fungus, etc.<br />
*Prerequisites*: Spark Sight 6, Voltaic Strikes 5 *or* Static Touch 8<br />

## Pain Suppression (C)
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 10 minutes to 25 minutes, plus 2 minutes to 4 minutes and 40 seconds per power level.<br />
*Stamina Cost*: 4000, minus 105 per level to a minimum of 1250<br />
*Channeling Time*: 125 moves, minus 4 moves per level to a minimum of 75<br />
*Effects*: Reduces incoming pain by 15% plus 2% per power level, to a maximum of 50% reduction, and increases the chance to remove pain during pain reduction checks by 10% plus 2% per power level to a maximum of 50% increased chance.<br />
*Prerequisites*: Neural Spasms 4 *or* (Spark Sight 8 AND Electrical Discharge 8)<br />

## Electrocutioner
*Difficulty*: 5<br />
*Target*: Line stretching 3 squares plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 150 per level to a minimum of 1200<br />
*Channeling Time*: 100 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Hurls a lightning bolt at a target within range, doing 20 to 45 electrical damage plus 2 to 4 per power level and leaving intensity 1 to 2 lightning fields in its wake.  This power causes additional sound at the target location.<br />
*Prerequisites*: Voltaic Strikes 8 *or* Static Touch 12, Electrical Discharge 8<br />

# Re-energize
*Difficulty*: 6<br />
*Target*: Adjacent vehicle or appliance<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 150 per level to a minimum of 4500<br />
*Channeling Time*: 15 seconds<br />
*Effects*: Recharges the batteries of a vehicle or an electrical grid, restoring 250 to 500 power plus 125 to 250 per power level.<br />
*Prerequisites*: Electron Overflow 10, Electrical Discharge 9 *or* Neural Spasms 7<br />

# Analgesic Block
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 60 seconds to 2 minutes 30 seconds, plus 8 seconds to 13 seconds per power level<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 1750<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 25<br />
*Effects*: Removes all pain and makes the psion immune to pain for the power's duration. When the duration ends, the psion receives all the pain they put off, plus an additional 10%, back all at once.<br />
*Prerequisites*: Pain Suppression 9<br />

# Neuro-acceleration
*Difficulty*: 6<br />
*Target*: Self or ally within 1 square<br />
*Duration*: 1 minute 30 seconds to 7 minutes 30 seconds, plus 15 to 27 seconds per level<br />
*Stamina Cost*: 6000, minus 135 per level to a minimum of 2750<br />
*Channeling Time*: 165 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Increases the target's reflexes and response time, adding 5 learning focus plus 1 per power level to a maximum of 35 learning focus, as well as 10 speed plus 1.5 per power level to a maximum of 60 speed.<br />
*Prerequisites*: Electron Overflow 11 *or* Neural Spasms 6, Electrical Discharge 8 *or* Spark Sight 5<br />

## Short Circuit
*Difficulty*: 7<br />
*Target*: One robot or cyborg within 1 square plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Overloads a robot or cyborg, completely short-circuiting it and destroying it, and releasing a cloud of sparks within 1 square of the target plus 0.4 squares per power level.  Yrax constructs do not function based on electricity and are immune to this power.<br />
*Prerequisites*: Re-energize 8 *or* Electrocutioner 8 *or* Voltaic Strikes 13, Spark Sight 8<br />

# Galvanic Aura
*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: 60 seconds to 4 minutes 10 seconds, plus 15 seconds to 25 seconds per power level<br />
*Stamina Cost*: 9000, minus 200 per level to a minimum of 4500<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 55<br />
*Effects*: Supercharges the air around the psion, releasing blasts of 12 fields of intensity 10 lightning every few seconds. It also provides electric armor equal to the power level and makes the psion and their gear immune to EMP blasts.<br />
*Prerequisites*: Electrical Discharge 12, Electron Overflow 15 *or* Re-energize 6<br />

# Ion Blast
*Difficulty*: 9<br />
*Target*: Line stretching 2 squares plus 0.7 squares per power level, causing an explosion with an AoE of 1 plus 1 per 4 power levels<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 100 per level to a minimum of 4000<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 65<br />
*Effects*: Unleashes a lightning bolt that explodes at the target point. The explosion does 25 to 90 electrical damage plus 2 to 4.5 per power level. The bolt does 5 to 25 plus 0.5 to 2.5 per power level. Both the bolt and the explosion release lightning fields of intensity 3 to 7.<br />
*Prerequisites*: Electrocutioner 10 *or* Short Circuit 6, Voltaic Strikes 8 *or* Static Touch 12<br />

# Revivification
*Difficulty*: 10<br />
*Target*: One corpse within 2 squares plus 1 square per 4 power levels<br />
*Duration*: Random but no longer than 12 minutes. The target has an escalating chance to collapse every turn of the effect, beginning at 0.0005% per second in the first minute, climbing to 0.01% per second at minute 4, 1% per second at minute 8, and reaching certainty at minute 12<br />
*Stamina Cost*: 10000, minus 150 per level to a minimum of 6000<br />
*Channeling Time*: 250 moves, minus 6 moves per level to a minimum of 125<br />
*Effects*: Revives a single target with the REVIVES flag, charms it, and heals it for 50% to 80% of its hit points. The revived monster will be allied to you for the power's duration. You may repeatedly use Revivification on the same target as long as it's not pulped.<br />
*Prerequisites*: Neuro-acceleration 8, Analgesic Block 6 *or* Pain Suppression 13<br />