/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SLEEP_DEF_H
#define SLEEP_DEF_H

/* --- SPM Flag Define --- */
#define SPM_FLAG_DISABLE_INFRA_PDN			BIT(0)
#define SPM_FLAG_DISABLE_DPM_PDN			BIT(1)
#define SPM_FLAG_DISABLE_MCUPM_PDN			BIT(2)
#define SPM_FLAG_RESERVED_BIT_3				BIT(3)
#define SPM_FLAG_DISABLE_VLP_PDN			BIT(4)
#define SPM_FLAG_DISABLE_VLPCLK_SWITCH			BIT(5)
#define SPM_FLAG_DISABLE_SSPM_SRAM_SLEEP		BIT(6)
#define SPM_FLAG_RESERVED_BIT_7				BIT(7)
#define SPM_FLAG_DISABLE_VCORE_DVS			BIT(8)
#define SPM_FLAG_DISABLE_DDR_DFS			BIT(9)
#define SPM_FLAG_DISABLE_EMI_DFS			BIT(10)
#define SPM_FLAG_DISABLE_BUS_DFS			BIT(11)
#define SPM_FLAG_DISABLE_COMMON_SCENARIO		BIT(12)
#define SPM_FLAG_RESERVED_BIT_13			BIT(13)
#define SPM_FLAG_RESERVED_BIT_14			BIT(14)
#define SPM_FLAG_RESERVED_BIT_15			BIT(15)
#define SPM_FLAG_KEEP_CSYSPWRACK_HIGH			BIT(16)
#define SPM_FLAG_ENABLE_MT8196_IVI			BIT(17)
#define SPM_FLAG_ENABLE_SPM_DBG_WDT_DUMP		BIT(18)
#define SPM_FLAG_RUN_COMMON_SCENARIO			BIT(19)
#define SPM_FLAG_USE_SRCCLKENO2				BIT(20)
#define SPM_FLAG_ENABLE_AOV				BIT(21)
#define SPM_FLAG_ENABLE_MD_MUMTAS			BIT(22)
#define SPM_FLAG_ENABLE_COMMON_SODI5			BIT(23)
#define SPM_FLAG_ENABLE_MT8196_E1_WA			BIT(24)
#define SPM_FLAG_ENABLE_MT8196_EMI_E1_WA		BIT(25)
#define SPM_FLAG_VCORE_STATE				BIT(26)
#define SPM_FLAG_VTCXO_STATE				BIT(27)
#define SPM_FLAG_INFRA_STATE				BIT(28)
#define SPM_FLAG_APSRC_STATE				BIT(29)
#define SPM_FLAG_VRF18_STATE				BIT(30)
#define SPM_FLAG_DDREN_STATE				BIT(31)

/* --- SPM Flag1 Define --- */
#define SPM_FLAG1_DISABLE_AXI_BUS_TO_26M		BIT(0)
#define SPM_FLAG1_DISABLE_SYSPLL_OFF			BIT(1)
#define SPM_FLAG1_DISABLE_PWRAP_CLK_SWITCH		BIT(2)
#define SPM_FLAG1_DISABLE_CSOPLU_OFF			BIT(3)
#define SPM_FLAG1_FW_SET_CSOPLU_ON			BIT(4)
#define SPM_FLAG1_DISABLE_EMI_CLK_TO_CSOPLU		BIT(5)
#define SPM_FLAG1_DISABLE_NO_RESUME			BIT(6)
#define SPM_FLAG1_RESERVED_BIT_7			BIT(7)
#define SPM_FLAG1_RESERVED_BIT_8			BIT(8)
#define SPM_FLAG1_RESERVED_BIT_9			BIT(9)
#define SPM_FLAG1_DISABLE_SRCLKEN_LOW			BIT(10)
#define SPM_FLAG1_DISABLE_SCP_CLK_SWITCH		BIT(11)
#define SPM_FLAG1_DISABLE_TOP_26M_CK_OFF		BIT(12)
#define SPM_FLAG1_DISABLE_PCM_26M_SWITCH		BIT(13)
#define SPM_FLAG1_DISABLE_CKSQ_OFF			BIT(14)
#define SPM_FLAG1_DO_DPSW_0P725V			BIT(15)
#define SPM_FLAG1_ENABLE_ALCO_TRACE			BIT(16)
#define SPM_FLAG1_ENABLE_SUSPEND_AVS			BIT(17)
#define SPM_FLAG1_DISABLE_TVCORE_OFF			BIT(18)
#define SPM_FLAG1_ENABLE_CSOPLU_OFF			BIT(19)
#define SPM_FLAG1_DISABLE_INFRA_SRAM_SLEEP		BIT(20)
#define SPM_FLAG1_DISABLE_AXI_MEM_CLK_OFF		BIT(21)
#define SPM_FLAG1_RESERVED_BIT_22			BIT(22)
#define SPM_FLAG1_RESERVED_BIT_23			BIT(23)
#define SPM_FLAG1_DISABLE_SCP_VREQ_MASK_CONTROL		BIT(24)
#define SPM_FLAG1_RESERVED_BIT_25			BIT(25)
#define SPM_FLAG1_RESERVED_BIT_26			BIT(26)
#define SPM_FLAG1_RESERVED_BIT_27			BIT(27)
#define SPM_FLAG1_RESERVED_BIT_28			BIT(28)
#define SPM_FLAG1_RESERVED_BIT_29			BIT(29)
#define SPM_FLAG1_ENABLE_WAKE_PROF			BIT(30)
#define SPM_FLAG1_ENABLE_SLEEP_PROF			BIT(31)

/* --- SPM DEBUG Define --- */
#define SPM_DBG_DEBUG_IDX_26M_WAKE			BIT(0)
#define SPM_DBG_DEBUG_IDX_26M_SLEEP			BIT(1)
#define SPM_DBG_DEBUG_IDX_INFRA_WAKE			BIT(2)
#define SPM_DBG_DEBUG_IDX_INFRA_SLEEP			BIT(3)
#define SPM_DBG_DEBUG_IDX_APSRC_WAKE			BIT(4)
#define SPM_DBG_DEBUG_IDX_APSRC_SLEEP			BIT(5)
#define SPM_DBG_DEBUG_IDX_VRF18_WAKE			BIT(6)
#define SPM_DBG_DEBUG_IDX_VRF18_SLEEP			BIT(7)
#define SPM_DBG_DEBUG_IDX_VCORE_WAKE			BIT(8)
#define SPM_DBG_DEBUG_IDX_VCORE_SLEEP			BIT(9)
#define SPM_DBG_DEBUG_IDX_DDREN_WAKE			BIT(10)
#define SPM_DBG_DEBUG_IDX_DDREN_SLEEP			BIT(11)
#define SPM_DBG_DEBUG_IDX_PMIC_WAKE			BIT(12)
#define SPM_DBG_DEBUG_IDX_PMIC_SLEEP			BIT(13)
#define SPM_DBG_DEBUG_IDX_EMI_WAKE			BIT(14)
#define SPM_DBG_DEBUG_IDX_EMI_SLEEP			BIT(15)
#define SPM_DBG_DEBUG_IDX_AOVBUS_WAKE			BIT(16)
#define SPM_DBG_DEBUG_IDX_AOVBUS_SLEEP			BIT(17)
#define SPM_DBG_DEBUG_IDX_CURRENT_IS_CM			BIT(18)
#define SPM_DBG_DEBUG_IDX_SYSRAM_ON			BIT(19)
#define SPM_DBG_DEBUG_IDX_WAIT_SSPM			BIT(20)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_SLP			BIT(21)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_ON			BIT(22)
#define SPM_DBG_DEBUG_IDX_SPM_DVFS_NO_REQ		BIT(23)
#define SPM_DBG_DEBUG_IDX_VCORE_LP_MODE		        BIT(24)
#define SPM_DBG_DEBUG_IDX_SPM_NORMAL_WAKEUP		BIT(28)
#define SPM_DBG_DEBUG_IDX_SPM_WAKEUP_BY_NONE		BIT(29)
/* --- SPM DEBUG1 Define --- */
#define SPM_DBG1_DEBUG_IDX_CURRENT_IS_LP		BIT(0)
#define SPM_DBG1_DEBUG_IDX_VCORE_DVFS_START		BIT(1)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_OFF			BIT(2)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_ON			BIT(3)
#define SPM_DBG1_DEBUG_IDX_VMDDRVDDQ_ON			BIT(4)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_OFF		BIT(5)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_ON		BIT(6)
#define SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_0		BIT(7)
#define SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_1		BIT(8)
#define SPM_DBG1_DEBUG_IDX_VCORE_SLEEP_ABORT_0		BIT(9)
#define SPM_DBG1_DEBUG_IDX_VCORE_SLEEP_ABORT_1		BIT(10)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_CSOPLU		BIT(11)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_26M		BIT(12)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_32K		BIT(13)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_26M		BIT(14)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_OFF			BIT(15)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_ON			BIT(16)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_LOW			BIT(17)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_HIGH		BIT(18)
#define SPM_DBG1_RESERVED_BIT_19			BIT(19)
#define SPM_DBG1_DEBUG_IDX_CSOPLU_IS_OFF_BUT_SHOULD_ON	BIT(20)
#define SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_LOW_ABORT	BIT(21)
#define SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_HIGH_ABORT	BIT(22)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_LOW_ABORT	BIT(23)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_HIGH_ABORT	BIT(24)
#define SPM_DBG1_DEBUG_IDX_VMDDRVDDQ_OFF		BIT(25)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_LOW_ABORT	BIT(26)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_HIGH_ABORT	BIT(27)
#define SPM_DBG1_DEBUG_IDX_SPM_PMIF_CMD_RDY_ABORT	BIT(28)
#define SPM_DBG1_DEBUG_IDX_EMI_PDN_RDY_ABORT		BIT(29)
#define SPM_DBG1_DEBUG_IDX_LVTS_WRONG_DEVICE_ID		BIT(30)
#define SPM_DBG1_DEBUG_IDX_DISABLE_DVFSRC		BIT(31)

/* --- SPM PCM_WDT_LATCH3 Define --- */
#define SPM_WDT_LATCH3_RESOURCE_STATE_AOV_INFRA_ON	BIT(0)
#define SPM_WDT_LATCH3_RESOURCE_STATE_26M_INFRA_ON	BIT(1)
#define SPM_WDT_LATCH3_RESOURCE_STATE_AOV_CLK_ON	BIT(2)
#define SPM_WDT_LATCH3_RESOURCE_STATE_26M_CLK_ON	BIT(3)
#define SPM_WDT_LATCH3_RESOURCE_STATE_AOV_EMI_ON	BIT(4)
#define SPM_WDT_LATCH3_RESOURCE_STATE_26M_EMI_ON	BIT(5)
#endif /* SLEEP_DEF_H */
