/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.executor;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.UrlUtils;
import org.jfrog.build.extractor.executor.CommandResults;
import org.jfrog.build.extractor.executor.StreamReader;

public class CommandExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] env;
    private String executablePath;

    public CommandExecutor(String executablePath, Map<String, String> env) {
        this.executablePath = executablePath;
        HashMap<String, String> finalEnvMap = new HashMap<String, String>(System.getenv());
        if (env != null) {
            HashMap<String, String> fixedEnvMap = new HashMap<String, String>(env);
            this.fixPathEnv(fixedEnvMap);
            finalEnvMap.putAll(fixedEnvMap);
        }
        this.env = (String[])finalEnvMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new);
    }

    private void fixPathEnv(Map<String, String> env) {
        String path = env.get("PATH");
        if (path == null) {
            return;
        }
        path = CommandExecutor.isWindows() ? CommandExecutor.getFixedWindowsPath(path) : path.replaceAll(";", File.pathSeparator) + ":/usr/local/bin";
        env.replace("PATH", path);
    }

    static String getFixedWindowsPath(String path) {
        String[] pathParts = path.split(";");
        CharSequence[] newPathParts = new String[pathParts.length];
        for (int index = 0; index < pathParts.length; ++index) {
            String part = pathParts[index];
            int backSlashIndex = part.indexOf(92);
            if (backSlashIndex < 0) {
                newPathParts[index] = part.replaceAll(":", ";");
                continue;
            }
            String startPart = part.substring(0, backSlashIndex);
            String endPart = part.substring(backSlashIndex);
            String newPart = startPart + endPart.replaceAll(":", ";");
            newPathParts[index] = newPart;
        }
        return String.join((CharSequence)";", newPathParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResults exeCommand(File execDir, List<String> args, Log logger) throws InterruptedException, IOException {
        CommandResults commandResults;
        args.add(0, this.executablePath);
        Process process = null;
        ExecutorService service = Executors.newFixedThreadPool(2);
        try {
            CommandResults commandRes = new CommandResults();
            process = CommandExecutor.runProcess(execDir, args, this.env, logger);
            StreamReader inputStreamReader = new StreamReader(process.getInputStream());
            StreamReader errorStreamReader = new StreamReader(process.getErrorStream());
            service.submit(inputStreamReader);
            service.submit(errorStreamReader);
            process.waitFor();
            service.shutdown();
            service.awaitTermination(10L, TimeUnit.SECONDS);
            commandRes.setRes(inputStreamReader.getOutput());
            commandRes.setErr(errorStreamReader.getOutput());
            commandRes.setExitValue(process.exitValue());
            commandResults = commandRes;
        }
        catch (Throwable throwable) {
            CommandExecutor.closeStreams(process);
            service.shutdownNow();
            throw throwable;
        }
        CommandExecutor.closeStreams(process);
        service.shutdownNow();
        return commandResults;
    }

    private static void closeStreams(Process process) {
        if (process != null) {
            IOUtils.closeQuietly(process.getInputStream());
            IOUtils.closeQuietly(process.getOutputStream());
            IOUtils.closeQuietly(process.getErrorStream());
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    private static Process runProcess(File execDir, List<String> args, String[] env, Log logger) throws IOException {
        String strArgs = String.join((CharSequence)" ", args);
        if (logger != null) {
            logger.info("Executing command: " + UrlUtils.maskCredentialsInUrl(strArgs));
        }
        if (CommandExecutor.isWindows()) {
            return Runtime.getRuntime().exec(new String[]{"cmd", "/c", strArgs}, env, execDir);
        }
        if (CommandExecutor.isMac()) {
            return Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", strArgs}, env, execDir);
        }
        return Runtime.getRuntime().exec(args.toArray(new String[0]), env, execDir);
    }
}

