/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ClassMethodMap;
import org.testng.IClass;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.InvokedMethod;
import org.testng.internal.JUnitUtils;
import org.testng.internal.MethodHelper;
import org.testng.internal.Parameters;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.ITest;
import org.testng.internal.thread.ICountDown;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IFutureResult;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadTimeoutException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker
implements IInvoker {
    private ITestContext m_testContext;
    private ITestResultNotifier m_notifier;
    private IAnnotationFinder m_annotationFinder;
    private Map<Class, Boolean> m_classInvocationResults = new HashMap<Class, Boolean>();
    private boolean m_suiteConfigurationFailed = false;
    private boolean m_withinThreadedMethod = false;

    public Invoker(ITestContext testContext, ITestResultNotifier notifier, IAnnotationFinder annotationFinder) {
        this.m_testContext = testContext;
        this.m_notifier = notifier;
        this.m_annotationFinder = annotationFinder;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ITestNGMethod[] methods;
        if (null == allMethods) {
            this.log(5, "No @Configuration methods found");
            return;
        }
        for (ITestNGMethod tm : methods = this.filterMethodsUnique(testClass, allMethods)) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            TestResult testResult = new TestResult(testClass, instance, tm, null, System.currentTimeMillis(), System.currentTimeMillis());
            IConfiguration configurationAnnotation = null;
            try {
                Object[] instances = tm.getInstances();
                if (instances == null || instances.length == 0) {
                    instances = new Object[]{instance};
                }
                Class<?> objectClass = instances[0].getClass();
                Method method = tm.getMethod();
                if (MethodHelper.isEnabled(objectClass, this.m_annotationFinder)) {
                    Object[] objectArray;
                    configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                    boolean before = null != configurationAnnotation ? configurationAnnotation.getBeforeTestClass() : false;
                    boolean after = null != configurationAnnotation ? configurationAnnotation.getAfterTestClass() : false;
                    boolean alwaysRun = false;
                    if (null != configurationAnnotation && (configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod()) && configurationAnnotation.getAlwaysRun()) {
                        alwaysRun = true;
                    }
                    if (!this.confInvocationPassed(tm.getRealClass()) && !alwaysRun) {
                        testResult.setStatus(3);
                        this.m_notifier.addSkippedTest(tm, testResult);
                        this.runTestListeners(testResult);
                        continue;
                    }
                    boolean isClassConfiguration = null != configurationAnnotation && (before || after);
                    this.log(3, "Invoking " + tm);
                    Object[] parameters = Parameters.createConfigurationParameters(tm.getMethod(), params, this.m_annotationFinder, suite);
                    testResult.setParameters(parameters);
                    if (null != instance) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = instance;
                    } else {
                        objectArray = instances;
                    }
                    Object[] newInstances = objectArray;
                    this.invokeConfigurationMethod(newInstances, tm, parameters, isClassConfiguration, testResult);
                    continue;
                }
                this.log(3, "Skipping " + method.getDeclaringClass().getName() + "." + method.getName() + "()" + " because " + objectClass.getName() + " is not enabled");
            }
            catch (InvocationTargetException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
            catch (TestNGException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
                Utils.log("", 1, ex.getMessage());
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
        }
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfiguration annotation, XmlSuite suite) {
        this.handleException(ite.getCause(), tm, testResult, 1);
        this.runTestListeners(testResult);
        if (null != annotation) {
            if (annotation.getBeforeTestClass() || annotation.getAfterTestClass() || annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
                this.setClassInvocationFailure(tm.getRealClass(), false);
            } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
                this.m_suiteConfigurationFailed = true;
            } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
                XmlClass[] classes;
                for (XmlClass xmlClass : classes = this.findClassesInSameTest(tm.getRealClass(), suite)) {
                    this.setClassInvocationFailure(xmlClass.getSupportClass(), false);
                }
            }
        } else {
            boolean isJUnit;
            String methodName = tm.getMethod().getName();
            boolean bl = isJUnit = "setUp".equals(methodName) || "tearDown".equals(methodName);
            if (isJUnit) {
                this.setClassInvocationFailure(tm.getRealClass(), false);
            }
        }
    }

    private XmlClass[] findClassesInSameTest(Class cls, XmlSuite suite) {
        HashMap<String, XmlClass> vResult = new HashMap<String, XmlClass>();
        String className = cls.getName();
        for (XmlTest test : suite.getTests()) {
            for (XmlClass testClass : test.getXmlClasses()) {
                if (!testClass.getName().equals(className)) continue;
                for (XmlClass thisClass : test.getXmlClasses()) {
                    vResult.put(thisClass.getName(), thisClass);
                }
            }
        }
        XmlClass[] result = vResult.values().toArray(new XmlClass[vResult.size()]);
        return result;
    }

    private boolean confInvocationPassed(Class cls) {
        boolean result = true;
        if (this.m_suiteConfigurationFailed) {
            result = false;
        } else if (this.m_classInvocationResults.containsKey(cls)) {
            result = this.m_classInvocationResults.get(cls);
        } else {
            for (Class clazz : this.m_classInvocationResults.keySet()) {
                if (!clazz.isAssignableFrom(cls)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void setClassInvocationFailure(Class clazz, boolean flag) {
        this.m_classInvocationResults.put(clazz, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConfigurationMethod(Object[] instances, ITestNGMethod tm, Object[] params, boolean isClass, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(Thread.currentThread().hashCode());
        long timeOut = tm.getTimeOut();
        for (Object targetInstance : instances) {
            InvokedMethod im = new InvokedMethod(targetInstance, tm, params, false, isClass, System.currentTimeMillis());
            this.m_notifier.addInvokedMethod(im);
            try {
                Reporter.setCurrentTestResult(testResult);
                MethodHelper.invokeMethod(tm.getMethod(), targetInstance, params);
            }
            finally {
                Reporter.setCurrentTestResult(testResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITestResult> invokeMethod(Object[] instances, ITestNGMethod tm, Object[] parameterValues, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        Method thisMethod = null;
        tm.setId(Thread.currentThread().hashCode());
        long timeOut = tm.getTimeOut();
        for (int i = 0; i < instances.length; ++i) {
            this.invokeBeforeGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[i]);
            this.invokeConfigurations(testClass, beforeMethods, suite, params, instances[i]);
            TestResult testResult = null;
            try {
                testResult = new TestResult(testClass, instances[i], tm, null, System.currentTimeMillis(), 0L);
                testResult.setParameters(parameterValues);
                testResult.setHost(this.m_testContext.getHost());
                testResult.setStatus(16);
                this.runTestListeners(testResult);
                results.add(testResult);
                InvokedMethod invokedMethod = new InvokedMethod(instances[i], tm, parameterValues, true, false, System.currentTimeMillis());
                this.m_notifier.addInvokedMethod(invokedMethod);
                thisMethod = tm.getMethod();
                if (this.confInvocationPassed(thisMethod.getDeclaringClass())) {
                    this.log(3, "Invoking " + thisMethod.getDeclaringClass().getName() + "." + thisMethod.getName());
                    if (timeOut <= 0L) {
                        if (IHookable.class.isAssignableFrom(thisMethod.getDeclaringClass())) {
                            this.invokeHookable(instances, parameterValues, testClass, thisMethod, i, testResult);
                            continue;
                        }
                        try {
                            Reporter.setCurrentTestResult(testResult);
                            MethodHelper.invokeMethod(thisMethod, instances[i], parameterValues);
                            testResult.setStatus(1);
                            continue;
                        }
                        finally {
                            Reporter.setCurrentTestResult(null);
                        }
                    }
                    ICountDown done = ThreadUtil.createCountDown(1);
                    IThreadFactory factory = ThreadUtil.createFactory(tm.getMethod().getName());
                    IExecutor exec = ThreadUtil.createExecutor(1, factory);
                    try {
                        InvokeMethodRunnable imr = new InvokeMethodRunnable(thisMethod, instances[i], parameterValues, done);
                        IFutureResult future = exec.submitRunnable(imr);
                        exec.shutdown();
                        boolean finished = exec.awaitTermination(timeOut);
                        if (!finished) {
                            exec.stopNow();
                            testResult.setThrowable(new ThreadTimeoutException("Method " + thisMethod + " didn't finish within the time-out " + timeOut));
                            testResult.setStatus(2);
                            continue;
                        }
                        this.log(3, "Method " + thisMethod + " completed within the time-out " + timeOut);
                        future.get();
                        done.await();
                        testResult.setStatus(1);
                    }
                    catch (InterruptedException e) {
                        System.err.println("WARN: invocation of method " + thisMethod + " has been interrupted.");
                    }
                    continue;
                }
                testResult.setStatus(3);
                continue;
            }
            catch (InvocationTargetException ite) {
                testResult.setThrowable(ite.getCause());
                continue;
            }
            catch (ThreadExecutionException tee) {
                Throwable cause = tee.getCause();
                if (InvokeMethodRunnable.TestNGRuntimeException.class.equals(cause.getClass())) {
                    testResult.setThrowable(cause.getCause());
                    continue;
                }
                testResult.setThrowable(cause);
                continue;
            }
            catch (Throwable thr) {
                testResult.setThrowable(thr);
                continue;
            }
            finally {
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.invokeConfigurations(testClass, afterMethods, suite, params, instances[i]);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[i]);
            }
        }
        return results;
    }

    private void invokeBeforeGroupsConfigurations(ITestClass testClass, ITestNGMethod tm, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ArrayList<ITestNGMethod> filteredMethods = new ArrayList<ITestNGMethod>();
        String[] groups = tm.getGroups();
        Map<String, List<ITestNGMethod>> beforeGroupMap = groupMethods.getBeforeGroupsMap();
        for (String group : groups) {
            List<ITestNGMethod> methods = beforeGroupMap.get(group);
            if (methods == null) continue;
            filteredMethods.addAll(methods);
        }
        ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[filteredMethods.size()]);
        this.invokeConfigurations(testClass, beforeMethodsArray, suite, params, instance);
        groupMethods.removeBeforeGroups(groups);
    }

    private void invokeAfterGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        String[] groups;
        if (testClass.getAfterGroupsMethods().length == 0) {
            return;
        }
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        HashMap<String, String> filteredGroups = new HashMap<String, String>();
        for (String group : groups = currentTestMethod.getGroups()) {
            if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
            filteredGroups.put(group, group);
        }
        HashMap<ITestNGMethod, ITestNGMethod> afterMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
        Map<String, List<ITestNGMethod>> map = groupMethods.getAfterGroupsMap();
        for (String g : filteredGroups.values()) {
            List<ITestNGMethod> methods = map.get(g);
            if (methods == null) continue;
            for (ITestNGMethod m : methods) {
                afterMethods.put(m, m);
            }
        }
        ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[afterMethods.size()]);
        this.invokeConfigurations(testClass, afterMethodsArray, suite, params, instance);
        groupMethods.removeAfterGroups(filteredGroups.keySet());
    }

    private void invokeHookable(Object[] instances, Object[] parameters, ITestClass testClass, Method thisMethod, int i, TestResult testResult) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Throwable {
        Method runMethod = null;
        runMethod = testClass.getRealClass().getMethod("run", IHookCallBack.class, ITestResult.class);
        final Method a = thisMethod;
        final Object b = instances[i];
        final Object[] c = parameters;
        final Throwable[] error = new Throwable[1];
        IHookCallBack callback = new IHookCallBack(){

            public void runTestMethod(ITestResult tr) {
                try {
                    MethodHelper.invokeMethod(a, b, c);
                }
                catch (Throwable t) {
                    error[0] = t;
                }
            }
        };
        runMethod.invoke(instances[i], callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
        testResult.setStatus(1);
    }

    private Iterator<Object[]> handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, ITestClass testClass, Map<String, String> parameters, XmlSuite xmlSuite) {
        Iterator<Object[]> result = null;
        Method dataProvider = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getMethod(), this.m_annotationFinder);
        if (null != dataProvider) {
            int parameterCount = testMethod.getMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            result = MethodHelper.invokeDataProvider(testClass.getInstances(true)[0], dataProvider, testMethod.getMethod());
        } else {
            allParameterNames.putAll(parameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createTestParameters(testMethod.getMethod(), parameters, this.m_annotationFinder, xmlSuite)};
            result = MethodHelper.createArrayIterator(allParameterValuesArray);
        }
        return result;
    }

    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, XmlSuite suite, Map<String, String> parameters, ITestNGMethod[] allTestMethods, int testMethodIndex, ConfigurationGroupMethods groupMethods) {
        List<ITestResult> result = null;
        ITestClass testClass = testMethod.getTestClass();
        Method method = testMethod.getMethod();
        assert (null != testClass) : "COULDN'T FIND TESTCLASS FOR " + method.getDeclaringClass();
        long start = System.currentTimeMillis();
        ITestNGMethod[] beforeMethods = this.filterMethods(testClass, testClass.getBeforeTestMethods());
        ITestNGMethod[] afterMethods = this.filterMethods(testClass, testClass.getAfterTestMethods());
        int invocationCount = testMethod.getInvocationCount();
        if (this.isWithinThreadedMethod()) {
            invocationCount = 1;
        }
        int failureCount = 0;
        boolean more = true;
        int threadPoolSize = testMethod.getThreadPoolSize();
        Class[] expectedExceptionClasses = Invoker.findExpectedExceptions(this.m_annotationFinder, testMethod.getMethod());
        while (invocationCount-- > 0 && more) {
            boolean okToProceed = this.checkDependencies(testMethod, testClass, allTestMethods);
            Object[] parameterValues = null;
            if (okToProceed) {
                HashMap<String, String> allParameterNames = new HashMap<String, String>();
                Iterator<Object[]> allParameterValues = this.handleParameters(testMethod, allParameterNames, testClass, parameters, suite);
                if (!MethodHelper.isEnabled(testMethod.getMethod(), this.m_annotationFinder)) continue;
                Iterator<Object[]> it = allParameterValues;
                while (it.hasNext()) {
                    parameterValues = it.next();
                    Object[] instances = testClass.getInstances(true);
                    if (JUnitUtils.isAssignableFromTestCase(testClass.getRealClass())) {
                        String name = testMethod.getMethodName();
                        try {
                            Method m = testClass.getRealClass().getMethod("setName", String.class);
                            for (Object instance : instances) {
                                m.invoke(instance, name);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (threadPoolSize > 1 && !this.isWithinThreadedMethod()) {
                        HashMap<ITestClass, ITestClass> beforeMethodsMap = new HashMap<ITestClass, ITestClass>();
                        HashMap<ITestClass, ITestClass> afterMethodsMap = new HashMap<ITestClass, ITestClass>();
                        ArrayList<TestMethodWorker> workers = new ArrayList<TestMethodWorker>();
                        ClassMethodMap classMethodMap = new ClassMethodMap(allTestMethods);
                        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
                            workers.add(new TestMethodWorker(this, new ITestNGMethod[]{testMethod}, suite, parameters, beforeMethodsMap, afterMethodsMap, allTestMethods, groupMethods, classMethodMap));
                        }
                        this.setWithinThreadedMethod(true);
                        result = this.runWorkers(testMethod, workers, threadPoolSize);
                        this.setWithinThreadedMethod(false);
                        more = false;
                    } else {
                        result = this.invokeMethod(instances, testMethod, parameterValues, suite, allParameterNames, testClass, beforeMethods, afterMethods, groupMethods);
                    }
                    for (ITestResult testResult : result) {
                        Throwable ite = testResult.getThrowable();
                        int status = testResult.getStatus();
                        if (ite != null) {
                            if (this.isExpectedException(ite, expectedExceptionClasses)) {
                                testResult.setStatus(1);
                                status = 1;
                            } else {
                                this.handleException(ite, testMethod, testResult, failureCount++);
                                status = testResult.getStatus();
                            }
                        } else if (expectedExceptionClasses.length > 0) {
                            testResult.setThrowable(new TestException("Expected an exception in test method " + testMethod));
                            status = 2;
                        }
                        testResult.setStatus(status);
                        if (1 == status) {
                            this.m_notifier.addPassedTest(testMethod, testResult);
                        } else if (3 == status) {
                            this.m_notifier.addSkippedTest(testMethod, testResult);
                        } else if (2 == status) {
                            this.m_notifier.addFailedTest(testMethod, testResult);
                        } else if (4 == status) {
                            this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
                        } else assert (false) : "UNKNOWN STATUS:" + status;
                        if (this.isWithinThreadedMethod()) continue;
                        this.runTestListeners(testResult);
                    }
                }
                continue;
            }
            TestResult testResult = new TestResult(testClass, null, testMethod, null, start, System.currentTimeMillis());
            testResult.setEndMillis(System.currentTimeMillis());
            testResult.setParameters(parameterValues);
            String missingGroup = testMethod.getMissingGroup();
            if (missingGroup != null) {
                testResult.setThrowable(new Throwable("Method " + testMethod + " depends on nonexistent group \"" + missingGroup + "\""));
            }
            testResult.setStatus(3);
            this.m_notifier.addSkippedTest(testMethod, testResult);
            this.runTestListeners(testResult);
        }
        return result;
    }

    public static Class[] findExpectedExceptions(IAnnotationFinder finder, Method method) {
        Class[] result = new Class[]{};
        IExpectedExceptions expectedExceptions = (IExpectedExceptions)finder.findAnnotation(method, IExpectedExceptions.class);
        if (expectedExceptions != null) {
            result = expectedExceptions.getValue();
        } else {
            ITest testAnnotation = (ITest)finder.findAnnotation(method, ITest.class);
            if (testAnnotation != null) {
                Class[] ee = testAnnotation.getExpectedExceptions();
                if (testAnnotation != null && ee.length > 0) {
                    result = ee;
                }
            }
        }
        return result;
    }

    private boolean isWithinThreadedMethod() {
        return this.m_withinThreadedMethod;
    }

    private void setWithinThreadedMethod(boolean f) {
        this.m_withinThreadedMethod = f;
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<TestMethodWorker> workers, int threadPoolSize) {
        long maxTimeOut = 10000L;
        IPooledExecutor executor = ThreadUtil.createPooledExecutor(threadPoolSize);
        for (TestMethodWorker tmw : workers) {
            long mt = tmw.getMaxTimeOut();
            if (mt > maxTimeOut) {
                maxTimeOut = mt;
            }
            executor.execute(tmw);
        }
        try {
            executor.shutdown();
            this.log(3, "Waiting for termination, timeout:" + maxTimeOut);
            executor.awaitTermination(maxTimeOut);
            this.log(3, "Successful termination");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<ITestResult> result = new ArrayList<ITestResult>();
        for (TestMethodWorker tmw : workers) {
            result.addAll(tmw.getTestResults());
        }
        return result;
    }

    private boolean checkDependencies(ITestNGMethod testMethod, ITestClass testClass, ITestNGMethod[] allTestMethods) {
        boolean result = true;
        if (testMethod.isAlwaysRun()) {
            return true;
        }
        if (testMethod.getMissingGroup() != null) {
            return false;
        }
        if (this.dependsOnGroups(testMethod)) {
            String[] groupsDependedUpon = testMethod.getGroupsDependedUpon();
            for (int i = 0; i < groupsDependedUpon.length; ++i) {
                ITestNGMethod[] methods = MethodHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), groupsDependedUpon[i]);
                result = result && this.haveBeenRunSuccessfully(methods);
            }
        }
        if (this.dependsOnMethods(testMethod)) {
            ITestNGMethod[] methods = MethodHelper.findMethodsNamed(testMethod.getMethod().getName(), allTestMethods, testMethod.getMethodsDependedUpon());
            result = result && this.haveBeenRunSuccessfully(methods);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod[] methods) {
        for (int j = 0; j < methods.length; ++j) {
            Set<ITestResult> results = this.m_notifier.getPassedTests(methods[j]);
            if (results == null || results.size() == 0) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        testResult.setThrowable(throwable);
        int successPercentage = testMethod.getSuccessPercentage();
        int invocationCount = testMethod.getInvocationCount();
        float numberOfTestsThatCanFail = (100 - successPercentage) * invocationCount / 100;
        if ((float)failureCount < numberOfTestsThatCanFail) {
            testResult.setStatus(4);
            this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
        } else {
            testResult.setStatus(2);
            this.m_notifier.addFailedTest(testMethod, testResult);
        }
    }

    private boolean isExpectedException(Throwable ite, Class[] exceptions) {
        if (null == exceptions) {
            return false;
        }
        Class<?> realExceptionClass = ite.getClass();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].isAssignableFrom(realExceptionClass)) continue;
            return true;
        }
        return false;
    }

    private ITestNGMethod[] filterMethods(IClass testClass, ITestNGMethod[] methods) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (tm.canRunFromClass(testClass)) {
                this.log(9, "Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private ITestNGMethod[] filterMethodsUnique(IClass testClass, ITestNGMethod[] methods) {
        if (null == testClass) {
            return methods;
        }
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            if (tm.getTestClass().getName().equals(testClass.getName())) {
                this.log(9, "        Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "        Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private boolean dependsOnGroups(ITestNGMethod tm) {
        String[] groups = tm.getGroupsDependedUpon();
        boolean result = null != groups && groups.length > 0;
        return result;
    }

    private boolean dependsOnMethods(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        boolean result = null != methods && methods.length > 0;
        return result;
    }

    @Override
    public void runTestListeners(ITestResult tr) {
        Invoker.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    private static void ppp(String s) {
        System.out.println("[Invoker]" + s);
    }

    private void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }
}

