/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/node/v1"
	nodev1 "k8s.io/client-go/applyconfigurations/node/v1"
	gentype "k8s.io/client-go/gentype"
	typednodev1 "k8s.io/client-go/kubernetes/typed/node/v1"
)

// fakeRuntimeClasses implements RuntimeClassInterface
type fakeRuntimeClasses struct {
	*gentype.FakeClientWithListAndApply[*v1.RuntimeClass, *v1.RuntimeClassList, *nodev1.RuntimeClassApplyConfiguration]
	Fake *FakeNodeV1
}

func newFakeRuntimeClasses(fake *FakeNodeV1) typednodev1.RuntimeClassInterface {
	return &fakeRuntimeClasses{
		gentype.NewFakeClientWithListAndApply[*v1.RuntimeClass, *v1.RuntimeClassList, *nodev1.RuntimeClassApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("runtimeclasses"),
			v1.SchemeGroupVersion.WithKind("RuntimeClass"),
			func() *v1.RuntimeClass { return &v1.RuntimeClass{} },
			func() *v1.RuntimeClassList { return &v1.RuntimeClassList{} },
			func(dst, src *v1.RuntimeClassList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RuntimeClassList) []*v1.RuntimeClass { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RuntimeClassList, items []*v1.RuntimeClass) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
