# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the BSD-style license found in the
# LICENSE file in the root directory of this source tree.

from typing import Callable, List, TypeVar

T = TypeVar("T")

# Criteo Data Set Parameters
INT_FEATURE_COUNT = 13
CAT_FEATURE_COUNT = 26
DEFAULT_LABEL_NAME = "label"
DEFAULT_INT_NAMES: List[str] = [f"int_{idx}" for idx in range(INT_FEATURE_COUNT)]
DEFAULT_CAT_NAMES: List[str] = [f"cat_{idx}" for idx in range(CAT_FEATURE_COUNT)]
DEFAULT_COLUMN_NAMES: List[str] = [
    DEFAULT_LABEL_NAME,
    *DEFAULT_INT_NAMES,
    *DEFAULT_CAT_NAMES,
]


def safe_cast(val: T, dest_type: Callable[[T], T], default: T) -> T:
    """
    Helper function to safely cast data with default as fallback.
    """
    try:
        return dest_type(val)
    except ValueError:
        return default


def safe_hex_to_int(num):
    try:
        return int(safe_cast(num, str, "0") or "0", 16)
    except Exception:
        return float("NaN")
