#include "test_data.hpp"
#include <test_utils.hpp>
#include <libslic3r/TriangleMesh.hpp>
#include <libslic3r/GCodeReader.hpp>
#include <libslic3r/Config.hpp>
#include <libslic3r/ModelArrange.hpp>
#include <libslic3r/Print.hpp>
#include <libslic3r/Point.hpp>
#include <cstdlib>
#include <string>
#include <fstream>
#include <cstdio>

using namespace std::string_literals;
using namespace std;

namespace Slic3r { namespace Test {

// Mesh enumeration to name mapping
const std::unordered_map<TestMesh, const std::string, TestMeshHash> mesh_names {
	std::make_pair<TestMesh, const std::string>(TestMesh::A,"A"),
    std::make_pair<TestMesh, const std::string>(TestMesh::L,"L"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::V,"V"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::_40x10,"40x10"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::cube_20x20x20,"cube_20x20x20"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::sphere_50mm,"sphere_50mm"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::bridge,"bridge"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::bridge_with_hole,"bridge_with_hole"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::cube_with_concave_hole,"cube_with_concave_hole"),
    std::make_pair<TestMesh, const std::string>(TestMesh::cube_with_hole,"cube_with_hole"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::gt2_teeth,"gt2_teeth"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::ipadstand,"ipadstand"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::overhang,"overhang"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::pyramid,"pyramid"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::sloping_hole,"sloping_hole"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::slopy_cube,"slopy_cube"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::small_dorito,"small_dorito"), 
    std::make_pair<TestMesh, const std::string>(TestMesh::step,"step"),
    std::make_pair<TestMesh, const std::string>(TestMesh::two_hollow_squares,"two_hollow_squares"),
    std::make_pair<TestMesh, const std::string>(TestMesh::di_5mm_center_notch,"5mm_center_notch"),
    std::make_pair<TestMesh, const std::string>(TestMesh::di_10mm_notch,"10mm_notch"),
    std::make_pair<TestMesh, const std::string>(TestMesh::di_20mm_notch,"20mm_notch"),
    std::make_pair<TestMesh, const std::string>(TestMesh::di_25mm_notch,"25mm_notch")
    
};



TriangleMesh mesh(TestMesh m) {
	std::vector<Vec3i32> facets;
	std::vector<Vec3f> vertices;
    switch(m) {
        case TestMesh::cube_with_hole:
            vertices = { Vec3f(0,0,0), Vec3f(0,0,10), Vec3f(0,20,0), Vec3f(0,20,10), Vec3f(20,0,0), Vec3f(20,0,10), Vec3f(5,5,0), Vec3f(15,5,0), Vec3f(5,15,0), Vec3f(20,20,0), Vec3f(15,15,0), Vec3f(20,20,10), Vec3f(5,5,10), Vec3f(5,15,10), Vec3f(15,5,10), Vec3f(15,15,10) };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(1,0,4), Vec3i32(5,1,4), Vec3i32(6,7,4), Vec3i32(8,2,9), Vec3i32(0,2,8), Vec3i32(10,8,9), Vec3i32(0,8,6), Vec3i32(0,6,4), Vec3i32(4,7,9), Vec3i32(7,10,9), Vec3i32(2,3,9), Vec3i32(9,3,11), Vec3i32(12,1,5), Vec3i32(13,3,12), Vec3i32(14,12,5), Vec3i32(3,1,12), Vec3i32(11,3,13), Vec3i32(11,15,5), Vec3i32(11,13,15), Vec3i32(15,14,5), Vec3i32(5,4,9), Vec3i32(11,5,9), Vec3i32(8,13,12), Vec3i32(6,8,12), Vec3i32(10,15,13), Vec3i32(8,10,13), Vec3i32(15,10,14), Vec3i32(14,10,7), Vec3i32(14,7,12), Vec3i32(12,7,6) 
            };
            break;
        case TestMesh::cube_with_concave_hole:
            vertices = std::vector<Vec3f>{
                Vec3f(-10,-10,-5), Vec3f(-10,-10,5), Vec3f(-10,10,-5), Vec3f(-10,10,5), Vec3f(10,-10,-5), Vec3f(10,-10,5), Vec3f(-5,-5,-5), Vec3f(5,-5,-5), Vec3f(5,5,-5), Vec3f(5,10,-5), Vec3f(-5,5,-5), Vec3f(0,5,-5), Vec3f(5,0,-5), Vec3f(0,0,-5), Vec3f(10,5,-5), Vec3f(5,10,5), Vec3f(-5,-5,5), Vec3f(5,0,5), Vec3f(5,-5,5), Vec3f(-5,5,5), Vec3f(10,5,5), Vec3f(5,5,5), Vec3f(0,5,5), Vec3f(0,0,5) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(1,0,4), Vec3i32(5,1,4), Vec3i32(6,7,4), Vec3i32(8,2,9), Vec3i32(10,2,11), Vec3i32(11,12,13), Vec3i32(0,2,10), Vec3i32(0,10,6), Vec3i32(0,6,4), Vec3i32(11,2,8), Vec3i32(4,7,12), Vec3i32(4,12,8), Vec3i32(12,11,8), Vec3i32(14,4,8), Vec3i32(2,3,9), Vec3i32(9,3,15), Vec3i32(16,1,5), Vec3i32(17,18,5), Vec3i32(19,3,16), Vec3i32(20,21,5), Vec3i32(18,16,5), Vec3i32(3,1,16), Vec3i32(22,3,19), Vec3i32(21,3,22), Vec3i32(21,17,5), Vec3i32(21,22,17), Vec3i32(21,15,3), Vec3i32(23,17,22), Vec3i32(5,4,14), Vec3i32(20,5,14), Vec3i32(20,14,21), Vec3i32(21,14,8), Vec3i32(9,15,21), Vec3i32(8,9,21), Vec3i32(10,19,16), Vec3i32(6,10,16), Vec3i32(11,22,19), Vec3i32(10,11,19), Vec3i32(13,23,11), Vec3i32(11,23,22), Vec3i32(23,13,12), Vec3i32(17,23,12), Vec3i32(17,12,18), Vec3i32(18,12,7), Vec3i32(18,7,16), Vec3i32(16,7,6) 
            };
            break;
        case TestMesh::V:
            vertices = std::vector<Vec3f>{
                Vec3f(-14,0,20), Vec3f(-14,15,20), Vec3f(0,0,0), Vec3f(0,15,0), Vec3f(-4,0,20), Vec3f(-4,15,20), Vec3f(5,0,7.14286), Vec3f(10,0,0), Vec3f(24,0,20), Vec3f(14,0,20), Vec3f(10,15,0), Vec3f(5,15,7.14286f), Vec3f(14,15,20), Vec3f(24,15,20) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(1,0,4), Vec3i32(5,1,4), Vec3i32(4,0,2), Vec3i32(6,4,2), Vec3i32(7,6,2), Vec3i32(8,9,7), Vec3i32(9,6,7), Vec3i32(2,3,7), Vec3i32(7,3,10), Vec3i32(1,5,3), Vec3i32(3,5,11), Vec3i32(11,12,13), Vec3i32(11,13,3), Vec3i32(3,13,10), Vec3i32(5,4,6), Vec3i32(11,5,6), Vec3i32(6,9,11), Vec3i32(11,9,12), Vec3i32(12,9,8), Vec3i32(13,12,8), Vec3i32(8,7,10), Vec3i32(13,8,10) 
            };
            break;
        case TestMesh::L:
            vertices = std::vector<Vec3f>{
                Vec3f(0,10,0), Vec3f(0,10,10), Vec3f(0,20,0), Vec3f(0,20,10), Vec3f(10,10,0), Vec3f(10,10,10), Vec3f(20,20,0), Vec3f(20,0,0), Vec3f(10,0,0), Vec3f(20,20,10), Vec3f(10,0,10), Vec3f(20,0,10) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(4,5,1), Vec3i32(0,4,1), Vec3i32(0,2,4), Vec3i32(4,2,6), Vec3i32(4,6,7), Vec3i32(4,7,8), Vec3i32(2,3,6), Vec3i32(6,3,9), Vec3i32(3,1,5), Vec3i32(9,3,5), Vec3i32(10,11,5), Vec3i32(11,9,5), Vec3i32(5,4,10), Vec3i32(10,4,8), Vec3i32(10,8,7), Vec3i32(11,10,7), Vec3i32(11,7,6), Vec3i32(9,11,6) 
            };
            break;
        case TestMesh::overhang:
            vertices = std::vector<Vec3f>{
                Vec3f(1364.68505859375,614.398010253906,20.002498626709), Vec3f(1389.68505859375,614.398010253906,20.002498626709), Vec3f(1377.18505859375,589.398986816406,20.002498626709), Vec3f(1389.68505859375,589.398986816406,20.002498626709), Vec3f(1389.68505859375,564.398986816406,20.0014991760254), Vec3f(1364.68505859375,589.398986816406,20.002498626709), Vec3f(1364.68505859375,564.398986816406,20.0014991760254), Vec3f(1360.93505859375,589.398986816406,17.0014991760254), Vec3f(1360.93505859375,585.64697265625,17.0014991760254), Vec3f(1357.18505859375,564.398986816406,17.0014991760254), Vec3f(1364.68505859375,589.398986816406,17.0014991760254), Vec3f(1364.68505859375,571.899963378906,17.0014991760254), Vec3f(1364.68505859375,564.398986816406,17.0014991760254), Vec3f(1348.43603515625,564.398986816406,17.0014991760254), Vec3f(1352.80908203125,589.398986816406,17.0014991760254), Vec3f(1357.18408203125,589.398986816406,17.0014991760254), Vec3f(1357.18310546875,614.398010253906,17.0014991760254), Vec3f(1364.68505859375,606.89599609375,17.0014991760254), Vec3f(1364.68505859375,614.398010253906,17.0014991760254), Vec3f(1352.18603515625,564.398986816406,20.0014991760254), Vec3f(1363.65405273438,589.398986816406,23.3004989624023), Vec3f(1359.46704101562,589.398986816406,23.3004989624023), Vec3f(1358.37109375,564.398986816406,23.3004989624023), Vec3f(1385.56103515625,564.398986816406,23.3004989624023), Vec3f(1373.06311035156,589.398986816406,23.3004989624023), Vec3f(1368.80810546875,564.398986816406,23.3004989624023), Vec3f(1387.623046875,589.398986816406,23.3004989624023), Vec3f(1387.623046875,585.276000976562,23.3004989624023), Vec3f(1389.68505859375,589.398986816406,23.3004989624023), Vec3f(1389.68505859375,572.64599609375,23.3004989624023), Vec3f(1389.68505859375,564.398986816406,23.3004989624023), Vec3f(1367.77709960938,589.398986816406,23.3004989624023), Vec3f(1366.7470703125,564.398986816406,23.3004989624023), Vec3f(1354.31201171875,589.398986816406,23.3004989624023), Vec3f(1352.18603515625,564.398986816406,23.3004989624023), Vec3f(1389.68505859375,614.398010253906,23.3004989624023), Vec3f(1377.31701660156,614.398010253906,23.3004989624023), Vec3f(1381.43908691406,589.398986816406,23.3004989624023), Vec3f(1368.80700683594,614.398010253906,23.3004989624023), Vec3f(1368.80810546875,589.398986816406,23.3004989624023), Vec3f(1356.43908691406,614.398010253906,23.3004989624023), Vec3f(1357.40502929688,589.398986816406,23.3004989624023), Vec3f(1360.56201171875,614.398010253906,23.3004989624023), Vec3f(1348.705078125,614.398010253906,23.3004989624023), Vec3f(1350.44506835938,589.398986816406,23.3004989624023), Vec3f(1389.68505859375,606.153015136719,23.3004989624023), Vec3f(1347.35205078125,589.398986816406,23.3004989624023), Vec3f(1346.56005859375,589.398986816406,23.3004989624023), Vec3f(1346.56005859375,594.159912109375,17.0014991760254), Vec3f(1346.56005859375,589.398986816406,17.0014991760254), Vec3f(1346.56005859375,605.250427246094,23.3004989624023), Vec3f(1346.56005859375,614.398010253906,23.3004989624023), Vec3f(1346.56005859375,614.398010253906,20.8258285522461), Vec3f(1346.56005859375,614.398010253906,17.0014991760254), Vec3f(1346.56005859375,564.398986816406,19.10133934021), Vec3f(1346.56005859375,567.548583984375,23.3004989624023), Vec3f(1346.56005859375,564.398986816406,17.0020332336426), Vec3f(1346.56005859375,564.398986816406,23.0018501281738), Vec3f(1346.56005859375,564.398986816406,23.3004989624023), Vec3f(1346.56005859375,575.118957519531,17.0014991760254), Vec3f(1346.56005859375,574.754028320312,23.3004989624023) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,3,4), Vec3i32(2,5,0), Vec3i32(4,6,2), Vec3i32(2,6,5), Vec3i32(2,1,3), Vec3i32(7,8,9), Vec3i32(10,9,8), Vec3i32(11,9,10), Vec3i32(12,9,11), Vec3i32(9,13,14), Vec3i32(7,15,16), Vec3i32(10,17,0), Vec3i32(10,0,5), Vec3i32(12,11,6), Vec3i32(18,16,0), Vec3i32(6,19,13), Vec3i32(6,13,9), Vec3i32(9,12,6), Vec3i32(17,18,0), Vec3i32(11,10,5), Vec3i32(11,5,6), Vec3i32(14,16,15), Vec3i32(17,7,18), Vec3i32(16,18,7), Vec3i32(14,15,9), Vec3i32(7,9,15), Vec3i32(7,17,8), Vec3i32(10,8,17), Vec3i32(20,21,22), Vec3i32(23,24,25), Vec3i32(26,23,27), Vec3i32(28,27,23), Vec3i32(29,28,23), Vec3i32(30,29,23), Vec3i32(25,31,32), Vec3i32(22,33,34), Vec3i32(35,36,37), Vec3i32(24,38,39), Vec3i32(21,40,41), Vec3i32(38,42,20), Vec3i32(33,43,44), Vec3i32(6,4,23), Vec3i32(6,23,25), Vec3i32(36,35,1), Vec3i32(1,0,38), Vec3i32(1,38,36), Vec3i32(29,30,4), Vec3i32(25,32,6), Vec3i32(40,42,0), Vec3i32(35,45,1), Vec3i32(4,3,28), Vec3i32(4,28,29), Vec3i32(3,1,45), Vec3i32(3,45,28), Vec3i32(22,34,19), Vec3i32(19,6,32), Vec3i32(19,32,22), Vec3i32(42,38,0), Vec3i32(30,23,4), Vec3i32(0,16,43), Vec3i32(0,43,40), Vec3i32(24,37,36), Vec3i32(38,24,36), Vec3i32(24,23,37), Vec3i32(37,23,26), Vec3i32(22,32,20), Vec3i32(20,32,31), Vec3i32(33,41,40), Vec3i32(43,33,40), Vec3i32(45,35,26), Vec3i32(37,26,35), Vec3i32(33,44,34), Vec3i32(44,43,46), Vec3i32(20,42,21), Vec3i32(40,21,42), Vec3i32(31,39,38), Vec3i32(20,31,38), Vec3i32(33,22,41), Vec3i32(21,41,22), Vec3i32(31,25,39), Vec3i32(24,39,25), Vec3i32(26,27,45), Vec3i32(28,45,27), Vec3i32(47,48,49), Vec3i32(47,50,48), Vec3i32(51,48,50), Vec3i32(52,48,51), Vec3i32(53,48,52), Vec3i32(54,55,56), Vec3i32(57,55,54), Vec3i32(58,55,57), Vec3i32(49,59,47), Vec3i32(60,56,55), Vec3i32(59,56,60), Vec3i32(60,47,59), Vec3i32(48,53,16), Vec3i32(56,13,19), Vec3i32(54,56,19), Vec3i32(56,59,13), Vec3i32(59,49,14), Vec3i32(59,14,13), Vec3i32(49,48,16), Vec3i32(49,16,14), Vec3i32(44,46,60), Vec3i32(44,60,55), Vec3i32(51,50,43), Vec3i32(19,34,58), Vec3i32(19,58,57), Vec3i32(53,52,16), Vec3i32(43,16,52), Vec3i32(43,52,51), Vec3i32(57,54,19), Vec3i32(47,60,46), Vec3i32(55,58,34), Vec3i32(55,34,44), Vec3i32(50,47,46), Vec3i32(50,46,43) 
            };
            break;
        case TestMesh::_40x10:
            vertices = std::vector<Vec3f>{
                Vec3f(12.8680295944214,29.5799007415771,12), Vec3f(11.7364797592163,29.8480796813965,12), Vec3f(11.1571502685547,29.5300102233887,12), Vec3f(10.5814504623413,29.9830799102783,12), Vec3f(10,29.6000003814697,12), Vec3f(9.41855144500732,29.9830799102783,12), Vec3f(8.84284687042236,29.5300102233887,12), Vec3f(8.26351833343506,29.8480796813965,12), Vec3f(7.70256900787354,29.3210391998291,12), Vec3f(7.13196802139282,29.5799007415771,12), Vec3f(6.59579277038574,28.9761600494385,12), Vec3f(6.03920221328735,29.1821594238281,12), Vec3f(5.53865718841553,28.5003795623779,12), Vec3f(5,28.6602592468262,12), Vec3f(4.54657793045044,27.9006500244141,12), Vec3f(4.02841377258301,28.0212306976318,12), Vec3f(3.63402199745178,27.1856994628906,12), Vec3f(3.13758301734924,27.2737407684326,12), Vec3f(2.81429696083069,26.3659801483154,12), Vec3f(2.33955597877502,26.4278793334961,12), Vec3f(2.0993549823761,25.4534206390381,12), Vec3f(1.64512205123901,25.4950904846191,12), Vec3f(1.49962198734283,24.4613399505615,12), Vec3f(1.0636739730835,24.4879894256592,12), Vec3f(1.02384400367737,23.4042091369629,12), Vec3f(0.603073298931122,23.4202003479004,12), Vec3f(0.678958415985107,22.2974300384521,12), Vec3f(0.269550800323486,22.3061599731445,12), Vec3f(0.469994693994522,21.1571502685547,12), Vec3f(0.067615881562233,21.1609306335449,12), Vec3f(0.399999290704727,20,12), Vec3f(0,20,12), Vec3f(0.399999290704727,5,12), Vec3f(0,5,12), Vec3f(0.456633001565933,4.2804012298584,12), Vec3f(0.0615576282143593,4.21782684326172,12), Vec3f(0.625140011310577,3.5785219669342,12), Vec3f(0.244717106223106,3.45491504669189,12), Vec3f(0.901369392871857,2.91164398193359,12), Vec3f(0.544967114925385,2.73004698753357,12), Vec3f(1.27852201461792,2.29618692398071,12), Vec3f(0.954914808273315,2.06107401847839,12), Vec3f(1.74730801582336,1.74730801582336,12), Vec3f(1.46446597576141,1.46446597576141,12), Vec3f(2.29618692398071,1.27852201461792,12), Vec3f(2.06107401847839,0.954914808273315,12), Vec3f(2.91164398193359,0.901369392871857,12), Vec3f(2.73004698753357,0.544967114925385,12), Vec3f(3.5785219669342,0.625140011310577,12), Vec3f(3.45491504669189,0.244717106223106,12), Vec3f(4.2804012298584,0.456633001565933,12), Vec3f(4.21782684326172,0.0615576282143593,12), Vec3f(5,0.399999290704727,12), Vec3f(5,0,12), Vec3f(19.6000003814697,0.399999290704727,12), Vec3f(20,0,12), Vec3f(19.6000003814697,20,12), Vec3f(20,20,12), Vec3f(19.5300102233887,21.1571502685547,12), Vec3f(19.9323806762695,21.1609306335449,12), Vec3f(19.3210391998291,22.2974300384521,12), Vec3f(19.7304496765137,22.3061599731445,12), Vec3f(18.9761600494385,23.4042091369629,12), Vec3f(19.3969306945801,23.4202003479004,12), Vec3f(18.5003795623779,24.4613399505615,12), Vec3f(18.9363307952881,24.4879894256592,12), Vec3f(17.9006500244141,25.4534206390381,12), Vec3f(18.3548793792725,25.4950904846191,12), Vec3f(17.1856994628906,26.3659801483154,12), Vec3f(17.6604404449463,26.4278793334961,12), Vec3f(16.3659801483154,27.1856994628906,12), Vec3f(16.862419128418,27.2737407684326,12), Vec3f(15.4534196853638,27.9006500244141,12), Vec3f(15.9715900421143,28.0212306976318,12), Vec3f(14.4613399505615,28.5003795623779,12), Vec3f(15,28.6602592468262,12), Vec3f(13.4042100906372,28.9761600494385,12), Vec3f(13.9608001708984,29.1821594238281,12), Vec3f(12.2974300384521,29.3210391998291,12), Vec3f(7.13196802139282,29.5799007415771,0), Vec3f(8.26351833343506,29.8480796813965,0), Vec3f(8.84284687042236,29.5300102233887,0), Vec3f(9.41855144500732,29.9830799102783,0), Vec3f(10,29.6000003814697,0), Vec3f(10.5814504623413,29.9830799102783,0), Vec3f(11.1571502685547,29.5300102233887,0), Vec3f(11.7364797592163,29.8480796813965,0), Vec3f(12.2974300384521,29.3210391998291,0), Vec3f(12.8680295944214,29.5799007415771,0), Vec3f(13.4042100906372,28.9761600494385,0), Vec3f(13.9608001708984,29.1821594238281,0), Vec3f(14.4613399505615,28.5003795623779,0), Vec3f(15,28.6602592468262,0), Vec3f(15.4534196853638,27.9006500244141,0), Vec3f(15.9715900421143,28.0212306976318,0), Vec3f(16.3659801483154,27.1856994628906,0), Vec3f(16.862419128418,27.2737407684326,0), Vec3f(17.1856994628906,26.3659801483154,0), Vec3f(17.6604404449463,26.4278793334961,0), Vec3f(17.9006500244141,25.4534206390381,0), Vec3f(18.3548793792725,25.4950904846191,0), Vec3f(18.5003795623779,24.4613399505615,0), Vec3f(18.9363307952881,24.4879894256592,0), Vec3f(18.9761600494385,23.4042091369629,0), Vec3f(19.3969306945801,23.4202003479004,0), Vec3f(19.3210391998291,22.2974300384521,0), Vec3f(19.7304496765137,22.3061599731445,0), Vec3f(19.5300102233887,21.1571502685547,0), Vec3f(19.9323806762695,21.1609306335449,0), Vec3f(19.6000003814697,20,0), Vec3f(20,20,0), Vec3f(19.6000003814697,0.399999290704727,0), Vec3f(20,0,0), Vec3f(5,0.399999290704727,0), Vec3f(5,0,0), Vec3f(4.2804012298584,0.456633001565933,0), Vec3f(4.21782684326172,0.0615576282143593,0), Vec3f(3.5785219669342,0.625140011310577,0), Vec3f(3.45491504669189,0.244717106223106,0), Vec3f(2.91164398193359,0.901369392871857,0), Vec3f(2.73004698753357,0.544967114925385,0), Vec3f(2.29618692398071,1.27852201461792,0), Vec3f(2.06107401847839,0.954914808273315,0), Vec3f(1.74730801582336,1.74730801582336,0), Vec3f(1.46446597576141,1.46446597576141,0), Vec3f(1.27852201461792,2.29618692398071,0), Vec3f(0.954914808273315,2.06107401847839,0), Vec3f(0.901369392871857,2.91164398193359,0), Vec3f(0.544967114925385,2.73004698753357,0), Vec3f(0.625140011310577,3.5785219669342,0), Vec3f(0.244717106223106,3.45491504669189,0), Vec3f(0.456633001565933,4.2804012298584,0), Vec3f(0.0615576282143593,4.21782684326172,0), Vec3f(0.399999290704727,5,0), Vec3f(0,5,0), Vec3f(0.399999290704727,20,0), Vec3f(0,20,0), Vec3f(0.469994693994522,21.1571502685547,0), Vec3f(0.067615881562233,21.1609306335449,0), Vec3f(0.678958415985107,22.2974300384521,0), Vec3f(0.269550800323486,22.3061599731445,0), Vec3f(1.02384400367737,23.4042091369629,0), Vec3f(0.603073298931122,23.4202003479004,0), Vec3f(1.49962198734283,24.4613399505615,0), Vec3f(1.0636739730835,24.4879894256592,0), Vec3f(2.0993549823761,25.4534206390381,0), Vec3f(1.64512205123901,25.4950904846191,0), Vec3f(2.81429696083069,26.3659801483154,0), Vec3f(2.33955597877502,26.4278793334961,0), Vec3f(3.63402199745178,27.1856994628906,0), Vec3f(3.13758301734924,27.2737407684326,0), Vec3f(4.54657793045044,27.9006500244141,0), Vec3f(4.02841377258301,28.0212306976318,0), Vec3f(5.53865718841553,28.5003795623779,0), Vec3f(5,28.6602592468262,0), Vec3f(6.59579277038574,28.9761600494385,0), Vec3f(6.03920221328735,29.1821594238281,0), Vec3f(7.70256900787354,29.3210391998291,0) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(2,3,4), Vec3i32(4,3,5), Vec3i32(4,5,6), Vec3i32(6,5,7), Vec3i32(6,7,8), Vec3i32(8,7,9), Vec3i32(8,9,10), Vec3i32(10,9,11), Vec3i32(10,11,12), Vec3i32(12,11,13), Vec3i32(12,13,14), Vec3i32(14,13,15), Vec3i32(14,15,16), Vec3i32(16,15,17), Vec3i32(16,17,18), Vec3i32(18,17,19), Vec3i32(18,19,20), Vec3i32(20,19,21), Vec3i32(20,21,22), Vec3i32(22,21,23), Vec3i32(22,23,24), Vec3i32(24,23,25), Vec3i32(24,25,26), Vec3i32(26,25,27), Vec3i32(26,27,28), Vec3i32(28,27,29), Vec3i32(28,29,30), Vec3i32(30,29,31), Vec3i32(30,31,32), Vec3i32(32,31,33), Vec3i32(32,33,34), Vec3i32(34,33,35), Vec3i32(34,35,36), Vec3i32(36,35,37), Vec3i32(36,37,38), Vec3i32(38,37,39), Vec3i32(38,39,40), Vec3i32(40,39,41), Vec3i32(40,41,42), Vec3i32(42,41,43), Vec3i32(42,43,44), Vec3i32(44,43,45), Vec3i32(44,45,46), Vec3i32(46,45,47), Vec3i32(46,47,48), Vec3i32(48,47,49), Vec3i32(48,49,50), Vec3i32(50,49,51), Vec3i32(50,51,52), Vec3i32(52,51,53), Vec3i32(52,53,54), Vec3i32(54,53,55), Vec3i32(54,55,56), Vec3i32(56,55,57), Vec3i32(56,57,58), Vec3i32(58,57,59), Vec3i32(58,59,60), Vec3i32(60,59,61), Vec3i32(60,61,62), Vec3i32(62,61,63), Vec3i32(62,63,64), Vec3i32(64,63,65), Vec3i32(64,65,66), Vec3i32(66,65,67), Vec3i32(66,67,68), Vec3i32(68,67,69), Vec3i32(68,69,70), Vec3i32(70,69,71), Vec3i32(70,71,72), Vec3i32(72,71,73), Vec3i32(72,73,74), Vec3i32(74,73,75), Vec3i32(74,75,76), Vec3i32(76,75,77), Vec3i32(76,77,78), Vec3i32(78,77,0), Vec3i32(78,0,2), Vec3i32(79,80,81), Vec3i32(81,80,82), Vec3i32(81,82,83), Vec3i32(83,82,84), Vec3i32(83,84,85), Vec3i32(85,84,86), Vec3i32(85,86,87), Vec3i32(87,86,88), Vec3i32(87,88,89), Vec3i32(89,88,90), Vec3i32(89,90,91), Vec3i32(91,90,92), Vec3i32(91,92,93), Vec3i32(93,92,94), Vec3i32(93,94,95), Vec3i32(95,94,96), Vec3i32(95,96,97), Vec3i32(97,96,98), Vec3i32(97,98,99), Vec3i32(99,98,100), Vec3i32(99,100,101), Vec3i32(101,100,102), Vec3i32(101,102,103), Vec3i32(103,102,104), Vec3i32(103,104,105), Vec3i32(105,104,106), Vec3i32(105,106,107), Vec3i32(107,106,108), Vec3i32(107,108,109), Vec3i32(109,108,110), Vec3i32(109,110,111), Vec3i32(111,110,112), Vec3i32(111,112,113), Vec3i32(113,112,114), Vec3i32(113,114,115), Vec3i32(115,114,116), Vec3i32(115,116,117), Vec3i32(117,116,118), Vec3i32(117,118,119), Vec3i32(119,118,120), Vec3i32(119,120,121), Vec3i32(121,120,122), Vec3i32(121,122,123), Vec3i32(123,122,124), Vec3i32(123,124,125), Vec3i32(125,124,126), Vec3i32(125,126,127), Vec3i32(127,126,128), Vec3i32(127,128,129), Vec3i32(129,128,130), Vec3i32(129,130,131), Vec3i32(131,130,132), Vec3i32(131,132,133), Vec3i32(133,132,134), Vec3i32(133,134,135), Vec3i32(135,134,136), Vec3i32(135,136,137), Vec3i32(137,136,138), Vec3i32(137,138,139), Vec3i32(139,138,140), Vec3i32(139,140,141), Vec3i32(141,140,142), Vec3i32(141,142,143), Vec3i32(143,142,144), Vec3i32(143,144,145), Vec3i32(145,144,146), Vec3i32(145,146,147), Vec3i32(147,146,148), Vec3i32(147,148,149), Vec3i32(149,148,150), Vec3i32(149,150,151), Vec3i32(151,150,152), Vec3i32(151,152,153), Vec3i32(153,152,154), Vec3i32(153,154,155), Vec3i32(155,154,156), Vec3i32(155,156,157), Vec3i32(157,156,79), Vec3i32(157,79,81), Vec3i32(57,110,108), Vec3i32(57,108,59), Vec3i32(59,108,106), Vec3i32(59,106,61), Vec3i32(61,106,104), Vec3i32(61,104,63), Vec3i32(63,104,102), Vec3i32(63,102,65), Vec3i32(65,102,100), Vec3i32(65,100,67), Vec3i32(67,100,98), Vec3i32(67,98,69), Vec3i32(69,98,96), Vec3i32(69,96,71), Vec3i32(71,96,94), Vec3i32(71,94,73), Vec3i32(73,94,92), Vec3i32(73,92,75), Vec3i32(75,92,90), Vec3i32(75,90,77), Vec3i32(77,90,88), Vec3i32(77,88,0), Vec3i32(0,88,86), Vec3i32(0,86,1), Vec3i32(1,86,84), Vec3i32(1,84,3), Vec3i32(3,84,82), Vec3i32(3,82,5), Vec3i32(5,82,80), Vec3i32(5,80,7), Vec3i32(7,80,79), Vec3i32(7,79,9), Vec3i32(9,79,156), Vec3i32(9,156,11), Vec3i32(11,156,154), Vec3i32(11,154,13), Vec3i32(13,154,152), Vec3i32(13,152,15), Vec3i32(15,152,150), Vec3i32(15,150,17), Vec3i32(17,150,148), Vec3i32(17,148,19), Vec3i32(19,148,146), Vec3i32(19,146,21), Vec3i32(21,146,144), Vec3i32(21,144,23), Vec3i32(23,144,142), Vec3i32(23,142,25), Vec3i32(25,142,140), Vec3i32(25,140,27), Vec3i32(27,140,138), Vec3i32(27,138,29), Vec3i32(29,138,136), Vec3i32(29,136,31), Vec3i32(33,31,134), Vec3i32(134,31,136), Vec3i32(33,134,132), Vec3i32(33,132,35), Vec3i32(35,132,130), Vec3i32(35,130,37), Vec3i32(37,130,128), Vec3i32(37,128,39), Vec3i32(39,128,126), Vec3i32(39,126,41), Vec3i32(41,126,124), Vec3i32(41,124,43), Vec3i32(43,124,122), Vec3i32(43,122,45), Vec3i32(45,122,120), Vec3i32(45,120,47), Vec3i32(47,120,118), Vec3i32(47,118,49), Vec3i32(49,118,116), Vec3i32(49,116,51), Vec3i32(51,116,114), Vec3i32(51,114,53), Vec3i32(55,53,112), Vec3i32(112,53,114), Vec3i32(57,55,110), Vec3i32(110,55,112), Vec3i32(30,135,137), Vec3i32(30,137,28), Vec3i32(28,137,139), Vec3i32(28,139,26), Vec3i32(26,139,141), Vec3i32(26,141,24), Vec3i32(24,141,143), Vec3i32(24,143,22), Vec3i32(22,143,145), Vec3i32(22,145,20), Vec3i32(20,145,147), Vec3i32(20,147,18), Vec3i32(18,147,149), Vec3i32(18,149,16), Vec3i32(16,149,151), Vec3i32(16,151,14), Vec3i32(14,151,153), Vec3i32(14,153,12), Vec3i32(12,153,155), Vec3i32(12,155,10), Vec3i32(10,155,157), Vec3i32(10,157,8), Vec3i32(8,157,81), Vec3i32(8,81,6), Vec3i32(6,81,83), Vec3i32(6,83,4), Vec3i32(4,83,85), Vec3i32(4,85,2), Vec3i32(2,85,87), Vec3i32(2,87,78), Vec3i32(78,87,89), Vec3i32(78,89,76), Vec3i32(76,89,91), Vec3i32(76,91,74), Vec3i32(74,91,93), Vec3i32(74,93,72), Vec3i32(72,93,95), Vec3i32(72,95,70), Vec3i32(70,95,97), Vec3i32(70,97,68), Vec3i32(68,97,99), Vec3i32(68,99,66), Vec3i32(66,99,101), Vec3i32(66,101,64), Vec3i32(64,101,103), Vec3i32(64,103,62), Vec3i32(62,103,105), Vec3i32(62,105,60), Vec3i32(60,105,107), Vec3i32(60,107,58), Vec3i32(58,107,109), Vec3i32(58,109,56), Vec3i32(30,32,135), Vec3i32(135,32,133), Vec3i32(52,113,115), Vec3i32(52,115,50), Vec3i32(50,115,117), Vec3i32(50,117,48), Vec3i32(48,117,119), Vec3i32(48,119,46), Vec3i32(46,119,121), Vec3i32(46,121,44), Vec3i32(44,121,123), Vec3i32(44,123,42), Vec3i32(42,123,125), Vec3i32(42,125,40), Vec3i32(40,125,127), Vec3i32(40,127,38), Vec3i32(38,127,129), Vec3i32(38,129,36), Vec3i32(36,129,131), Vec3i32(36,131,34), Vec3i32(34,131,133), Vec3i32(34,133,32), Vec3i32(52,54,113), Vec3i32(113,54,111), Vec3i32(54,56,111), Vec3i32(111,56,109) 
            };
            break;
        case TestMesh::sloping_hole:
            vertices = std::vector<Vec3f>{
                Vec3f(-20,-20,-5), Vec3f(-20,-20,5), Vec3f(-20,20,-5), Vec3f(-20,20,5), Vec3f(20,-20,-5), Vec3f(20,-20,5), Vec3f(4.46294021606445,7.43144989013672,-5), Vec3f(20,20,-5), Vec3f(-19.1420993804932,0,-5), Vec3f(-18.8330993652344,-2.07911992073059,-5), Vec3f(-17.9195003509521,-4.06736993789673,-5), Vec3f(-16.4412002563477,-5.87785005569458,-5), Vec3f(-14.4629001617432,-7.43144989013672,-5), Vec3f(-12.0711002349854,-8.66024971008301,-5), Vec3f(-9.37016010284424,-9.51056003570557,-5), Vec3f(-3.5217399597168,-9.94521999359131,-5), Vec3f(-6.4782600402832,-9.94521999359131,-5), Vec3f(-0.629840016365051,-9.51056003570557,-5), Vec3f(2.07106995582581,-8.66024971008301,-5), Vec3f(6.44122982025146,-5.87785005569458,-5), Vec3f(4.46294021606445,-7.43144989013672,-5), Vec3f(-12.0711002349854,8.66024971008301,-5), Vec3f(-9.37016010284424,9.51056003570557,-5), Vec3f(7.91947984695435,-4.06736993789673,-5), Vec3f(8.83310031890869,-2.07911992073059,-5), Vec3f(-6.4782600402832,9.94521999359131,-5), Vec3f(-0.629840016365051,9.51056003570557,-5), Vec3f(2.07106995582581,8.66024971008301,-5), Vec3f(9.14214038848877,0,-5), Vec3f(8.83310031890869,2.07911992073059,-5), Vec3f(-3.5217399597168,9.94521999359131,-5), Vec3f(7.91947984695435,4.06736993789673,-5), Vec3f(6.44122982025146,5.87785005569458,-5), Vec3f(-14.4629001617432,7.43144989013672,-5), Vec3f(-16.4412002563477,5.87785005569458,-5), Vec3f(-17.9195003509521,4.06736993789673,-5), Vec3f(-18.8330993652344,2.07911992073059,-5), Vec3f(20,20,5), Vec3f(3.5217399597168,-9.94521999359131,5), Vec3f(-8.83310031890869,-2.07911992073059,5), Vec3f(-9.14214038848877,0,5), Vec3f(-8.83310031890869,2.07911992073059,5), Vec3f(6.4782600402832,-9.94521999359131,5), Vec3f(-7.91947984695435,4.06736993789673,5), Vec3f(-6.44122982025146,5.87785005569458,5), Vec3f(-4.46294021606445,7.43144989013672,5), Vec3f(-2.07106995582581,8.66024971008301,5), Vec3f(0.629840016365051,9.51056003570557,5), Vec3f(12.0711002349854,-8.66024971008301,5), Vec3f(9.37016010284424,-9.51056003570557,5), Vec3f(3.5217399597168,9.94521999359131,5), Vec3f(6.4782600402832,9.94521999359131,5), Vec3f(9.37016010284424,9.51056003570557,5), Vec3f(12.0711002349854,8.66024971008301,5), Vec3f(14.4629001617432,7.43144989013672,5), Vec3f(16.4412002563477,-5.87785005569458,5), Vec3f(14.4629001617432,-7.43144989013672,5), Vec3f(16.4412002563477,5.87785005569458,5), Vec3f(17.9195003509521,4.06736993789673,5), Vec3f(18.8330993652344,-2.07911992073059,5), Vec3f(17.9195003509521,-4.06736993789673,5), Vec3f(18.8330993652344,2.07911992073059,5), Vec3f(19.1420993804932,0,5), Vec3f(0.629840016365051,-9.51056003570557,5), Vec3f(-2.07106995582581,-8.66024971008301,5), Vec3f(-4.46294021606445,-7.43144989013672,5), Vec3f(-6.44122982025146,-5.87785005569458,5), Vec3f(-7.91947984695435,-4.06736993789673,5) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(2,1,3), Vec3i32(1,0,4), Vec3i32(5,1,4), Vec3i32(6,2,7), Vec3i32(0,2,8), Vec3i32(0,8,9), Vec3i32(0,9,10), Vec3i32(0,10,11), Vec3i32(0,11,12), Vec3i32(0,12,13), Vec3i32(0,13,4), Vec3i32(13,14,4), Vec3i32(15,4,16), Vec3i32(17,4,15), Vec3i32(18,4,17), Vec3i32(19,4,20), Vec3i32(18,20,4), Vec3i32(21,2,22), Vec3i32(4,19,23), Vec3i32(4,23,7), Vec3i32(23,24,7), Vec3i32(22,2,25), Vec3i32(26,2,27), Vec3i32(28,29,7), Vec3i32(25,2,30), Vec3i32(29,31,7), Vec3i32(30,2,26), Vec3i32(31,32,7), Vec3i32(27,2,6), Vec3i32(32,6,7), Vec3i32(28,7,24), Vec3i32(33,2,21), Vec3i32(34,2,33), Vec3i32(35,2,34), Vec3i32(36,2,35), Vec3i32(8,2,36), Vec3i32(16,4,14), Vec3i32(2,3,7), Vec3i32(7,3,37), Vec3i32(38,1,5), Vec3i32(3,1,39), Vec3i32(3,39,40), Vec3i32(3,40,41), Vec3i32(42,38,5), Vec3i32(3,41,43), Vec3i32(3,43,44), Vec3i32(37,3,45), Vec3i32(37,45,46), Vec3i32(37,46,47), Vec3i32(48,49,5), Vec3i32(37,47,50), Vec3i32(49,42,5), Vec3i32(37,50,51), Vec3i32(37,51,52), Vec3i32(37,52,53), Vec3i32(37,53,54), Vec3i32(55,56,5), Vec3i32(37,54,57), Vec3i32(37,57,58), Vec3i32(59,60,5), Vec3i32(37,58,61), Vec3i32(37,62,5), Vec3i32(37,61,62), Vec3i32(62,59,5), Vec3i32(60,55,5), Vec3i32(63,1,38), Vec3i32(64,1,63), Vec3i32(65,1,64), Vec3i32(66,1,65), Vec3i32(67,1,66), Vec3i32(39,1,67), Vec3i32(44,45,3), Vec3i32(56,48,5), Vec3i32(5,4,7), Vec3i32(37,5,7), Vec3i32(41,40,36), Vec3i32(36,40,8), Vec3i32(39,9,40), Vec3i32(40,9,8), Vec3i32(43,41,35), Vec3i32(35,41,36), Vec3i32(44,43,34), Vec3i32(34,43,35), Vec3i32(33,45,44), Vec3i32(34,33,44), Vec3i32(21,46,45), Vec3i32(33,21,45), Vec3i32(22,47,46), Vec3i32(21,22,46), Vec3i32(25,50,47), Vec3i32(22,25,47), Vec3i32(30,51,50), Vec3i32(25,30,50), Vec3i32(26,52,51), Vec3i32(30,26,51), Vec3i32(27,53,52), Vec3i32(26,27,52), Vec3i32(6,54,53), Vec3i32(27,6,53), Vec3i32(32,57,54), Vec3i32(6,32,54), Vec3i32(31,58,57), Vec3i32(32,31,57), Vec3i32(29,61,58), Vec3i32(31,29,58), Vec3i32(28,62,61), Vec3i32(29,28,61), Vec3i32(59,62,28), Vec3i32(24,59,28), Vec3i32(60,59,24), Vec3i32(23,60,24), Vec3i32(55,60,23), Vec3i32(19,55,23), Vec3i32(55,19,56), Vec3i32(56,19,20), Vec3i32(56,20,48), Vec3i32(48,20,18), Vec3i32(48,18,49), Vec3i32(49,18,17), Vec3i32(49,17,42), Vec3i32(42,17,15), Vec3i32(42,15,38), Vec3i32(38,15,16), Vec3i32(38,16,63), Vec3i32(63,16,14), Vec3i32(63,14,64), Vec3i32(64,14,13), Vec3i32(64,13,65), Vec3i32(65,13,12), Vec3i32(65,12,66), Vec3i32(66,12,11), Vec3i32(66,11,67), Vec3i32(67,11,10), Vec3i32(67,10,39), Vec3i32(39,10,9) 
            };
            break;
        case TestMesh::ipadstand:
            vertices = std::vector<Vec3f>{
                Vec3f(17.4344673156738,-2.69879599481136e-16,9.5), Vec3f(14.2814798355103,10,9.5), Vec3f(0,0,9.5), Vec3f(31.7159481048584,10,9.5), Vec3f(62.2344741821289,2.06667568800577e-16,20), Vec3f(31.7159481048584,10,20), Vec3f(17.4344673156738,-2.69879599481136e-16,20), Vec3f(62.2344741821289,10,20), Vec3f(98.2079696655273,10,0), Vec3f(98.2079696655273,8.56525380796383e-16,10), Vec3f(98.2079696655273,0,0), Vec3f(98.2079696655273,10,20), Vec3f(98.2079696655273,0,20), Vec3f(81.6609649658203,-4.39753856997999e-16,10), Vec3f(90.0549850463867,10,10), Vec3f(78.5079803466797,10,10), Vec3f(93.2079696655273,8.56525380796383e-16,10), Vec3f(14.2814798355103,10,20), Vec3f(0,0,20), Vec3f(87.4344711303711,2.81343962782118e-15,20), Vec3f(84.2814788818359,10,20), Vec3f(0,10,20), Vec3f(0,0,0), Vec3f(0,10,0), Vec3f(62.2344741821289,2.06667568800577e-16,30), Vec3f(66.9609756469727,10,30), Vec3f(62.2344741821289,10,30), Vec3f(70.1139602661133,8.5525763717214e-16,30), Vec3f(67.7053375244141,10,28.7107200622559), Vec3f(71.6787109375,1.24046736339707e-15,27.2897701263428) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(1,0,3), Vec3i32(4,5,6), Vec3i32(5,4,7), Vec3i32(8,9,10), Vec3i32(9,11,12), Vec3i32(11,9,8), Vec3i32(13,14,15), Vec3i32(14,13,16), Vec3i32(17,2,1), Vec3i32(2,17,18), Vec3i32(19,11,20), Vec3i32(11,19,12), Vec3i32(17,21,18), Vec3i32(21,2,18), Vec3i32(2,21,22), Vec3i32(22,21,23), Vec3i32(8,22,23), Vec3i32(22,8,10), Vec3i32(24,25,26), Vec3i32(25,24,27), Vec3i32(23,1,8), Vec3i32(1,23,21), Vec3i32(1,21,17), Vec3i32(5,15,3), Vec3i32(15,5,7), Vec3i32(15,7,28), Vec3i32(28,7,26), Vec3i32(28,26,25), Vec3i32(8,14,11), Vec3i32(14,8,3), Vec3i32(3,8,1), Vec3i32(14,3,15), Vec3i32(11,14,20), Vec3i32(26,4,24), Vec3i32(4,26,7), Vec3i32(12,16,9), Vec3i32(16,12,19), Vec3i32(29,4,13), Vec3i32(4,29,24), Vec3i32(24,29,27), Vec3i32(9,22,10), Vec3i32(22,9,0), Vec3i32(0,9,16), Vec3i32(0,16,13), Vec3i32(0,13,6), Vec3i32(6,13,4), Vec3i32(2,22,0), Vec3i32(19,14,16), Vec3i32(14,19,20), Vec3i32(15,29,13), Vec3i32(29,25,27), Vec3i32(25,29,15), Vec3i32(25,15,28), Vec3i32(6,3,0), Vec3i32(3,6,5) 
            };
            break;
        case TestMesh::A:
            vertices = std::vector<Vec3f>{
                Vec3f(513.075988769531,51.6074333190918,36.0009002685547), Vec3f(516.648803710938,51.7324333190918,36.0009002685547), Vec3f(513.495178222656,51.7324333190918,36.0009002685547), Vec3f(489.391204833984,51.4824333190918,24.0011005401611), Vec3f(488.928588867188,51.7324333190918,24.0011005401611), Vec3f(492.06201171875,51.7324333190918,24.0011005401611), Vec3f(496.840393066406,51.2324333190918,24.0011005401611), Vec3f(495.195404052734,51.7324333190918,24.0011005401611), Vec3f(498.981994628906,51.7324333190918,24.0011005401611), Vec3f(506.966613769531,51.6074333190918,24.0011005401611), Vec3f(510.342010498047,51.7324333190918,24.0011005401611), Vec3f(507.163818359375,51.6074333190918,24.0011005401611), Vec3f(512.515380859375,54.7190322875977,36.0009002685547), Vec3f(514.161987304688,54.5058326721191,36.0009002685547), Vec3f(493.06201171875,54.7190322875977,36.0009002685547), Vec3f(495.195404052734,51.7324333190918,36.0009002685547), Vec3f(496.195404052734,54.7190322875977,36.0009002685547), Vec3f(497.195404052734,57.7058334350586,36.0009002685547), Vec3f(500.851989746094,60.2658309936523,36.0009002685547), Vec3f(498.915405273438,62.8258323669434,36.0009002685547), Vec3f(506.701995849609,62.8258323669434,36.0009002685547), Vec3f(503.648590087891,60.2658309936523,36.0009002685547), Vec3f(508.381805419922,57.7058334350586,36.0009002685547), Vec3f(496.418792724609,60.052433013916,36.0009002685547), Vec3f(506.515197753906,72.2124328613281,36.0009002685547), Vec3f(502.808807373047,74.5324325561523,36.0009002685547), Vec3f(503.781982421875,71.6058349609375,36.0009002685547), Vec3f(515.358764648438,55.4658317565918,36.0009002685547), Vec3f(499.375183105469,76.9058380126953,36.0009002685547), Vec3f(501.168792724609,78.0658340454102,36.0009002685547), Vec3f(504.568786621094,78.0658340454102,36.0009002685547), Vec3f(506.32861328125,81.599235534668,36.0009002685547), Vec3f(502.928588867188,81.599235534668,36.0009002685547), Vec3f(499.528594970703,81.599235534668,36.0009002685547), Vec3f(498.20361328125,77.8658294677734,36.0009002685547), Vec3f(495.195404052734,51.7324333190918,30.0011005401611), Vec3f(498.981994628906,51.7324333190918,27.0011005401611), Vec3f(506.555206298828,51.7324333190918,33.0009002685547), Vec3f(506.555206298828,51.7324333190918,36.0009002685547), Vec3f(510.342010498047,51.7324333190918,36.0009002685547), Vec3f(512.515380859375,54.7190322875977,24.0011005401611), Vec3f(509.361999511719,54.7190322875977,24.0011005401611), Vec3f(508.381805419922,57.7058334350586,24.0011005401611), Vec3f(506.701995849609,62.8258323669434,24.0011005401611), Vec3f(509.188812255859,60.052433013916,24.0011005401611), Vec3f(493.06201171875,54.7190322875977,24.0011005401611), Vec3f(503.648590087891,60.2658309936523,24.0011005401611), Vec3f(500.851989746094,60.2658309936523,24.0011005401611), Vec3f(498.915405273438,62.8258323669434,24.0011005401611), Vec3f(502.808807373047,62.8258323669434,24.0011005401611), Vec3f(491.425201416016,54.5058326721191,24.0011005401611), Vec3f(506.421813964844,76.9058380126953,24.0011005401611), Vec3f(502.808807373047,74.5324325561523,24.0011005401611), Vec3f(504.568786621094,78.0658340454102,24.0011005401611), Vec3f(506.32861328125,81.599235534668,24.0011005401611), Vec3f(507.618804931641,77.8658294677734,24.0011005401611), Vec3f(499.221801757812,72.2124328613281,24.0011005401611), Vec3f(501.835388183594,71.6058349609375,24.0011005401611), Vec3f(501.168792724609,78.0658340454102,24.0011005401611), Vec3f(499.528594970703,81.599235534668,24.0011005401611), Vec3f(502.048583984375,79.8324356079102,24.0011005401611), Vec3f(490.253601074219,55.4658317565918,24.0011005401611), Vec3f(488.928588867188,51.7324333190918,30.0011005401611), Vec3f(488.928588867188,51.7324333190918,36.0009002685547), Vec3f(490.253601074219,55.4658317565918,31.5009002685547), Vec3f(498.20361328125,77.8658294677734,34.5009002685547), Vec3f(508.381805419922,57.7058334350586,30.0011005401611), Vec3f(505.585388183594,57.7058334350586,27.0011005401611), Vec3f(502.788818359375,57.7058334350586,36.0009002685547), Vec3f(499.992004394531,57.7058334350586,33.0009002685547), Vec3f(509.851989746094,53.2258338928223,33.0009002685547), Vec3f(509.361999511719,54.7190322875977,36.0009002685547), Vec3f(508.871795654297,56.2124328613281,27.0011005401611), Vec3f(496.695404052734,56.2124328613281,33.0009002685547), Vec3f(495.695404052734,53.2258338928223,27.0011005401611), Vec3f(506.32861328125,81.599235534668,30.0011005401611), Vec3f(507.618804931641,77.8658294677734,25.5011005401611), Vec3f(515.358764648438,55.4658317565918,34.5009002685547), Vec3f(501.228607177734,81.599235534668,33.0009002685547), Vec3f(504.628601074219,81.599235534668,27.0011005401611), Vec3f(503.781982421875,71.6058349609375,33.0009002685547), Vec3f(502.808807373047,74.5324325561523,30.0011005401611), Vec3f(498.915405273438,62.8258323669434,30.0011005401611), Vec3f(500.861999511719,62.8258323669434,27.0011005401611), Vec3f(502.808807373047,62.8258323669434,36.0009002685547), Vec3f(504.755187988281,62.8258323669434,33.0009002685547), Vec3f(501.835388183594,71.6058349609375,33.0009002685547), Vec3f(499.888793945312,65.7524337768555,33.0009002685547), Vec3f(499.888793945312,65.7524337768555,36.0009002685547), Vec3f(513.128601074219,51.4824333190918,36.0009002685547), Vec3f(513.075988769531,51.6074333190918,24.0011005401611), Vec3f(516.648803710938,51.7324333190918,24.0011005401611), Vec3f(513.128601074219,51.4824333190918,24.0011005401611), Vec3f(513.495178222656,51.7324333190918,24.0011005401611), Vec3f(506.966613769531,51.6074333190918,36.0009002685547), Vec3f(507.163818359375,51.6074333190918,36.0009002685547), Vec3f(490.337799072266,51.4824333190918,24.0011005401611), Vec3f(489.391204833984,51.4824333190918,36.0009002685547), Vec3f(492.06201171875,51.7324333190918,36.0009002685547), Vec3f(490.337799072266,51.4824333190918,36.0009002685547), Vec3f(513.233764648438,51.2324333190918,24.0011005401611), Vec3f(513.233764648438,51.2324333190918,36.0009002685547), Vec3f(504.773803710938,51.4824333190918,36.0009002685547), Vec3f(504.773803710938,51.4824333190918,24.0011005401611), Vec3f(489.266998291016,51.2324333190918,24.0011005401611), Vec3f(489.266998291016,51.2324333190918,36.0009002685547), Vec3f(490.253601074219,55.4658317565918,25.5011005401611), Vec3f(499.528594970703,81.599235534668,30.0011005401611), Vec3f(498.20361328125,77.8658294677734,31.5009002685547), Vec3f(515.358764648438,55.4658317565918,28.5011005401611), Vec3f(515.358764648438,55.4658317565918,25.5011005401611), Vec3f(495.246795654297,61.0124320983887,36.0009002685547), Vec3f(490.253601074219,55.4658317565918,34.5009002685547), Vec3f(490.253601074219,55.4658317565918,36.0009002685547), Vec3f(494.228607177734,66.6658325195312,24.0011005401611), Vec3f(499.068786621094,67.5192337036133,24.0011005401611), Vec3f(498.20361328125,77.8658294677734,25.5011005401611), Vec3f(498.20361328125,77.8658294677734,24.0011005401611), Vec3f(506.608795166016,67.5192337036133,36.0009002685547), Vec3f(509.09521484375,64.7458343505859,36.0009002685547), Vec3f(507.618804931641,77.8658294677734,34.5009002685547), Vec3f(507.618804931641,77.8658294677734,36.0009002685547), Vec3f(510.385406494141,61.0124320983887,24.0011005401611), Vec3f(515.358764648438,55.4658317565918,24.0011005401611), Vec3f(489.32861328125,47.7324333190918,31.5009002685547), Vec3f(492.95361328125,47.7324333190918,33.5634994506836), Vec3f(489.32861328125,47.7324333190918,34.5009002685547), Vec3f(489.32861328125,47.7324333190918,28.5011005401611), Vec3f(489.32861328125,47.7324333190918,25.5011005401611), Vec3f(492.95361328125,47.7324333190918,26.4385013580322), Vec3f(492.95361328125,47.7324333190918,30.5635013580322), Vec3f(492.95361328125,47.7324333190918,32.0634994506836), Vec3f(492.95361328125,47.7324333190918,31.3135013580322), Vec3f(492.95361328125,47.7324333190918,35.4384994506836), Vec3f(489.32861328125,47.7324333190918,36.0009002685547), Vec3f(492.95361328125,47.7324333190918,34.3134994506836), Vec3f(492.95361328125,47.7324333190918,34.6884994506836), Vec3f(492.95361328125,47.7324333190918,27.9385013580322), Vec3f(492.95361328125,47.7324333190918,28.6885013580322), Vec3f(492.95361328125,47.7324333190918,29.0635013580322), Vec3f(489.32861328125,47.7324333190918,24.0011005401611), Vec3f(492.95361328125,47.7324333190918,24.5635013580322), Vec3f(492.95361328125,47.7324333190918,25.6885013580322), Vec3f(492.95361328125,47.7324333190918,25.3135013580322), Vec3f(492.95361328125,47.7324333190918,24.1885013580322), Vec3f(492.95361328125,47.7324333190918,24.0011005401611), Vec3f(513.443786621094,50.7324333190918,24.0011005401611), Vec3f(492.95361328125,47.7324333190918,35.8134994506836), Vec3f(492.95361328125,47.7324333190918,36.0009002685547), Vec3f(513.443786621094,50.7324333190918,36.0009002685547), Vec3f(506.350402832031,51.4824333190918,36.0009002685547), Vec3f(506.350402832031,51.4824333190918,24.0011005401611), Vec3f(492.743804931641,48.2324333190918,24.0011005401611), Vec3f(492.638793945312,48.4824333190918,24.0011005401611), Vec3f(492.743804931641,48.2324333190918,36.0009002685547), Vec3f(492.638793945312,48.4824333190918,36.0009002685547), Vec3f(490.089599609375,50.9824333190918,36.0009002685547), Vec3f(490.089599609375,50.9824333190918,24.0011005401611), Vec3f(510.342010498047,51.7324333190918,30.0011005401611), Vec3f(499.068786621094,67.5192337036133,36.0009002685547), Vec3f(494.228607177734,66.6658325195312,36.0009002685547), Vec3f(499.375183105469,76.9058380126953,24.0011005401611), Vec3f(506.421813964844,76.9058380126953,36.0009002685547), Vec3f(506.608795166016,67.5192337036133,24.0011005401611), Vec3f(505.728607177734,65.7524337768555,24.0011005401611), Vec3f(509.09521484375,64.7458343505859,24.0011005401611), Vec3f(506.701995849609,62.8258323669434,30.0011005401611), Vec3f(505.728607177734,65.7524337768555,27.0011005401611), Vec3f(501.835388183594,71.6058349609375,27.0011005401611), Vec3f(499.888793945312,65.7524337768555,27.0011005401611), Vec3f(494.228607177734,66.6658325195312,30.0011005401611), Vec3f(495.553588867188,70.3992309570312,28.5011005401611), Vec3f(492.903594970703,62.9324340820312,28.5011005401611), Vec3f(495.553588867188,70.3992309570312,31.5009002685547), Vec3f(492.903594970703,62.9324340820312,31.5009002685547), Vec3f(511.488800048828,66.6658325195312,24.0011005401611), Vec3f(511.488800048828,66.6658325195312,30.0011005401611), Vec3f(512.778564453125,62.9324340820312,28.5011005401611), Vec3f(515.358764648438,55.4658317565918,31.5009002685547), Vec3f(507.618804931641,77.8658294677734,31.5009002685547), Vec3f(510.198791503906,70.3992309570312,28.5011005401611), Vec3f(511.488800048828,66.6658325195312,36.0009002685547), Vec3f(512.778564453125,62.9324340820312,31.5009002685547), Vec3f(510.198791503906,70.3992309570312,31.5009002685547), Vec3f(502.788818359375,57.7058334350586,24.0011005401611), Vec3f(497.195404052734,57.7058334350586,30.0011005401611), Vec3f(492.903594970703,62.9324340820312,34.5009002685547), Vec3f(492.903594970703,62.9324340820312,36.0009002685547), Vec3f(495.553588867188,70.3992309570312,24.0011005401611), Vec3f(496.725189208984,69.4392318725586,24.0011005401611), Vec3f(495.553588867188,70.3992309570312,25.5011005401611), Vec3f(495.246795654297,61.0124320983887,24.0011005401611), Vec3f(492.903594970703,62.9324340820312,25.5011005401611), Vec3f(492.903594970703,62.9324340820312,24.0011005401611), Vec3f(495.553588867188,70.3992309570312,36.0009002685547), Vec3f(496.725189208984,69.4392318725586,36.0009002685547), Vec3f(495.553588867188,70.3992309570312,34.5009002685547), Vec3f(510.198791503906,70.3992309570312,36.0009002685547), Vec3f(509.002014160156,69.4392318725586,36.0009002685547), Vec3f(510.198791503906,70.3992309570312,34.5009002685547), Vec3f(512.778564453125,62.9324340820312,25.5011005401611), Vec3f(512.778564453125,62.9324340820312,24.0011005401611), Vec3f(510.198791503906,70.3992309570312,24.0011005401611), Vec3f(509.002014160156,69.4392318725586,24.0011005401611), Vec3f(510.198791503906,70.3992309570312,25.5011005401611), Vec3f(510.385406494141,61.0124320983887,36.0009002685547), Vec3f(512.778564453125,62.9324340820312,34.5009002685547), Vec3f(512.778564453125,62.9324340820312,36.0009002685547), Vec3f(496.840393066406,51.2324333190918,36.0009002685547), Vec3f(498.981994628906,51.7324333190918,36.0009002685547), Vec3f(498.981994628906,51.7324333190918,33.0009002685547), Vec3f(506.555206298828,51.7324333190918,24.0011005401611), Vec3f(506.555206298828,51.7324333190918,27.0011005401611), Vec3f(503.82861328125,47.7324333190918,30.7509002685547), Vec3f(507.45361328125,47.7324333190918,32.8134994506836), Vec3f(503.82861328125,47.7324333190918,33.7509002685547), Vec3f(503.82861328125,47.7324333190918,29.2511005401611), Vec3f(503.82861328125,47.7324333190918,26.2511005401611), Vec3f(507.45361328125,47.7324333190918,27.1885013580322), Vec3f(493.921813964844,57.2792320251465,36.0009002685547), Vec3f(491.425201416016,54.5058326721191,36.0009002685547), Vec3f(497.195404052734,57.7058334350586,24.0011005401611), Vec3f(496.418792724609,60.052433013916,24.0011005401611), Vec3f(509.188812255859,60.052433013916,36.0009002685547), Vec3f(511.675415039062,57.2792320251465,24.0011005401611), Vec3f(514.161987304688,54.5058326721191,24.0011005401611), Vec3f(507.45361328125,47.7324333190918,34.3134994506836), Vec3f(503.82861328125,47.7324333190918,35.2509002685547), Vec3f(507.45361328125,47.7324333190918,25.6885013580322), Vec3f(503.82861328125,47.7324333190918,24.7511005401611), Vec3f(500.20361328125,47.7324333190918,31.6885013580322), Vec3f(500.20361328125,47.7324333190918,28.3135013580322), Vec3f(500.20361328125,47.7324333190918,30.1885013580322), Vec3f(507.45361328125,47.7324333190918,29.8135013580322), Vec3f(507.45361328125,47.7324333190918,31.3135013580322), Vec3f(507.45361328125,47.7324333190918,30.5635013580322), Vec3f(503.82861328125,47.7324333190918,36.0009002685547), Vec3f(507.45361328125,47.7324333190918,35.4384994506836), Vec3f(507.45361328125,47.7324333190918,35.0634994506836), Vec3f(507.45361328125,47.7324333190918,28.6885013580322), Vec3f(507.45361328125,47.7324333190918,29.4385013580322), Vec3f(503.82861328125,47.7324333190918,24.0011005401611), Vec3f(507.45361328125,47.7324333190918,24.5635013580322), Vec3f(507.45361328125,47.7324333190918,24.9385013580322), Vec3f(500.20361328125,47.7324333190918,34.6884994506836), Vec3f(500.20361328125,47.7324333190918,33.1884994506836), Vec3f(500.20361328125,47.7324333190918,33.9384994506836), Vec3f(500.20361328125,47.7324333190918,25.3135013580322), Vec3f(500.20361328125,47.7324333190918,26.8135013580322), Vec3f(500.20361328125,47.7324333190918,26.0635013580322), Vec3f(500.20361328125,47.7324333190918,30.9385013580322), Vec3f(500.20361328125,47.7324333190918,35.0634994506836), Vec3f(500.20361328125,47.7324333190918,35.4384994506836), Vec3f(500.20361328125,47.7324333190918,29.0635013580322), Vec3f(500.20361328125,47.7324333190918,29.4385013580322), Vec3f(500.20361328125,47.7324333190918,24.9385013580322), Vec3f(500.20361328125,47.7324333190918,24.5635013580322), Vec3f(507.45361328125,47.7324333190918,24.1885013580322), Vec3f(507.45361328125,47.7324333190918,24.0011005401611), Vec3f(513.86376953125,49.7324333190918,24.0011005401611), Vec3f(507.45361328125,47.7324333190918,35.8134994506836), Vec3f(507.45361328125,47.7324333190918,36.0009002685547), Vec3f(513.86376953125,49.7324333190918,36.0009002685547), Vec3f(500.20361328125,47.7324333190918,24.1885013580322), Vec3f(500.20361328125,47.7324333190918,24.0011005401611), Vec3f(502.988800048828,49.7324333190918,24.0011005401611), Vec3f(500.20361328125,47.7324333190918,35.8134994506836), Vec3f(500.20361328125,47.7324333190918,36.0009002685547), Vec3f(502.988800048828,49.7324333190918,36.0009002685547), Vec3f(504.755187988281,62.8258323669434,27.0011005401611), Vec3f(499.205383300781,51.2324333190918,36.0009002685547), Vec3f(498.786193847656,51.1074333190918,36.0009002685547), Vec3f(502.358795166016,51.2324333190918,36.0009002685547), Vec3f(499.205383300781,51.2324333190918,24.0011005401611), Vec3f(502.358795166016,51.2324333190918,24.0011005401611), Vec3f(498.786193847656,51.1074333190918,24.0011005401611), Vec3f(502.568786621094,50.7324333190918,24.0011005401611), Vec3f(505.931213378906,51.3574333190918,24.0011005401611), Vec3f(509.503601074219,51.4824333190918,24.0011005401611), Vec3f(502.568786621094,50.7324333190918,36.0009002685547), Vec3f(505.931213378906,51.3574333190918,36.0009002685547), Vec3f(509.503601074219,51.4824333190918,36.0009002685547), Vec3f(499.048583984375,50.4824333190918,36.0009002685547), Vec3f(492.428588867188,48.9824333190918,36.0009002685547), Vec3f(499.048583984375,50.4824333190918,24.0011005401611), Vec3f(492.428588867188,48.9824333190918,24.0011005401611), Vec3f(506.088806152344,50.9824333190918,24.0011005401611), Vec3f(506.036010742188,51.1074333190918,24.0011005401611), Vec3f(506.088806152344,50.9824333190918,36.0009002685547), Vec3f(506.036010742188,51.1074333190918,36.0009002685547), Vec3f(498.891204833984,50.8574333190918,36.0009002685547), Vec3f(498.943786621094,50.7324333190918,36.0009002685547), Vec3f(498.891204833984,50.8574333190918,24.0011005401611), Vec3f(498.943786621094,50.7324333190918,24.0011005401611), Vec3f(499.573608398438,49.2324333190918,24.0011005401611), Vec3f(499.783813476562,48.7324333190918,24.0011005401611), Vec3f(499.573608398438,49.2324333190918,36.0009002685547), Vec3f(499.783813476562,48.7324333190918,36.0009002685547), Vec3f(506.403594970703,50.2324333190918,24.0011005401611), Vec3f(506.298797607422,50.4824333190918,24.0011005401611), Vec3f(506.403594970703,50.2324333190918,36.0009002685547), Vec3f(506.298797607422,50.4824333190918,36.0009002685547), Vec3f(501.228607177734,81.599235534668,27.0011005401611), Vec3f(502.928588867188,81.599235534668,24.0011005401611), Vec3f(499.2587890625,49.9824333190918,36.0009002685547), Vec3f(499.363800048828,49.7324333190918,36.0009002685547), Vec3f(499.2587890625,49.9824333190918,24.0011005401611), Vec3f(499.363800048828,49.7324333190918,24.0011005401611), Vec3f(496.695404052734,56.2124328613281,27.0011005401611), Vec3f(496.195404052734,54.7190322875977,24.0011005401611), Vec3f(509.851989746094,53.2258338928223,27.0011005401611), Vec3f(493.464782714844,51.1074333190918,36.0009002685547), Vec3f(493.464782714844,51.1074333190918,24.0011005401611), Vec3f(502.768798828125,51.7324333190918,24.0011005401611), Vec3f(500.215789794922,51.3574333190918,24.0011005401611), Vec3f(497.628601074219,51.2324333190918,24.0011005401611), Vec3f(502.768798828125,51.7324333190918,36.0009002685547), Vec3f(500.215789794922,51.3574333190918,36.0009002685547), Vec3f(497.628601074219,51.2324333190918,36.0009002685547), Vec3f(507.033813476562,48.7324333190918,24.0011005401611), Vec3f(506.823791503906,49.2324333190918,24.0011005401611), Vec3f(507.033813476562,48.7324333190918,36.0009002685547), Vec3f(506.823791503906,49.2324333190918,36.0009002685547), Vec3f(494.4501953125,51.1074333190918,24.0011005401611), Vec3f(494.4501953125,51.1074333190918,36.0009002685547), Vec3f(500.807006835938,51.3574333190918,36.0009002685547), Vec3f(503.591186523438,51.4824333190918,36.0009002685547), Vec3f(503.591186523438,51.4824333190918,24.0011005401611), Vec3f(500.807006835938,51.3574333190918,24.0011005401611), Vec3f(505.728607177734,65.7524337768555,36.0009002685547), Vec3f(505.728607177734,65.7524337768555,33.0009002685547), Vec3f(499.221801757812,72.2124328613281,36.0009002685547), Vec3f(501.835388183594,71.6058349609375,36.0009002685547), Vec3f(506.515197753906,72.2124328613281,24.0011005401611), Vec3f(503.781982421875,71.6058349609375,24.0011005401611), Vec3f(503.781982421875,71.6058349609375,27.0011005401611), Vec3f(499.888793945312,65.7524337768555,24.0011005401611), Vec3f(495.695404052734,53.2258338928223,33.0009002685547), Vec3f(516.648803710938,51.7324333190918,30.0011005401611), Vec3f(498.20361328125,77.8658294677734,28.5011005401611), Vec3f(505.585388183594,57.7058334350586,33.0009002685547), Vec3f(508.871795654297,56.2124328613281,33.0009002685547), Vec3f(499.992004394531,57.7058334350586,27.0011005401611), Vec3f(504.628601074219,81.599235534668,33.0009002685547), Vec3f(500.861999511719,62.8258323669434,33.0009002685547), Vec3f(496.878601074219,74.1324310302734,27.0011005401611), Vec3f(496.878601074219,74.1324310302734,33.0009002685547), Vec3f(491.57861328125,59.199031829834,27.0011005401611), Vec3f(490.253601074219,55.4658317565918,28.5011005401611), Vec3f(491.57861328125,59.199031829834,33.0009002685547), Vec3f(514.068786621094,59.199031829834,27.0011005401611), Vec3f(514.068786621094,59.199031829834,33.0009002685547), Vec3f(508.908813476562,74.1324310302734,27.0011005401611), Vec3f(507.618804931641,77.8658294677734,28.5011005401611), Vec3f(508.908813476562,74.1324310302734,33.0009002685547), Vec3f(491.271789550781,50.9824333190918,36.0009002685547), Vec3f(490.877807617188,50.9824333190918,36.0009002685547), Vec3f(491.271789550781,50.9824333190918,24.0011005401611), Vec3f(490.877807617188,50.9824333190918,24.0011005401611), Vec3f(495.213806152344,50.9824333190918,36.0009002685547), Vec3f(493.636993408203,50.9824333190918,36.0009002685547), Vec3f(495.213806152344,50.9824333190918,24.0011005401611), Vec3f(493.636993408203,50.9824333190918,24.0011005401611), Vec3f(503.985412597656,51.4824333190918,36.0009002685547), Vec3f(503.985412597656,51.4824333190918,24.0011005401611), Vec3f(511.675415039062,57.2792320251465,36.0009002685547), Vec3f(493.921813964844,57.2792320251465,24.0011005401611), Vec3f(502.768798828125,51.7324333190918,30.0011005401611), Vec3f(506.555206298828,51.7324333190918,30.0011005401611), Vec3f(498.981994628906,51.7324333190918,30.0011005401611), Vec3f(492.848815917969,50.9824333190918,24.0011005401611), Vec3f(492.848815917969,50.9824333190918,36.0009002685547), Vec3f(500.861999511719,68.6792297363281,36.0009002685547), Vec3f(500.861999511719,68.6792297363281,24.0011005401611), Vec3f(496.878601074219,74.1324310302734,24.0011005401611), Vec3f(496.878601074219,74.1324310302734,36.0009002685547), Vec3f(504.755187988281,68.6792297363281,24.0011005401611), Vec3f(504.755187988281,68.6792297363281,36.0009002685547), Vec3f(508.908813476562,74.1324310302734,36.0009002685547), Vec3f(508.908813476562,74.1324310302734,24.0011005401611), Vec3f(505.728607177734,65.7524337768555,30.0011005401611), Vec3f(504.755187988281,68.6792297363281,30.0011005401611), Vec3f(503.781982421875,71.6058349609375,30.0011005401611), Vec3f(500.861999511719,68.6792297363281,30.0011005401611), Vec3f(499.888793945312,65.7524337768555,30.0011005401611), Vec3f(501.835388183594,71.6058349609375,30.0011005401611), Vec3f(491.57861328125,59.199031829834,24.0011005401611), Vec3f(491.57861328125,59.199031829834,36.0009002685547), Vec3f(514.068786621094,59.199031829834,36.0009002685547), Vec3f(514.068786621094,59.199031829834,24.0011005401611), Vec3f(511.07861328125,47.7324333190918,34.8759002685547), Vec3f(511.07861328125,47.7324333190918,31.8759002685547), Vec3f(514.70361328125,47.7324333190918,33.9384994506836), Vec3f(511.07861328125,47.7324333190918,25.1261005401611), Vec3f(514.70361328125,47.7324333190918,26.0635013580322), Vec3f(511.07861328125,47.7324333190918,28.1261005401611), Vec3f(502.788818359375,57.7058334350586,30.0011005401611), Vec3f(502.048583984375,79.8324356079102,36.0009002685547), Vec3f(514.70361328125,47.7324333190918,30.9385013580322), Vec3f(511.07861328125,47.7324333190918,30.3759002685547), Vec3f(514.70361328125,47.7324333190918,29.0635013580322), Vec3f(511.07861328125,47.7324333190918,29.6261005401611), Vec3f(496.57861328125,47.7324333190918,31.1259002685547), Vec3f(496.57861328125,47.7324333190918,32.6259002685547), Vec3f(496.57861328125,47.7324333190918,34.1259002685547), Vec3f(496.57861328125,47.7324333190918,28.8761005401611), Vec3f(496.57861328125,47.7324333190918,27.3761005401611), Vec3f(496.57861328125,47.7324333190918,25.8761005401611), Vec3f(496.57861328125,47.7324333190918,29.6261005401611), Vec3f(514.70361328125,47.7324333190918,35.4384994506836), Vec3f(511.07861328125,47.7324333190918,35.6259002685547), Vec3f(514.70361328125,47.7324333190918,24.5635013580322), Vec3f(511.07861328125,47.7324333190918,24.3761005401611), Vec3f(496.57861328125,47.7324333190918,34.8759002685547), Vec3f(496.57861328125,47.7324333190918,25.1261005401611), Vec3f(496.57861328125,47.7324333190918,35.6259002685547), Vec3f(496.57861328125,47.7324333190918,24.3761005401611), Vec3f(511.07861328125,47.7324333190918,36.0009002685547), Vec3f(511.07861328125,47.7324333190918,24.0011005401611), Vec3f(514.70361328125,47.7324333190918,30.1885013580322), Vec3f(514.70361328125,47.7324333190918,35.8134994506836), Vec3f(514.70361328125,47.7324333190918,29.8135013580322), Vec3f(514.70361328125,47.7324333190918,24.1885013580322), Vec3f(496.57861328125,47.7324333190918,36.0009002685547), Vec3f(496.57861328125,47.7324333190918,24.0011005401611), Vec3f(510.238800048828,49.7324333190918,24.0011005401611), Vec3f(510.238800048828,49.7324333190918,36.0009002685547), Vec3f(514.70361328125,47.7324333190918,24.0011005401611), Vec3f(514.70361328125,47.7324333190918,36.0009002685547), Vec3f(496.158813476562,48.7324333190918,36.0009002685547), Vec3f(496.158813476562,48.7324333190918,24.0011005401611), Vec3f(502.808807373047,62.8258323669434,30.0011005401611), Vec3f(509.608795166016,51.2324333190918,24.0011005401611), Vec3f(509.608795166016,51.2324333190918,36.0009002685547), Vec3f(491.641204833984,50.8574333190918,24.0011005401611), Vec3f(495.423797607422,50.4824333190918,36.0009002685547), Vec3f(495.423797607422,50.4824333190918,24.0011005401611), Vec3f(491.641204833984,50.8574333190918,36.0009002685547), Vec3f(495.528594970703,50.2324333190918,24.0011005401611), Vec3f(492.0087890625,49.9824333190918,24.0011005401611), Vec3f(509.818786621094,50.7324333190918,24.0011005401611), Vec3f(495.948608398438,49.2324333190918,36.0009002685547), Vec3f(495.528594970703,50.2324333190918,36.0009002685547), Vec3f(495.948608398438,49.2324333190918,24.0011005401611), Vec3f(509.818786621094,50.7324333190918,36.0009002685547), Vec3f(492.0087890625,49.9824333190918,36.0009002685547), Vec3f(491.956207275391,50.1074333190918,24.0011005401611), Vec3f(491.956207275391,50.1074333190918,36.0009002685547), Vec3f(502.928588867188,81.599235534668,30.0011005401611), Vec3f(491.851013183594,50.3574333190918,36.0009002685547), Vec3f(491.851013183594,50.3574333190918,24.0011005401611), Vec3f(496.195404052734,54.7190322875977,30.0011005401611), Vec3f(509.361999511719,54.7190322875977,30.0011005401611), Vec3f(488.632598876953,51.7256317138672,30.0011005401611), Vec3f(488.632598876953,51.7256317138672,29.5091018676758), Vec3f(488.632598876953,51.7188339233398,24.0011005401611), Vec3f(488.632598876953,51.7256317138672,27.4929008483887), Vec3f(488.632598876953,51.7324333190918,30.0011005401611), Vec3f(488.632598876953,51.7324333190918,29.0175018310547), Vec3f(488.632598876953,51.7324333190918,24.9847011566162), Vec3f(488.632598876953,51.7324333190918,24.0011005401611), Vec3f(488.632598876953,51.7188339233398,30.0011005401611), Vec3f(488.632598876953,51.7176322937012,24.0011005401611), Vec3f(488.632598876953,51.7182312011719,30.0011005401611), Vec3f(488.632598876953,51.7176322937012,30.0011005401611), Vec3f(488.632598876953,51.715030670166,24.0011005401611), Vec3f(488.632598876953,51.7162322998047,30.0011005401611), Vec3f(488.632598876953,50.761833190918,24.0011005401611), Vec3f(488.632598876953,50.7578315734863,24.0011005401611), Vec3f(488.632598876953,50.7598342895508,30.0011005401611), Vec3f(488.632598876953,50.7522315979004,24.0011005401611), Vec3f(488.632598876953,49.7838325500488,24.0011005401611), Vec3f(488.632598876953,50.2680320739746,30.0011005401611), Vec3f(488.632598876953,51.7046318054199,24.0011005401611), Vec3f(488.632598876953,51.709831237793,30.0011005401611), Vec3f(488.632598876953,50.9120330810547,24.0011005401611), Vec3f(488.632598876953,50.8882331848145,24.0011005401611), Vec3f(488.632598876953,50.9002304077148,30.0011005401611), Vec3f(488.632598876953,47.7324333190918,24.0370998382568), Vec3f(488.632598876953,48.5612335205078,30.0011005401611), Vec3f(488.632598876953,47.7324333190918,24.0011005401611), Vec3f(488.632598876953,47.7324333190918,24.1091003417969), Vec3f(488.632598876953,48.5612335205078,30.0189018249512), Vec3f(488.632598876953,47.7324333190918,25.3211002349854), Vec3f(488.632598876953,48.5612335205078,30.0551013946533), Vec3f(488.632598876953,47.7324333190918,25.4651012420654), Vec3f(488.632598876953,48.5612335205078,30.6609001159668), Vec3f(488.632598876953,47.7324333190918,25.5371017456055), Vec3f(488.632598876953,48.5612335205078,30.7329006195068), Vec3f(488.632598876953,47.7324333190918,25.6091003417969), Vec3f(488.632598876953,48.5612335205078,30.7689018249512), Vec3f(488.632598876953,47.7324333190918,25.8971004486084), Vec3f(488.632598876953,48.5612335205078,30.8051013946533), Vec3f(488.632598876953,47.7324333190918,28.321102142334), Vec3f(488.632598876953,48.5612335205078,30.9491004943848), Vec3f(488.632598876953,47.7324333190918,28.4651012420654), Vec3f(488.632598876953,48.5612335205078,32.1609001159668), Vec3f(488.632598876953,47.7324333190918,28.5371017456055), Vec3f(488.632598876953,48.5612335205078,32.2329025268555), Vec3f(488.632598876953,47.7324333190918,28.6811008453369), Vec3f(488.632598876953,48.5612335205078,32.2689018249512), Vec3f(488.632598876953,47.7324333190918,31.1049003601074), Vec3f(488.632598876953,48.5612335205078,32.3411026000977), Vec3f(488.632598876953,47.7324333190918,31.3929004669189), Vec3f(488.632598876953,49.3900299072266,36.0009002685547), Vec3f(488.632598876953,47.7324333190918,31.536901473999), Vec3f(488.632598876953,47.7324333190918,31.6809005737305), Vec3f(488.632598876953,47.7324333190918,34.1049003601074), Vec3f(488.632598876953,47.7324333190918,34.3929023742676), Vec3f(488.632598876953,47.7324333190918,34.464900970459), Vec3f(488.632598876953,47.7324333190918,34.5369033813477), Vec3f(488.632598876953,47.7324333190918,34.6809005737305), Vec3f(488.632598876953,47.7324333190918,35.8929023742676), Vec3f(488.632598876953,47.7324333190918,35.964900970459), Vec3f(488.632598876953,47.7324333190918,36.0009002685547), Vec3f(488.632598876953,50.8816299438477,24.0011005401611), Vec3f(488.632598876953,50.8850326538086,30.0011005401611), Vec3f(488.632598876953,49.7480316162109,24.0011005401611), Vec3f(488.632598876953,49.7426300048828,24.0011005401611), Vec3f(488.632598876953,49.745231628418,30.0011005401611), Vec3f(488.632598876953,49.7592315673828,24.0011005401611), Vec3f(488.632598876953,49.7536315917969,30.0011005401611), Vec3f(488.632598876953,49.3900299072266,24.0011005401611), Vec3f(488.632598876953,49.5664329528809,30.0011005401611), Vec3f(488.632598876953,50.8786315917969,24.0011005401611), Vec3f(488.632598876953,50.7764320373535,24.0011005401611), Vec3f(488.632598876953,50.8274307250977,30.0011005401611), Vec3f(488.632598876953,50.7550315856934,30.0011005401611), Vec3f(488.632598876953,50.7692337036133,30.0011005401611), Vec3f(488.632598876953,50.9284324645996,24.0011005401611), Vec3f(488.632598876953,50.9202308654785,30.0011005401611), Vec3f(488.632598876953,51.1788330078125,24.0011005401611), Vec3f(488.632598876953,51.139232635498,24.0011005401611), Vec3f(488.632598876953,51.1590309143066,30.0011005401611), Vec3f(488.632598876953,51.2324333190918,24.0011005401611), Vec3f(488.632598876953,51.2056312561035,30.0011005401611), Vec3f(488.632598876953,51.4340324401855,24.0011005401611), Vec3f(488.632598876953,51.3946304321289,24.0011005401611), Vec3f(488.632598876953,51.4142303466797,30.0011005401611), Vec3f(488.632598876953,51.4498329162598,24.0011005401611), Vec3f(488.632598876953,51.5772323608398,30.0011005401611), Vec3f(488.632598876953,51.4418334960938,30.0011005401611), Vec3f(488.632598876953,51.3136329650879,30.0011005401611), Vec3f(488.632598876953,49.7714309692383,30.0011005401611), Vec3f(488.632598876953,51.0338325500488,30.0011005401611), Vec3f(488.632598876953,50.8816299438477,30.0011005401611), Vec3f(488.632598876953,50.8800315856934,30.0011005401611), Vec3f(488.632598876953,51.7188339233398,36.0009002685547), Vec3f(488.632598876953,51.7176322937012,36.0009002685547), Vec3f(488.632598876953,49.3900299072266,30.0011005401611), Vec3f(488.632598876953,50.7522315979004,30.0011005401611), Vec3f(488.632598876953,50.7522315979004,36.0009002685547), Vec3f(488.632598876953,49.7426300048828,30.0011005401611), Vec3f(488.632598876953,49.7426300048828,36.0009002685547), Vec3f(488.632598876953,49.7480316162109,30.0011005401611), Vec3f(488.632598876953,49.7480316162109,36.0009002685547), Vec3f(488.632598876953,51.715030670166,30.0011005401611), Vec3f(488.632598876953,51.715030670166,36.0009002685547), Vec3f(488.632598876953,50.7578315734863,30.0011005401611), Vec3f(488.632598876953,50.7578315734863,36.0009002685547), Vec3f(488.632598876953,50.761833190918,30.0011005401611), Vec3f(488.632598876953,50.761833190918,36.0009002685547), Vec3f(488.632598876953,50.8882331848145,30.0011005401611), Vec3f(488.632598876953,50.8882331848145,36.0009002685547), Vec3f(488.632598876953,49.7592315673828,30.0011005401611), Vec3f(488.632598876953,49.7592315673828,36.0009002685547), Vec3f(488.632598876953,51.1788330078125,30.0011005401611), Vec3f(488.632598876953,51.1788330078125,36.0009002685547), Vec3f(488.632598876953,50.9120330810547,30.0011005401611), Vec3f(488.632598876953,50.9120330810547,36.0009002685547), Vec3f(488.632598876953,51.4498329162598,30.0011005401611), Vec3f(488.632598876953,51.4498329162598,36.0009002685547), Vec3f(488.632598876953,51.7046318054199,30.0011005401611), Vec3f(488.632598876953,51.7046318054199,36.0009002685547), Vec3f(488.632598876953,51.2324333190918,30.0011005401611), Vec3f(488.632598876953,51.2324333190918,36.0009002685547), Vec3f(488.632598876953,51.3946304321289,30.0011005401611), Vec3f(488.632598876953,51.3946304321289,36.0009002685547), Vec3f(488.632598876953,51.4340324401855,30.0011005401611), Vec3f(488.632598876953,51.4340324401855,36.0009002685547), Vec3f(488.632598876953,49.7838325500488,30.0011005401611), Vec3f(488.632598876953,49.7838325500488,36.0009002685547), Vec3f(488.632598876953,50.7764320373535,30.0011005401611), Vec3f(488.632598876953,50.7764320373535,36.0009002685547), Vec3f(488.632598876953,51.139232635498,30.0011005401611), Vec3f(488.632598876953,51.139232635498,36.0009002685547), Vec3f(488.632598876953,50.9284324645996,30.0011005401611), Vec3f(488.632598876953,50.9284324645996,36.0009002685547), Vec3f(488.632598876953,50.8816299438477,36.0009002685547), Vec3f(488.632598876953,50.8786315917969,30.0011005401611), Vec3f(488.632598876953,50.8786315917969,36.0009002685547), Vec3f(488.632598876953,51.7324333190918,35.0173034667969), Vec3f(488.632598876953,51.7324333190918,36.0009002685547), Vec3f(488.632598876953,51.7324333190918,30.9847011566162), Vec3f(517.188415527344,51.7140884399414,24.0011005401611), Vec3f(517.188415527344,51.7140884399414,36.0009002685547), Vec3f(517.188415527344,50.4475173950195,24.0011005401611), Vec3f(517.188415527344,51.7324333190918,35.3734130859375), Vec3f(517.188415527344,51.7324333190918,36.0009002685547), Vec3f(517.188415527344,51.7324333190918,34.1185760498047), Vec3f(517.188415527344,51.7324333190918,31.88330078125), Vec3f(517.188415527344,51.7324333190918,30.0011005401611), Vec3f(517.188415527344,51.7324333190918,28.1187744140625), Vec3f(517.188415527344,51.7324333190918,25.8834266662598), Vec3f(517.188415527344,51.7324333190918,24.6285915374756), Vec3f(517.188415527344,51.7324333190918,24.0011005401611), Vec3f(517.188415527344,47.7324333190918,24.0600452423096), Vec3f(517.188415527344,47.7324333190918,24.0011005401611), Vec3f(517.188415527344,50.4475173950195,36.0009002685547), Vec3f(517.188415527344,47.7324333190918,24.1779975891113), Vec3f(517.188415527344,47.7324333190918,24.6498031616211), Vec3f(517.188415527344,47.7324333190918,28.7625770568848), Vec3f(517.188415527344,47.7324333190918,29.7061901092529), Vec3f(517.188415527344,47.7324333190918,29.9420928955078), Vec3f(517.188415527344,47.7324333190918,30.0600452423096), Vec3f(517.188415527344,47.7324333190918,30.2959480285645), Vec3f(517.188415527344,47.7324333190918,31.2395629882812), Vec3f(517.188415527344,47.7324333190918,35.3521995544434), Vec3f(517.188415527344,47.7324333190918,35.8240051269531), Vec3f(517.188415527344,47.7324333190918,35.9419555664062), Vec3f(517.188415527344,47.7324333190918,36.0009002685547) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(3,4,5), Vec3i32(6,7,8), Vec3i32(9,10,11), Vec3i32(12,2,1), Vec3i32(12,1,13), Vec3i32(14,15,16), Vec3i32(17,18,19), Vec3i32(20,21,22), Vec3i32(17,19,23), Vec3i32(24,25,26), Vec3i32(27,13,1), Vec3i32(28,25,29), Vec3i32(30,31,32), Vec3i32(28,33,34), Vec3i32(35,36,7), Vec3i32(37,38,39), Vec3i32(40,10,41), Vec3i32(42,43,44), Vec3i32(45,5,4), Vec3i32(46,47,48), Vec3i32(46,48,49), Vec3i32(45,4,50), Vec3i32(51,52,53), Vec3i32(51,54,55), Vec3i32(56,52,57), Vec3i32(58,59,60), Vec3i32(61,50,4), Vec3i32(62,63,64), Vec3i32(65,34,33), Vec3i32(66,67,42), Vec3i32(68,17,69), Vec3i32(70,71,22), Vec3i32(66,42,72), Vec3i32(73,16,15), Vec3i32(35,7,74), Vec3i32(75,76,54), Vec3i32(77,27,1), Vec3i32(78,32,31), Vec3i32(75,54,79), Vec3i32(80,26,25), Vec3i32(81,80,25), Vec3i32(82,83,48), Vec3i32(84,20,85), Vec3i32(81,25,86), Vec3i32(87,88,19), Vec3i32(0,89,1), Vec3i32(90,91,92), Vec3i32(90,10,93), Vec3i32(38,94,39), Vec3i32(94,95,39), Vec3i32(3,7,96), Vec3i32(97,15,98), Vec3i32(97,99,15), Vec3i32(92,91,100), Vec3i32(89,101,1), Vec3i32(102,39,95), Vec3i32(103,11,10), Vec3i32(104,96,7), Vec3i32(105,15,99), Vec3i32(106,61,4), Vec3i32(107,108,33), Vec3i32(76,55,54), Vec3i32(109,91,110), Vec3i32(111,23,19), Vec3i32(112,63,113), Vec3i32(114,115,48), Vec3i32(116,59,117), Vec3i32(118,20,119), Vec3i32(120,31,121), Vec3i32(122,44,43), Vec3i32(110,91,123), Vec3i32(124,125,126), Vec3i32(127,128,129), Vec3i32(127,130,124), Vec3i32(131,124,132), Vec3i32(126,133,134), Vec3i32(135,136,126), Vec3i32(137,138,127), Vec3i32(139,127,138), Vec3i32(128,140,141), Vec3i32(142,128,143), Vec3i32(144,140,145), Vec3i32(100,91,146), Vec3i32(147,148,134), Vec3i32(101,149,1), Vec3i32(102,150,39), Vec3i32(103,10,151), Vec3i32(145,140,152), Vec3i32(152,140,153), Vec3i32(148,154,134), Vec3i32(154,155,134), Vec3i32(156,15,105), Vec3i32(157,104,7), Vec3i32(36,8,7), Vec3i32(158,37,39), Vec3i32(159,19,88), Vec3i32(160,19,159), Vec3i32(161,59,58), Vec3i32(161,117,59), Vec3i32(162,31,30), Vec3i32(162,121,31), Vec3i32(163,43,164), Vec3i32(163,165,43), Vec3i32(166,167,43), Vec3i32(167,164,43), Vec3i32(168,57,52), Vec3i32(82,48,169), Vec3i32(114,170,171), Vec3i32(108,65,33), Vec3i32(64,63,112), Vec3i32(114,172,170), Vec3i32(160,173,170), Vec3i32(171,170,173), Vec3i32(172,174,170), Vec3i32(160,170,174), Vec3i32(175,176,177), Vec3i32(178,77,1), Vec3i32(179,31,120), Vec3i32(175,180,176), Vec3i32(181,182,176), Vec3i32(177,176,182), Vec3i32(180,183,176), Vec3i32(181,176,183), Vec3i32(184,42,67), Vec3i32(185,69,17), Vec3i32(160,111,19), Vec3i32(186,187,160), Vec3i32(188,189,114), Vec3i32(190,188,114), Vec3i32(114,48,191), Vec3i32(192,114,193), Vec3i32(194,160,195), Vec3i32(196,160,194), Vec3i32(197,198,181), Vec3i32(199,197,181), Vec3i32(122,43,165), Vec3i32(200,201,175), Vec3i32(202,175,203), Vec3i32(204,175,202), Vec3i32(205,119,20), Vec3i32(206,181,207), Vec3i32(208,209,15), Vec3i32(210,15,209), Vec3i32(211,10,9), Vec3i32(212,10,211), Vec3i32(213,214,215), Vec3i32(216,217,218), Vec3i32(219,14,17), Vec3i32(113,63,220), Vec3i32(221,222,48), Vec3i32(191,48,222), Vec3i32(22,223,20), Vec3i32(205,20,223), Vec3i32(224,40,42), Vec3i32(123,91,225), Vec3i32(214,226,215), Vec3i32(227,215,226), Vec3i32(218,217,228), Vec3i32(229,228,217), Vec3i32(215,230,213), Vec3i32(125,135,126), Vec3i32(217,216,231), Vec3i32(129,128,142), Vec3i32(216,213,232), Vec3i32(130,132,124), Vec3i32(213,216,233), Vec3i32(234,213,235), Vec3i32(236,227,237), Vec3i32(238,237,227), Vec3i32(239,240,216), Vec3i32(233,216,240), Vec3i32(241,242,229), Vec3i32(243,229,242), Vec3i32(215,227,244), Vec3i32(245,215,246), Vec3i32(217,247,229), Vec3i32(248,249,217), Vec3i32(232,213,250), Vec3i32(230,250,213), Vec3i32(133,147,134), Vec3i32(244,227,251), Vec3i32(236,252,227), Vec3i32(251,227,252), Vec3i32(231,216,253), Vec3i32(254,253,216), Vec3i32(141,140,144), Vec3i32(247,255,229), Vec3i32(241,229,256), Vec3i32(255,256,229), Vec3i32(257,241,258), Vec3i32(259,146,91), Vec3i32(260,261,236), Vec3i32(262,1,149), Vec3i32(263,264,241), Vec3i32(265,241,264), Vec3i32(266,236,267), Vec3i32(268,267,236), Vec3i32(49,48,83), Vec3i32(166,43,269), Vec3i32(270,271,272), Vec3i32(273,274,275), Vec3i32(276,274,277), Vec3i32(278,151,10), Vec3i32(279,280,272), Vec3i32(281,39,150), Vec3i32(272,282,279), Vec3i32(155,283,134), Vec3i32(274,276,284), Vec3i32(153,140,285), Vec3i32(286,276,287), Vec3i32(265,276,286), Vec3i32(288,289,279), Vec3i32(268,288,279), Vec3i32(290,291,272), Vec3i32(271,290,272), Vec3i32(292,274,293), Vec3i32(275,274,292), Vec3i32(294,265,295), Vec3i32(276,265,294), Vec3i32(296,297,268), Vec3i32(279,296,268), Vec3i32(241,265,298), Vec3i32(298,265,299), Vec3i32(236,300,268), Vec3i32(300,301,268), Vec3i32(107,33,78), Vec3i32(302,303,59), Vec3i32(304,305,279), Vec3i32(282,304,279), Vec3i32(306,276,307), Vec3i32(284,276,306), Vec3i32(185,17,73), Vec3i32(308,309,221), Vec3i32(158,39,70), Vec3i32(310,41,10), Vec3i32(15,311,208), Vec3i32(7,6,312), Vec3i32(313,314,6), Vec3i32(315,6,314), Vec3i32(316,208,317), Vec3i32(318,317,208), Vec3i32(258,241,319), Vec3i32(319,241,320), Vec3i32(261,321,236), Vec3i32(321,322,236), Vec3i32(6,315,323), Vec3i32(208,324,318), Vec3i32(270,325,318), Vec3i32(326,318,325), Vec3i32(327,328,315), Vec3i32(273,315,328), Vec3i32(118,329,20), Vec3i32(330,20,329), Vec3i32(331,332,25), Vec3i32(86,25,332), Vec3i32(333,334,52), Vec3i32(335,52,334), Vec3i32(115,336,48), Vec3i32(169,48,336), Vec3i32(62,106,4), Vec3i32(35,15,210), Vec3i32(35,337,15), Vec3i32(158,10,212), Vec3i32(158,310,10), Vec3i32(338,178,1), Vec3i32(339,59,116), Vec3i32(107,302,59), Vec3i32(66,22,340), Vec3i32(66,341,22), Vec3i32(185,221,342), Vec3i32(185,308,221), Vec3i32(75,31,179), Vec3i32(75,343,31), Vec3i32(166,20,330), Vec3i32(166,85,20), Vec3i32(81,52,335), Vec3i32(81,168,52), Vec3i32(82,19,344), Vec3i32(82,87,19), Vec3i32(108,339,345), Vec3i32(346,108,345), Vec3i32(64,347,348), Vec3i32(349,347,64), Vec3i32(178,109,350), Vec3i32(351,178,350), Vec3i32(179,352,353), Vec3i32(354,352,179), Vec3i32(355,208,356), Vec3i32(356,208,311), Vec3i32(357,358,6), Vec3i32(358,312,6), Vec3i32(68,22,21), Vec3i32(68,340,22), Vec3i32(221,48,47), Vec3i32(184,342,221), Vec3i32(359,270,360), Vec3i32(318,360,270), Vec3i32(361,362,273), Vec3i32(315,273,362), Vec3i32(272,102,270), Vec3i32(363,270,102), Vec3i32(274,273,103), Vec3i32(364,103,273), Vec3i32(21,19,18), Vec3i32(21,20,84), Vec3i32(184,46,42), Vec3i32(43,42,46), Vec3i32(12,22,71), Vec3i32(365,22,12), Vec3i32(14,98,15), Vec3i32(14,220,63), Vec3i32(40,93,10), Vec3i32(40,225,91), Vec3i32(45,221,309), Vec3i32(366,221,45), Vec3i32(313,367,212), Vec3i32(212,367,368), Vec3i32(36,369,367), Vec3i32(313,36,367), Vec3i32(316,37,367), Vec3i32(37,368,367), Vec3i32(210,367,369), Vec3i32(316,367,210), Vec3i32(362,370,315), Vec3i32(370,323,315), Vec3i32(360,318,371), Vec3i32(371,318,324), Vec3i32(372,331,159), Vec3i32(159,195,160), Vec3i32(373,115,56), Vec3i32(115,114,189), Vec3i32(52,56,161), Vec3i32(374,161,56), Vec3i32(25,28,331), Vec3i32(375,331,28), Vec3i32(376,333,163), Vec3i32(163,203,175), Vec3i32(377,118,24), Vec3i32(118,181,198), Vec3i32(25,24,162), Vec3i32(378,162,24), Vec3i32(52,51,333), Vec3i32(379,333,51), Vec3i32(167,380,381), Vec3i32(376,167,381), Vec3i32(377,381,330), Vec3i32(330,381,380), Vec3i32(335,381,382), Vec3i32(376,381,335), Vec3i32(373,383,169), Vec3i32(169,383,384), Vec3i32(168,385,383), Vec3i32(373,168,383), Vec3i32(372,87,383), Vec3i32(87,384,383), Vec3i32(377,80,381), Vec3i32(80,382,381), Vec3i32(86,383,385), Vec3i32(372,383,86), Vec3i32(106,348,347), Vec3i32(386,106,347), Vec3i32(375,65,346), Vec3i32(108,346,65), Vec3i32(64,112,349), Vec3i32(387,349,112), Vec3i32(171,190,114), Vec3i32(346,345,171), Vec3i32(374,190,345), Vec3i32(171,345,190), Vec3i32(349,172,347), Vec3i32(172,114,192), Vec3i32(386,347,192), Vec3i32(172,192,347), Vec3i32(173,160,196), Vec3i32(171,173,346), Vec3i32(375,346,196), Vec3i32(173,196,346), Vec3i32(172,349,174), Vec3i32(174,186,160), Vec3i32(387,186,349), Vec3i32(174,349,186), Vec3i32(64,348,62), Vec3i32(106,62,348), Vec3i32(108,107,339), Vec3i32(59,339,107), Vec3i32(374,345,116), Vec3i32(339,116,345), Vec3i32(76,353,352), Vec3i32(379,76,352), Vec3i32(388,77,351), Vec3i32(178,351,77), Vec3i32(179,120,354), Vec3i32(378,354,120), Vec3i32(177,200,175), Vec3i32(351,350,177), Vec3i32(389,200,350), Vec3i32(177,350,200), Vec3i32(354,180,352), Vec3i32(180,175,204), Vec3i32(379,352,204), Vec3i32(180,204,352), Vec3i32(182,181,206), Vec3i32(177,182,351), Vec3i32(388,351,206), Vec3i32(182,206,351), Vec3i32(180,354,183), Vec3i32(183,199,181), Vec3i32(378,199,354), Vec3i32(183,354,199), Vec3i32(91,109,338), Vec3i32(178,338,109), Vec3i32(76,75,353), Vec3i32(179,353,75), Vec3i32(389,350,110), Vec3i32(109,110,350), Vec3i32(390,391,392), Vec3i32(393,394,395), Vec3i32(224,122,389), Vec3i32(122,175,201), Vec3i32(365,388,205), Vec3i32(205,207,181), Vec3i32(66,340,396), Vec3i32(68,396,340), Vec3i32(184,396,342), Vec3i32(185,342,396), Vec3i32(66,396,67), Vec3i32(184,67,396), Vec3i32(68,69,396), Vec3i32(185,396,69), Vec3i32(219,111,387), Vec3i32(111,160,187), Vec3i32(366,386,191), Vec3i32(191,193,114), Vec3i32(150,272,280), Vec3i32(102,272,150), Vec3i32(151,277,274), Vec3i32(103,151,274), Vec3i32(161,374,117), Vec3i32(116,117,374), Vec3i32(366,61,386), Vec3i32(106,386,61), Vec3i32(111,187,387), Vec3i32(186,387,187), Vec3i32(56,188,374), Vec3i32(190,374,188), Vec3i32(191,386,193), Vec3i32(192,193,386), Vec3i32(331,375,194), Vec3i32(196,194,375), Vec3i32(28,34,375), Vec3i32(65,375,34), Vec3i32(219,387,113), Vec3i32(112,113,387), Vec3i32(224,389,123), Vec3i32(110,123,389), Vec3i32(51,55,379), Vec3i32(76,379,55), Vec3i32(24,197,378), Vec3i32(199,378,197), Vec3i32(122,201,389), Vec3i32(200,389,201), Vec3i32(333,379,202), Vec3i32(204,202,379), Vec3i32(205,388,207), Vec3i32(206,207,388), Vec3i32(365,27,388), Vec3i32(77,388,27), Vec3i32(162,378,121), Vec3i32(120,121,378), Vec3i32(162,30,25), Vec3i32(30,29,25), Vec3i32(51,53,54), Vec3i32(303,60,59), Vec3i32(28,29,33), Vec3i32(29,397,33), Vec3i32(161,58,52), Vec3i32(53,52,58), Vec3i32(21,84,19), Vec3i32(84,344,19), Vec3i32(46,49,43), Vec3i32(49,269,43), Vec3i32(208,316,209), Vec3i32(210,209,316), Vec3i32(327,313,211), Vec3i32(212,211,313), Vec3i32(36,35,369), Vec3i32(210,369,35), Vec3i32(37,158,368), Vec3i32(212,368,158), Vec3i32(6,8,313), Vec3i32(36,313,8), Vec3i32(326,38,316), Vec3i32(37,316,38), Vec3i32(392,391,398), Vec3i32(399,398,391), Vec3i32(394,400,395), Vec3i32(401,395,400), Vec3i32(390,214,391), Vec3i32(214,213,234), Vec3i32(393,395,218), Vec3i32(218,239,216), Vec3i32(402,230,403), Vec3i32(230,215,245), Vec3i32(125,124,131), Vec3i32(404,125,403), Vec3i32(405,406,231), Vec3i32(231,248,217), Vec3i32(129,137,127), Vec3i32(407,406,129), Vec3i32(130,127,139), Vec3i32(402,130,408), Vec3i32(194,195,331), Vec3i32(159,331,195), Vec3i32(115,189,56), Vec3i32(188,56,189), Vec3i32(14,219,220), Vec3i32(113,220,219), Vec3i32(45,50,366), Vec3i32(61,366,50), Vec3i32(221,366,222), Vec3i32(191,222,366), Vec3i32(17,23,219), Vec3i32(111,219,23), Vec3i32(118,198,24), Vec3i32(197,24,198), Vec3i32(202,203,333), Vec3i32(163,333,203), Vec3i32(40,224,225), Vec3i32(123,225,224), Vec3i32(12,13,365), Vec3i32(27,365,13), Vec3i32(22,365,223), Vec3i32(205,223,365), Vec3i32(42,44,224), Vec3i32(122,224,44), Vec3i32(399,391,234), Vec3i32(214,234,391), Vec3i32(401,239,395), Vec3i32(218,395,239), Vec3i32(214,390,226), Vec3i32(226,238,227), Vec3i32(218,228,393), Vec3i32(228,229,243), Vec3i32(401,399,233), Vec3i32(233,235,213), Vec3i32(392,409,390), Vec3i32(410,390,409), Vec3i32(394,393,411), Vec3i32(412,411,393), Vec3i32(402,403,131), Vec3i32(125,131,403), Vec3i32(405,137,406), Vec3i32(129,406,137), Vec3i32(405,408,139), Vec3i32(130,139,408), Vec3i32(230,245,403), Vec3i32(404,403,245), Vec3i32(231,406,248), Vec3i32(407,248,406), Vec3i32(232,254,216), Vec3i32(402,408,232), Vec3i32(413,404,244), Vec3i32(244,246,215), Vec3i32(414,247,407), Vec3i32(247,217,249), Vec3i32(133,126,136), Vec3i32(415,133,413), Vec3i32(141,143,128), Vec3i32(416,414,141), Vec3i32(410,238,390), Vec3i32(226,390,238), Vec3i32(412,393,243), Vec3i32(228,243,393), Vec3i32(233,399,235), Vec3i32(234,235,399), Vec3i32(237,260,236), Vec3i32(238,410,237), Vec3i32(417,260,410), Vec3i32(237,410,260), Vec3i32(239,401,240), Vec3i32(233,240,401), Vec3i32(242,241,257), Vec3i32(243,242,412), Vec3i32(418,412,257), Vec3i32(242,257,412), Vec3i32(401,419,399), Vec3i32(398,399,419), Vec3i32(417,410,420), Vec3i32(409,420,410), Vec3i32(400,421,401), Vec3i32(419,401,421), Vec3i32(418,422,412), Vec3i32(411,412,422), Vec3i32(413,135,404), Vec3i32(125,404,135), Vec3i32(414,407,142), Vec3i32(129,142,407), Vec3i32(130,402,132), Vec3i32(131,132,402), Vec3i32(133,136,413), Vec3i32(135,413,136), Vec3i32(423,147,415), Vec3i32(133,415,147), Vec3i32(137,405,138), Vec3i32(139,138,405), Vec3i32(141,414,143), Vec3i32(142,143,414), Vec3i32(424,416,144), Vec3i32(141,144,416), Vec3i32(405,254,408), Vec3i32(232,408,254), Vec3i32(244,404,246), Vec3i32(245,246,404), Vec3i32(247,249,407), Vec3i32(248,407,249), Vec3i32(232,250,402), Vec3i32(230,402,250), Vec3i32(415,413,251), Vec3i32(244,251,413), Vec3i32(252,236,266), Vec3i32(251,252,415), Vec3i32(423,415,266), Vec3i32(252,266,415), Vec3i32(231,253,405), Vec3i32(254,405,253), Vec3i32(416,255,414), Vec3i32(247,414,255), Vec3i32(256,263,241), Vec3i32(255,416,256), Vec3i32(424,263,416), Vec3i32(256,416,263), Vec3i32(257,258,418), Vec3i32(425,418,258), Vec3i32(260,417,261), Vec3i32(426,261,417), Vec3i32(422,418,427), Vec3i32(427,259,91), Vec3i32(420,428,417), Vec3i32(428,1,262), Vec3i32(147,423,148), Vec3i32(429,148,423), Vec3i32(263,424,264), Vec3i32(264,295,265), Vec3i32(266,267,423), Vec3i32(267,268,297), Vec3i32(144,145,424), Vec3i32(430,424,145), Vec3i32(49,431,269), Vec3i32(166,269,431), Vec3i32(82,431,83), Vec3i32(49,83,431), Vec3i32(84,85,431), Vec3i32(166,431,85), Vec3i32(82,344,431), Vec3i32(84,431,344), Vec3i32(432,278,90), Vec3i32(10,90,278), Vec3i32(433,0,281), Vec3i32(39,281,0), Vec3i32(362,361,434), Vec3i32(435,271,359), Vec3i32(270,359,271), Vec3i32(436,361,275), Vec3i32(273,275,361), Vec3i32(360,437,359), Vec3i32(277,287,276), Vec3i32(151,278,277), Vec3i32(280,279,289), Vec3i32(150,280,281), Vec3i32(436,438,439), Vec3i32(439,285,140), Vec3i32(90,92,432), Vec3i32(440,432,92), Vec3i32(282,272,291), Vec3i32(441,282,442), Vec3i32(284,293,274), Vec3i32(443,438,284), Vec3i32(278,432,286), Vec3i32(286,299,265), Vec3i32(281,288,433), Vec3i32(288,268,301), Vec3i32(0,433,89), Vec3i32(444,89,433), Vec3i32(435,445,442), Vec3i32(445,134,283), Vec3i32(439,446,436), Vec3i32(361,436,446), Vec3i32(442,290,435), Vec3i32(271,435,290), Vec3i32(438,436,292), Vec3i32(275,292,436), Vec3i32(445,435,447), Vec3i32(359,447,435), Vec3i32(286,287,278), Vec3i32(277,278,287), Vec3i32(288,281,289), Vec3i32(280,289,281), Vec3i32(145,152,430), Vec3i32(443,430,152), Vec3i32(148,429,154), Vec3i32(441,154,429), Vec3i32(424,430,294), Vec3i32(294,307,276), Vec3i32(423,296,429), Vec3i32(296,279,305), Vec3i32(425,440,100), Vec3i32(92,100,440), Vec3i32(290,442,291), Vec3i32(282,291,442), Vec3i32(292,293,438), Vec3i32(284,438,293), Vec3i32(298,320,241), Vec3i32(432,440,298), Vec3i32(300,236,322), Vec3i32(433,300,444), Vec3i32(426,101,444), Vec3i32(89,444,101), Vec3i32(107,448,302), Vec3i32(302,79,54), Vec3i32(78,31,343), Vec3i32(107,78,448), Vec3i32(75,79,448), Vec3i32(302,448,79), Vec3i32(78,343,448), Vec3i32(75,448,343), Vec3i32(427,418,259), Vec3i32(425,259,418), Vec3i32(428,262,417), Vec3i32(426,417,262), Vec3i32(437,449,359), Vec3i32(447,359,449), Vec3i32(434,361,450), Vec3i32(446,450,361), Vec3i32(32,33,397), Vec3i32(78,33,32), Vec3i32(53,303,54), Vec3i32(302,54,303), Vec3i32(152,153,443), Vec3i32(438,443,153), Vec3i32(429,304,441), Vec3i32(282,441,304), Vec3i32(430,443,306), Vec3i32(284,306,443), Vec3i32(154,441,155), Vec3i32(442,155,441), Vec3i32(298,299,432), Vec3i32(286,432,299), Vec3i32(300,433,301), Vec3i32(288,301,433), Vec3i32(185,451,308), Vec3i32(308,74,7), Vec3i32(73,15,337), Vec3i32(185,73,451), Vec3i32(35,74,451), Vec3i32(308,451,74), Vec3i32(73,337,451), Vec3i32(35,451,337), Vec3i32(158,452,310), Vec3i32(310,72,42), Vec3i32(70,22,341), Vec3i32(158,70,452), Vec3i32(66,72,452), Vec3i32(310,452,72), Vec3i32(70,341,452), Vec3i32(66,452,341), Vec3i32(313,327,314), Vec3i32(315,314,327), Vec3i32(316,317,326), Vec3i32(318,326,317), Vec3i32(15,156,311), Vec3i32(356,311,156), Vec3i32(7,312,157), Vec3i32(358,157,312), Vec3i32(211,9,327), Vec3i32(364,327,9), Vec3i32(38,326,94), Vec3i32(363,94,326), Vec3i32(294,295,424), Vec3i32(264,424,295), Vec3i32(296,423,297), Vec3i32(267,297,423), Vec3i32(262,149,426), Vec3i32(101,426,149), Vec3i32(258,319,425), Vec3i32(440,425,319), Vec3i32(261,426,321), Vec3i32(444,321,426), Vec3i32(259,425,146), Vec3i32(100,146,425), Vec3i32(306,307,430), Vec3i32(294,430,307), Vec3i32(304,429,305), Vec3i32(296,305,429), Vec3i32(319,320,440), Vec3i32(298,440,320), Vec3i32(321,444,322), Vec3i32(300,322,444), Vec3i32(445,283,442), Vec3i32(155,442,283), Vec3i32(439,438,285), Vec3i32(153,285,438), Vec3i32(17,68,18), Vec3i32(21,18,68), Vec3i32(46,184,47), Vec3i32(221,47,184), Vec3i32(102,95,363), Vec3i32(94,363,95), Vec3i32(9,11,364), Vec3i32(103,364,11), Vec3i32(6,323,357), Vec3i32(370,357,323), Vec3i32(371,324,355), Vec3i32(208,355,324), Vec3i32(270,363,325), Vec3i32(326,325,363), Vec3i32(327,364,328), Vec3i32(273,328,364), Vec3i32(0,2,39), Vec3i32(12,39,2), Vec3i32(90,93,91), Vec3i32(40,91,93), Vec3i32(14,16,17), Vec3i32(73,17,16), Vec3i32(45,309,7), Vec3i32(308,7,309), Vec3i32(12,71,39), Vec3i32(70,39,71), Vec3i32(40,41,42), Vec3i32(310,42,41), Vec3i32(97,98,63), Vec3i32(14,63,98), Vec3i32(3,5,7), Vec3i32(45,7,5), Vec3i32(118,377,329), Vec3i32(330,329,377), Vec3i32(331,372,332), Vec3i32(86,332,372), Vec3i32(333,376,334), Vec3i32(335,334,376), Vec3i32(115,373,336), Vec3i32(169,336,373), Vec3i32(167,166,380), Vec3i32(330,380,166), Vec3i32(80,81,382), Vec3i32(335,382,81), Vec3i32(86,385,81), Vec3i32(168,81,385), Vec3i32(169,384,82), Vec3i32(87,82,384), Vec3i32(159,88,372), Vec3i32(87,372,88), Vec3i32(163,164,376), Vec3i32(167,376,164), Vec3i32(24,26,377), Vec3i32(80,377,26), Vec3i32(56,57,373), Vec3i32(168,373,57), Vec3i32(32,397,30), Vec3i32(29,30,397), Vec3i32(58,60,53), Vec3i32(303,53,60), Vec3i32(205,181,119), Vec3i32(118,119,181), Vec3i32(163,175,165), Vec3i32(122,165,175), Vec3i32(453,454,455), Vec3i32(454,456,455), Vec3i32(457,455,456), Vec3i32(458,455,457), Vec3i32(459,455,458), Vec3i32(460,455,459), Vec3i32(461,462,463), Vec3i32(464,465,466), Vec3i32(467,468,469), Vec3i32(470,471,472), Vec3i32(465,473,474), Vec3i32(475,476,477), Vec3i32(478,479,480), Vec3i32(481,482,478), Vec3i32(483,484,481), Vec3i32(485,486,483), Vec3i32(487,488,485), Vec3i32(489,490,487), Vec3i32(491,492,489), Vec3i32(493,494,491), Vec3i32(495,496,493), Vec3i32(497,498,495), Vec3i32(499,500,497), Vec3i32(501,502,499), Vec3i32(503,504,501), Vec3i32(505,504,503), Vec3i32(506,504,505), Vec3i32(507,504,506), Vec3i32(508,504,507), Vec3i32(509,504,508), Vec3i32(510,504,509), Vec3i32(511,504,510), Vec3i32(512,504,511), Vec3i32(513,504,512), Vec3i32(514,504,513), Vec3i32(476,515,516), Vec3i32(517,518,519), Vec3i32(520,517,521), Vec3i32(518,522,523), Vec3i32(522,480,479), Vec3i32(524,525,526), Vec3i32(468,470,527), Vec3i32(525,467,528), Vec3i32(529,475,530), Vec3i32(531,532,533), Vec3i32(534,531,535), Vec3i32(536,537,538), Vec3i32(473,539,540), Vec3i32(539,536,541), Vec3i32(537,534,542), Vec3i32(471,520,543), Vec3i32(532,529,544), Vec3i32(545,524,546), Vec3i32(453,461,547), Vec3i32(463,464,548), Vec3i32(523,549,504), Vec3i32(527,550,551), Vec3i32(519,552,553), Vec3i32(521,554,555), Vec3i32(466,556,557), Vec3i32(469,558,559), Vec3i32(528,560,561), Vec3i32(477,562,563), Vec3i32(543,564,565), Vec3i32(535,566,567), Vec3i32(530,568,569), Vec3i32(540,570,571), Vec3i32(474,572,573), Vec3i32(542,574,575), Vec3i32(538,576,577), Vec3i32(541,578,579), Vec3i32(472,580,581), Vec3i32(526,582,583), Vec3i32(533,584,585), Vec3i32(544,586,587), Vec3i32(516,545,588), Vec3i32(588,589,590), Vec3i32(455,460,4), Vec3i32(591,592,63), Vec3i32(462,455,4), Vec3i32(592,547,63), Vec3i32(547,548,63), Vec3i32(465,462,4), Vec3i32(548,557,63), Vec3i32(127,124,501), Vec3i32(127,501,499), Vec3i32(505,503,124), Vec3i32(124,126,507), Vec3i32(124,507,506), Vec3i32(509,508,126), Vec3i32(126,134,512), Vec3i32(126,512,511), Vec3i32(510,509,126), Vec3i32(128,127,493), Vec3i32(128,493,491), Vec3i32(497,495,127), Vec3i32(489,487,128), Vec3i32(140,128,483), Vec3i32(140,483,481), Vec3i32(487,485,128), Vec3i32(478,480,140), Vec3i32(480,522,140), Vec3i32(514,513,134), Vec3i32(504,514,134), Vec3i32(551,581,437), Vec3i32(471,470,434), Vec3i32(445,447,555), Vec3i32(445,555,553), Vec3i32(134,445,553), Vec3i32(134,553,504), Vec3i32(446,439,518), Vec3i32(446,518,517), Vec3i32(439,140,522), Vec3i32(439,522,518), Vec3i32(515,476,358), Vec3i32(563,588,356), Vec3i32(557,573,63), Vec3i32(473,465,4), Vec3i32(437,360,559), Vec3i32(437,559,551), Vec3i32(360,371,561), Vec3i32(360,561,559), Vec3i32(362,434,470), Vec3i32(362,470,468), Vec3i32(370,362,468), Vec3i32(370,468,467), Vec3i32(499,497,127), Vec3i32(506,505,124), Vec3i32(495,493,127), Vec3i32(513,512,134), Vec3i32(481,478,140), Vec3i32(447,449,565), Vec3i32(447,565,555), Vec3i32(450,446,517), Vec3i32(450,517,520), Vec3i32(356,156,569), Vec3i32(356,569,563), Vec3i32(157,358,476), Vec3i32(157,476,475), Vec3i32(357,370,467), Vec3i32(357,467,525), Vec3i32(371,355,583), Vec3i32(371,583,561), Vec3i32(460,459,4), Vec3i32(63,62,593), Vec3i32(63,593,591), Vec3i32(62,4,459), Vec3i32(62,459,458), Vec3i32(532,531,104), Vec3i32(531,534,104), Vec3i32(567,585,105), Vec3i32(575,567,105), Vec3i32(4,3,539), Vec3i32(4,539,473), Vec3i32(536,539,3), Vec3i32(97,63,573), Vec3i32(97,573,571), Vec3i32(571,579,97), Vec3i32(99,97,579), Vec3i32(99,579,577), Vec3i32(105,99,577), Vec3i32(105,577,575), Vec3i32(96,104,534), Vec3i32(96,534,537), Vec3i32(3,96,537), Vec3i32(3,537,536), Vec3i32(503,501,124), Vec3i32(508,507,126), Vec3i32(491,489,128), Vec3i32(511,510,126), Vec3i32(485,483,128), Vec3i32(434,450,520), Vec3i32(434,520,471), Vec3i32(449,437,581), Vec3i32(449,581,565), Vec3i32(156,105,585), Vec3i32(156,585,587), Vec3i32(587,569,156), Vec3i32(104,157,529), Vec3i32(104,529,532), Vec3i32(475,529,157), Vec3i32(590,583,355), Vec3i32(355,356,588), Vec3i32(355,588,590), Vec3i32(358,357,524), Vec3i32(358,524,515), Vec3i32(525,524,357), Vec3i32(458,457,62), Vec3i32(457,593,62), Vec3i32(479,478,482), Vec3i32(479,504,549), Vec3i32(479,482,504), Vec3i32(482,481,484), Vec3i32(472,551,550), Vec3i32(581,551,472), Vec3i32(482,484,504), Vec3i32(484,483,486), Vec3i32(523,553,552), Vec3i32(504,553,523), Vec3i32(540,573,572), Vec3i32(571,573,540), Vec3i32(544,585,584), Vec3i32(587,585,544), Vec3i32(542,577,576), Vec3i32(575,577,542), Vec3i32(526,590,589), Vec3i32(583,590,526), Vec3i32(535,575,574), Vec3i32(567,575,535), Vec3i32(533,567,566), Vec3i32(585,567,533), Vec3i32(538,579,578), Vec3i32(577,579,538), Vec3i32(543,581,580), Vec3i32(565,581,543), Vec3i32(477,569,568), Vec3i32(563,569,477), Vec3i32(530,587,586), Vec3i32(569,587,530), Vec3i32(541,571,570), Vec3i32(579,571,541), Vec3i32(528,583,582), Vec3i32(561,583,528), Vec3i32(591,453,592), Vec3i32(547,592,453), Vec3i32(521,565,564), Vec3i32(555,565,521), Vec3i32(474,557,556), Vec3i32(573,557,474), Vec3i32(516,563,562), Vec3i32(588,563,516), Vec3i32(519,555,554), Vec3i32(553,555,519), Vec3i32(527,559,558), Vec3i32(551,559,527), Vec3i32(469,561,560), Vec3i32(559,561,469), Vec3i32(462,461,455), Vec3i32(453,455,461), Vec3i32(461,463,547), Vec3i32(548,547,463), Vec3i32(465,464,462), Vec3i32(463,462,464), Vec3i32(464,466,548), Vec3i32(557,548,466), Vec3i32(469,560,467), Vec3i32(528,467,560), Vec3i32(472,550,470), Vec3i32(527,470,550), Vec3i32(474,556,465), Vec3i32(466,465,556), Vec3i32(477,568,475), Vec3i32(530,475,568), Vec3i32(516,562,476), Vec3i32(477,476,562), Vec3i32(519,554,517), Vec3i32(521,517,554), Vec3i32(521,564,520), Vec3i32(543,520,564), Vec3i32(523,552,518), Vec3i32(519,518,552), Vec3i32(479,549,522), Vec3i32(523,522,549), Vec3i32(526,589,524), Vec3i32(589,546,524), Vec3i32(527,558,468), Vec3i32(469,468,558), Vec3i32(528,582,525), Vec3i32(526,525,582), Vec3i32(530,586,529), Vec3i32(544,529,586), Vec3i32(533,566,531), Vec3i32(535,531,566), Vec3i32(535,574,534), Vec3i32(542,534,574), Vec3i32(538,578,536), Vec3i32(541,536,578), Vec3i32(540,572,473), Vec3i32(474,473,572), Vec3i32(541,570,539), Vec3i32(540,539,570), Vec3i32(542,576,537), Vec3i32(538,537,576), Vec3i32(543,580,471), Vec3i32(472,471,580), Vec3i32(544,584,532), Vec3i32(533,532,584), Vec3i32(524,545,515), Vec3i32(516,515,545), Vec3i32(545,546,588), Vec3i32(589,588,546), Vec3i32(453,591,454), Vec3i32(593,454,591), Vec3i32(484,486,504), Vec3i32(486,485,488), Vec3i32(486,488,504), Vec3i32(488,487,490), Vec3i32(488,490,504), Vec3i32(490,489,492), Vec3i32(490,492,504), Vec3i32(492,491,494), Vec3i32(492,494,504), Vec3i32(494,493,496), Vec3i32(494,496,504), Vec3i32(496,495,498), Vec3i32(496,498,504), Vec3i32(498,497,500), Vec3i32(498,500,504), Vec3i32(500,499,502), Vec3i32(500,502,504), Vec3i32(501,504,502), Vec3i32(454,593,456), Vec3i32(457,456,593), Vec3i32(594,595,596), Vec3i32(597,598,594), Vec3i32(599,597,594), Vec3i32(600,599,594), Vec3i32(601,600,594), Vec3i32(602,601,594), Vec3i32(603,602,594), Vec3i32(604,603,594), Vec3i32(605,604,594), Vec3i32(606,607,608), Vec3i32(609,606,608), Vec3i32(610,609,608), Vec3i32(611,610,608), Vec3i32(612,611,608), Vec3i32(613,612,608), Vec3i32(614,613,608), Vec3i32(615,614,608), Vec3i32(616,615,608), Vec3i32(617,616,608), Vec3i32(618,617,608), Vec3i32(619,618,608), Vec3i32(620,619,608), Vec3i32(596,608,607), Vec3i32(595,594,598), Vec3i32(608,596,595), Vec3i32(605,594,91), Vec3i32(91,338,602), Vec3i32(91,602,603), Vec3i32(598,597,1), Vec3i32(594,596,91), Vec3i32(608,595,1), Vec3i32(595,598,1), Vec3i32(616,617,392), Vec3i32(610,611,394), Vec3i32(419,421,613), Vec3i32(419,613,614), Vec3i32(422,427,607), Vec3i32(422,607,606), Vec3i32(427,91,596), Vec3i32(427,596,607), Vec3i32(428,420,619), Vec3i32(428,619,620), Vec3i32(1,428,620), Vec3i32(1,620,608), Vec3i32(420,409,618), Vec3i32(420,618,619), Vec3i32(411,422,606), Vec3i32(411,606,609), Vec3i32(398,419,614), Vec3i32(398,614,615), Vec3i32(421,400,612), Vec3i32(421,612,613), Vec3i32(409,392,617), Vec3i32(409,617,618), Vec3i32(394,411,609), Vec3i32(394,609,610), Vec3i32(604,605,91), Vec3i32(338,1,599), Vec3i32(338,599,600), Vec3i32(392,398,615), Vec3i32(392,615,616), Vec3i32(400,394,611), Vec3i32(400,611,612), Vec3i32(603,604,91), Vec3i32(601,602,338), Vec3i32(597,599,1), Vec3i32(600,601,338) 
            };
            break;
        case TestMesh::gt2_teeth:
            vertices = std::vector<Vec3f>{
                Vec3f(15.8899993896484,19.444055557251,2.67489433288574), Vec3f(15.9129991531372,19.1590557098389,2.67489433288574), Vec3f(15.9039993286133,19.1500549316406,2.67489433288574), Vec3f(15.9489994049072,19.2490558624268,2.67489433288574), Vec3f(15.9579992294312,19.3570556640625,2.67489433288574), Vec3f(15.8819999694824,18.690055847168,2.67489433288574), Vec3f(15.8319997787476,17.7460556030273,2.67489433288574), Vec3f(15.8489999771118,18.819055557251,2.67489433288574), Vec3f(15.8589992523193,17.7190551757812,2.67489433288574), Vec3f(15.8769998550415,19.0490550994873,2.67489433288574), Vec3f(15.7529993057251,17.8080558776855,2.67489433288574), Vec3f(15.7869997024536,19.5010547637939,2.67489433288574), Vec3f(14.0329990386963,18.7170543670654,2.67489433288574), Vec3f(13.9599990844727,18.7460556030273,2.67489433288574), Vec3f(13.9869995117188,20.2840557098389,2.67489433288574), Vec3f(14.2029991149902,20.149055480957,2.67489433288574), Vec3f(14.1939992904663,19.9560546875,2.67489433288574), Vec3f(14.1939992904663,20.1670551300049,2.67489433288574), Vec3f(14.2119998931885,20.0590553283691,2.67489433288574), Vec3f(12.1899995803833,19.1840553283691,2.67489433288574), Vec3f(12.096999168396,19.1950550079346,2.67489433288574), Vec3f(12.1099996566772,20.6690559387207,2.67489433288574), Vec3f(11.382999420166,19.9750556945801,2.67489433288574), Vec3f(11.2599992752075,19.2490558624268,2.67489433288574), Vec3f(11.2369995117188,19.9320545196533,2.67489433288574), Vec3f(11.5349998474121,20.0640544891357,2.67489433288574), Vec3f(11.6259994506836,20.1550559997559,2.67489433288574), Vec3f(11.6829986572266,20.2390556335449,2.67489433288574), Vec3f(11.7369995117188,20.3570556640625,2.67489433288574), Vec3f(11.8449993133545,20.645055770874,2.67489433288574), Vec3f(11.7729988098145,20.4640560150146,2.67489433288574), Vec3f(11.7799987792969,20.5370559692383,9.41389465332031), Vec3f(11.7639999389648,20.4470558166504,2.67489433288574), Vec3f(11.9559993743896,20.6810550689697,2.67489433288574), Vec3f(12.3079996109009,20.6020545959473,2.67489433288574), Vec3f(12.1959991455078,19.1860542297363,2.67489433288574), Vec3f(12.2059993743896,20.6540546417236,2.67489433288574), Vec3f(12.3489990234375,20.3740558624268,2.67489433288574), Vec3f(12.3579998016357,20.2750549316406,2.67489433288574), Vec3f(12.3669996261597,20.266056060791,2.67489433288574), Vec3f(12.3849992752075,20.1670551300049,2.67489433288574), Vec3f(12.4269990921021,20.0680541992188,2.67489433288574), Vec3f(12.5029993057251,19.9540557861328,2.67489433288574), Vec3f(12.6169996261597,19.8550548553467,2.67489433288574), Vec3f(12.7449989318848,19.7800559997559,2.67489433288574), Vec3f(12.7629995346069,19.7800559997559,2.67489433288574), Vec3f(12.8799991607666,19.7350559234619,2.67489433288574), Vec3f(13.0369997024536,19.7250556945801,2.67489433288574), Vec3f(13.0149993896484,19.0340557098389,2.67489433288574), Vec3f(11.1699991226196,19.2580547332764,2.67489433288574), Vec3f(11.0959987640381,19.2580547332764,2.67489433288574), Vec3f(11.1209993362427,19.9230556488037,2.67489433288574), Vec3f(13.0599994659424,19.024055480957,2.67489433288574), Vec3f(14.9049997329712,18.3170547485352,2.67489433288574), Vec3f(14.8779993057251,18.3400554656982,2.67489433288574), Vec3f(14.8779993057251,19.149055480957,2.67489433288574), Vec3f(13.3039989471436,19.77805519104,2.67489433288574), Vec3f(13.1589994430542,18.9890556335449,2.67489433288574), Vec3f(13.1559991836548,19.7350559234619,2.67489433288574), Vec3f(13.4269990921021,19.8600559234619,2.67489433288574), Vec3f(13.5339994430542,19.9700546264648,2.67389440536499), Vec3f(13.6359996795654,20.1220550537109,2.67489433288574), Vec3f(13.6359996795654,20.1400547027588,2.67489433288574), Vec3f(13.6719989776611,20.2210559844971,2.67489433288574), Vec3f(13.6899995803833,20.2300548553467,2.67489433288574), Vec3f(13.7509994506836,20.3010559082031,2.67489433288574), Vec3f(13.8539991378784,20.3180541992188,2.67489433288574), Vec3f(14.8329992294312,18.3580551147461,2.67489433288574), Vec3f(14.1849994659424,19.8530559539795,2.67489433288574), Vec3f(14.0769996643066,18.7000541687012,2.67489433288574), Vec3f(14.1099996566772,20.2400550842285,2.67489433288574), Vec3f(14.2009992599487,19.6230545043945,2.67489433288574), Vec3f(14.2729997634888,19.4670543670654,2.67489433288574), Vec3f(14.3379993438721,19.3790550231934,2.67489433288574), Vec3f(14.4549999237061,19.2770557403564,2.67489433288574), Vec3f(14.5899991989136,19.2040557861328,2.67489433288574), Vec3f(14.6079998016357,19.2040557861328,2.67489433288574), Vec3f(14.7209997177124,19.1600551605225,2.67489433288574), Vec3f(15.1379995346069,19.210054397583,2.67489433288574), Vec3f(14.9949998855591,18.2680549621582,2.67489433288574), Vec3f(15.0029993057251,19.1580543518066,2.67489433288574), Vec3f(15.2369995117188,19.2760543823242,2.67489433288574), Vec3f(15.3779993057251,19.4060554504395,2.67489433288574), Vec3f(15.4539995193481,19.520055770874,2.67489433288574), Vec3f(15.471999168396,19.52805519104,2.67489433288574), Vec3f(15.5449991226196,19.5830554962158,2.67489433288574), Vec3f(15.6529998779297,19.573055267334,2.67489433288574), Vec3f(15.7059993743896,17.8360557556152,2.67489433288574), Vec3f(15.9449996948242,18.5560550689697,2.67489433288574), Vec3f(15.8589992523193,18.9380550384521,2.67489433288574), Vec3f(14.9589996337891,18.2950553894043,2.67489433288574), Vec3f(15.7779998779297,19.5100555419922,2.67489433288574), Vec3f(14.0049991607666,20.2750549316406,2.67489433288574), Vec3f(12.3489990234375,20.5000553131104,2.67489433288574), Vec3f(13.0689992904663,19.0150547027588,2.67489433288574), Vec3f(13.0999994277954,19.0100555419922,2.67489433288574), Vec3f(15.9489994049072,19.3670558929443,9.41489505767822), Vec3f(15.9489994049072,19.2490558624268,9.41489505767822), Vec3f(15.75,17.8080558776855,9.41489505767822), Vec3f(15.6639995574951,19.5710544586182,9.41489505767822), Vec3f(15.5709991455078,17.9260559082031,9.41489505767822), Vec3f(15.8769998550415,18.690055847168,9.41489505767822), Vec3f(15.8499994277954,18.8170547485352,9.41489505767822), Vec3f(15.9459991455078,18.5520553588867,9.41489505767822), Vec3f(15.914999961853,17.6890544891357,9.41489505767822), Vec3f(15.3999996185303,19.4290542602539,9.41489505767822), Vec3f(15.3099994659424,19.339054107666,9.41489505767822), Vec3f(15.3729991912842,18.0440559387207,9.41489505767822), Vec3f(15.4579992294312,19.5170555114746,9.41489505767822), Vec3f(15.5469999313354,19.5820541381836,9.41489505767822), Vec3f(13.2309989929199,19.7610549926758,9.41489505767822), Vec3f(13.168999671936,19.7360553741455,9.41489505767822), Vec3f(13.096999168396,19.0140552520752,9.41489505767822), Vec3f(13.1999988555908,18.9870548248291,9.41489505767822), Vec3f(15.1399993896484,19.2080554962158,9.41489505767822), Vec3f(15.0159997940063,19.1600551605225,9.41489505767822), Vec3f(14.9859991073608,18.2770557403564,9.41489505767822), Vec3f(15.1749992370605,18.1690559387207,9.41489505767822), Vec3f(15.9039993286133,19.1320552825928,9.41489505767822), Vec3f(15.8949995040894,19.4460544586182,9.41489505767822), Vec3f(15.8769998550415,19.0420551300049,9.41489505767822), Vec3f(12.2169990539551,20.6500549316406,9.41489505767822), Vec3f(11.9379997253418,20.6810550689697,9.41489505767822), Vec3f(11.8629989624023,19.2130546569824,9.41489505767822), Vec3f(12.096999168396,19.1950550079346,9.41489505767822), Vec3f(14.1669998168945,18.6640548706055,9.41489505767822), Vec3f(14.1039991378784,20.2460556030273,9.41489505767822), Vec3f(13.9849996566772,18.7360553741455,9.41489505767822), Vec3f(14.7349996566772,19.1590557098389,9.41489505767822), Vec3f(14.5849990844727,19.2050552368164,9.41489505767822), Vec3f(14.5719995498657,18.4850559234619,9.41489505767822), Vec3f(14.1939992904663,19.6760559082031,9.41489505767822), Vec3f(14.1849994659424,19.9330558776855,9.41489505767822), Vec3f(14.1759996414185,18.6640548706055,9.41489505767822), Vec3f(14.261999130249,19.4890556335449,9.41489505767822), Vec3f(14.3539991378784,19.3610553741455,9.41489505767822), Vec3f(14.3559989929199,18.5830554962158,9.41489505767822), Vec3f(11.6039991378784,20.1250553131104,9.41489505767822), Vec3f(11.5209999084473,20.0520553588867,9.41489505767822), Vec3f(11.4209995269775,19.2480545043945,9.41489505767822), Vec3f(11.6989994049072,20.2690544128418,9.41389465332031), Vec3f(11.7609996795654,20.4310550689697,9.41489505767822), Vec3f(11.8359994888306,19.2130546569824,9.41489505767822), Vec3f(14.1889991760254,20.1710548400879,9.41489505767822), Vec3f(13.9689998626709,20.2840557098389,9.41489505767822), Vec3f(13.8739995956421,20.315055847168,9.41489505767822), Vec3f(13.7799997329712,18.8080558776855,9.41489505767822), Vec3f(13.9869995117188,20.2750549316406,9.41489505767822), Vec3f(12.3129997253418,20.5980548858643,9.41489505767822), Vec3f(12.3399991989136,20.5090560913086,9.41489505767822), Vec3f(12.3489990234375,20.3830547332764,9.41489505767822), Vec3f(12.3599996566772,20.2680549621582,9.41489505767822), Vec3f(12.3849992752075,20.1850547790527,9.41489505767822), Vec3f(12.3849992752075,20.1670551300049,9.41489505767822), Vec3f(12.4249992370605,20.065055847168,9.41489505767822), Vec3f(12.4729995727539,19.1350555419922,9.41489505767822), Vec3f(14.4399995803833,19.2900543212891,9.41489505767822), Vec3f(14.3649997711182,18.5740547180176,9.41489505767822), Vec3f(13.5729999542236,20.0310554504395,9.41489505767822), Vec3f(13.4889993667603,19.9140548706055,9.41489505767822), Vec3f(13.5639991760254,18.8710556030273,9.41489505767822), Vec3f(13.6389999389648,20.1310558319092,9.41489505767822), Vec3f(13.6719989776611,20.2130546569824,9.41489505767822), Vec3f(13.75,20.3020553588867,9.41489505767822), Vec3f(12.7399997711182,19.7810554504395,9.41489505767822), Vec3f(12.6189994812012,19.8520545959473,9.41489505767822), Vec3f(12.5799999237061,19.1200542449951,9.41489505767822), Vec3f(12.8349990844727,19.069055557251,9.41489505767822), Vec3f(11.2669992446899,19.9350547790527,9.41489505767822), Vec3f(11.1029987335205,19.9230556488037,9.41489505767822), Vec3f(11.0209999084473,19.2600555419922,9.41489505767822), Vec3f(11.3819999694824,19.9710559844971,9.41489505767822), Vec3f(13.418999671936,19.8530559539795,9.41489505767822), Vec3f(13.4329996109009,18.9160556793213,9.41489505767822), Vec3f(11.8399991989136,20.6430549621582,9.41489505767822), Vec3f(13.3119993209839,19.7800559997559,9.41489505767822), Vec3f(15.2189998626709,19.2600555419922,9.41489505767822), Vec3f(15.1839990615845,18.1600551605225,9.41489505767822), Vec3f(15.3639993667603,18.0520553588867,9.41489505767822), Vec3f(13.0189990997314,19.7250556945801,9.41489505767822), Vec3f(12.8949995040894,19.7350559234619,9.41489505767822), Vec3f(15.9039993286133,19.1500549316406,9.41489505767822), Vec3f(15.7699995040894,19.5140552520752,9.41489505767822), Vec3f(15.8589992523193,18.9340553283691,9.41489505767822), Vec3f(14.1939992904663,19.9510555267334,9.41489505767822), Vec3f(14.2119998931885,20.0630550384521,9.41489505767822), Vec3f(14.8589992523193,19.149055480957,9.41489505767822), Vec3f(14.8159999847412,18.3670558929443,9.41489505767822), Vec3f(14.8959999084473,18.3220558166504,9.41489505767822), Vec3f(12.5189990997314,19.9360542297363,9.41489505767822), Vec3f(11.0209999084473,19.9290542602539,9.41489505767822), Vec3f(11.0209999084473,19.2530555725098,2.67489433288574), Vec3f(11.0209999084473,19.9300556182861,2.67489433288574), Vec3f(15.9799995422363,18.505931854248,5.58724021911621), Vec3f(15.9799995422363,18.5044555664062,9.41489505767822), Vec3f(15.9799995422363,18.5041732788086,2.67489433288574), Vec3f(15.9799995422363,18.1684837341309,2.67489433288574), Vec3f(15.9799995422363,18.1288299560547,9.41489505767822), Vec3f(15.9799995422363,17.9876575469971,2.67489433288574), Vec3f(15.9799995422363,17.6247596740723,3.91620373725891), Vec3f(15.9799995422363,17.6247596740723,2.67489433288574), Vec3f(15.9799995422363,17.6254329681396,4.32245063781738), Vec3f(15.9799995422363,17.8920269012451,9.41489505767822), Vec3f(15.9799995422363,17.8795108795166,2.67489433288574), Vec3f(15.9799995422363,17.629810333252,4.58585262298584), Vec3f(15.9799995422363,17.6336059570312,5.27938556671143), Vec3f(15.9799995422363,17.8311748504639,2.67489433288574), Vec3f(15.9799995422363,17.638355255127,9.41489505767822), Vec3f(15.9799995422363,17.6346111297607,5.98653984069824), Vec3f(15.9799995422363,17.8728256225586,2.67489433288574), Vec3f(15.9799995422363,18.2221603393555,2.67489433288574) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(0,3,1), Vec3i32(0,4,3), Vec3i32(5,6,7), Vec3i32(8,6,5), Vec3i32(2,9,0), Vec3i32(6,10,11), Vec3i32(12,13,14), Vec3i32(15,16,17), Vec3i32(18,16,15), Vec3i32(19,20,21), Vec3i32(22,23,24), Vec3i32(25,23,22), Vec3i32(26,23,25), Vec3i32(27,23,26), Vec3i32(28,23,27), Vec3i32(29,30,31), Vec3i32(29,32,30), Vec3i32(29,28,32), Vec3i32(33,28,29), Vec3i32(33,23,28), Vec3i32(21,23,33), Vec3i32(20,23,21), Vec3i32(34,35,36), Vec3i32(37,35,34), Vec3i32(38,35,37), Vec3i32(39,35,38), Vec3i32(40,35,39), Vec3i32(41,35,40), Vec3i32(42,35,41), Vec3i32(43,35,42), Vec3i32(44,35,43), Vec3i32(45,35,44), Vec3i32(46,35,45), Vec3i32(47,35,46), Vec3i32(48,35,47), Vec3i32(49,50,51), Vec3i32(52,48,47), Vec3i32(23,49,24), Vec3i32(53,54,55), Vec3i32(56,57,58), Vec3i32(59,57,56), Vec3i32(60,57,59), Vec3i32(61,57,60), Vec3i32(62,57,61), Vec3i32(63,57,62), Vec3i32(64,57,63), Vec3i32(65,57,64), Vec3i32(66,57,65), Vec3i32(13,57,66), Vec3i32(54,67,55), Vec3i32(68,69,70), Vec3i32(71,69,68), Vec3i32(72,69,71), Vec3i32(73,69,72), Vec3i32(74,69,73), Vec3i32(75,69,74), Vec3i32(76,69,75), Vec3i32(77,69,76), Vec3i32(67,69,77), Vec3i32(70,16,68), Vec3i32(70,17,16), Vec3i32(78,79,80), Vec3i32(81,79,78), Vec3i32(82,79,81), Vec3i32(83,79,82), Vec3i32(84,79,83), Vec3i32(85,79,84), Vec3i32(86,79,85), Vec3i32(87,79,86), Vec3i32(88,8,5), Vec3i32(11,7,6), Vec3i32(11,89,7), Vec3i32(11,9,89), Vec3i32(11,0,9), Vec3i32(55,90,53), Vec3i32(55,79,90), Vec3i32(55,80,79), Vec3i32(91,11,10), Vec3i32(92,69,12), Vec3i32(92,70,69), Vec3i32(34,93,37), Vec3i32(47,94,52), Vec3i32(47,95,94), Vec3i32(47,57,95), Vec3i32(47,58,57), Vec3i32(51,24,49), Vec3i32(21,35,19), Vec3i32(21,36,35), Vec3i32(14,92,12), Vec3i32(86,10,87), Vec3i32(86,91,10), Vec3i32(77,55,67), Vec3i32(66,14,13), Vec3i32(96,97,4), Vec3i32(98,99,100), Vec3i32(101,102,98), Vec3i32(103,101,98), Vec3i32(104,103,98), Vec3i32(105,106,107), Vec3i32(108,105,107), Vec3i32(109,108,107), Vec3i32(100,109,107), Vec3i32(110,111,112), Vec3i32(113,110,112), Vec3i32(114,115,116), Vec3i32(117,114,116), Vec3i32(118,119,120), Vec3i32(121,122,123), Vec3i32(124,121,123), Vec3i32(125,126,127), Vec3i32(128,129,130), Vec3i32(131,132,133), Vec3i32(71,131,133), Vec3i32(134,71,133), Vec3i32(135,134,133), Vec3i32(136,135,133), Vec3i32(137,138,139), Vec3i32(140,137,139), Vec3i32(141,140,139), Vec3i32(142,31,141), Vec3i32(142,141,139), Vec3i32(143,126,132), Vec3i32(144,145,146), Vec3i32(147,144,146), Vec3i32(127,147,146), Vec3i32(148,121,124), Vec3i32(149,148,124), Vec3i32(150,149,124), Vec3i32(151,150,124), Vec3i32(152,151,124), Vec3i32(153,152,124), Vec3i32(154,153,124), Vec3i32(155,154,124), Vec3i32(129,156,157), Vec3i32(130,129,157), Vec3i32(158,159,160), Vec3i32(161,158,160), Vec3i32(162,161,160), Vec3i32(163,162,160), Vec3i32(146,163,160), Vec3i32(164,165,166), Vec3i32(167,164,166), Vec3i32(168,169,170), Vec3i32(171,168,170), Vec3i32(139,171,170), Vec3i32(159,172,173), Vec3i32(123,174,142), Vec3i32(175,110,113), Vec3i32(173,175,113), Vec3i32(106,176,177), Vec3i32(178,106,177), Vec3i32(179,180,167), Vec3i32(112,179,167), Vec3i32(175,173,172), Vec3i32(119,118,181), Vec3i32(119,181,97), Vec3i32(119,97,96), Vec3i32(182,98,102), Vec3i32(182,102,183), Vec3i32(182,183,120), Vec3i32(182,120,119), Vec3i32(143,132,184), Vec3i32(184,185,143), Vec3i32(147,127,126), Vec3i32(174,123,122), Vec3i32(159,173,160), Vec3i32(126,125,133), Vec3i32(126,133,132), Vec3i32(186,187,188), Vec3i32(186,188,116), Vec3i32(186,116,115), Vec3i32(99,98,182), Vec3i32(109,100,99), Vec3i32(106,178,107), Vec3i32(114,117,177), Vec3i32(114,177,176), Vec3i32(128,130,187), Vec3i32(128,187,186), Vec3i32(135,136,157), Vec3i32(135,157,156), Vec3i32(163,146,145), Vec3i32(164,167,180), Vec3i32(179,112,111), Vec3i32(171,139,138), Vec3i32(189,155,166), Vec3i32(189,166,165), Vec3i32(149,150,93), Vec3i32(154,155,189), Vec3i32(31,142,174), Vec3i32(114,176,78), Vec3i32(81,78,176), Vec3i32(7,89,183), Vec3i32(89,9,120), Vec3i32(89,120,183), Vec3i32(78,80,114), Vec3i32(176,106,81), Vec3i32(88,5,103), Vec3i32(183,102,7), Vec3i32(118,120,9), Vec3i32(9,2,181), Vec3i32(9,181,118), Vec3i32(115,114,80), Vec3i32(82,81,106), Vec3i32(101,103,5), Vec3i32(102,101,5), Vec3i32(5,7,102), Vec3i32(97,181,2), Vec3i32(2,1,97), Vec3i32(1,3,97), Vec3i32(80,55,115), Vec3i32(172,159,59), Vec3i32(59,56,172), Vec3i32(3,4,97), Vec3i32(4,0,96), Vec3i32(105,108,82), Vec3i32(186,115,55), Vec3i32(82,106,105), Vec3i32(83,82,108), Vec3i32(60,59,159), Vec3i32(175,172,56), Vec3i32(119,96,0), Vec3i32(0,11,119), Vec3i32(108,109,84), Vec3i32(84,83,108), Vec3i32(55,77,186), Vec3i32(56,58,110), Vec3i32(56,110,175), Vec3i32(60,159,158), Vec3i32(11,91,182), Vec3i32(182,119,11), Vec3i32(91,86,182), Vec3i32(85,84,109), Vec3i32(86,85,99), Vec3i32(128,186,77), Vec3i32(58,111,110), Vec3i32(158,161,60), Vec3i32(26,25,137), Vec3i32(138,137,25), Vec3i32(99,182,86), Vec3i32(109,99,85), Vec3i32(77,76,128), Vec3i32(58,47,111), Vec3i32(61,60,161), Vec3i32(137,140,26), Vec3i32(27,26,140), Vec3i32(25,22,138), Vec3i32(129,128,76), Vec3i32(76,75,129), Vec3i32(75,74,129), Vec3i32(74,73,156), Vec3i32(73,72,135), Vec3i32(68,16,184), Vec3i32(68,184,132), Vec3i32(16,18,185), Vec3i32(161,162,62), Vec3i32(62,61,161), Vec3i32(179,111,47), Vec3i32(171,138,22), Vec3i32(156,129,74), Vec3i32(135,156,73), Vec3i32(134,135,72), Vec3i32(72,71,134), Vec3i32(68,132,131), Vec3i32(185,184,16), Vec3i32(18,15,185), Vec3i32(63,62,162), Vec3i32(28,27,140), Vec3i32(22,24,171), Vec3i32(71,68,131), Vec3i32(15,17,143), Vec3i32(15,143,185), Vec3i32(17,70,143), Vec3i32(70,92,126), Vec3i32(162,163,64), Vec3i32(64,63,162), Vec3i32(180,179,47), Vec3i32(47,46,180), Vec3i32(140,141,28), Vec3i32(168,171,24), Vec3i32(126,143,70), Vec3i32(92,14,147), Vec3i32(147,126,92), Vec3i32(14,66,144), Vec3i32(14,144,147), Vec3i32(65,64,163), Vec3i32(66,65,145), Vec3i32(46,45,180), Vec3i32(32,28,141), Vec3i32(24,51,168), Vec3i32(145,144,66), Vec3i32(163,145,65), Vec3i32(164,180,45), Vec3i32(45,44,164), Vec3i32(44,43,164), Vec3i32(43,42,165), Vec3i32(38,37,151), Vec3i32(150,151,37), Vec3i32(37,93,150), Vec3i32(141,31,30), Vec3i32(30,32,141), Vec3i32(169,168,51), Vec3i32(165,164,43), Vec3i32(189,165,42), Vec3i32(42,41,189), Vec3i32(40,39,152), Vec3i32(40,152,153), Vec3i32(151,152,39), Vec3i32(39,38,151), Vec3i32(93,34,149), Vec3i32(154,189,41), Vec3i32(153,154,41), Vec3i32(41,40,153), Vec3i32(148,149,34), Vec3i32(34,36,148), Vec3i32(36,21,121), Vec3i32(31,174,29), Vec3i32(121,148,36), Vec3i32(21,33,122), Vec3i32(21,122,121), Vec3i32(33,29,122), Vec3i32(174,122,29), Vec3i32(116,188,53), Vec3i32(104,98,10), Vec3i32(87,10,98), Vec3i32(98,100,87), Vec3i32(79,87,100), Vec3i32(79,100,107), Vec3i32(90,79,107), Vec3i32(90,107,178), Vec3i32(178,177,90), Vec3i32(53,90,177), Vec3i32(53,177,117), Vec3i32(117,116,53), Vec3i32(54,53,188), Vec3i32(54,188,187), Vec3i32(67,54,187), Vec3i32(67,187,130), Vec3i32(69,67,130), Vec3i32(69,130,157), Vec3i32(12,69,157), Vec3i32(12,157,136), Vec3i32(136,133,12), Vec3i32(12,133,125), Vec3i32(125,127,12), Vec3i32(13,12,127), Vec3i32(127,146,13), Vec3i32(57,13,146), Vec3i32(57,146,160), Vec3i32(95,57,160), Vec3i32(95,160,173), Vec3i32(173,113,95), Vec3i32(94,95,113), Vec3i32(113,112,94), Vec3i32(52,94,112), Vec3i32(48,52,112), Vec3i32(112,167,48), Vec3i32(35,48,167), Vec3i32(35,167,166), Vec3i32(19,35,166), Vec3i32(139,170,50), Vec3i32(50,49,139), Vec3i32(166,155,19), Vec3i32(20,19,155), Vec3i32(155,124,20), Vec3i32(23,20,124), Vec3i32(23,124,123), Vec3i32(49,23,123), Vec3i32(49,123,142), Vec3i32(142,139,49), Vec3i32(190,191,170), Vec3i32(192,191,190), Vec3i32(191,192,51), Vec3i32(191,51,50), Vec3i32(170,169,190), Vec3i32(169,51,192), Vec3i32(169,192,190), Vec3i32(170,191,50), Vec3i32(193,194,195), Vec3i32(196,197,198), Vec3i32(199,200,201), Vec3i32(198,202,203), Vec3i32(204,201,200), Vec3i32(205,204,200), Vec3i32(206,207,208), Vec3i32(206,208,205), Vec3i32(206,205,200), Vec3i32(207,206,209), Vec3i32(207,209,203), Vec3i32(207,203,202), Vec3i32(202,198,197), Vec3i32(197,196,210), Vec3i32(197,210,195), Vec3i32(197,195,194), Vec3i32(8,88,195), Vec3i32(8,195,210), Vec3i32(210,196,8), Vec3i32(196,198,8), Vec3i32(198,203,8), Vec3i32(203,209,8), Vec3i32(209,206,8), Vec3i32(206,200,8), Vec3i32(202,197,104), Vec3i32(207,202,104), Vec3i32(103,104,197), Vec3i32(103,197,194), Vec3i32(193,195,88), Vec3i32(88,103,194), Vec3i32(88,194,193), Vec3i32(200,199,8), Vec3i32(199,201,8), Vec3i32(204,205,6), Vec3i32(6,8,201), Vec3i32(6,201,204), Vec3i32(10,6,205), Vec3i32(10,205,208), Vec3i32(104,10,208), Vec3i32(104,208,207) 
            };
            break;
        case TestMesh::pyramid:
            vertices = std::vector<Vec3f>{
                Vec3f(10,10,40), Vec3f(0,0,0), Vec3f(20,0,0), Vec3f(20,20,0), Vec3f(0,20,0)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(0,3,4), Vec3i32(3,1,4), Vec3i32(1,3,2), Vec3i32(3,0,2), Vec3i32(4,1,0)
            };
            break;
        case TestMesh::two_hollow_squares:
            vertices = std::vector<Vec3f>{
                Vec3f(66.7133483886719,104.286666870117,0), Vec3f(66.7133483886719,95.7133331298828,0), Vec3f(65.6666870117188,94.6666717529297,0), Vec3f(75.2866821289062,95.7133331298828,0), Vec3f(76.3333435058594,105.333335876465,0), Vec3f(76.3333435058594,94.6666717529297,0), 
                Vec3f(65.6666870117188,105.33332824707,0), Vec3f(75.2866821289062,104.286666870117,0), Vec3f(71.1066818237305,104.58666229248,2.79999995231628), Vec3f(66.4133529663086,104.58666229248,2.79999995231628), Vec3f(75.5866851806641,104.58666229248,2.79999995231628), 
                Vec3f(66.4133529663086,99.8933334350586,2.79999995231628), Vec3f(66.4133529663086,95.4133377075195,2.79999995231628), Vec3f(71.1066818237305,95.4133377075195,2.79999995231628), Vec3f(75.5866851806641,95.4133377075195,2.79999995231628), Vec3f(75.5866851806641,100.106666564941,2.79999995231628), 
                Vec3f(74.5400161743164,103.540000915527,2.79999995231628), Vec3f(70.0320129394531,103.540000915527,2.79999995231628), Vec3f(67.4600067138672,103.540000915527,2.79999995231628), Vec3f(67.4600067138672,100.968002319336,2.79999995231628), Vec3f(67.4600067138672,96.4599990844727,2.79999995231628), 
                Vec3f(74.5400161743164,99.0319976806641,2.79999995231628), Vec3f(74.5400161743164,96.4599990844727,2.79999995231628), Vec3f(70.0320129394531,96.4599990844727,2.79999995231628), Vec3f(123.666717529297,94.6666717529297,0), Vec3f(134.333312988281,94.6666717529297,0), 
                Vec3f(124.413360595703,95.4133377075195,2.79999995231628), Vec3f(129.106674194336,95.4133377075195,2.79999995231628), Vec3f(133.586669921875,95.4133377075195,2.79999995231628), Vec3f(123.666717529297,105.33332824707,0), Vec3f(124.413360595703,104.58666229248,2.79999995231628), 
                Vec3f(124.413360595703,99.8933334350586,2.79999995231628), Vec3f(134.333312988281,105.33332824707,0), Vec3f(129.106674194336,104.58666229248,2.79999995231628), Vec3f(133.586669921875,104.58666229248,2.79999995231628), Vec3f(133.586669921875,100.106666564941,2.79999995231628), 
                Vec3f(124.713317871094,104.286666870117,0), Vec3f(124.713317871094,95.7133331298828,0), Vec3f(133.286712646484,95.7133331298828,0), Vec3f(133.286712646484,104.286666870117,0), Vec3f(132.540023803711,103.540000915527,2.79999995231628), Vec3f(128.032028198242,103.540008544922,2.79999995231628), 
                Vec3f(125.460006713867,103.540000915527,2.79999995231628), Vec3f(125.460006713867,100.968002319336,2.79999995231628), Vec3f(125.460006713867,96.4599990844727,2.79999995231628), Vec3f(132.540023803711,99.0319976806641,2.79999995231628), Vec3f(132.540023803711,96.4599990844727,2.79999995231628), 
                Vec3f(128.032028198242,96.4599990844727,2.79999995231628)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(3,4,5), Vec3i32(6,4,0), Vec3i32(6,0,2), Vec3i32(2,1,5), Vec3i32(7,4,3), Vec3i32(1,3,5), Vec3i32(0,4,7), Vec3i32(4,6,8), Vec3i32(6,9,8), Vec3i32(4,8,10), Vec3i32(6,2,9), Vec3i32(2,11,9), Vec3i32(2,12,11), Vec3i32(2,5,12), Vec3i32(5,13,12), Vec3i32(5,14,13), 
                Vec3i32(4,10,15), Vec3i32(5,4,14), Vec3i32(4,15,14), Vec3i32(7,16,17), Vec3i32(0,7,18), Vec3i32(7,17,18), Vec3i32(1,19,20), Vec3i32(1,0,19), Vec3i32(0,18,19), Vec3i32(7,3,21), Vec3i32(3,22,21), Vec3i32(7,21,16), Vec3i32(3,23,22), Vec3i32(3,1,23), Vec3i32(1,20,23), Vec3i32(24,25,26), 
                Vec3i32(25,27,26), Vec3i32(25,28,27), Vec3i32(29,24,30), Vec3i32(24,31,30), Vec3i32(24,26,31), Vec3i32(32,29,33), Vec3i32(29,30,33), Vec3i32(32,33,34), Vec3i32(32,34,35), Vec3i32(25,32,28), Vec3i32(32,35,28), Vec3i32(36,37,24), Vec3i32(38,32,25), Vec3i32(29,32,36), Vec3i32(29,36,24), 
                Vec3i32(24,37,25), Vec3i32(39,32,38), Vec3i32(37,38,25), Vec3i32(36,32,39), Vec3i32(39,40,41), Vec3i32(36,39,42), Vec3i32(39,41,42), Vec3i32(37,43,44), Vec3i32(37,36,43), Vec3i32(36,42,43), Vec3i32(39,38,45), Vec3i32(38,46,45), Vec3i32(39,45,40), Vec3i32(38,47,46), Vec3i32(38,37,47), 
                Vec3i32(37,44,47), Vec3i32(16,8,9), Vec3i32(16,10,8), Vec3i32(10,16,15), Vec3i32(15,16,21), Vec3i32(22,15,21), Vec3i32(15,22,14), Vec3i32(22,23,14), Vec3i32(23,20,14), Vec3i32(17,16,9), Vec3i32(18,17,9), Vec3i32(19,18,9), Vec3i32(19,9,11), Vec3i32(19,11,20), Vec3i32(13,14,20), 
                Vec3i32(20,11,12), Vec3i32(13,20,12), Vec3i32(41,40,30), Vec3i32(42,41,30), Vec3i32(43,42,30), Vec3i32(43,30,31), Vec3i32(43,31,44), Vec3i32(27,28,44), Vec3i32(44,31,26), Vec3i32(27,44,26), Vec3i32(40,33,30), Vec3i32(40,34,33), Vec3i32(34,40,35), Vec3i32(35,40,45), Vec3i32(46,35,45), 
                Vec3i32(35,46,28), Vec3i32(46,47,28), Vec3i32(47,44,28) ,
            };
            break;
        case TestMesh::small_dorito:
            vertices = std::vector<Vec3f>{
                Vec3f(6.00058937072754,-22.9982089996338,0), Vec3f(22.0010242462158,-49.9998741149902,0), Vec3f(-9.99957847595215,-49.999870300293,0), Vec3f(6.00071382522583,-32.2371635437012,28.0019245147705), Vec3f(11.1670551300049,-37.9727020263672,18.9601669311523), 
                Vec3f(6.00060224533081,-26.5392456054688,10.7321853637695) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(3,4,5), Vec3i32(2,1,4), Vec3i32(2,4,3), Vec3i32(2,3,5), Vec3i32(2,5,0), Vec3i32(5,4,1), Vec3i32(5,1,0) 
            };
            break;
        case TestMesh::bridge:
            vertices = std::vector<Vec3f>{
                Vec3f(75,84.5,8), Vec3f(125,84.5,8), Vec3f(75,94.5,8), Vec3f(120,84.5,5), Vec3f(125,94.5,8), Vec3f(75,84.5,0), Vec3f(80,84.5,5), Vec3f(125,84.5,0), Vec3f(125,94.5,0), Vec3f(80,94.5,5), Vec3f(75,94.5,0), Vec3f(120,94.5,5), Vec3f(120,84.5,0), Vec3f(80,94.5,0), Vec3f(80,84.5,0), Vec3f(120,94.5,0) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(1,0,3), Vec3i32(2,1,4), Vec3i32(2,5,0), Vec3i32(0,6,3), Vec3i32(1,3,7), Vec3i32(1,8,4), Vec3i32(4,9,2), Vec3i32(10,5,2), Vec3i32(5,6,0), Vec3i32(6,11,3), Vec3i32(3,12,7), Vec3i32(7,8,1), Vec3i32(4,8,11), Vec3i32(4,11,9), Vec3i32(9,10,2), Vec3i32(10,13,5), 
                Vec3i32(14,6,5), Vec3i32(9,11,6), Vec3i32(11,12,3), Vec3i32(12,8,7), Vec3i32(11,8,15), Vec3i32(13,10,9), Vec3i32(5,13,14), Vec3i32(14,13,6), Vec3i32(6,13,9), Vec3i32(15,12,11), Vec3i32(15,8,12) 
            };
            break;
        case TestMesh::bridge_with_hole:
            vertices = std::vector<Vec3f>{
                Vec3f(75,69.5,8), Vec3f(80,76.9091644287109,8), Vec3f(75,94.5,8), Vec3f(125,69.5,8), Vec3f(120,76.9091644287109,8), Vec3f(120,87.0908355712891,8), Vec3f(80,87.0908355712891,8), Vec3f(125,94.5,8), Vec3f(80,87.0908355712891,5), Vec3f(120,87.0908355712891,5), Vec3f(125,94.5,0), Vec3f(120,69.5,0), Vec3f(120,94.5,0), Vec3f(125,69.5,0), Vec3f(120,94.5,5), Vec3f(80,94.5,5), Vec3f(80,94.5,0), Vec3f(75,94.5,0), Vec3f(80,69.5,5), Vec3f(80,69.5,0), Vec3f(80,76.9091644287109,5), Vec3f(120,69.5,5), Vec3f(75,69.5,0), Vec3f(120,76.9091644287109,5) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(1,0,3), Vec3i32(1,3,4), Vec3i32(4,3,5), Vec3i32(2,6,7), Vec3i32(6,2,1), Vec3i32(7,6,5), Vec3i32(7,5,3), Vec3i32(5,8,9), Vec3i32(8,5,6), Vec3i32(10,11,12), Vec3i32(11,10,13), Vec3i32(14,8,15), Vec3i32(8,14,9), Vec3i32(2,16,17), Vec3i32(16,2,15), Vec3i32(15,2,14), 
                Vec3i32(14,10,12), Vec3i32(10,14,7), Vec3i32(7,14,2), Vec3i32(16,18,19), Vec3i32(18,16,20), Vec3i32(20,16,1), Vec3i32(1,16,8), Vec3i32(8,16,15), Vec3i32(6,1,8), Vec3i32(3,11,13), Vec3i32(11,3,21), Vec3i32(21,3,18), Vec3i32(18,22,19), Vec3i32(22,18,0), Vec3i32(0,18,3), Vec3i32(16,22,17), Vec3i32(22,16,19), Vec3i32(2,22,0), Vec3i32(22,2,17), Vec3i32(5,23,4), Vec3i32(23,11,21), Vec3i32(11,23,12), Vec3i32(12,23,9), Vec3i32(9,23,5), Vec3i32(12,9,14), Vec3i32(23,18,20), Vec3i32(18,23,21), Vec3i32(10,3,13), Vec3i32(3,10,7), Vec3i32(1,23,20), Vec3i32(23,1,4) 
            };
            break;
        case TestMesh::step:
            vertices = std::vector<Vec3f>{
                Vec3f(0,20,5), Vec3f(0,20,0), Vec3f(0,0,5), Vec3f(0,0,0), Vec3f(20,0,0), Vec3f(20,0,5), Vec3f(1,19,5), Vec3f(1,1,5), Vec3f(19,1,5), Vec3f(20,20,5), Vec3f(19,19,5), Vec3f(20,20,0), Vec3f(19,19,10), Vec3f(1,19,10), Vec3f(1,1,10), Vec3f(19,1,10) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2), Vec3i32(1,3,2), Vec3i32(3,4,5), Vec3i32(2,3,5), Vec3i32(6,0,2), Vec3i32(6,2,7), Vec3i32(5,8,7), Vec3i32(5,7,2), Vec3i32(9,10,8), Vec3i32(9,8,5), Vec3i32(9,0,6), Vec3i32(9,6,10), Vec3i32(9,11,1), Vec3i32(9,1,0), Vec3i32(3,1,11), Vec3i32(4,3,11), Vec3i32(5,11,9), 
                Vec3i32(5,4,11), Vec3i32(12,10,6), Vec3i32(12,6,13), Vec3i32(6,7,14), Vec3i32(13,6,14), Vec3i32(7,8,15), Vec3i32(14,7,15), Vec3i32(15,8,10), Vec3i32(15,10,12), Vec3i32(12,13,14), Vec3i32(12,14,15) 
            };
            break;
        case TestMesh::slopy_cube:
            vertices = std::vector<Vec3f>{
                Vec3f(-10,-10,0) , Vec3f(-10,-10,20) , Vec3f(-10,10,0) , Vec3f(-10,10,20) , Vec3f(0,-10,10) , Vec3f(10,-10,0) , Vec3f(2.92893,-10,10) , Vec3f(10,-10,2.92893) , 
                Vec3f(0,-10,20) , Vec3f(10,10,0) , Vec3f(0,10,10) , Vec3f(0,10,20) , Vec3f(2.92893,10,10) , Vec3f(10,10,2.92893) 
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2) , Vec3i32(2,1,3) , Vec3i32(4,0,5) , Vec3i32(4,1,0) , Vec3i32(6,4,7) , Vec3i32(7,4,5) , Vec3i32(4,8,1) , Vec3i32(0,2,5) , Vec3i32(5,2,9) , Vec3i32(2,10,9) , Vec3i32(10,3,11) , 
                Vec3i32(2,3,10) , Vec3i32(9,10,12) , Vec3i32(13,9,12) , Vec3i32(3,1,8) , Vec3i32(11,3,8) , Vec3i32(10,11,8) , Vec3i32(4,10,8) , Vec3i32(6,12,10) , Vec3i32(4,6,10) , 
                Vec3i32(7,13,12) , Vec3i32(6,7,12) , Vec3i32(7,5,9) , Vec3i32(13,7,9) 
            };
            break;
        case TestMesh::di_5mm_center_notch:
            vertices = std::vector<Vec3f>{
                Vec3f(-15,-15,0),Vec3f(-15,15,10),Vec3f(-15,15,0),Vec3f(-15,-15,10),Vec3f(3,-2,10),Vec3f(15,15,10),Vec3f(3,3,10),Vec3f(-2,3,10),Vec3f(-2,-2,10),Vec3f(15,-15,10),Vec3f(15,15,0),Vec3f(15,-15,0),Vec3f(-2,3,5),Vec3f(-2,-2,5),Vec3f(3,-2,5),Vec3f(3,3,5)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2),Vec3i32(1,0,3),Vec3i32(4,5,6),Vec3i32(5,7,6),Vec3i32(7,1,8),Vec3i32(1,7,5),Vec3i32(5,4,9),Vec3i32(8,9,4),Vec3i32(8,3,9),Vec3i32(3,8,1),Vec3i32(9,10,5),Vec3i32(10,9,11),Vec3i32(10,1,5),Vec3i32(1,10,2),Vec3i32(0,10,11),Vec3i32(10,0,2),Vec3i32(0,9,3),Vec3i32(9,0,11),
                Vec3i32(8,12,7),Vec3i32(12,8,13),Vec3i32(14,6,15),Vec3i32(6,14,4),Vec3i32(12,14,15),Vec3i32(14,12,13),Vec3i32(14,8,4),Vec3i32(8,14,13),Vec3i32(12,6,7),Vec3i32(6,12,15)
            };
            break;
        case TestMesh::di_10mm_notch:
            vertices = std::vector<Vec3f>{
                Vec3f(-15,15,0),Vec3f(-15,-5,5),Vec3f(-15,15,10),Vec3f(-15,-15,0),Vec3f(-15,-15,5),Vec3f(-15,-5,10),Vec3f(15,15,10),Vec3f(-5,-5,10),Vec3f(15,-15,10),Vec3f(-5,-15,10),Vec3f(15,15,0),Vec3f(15,-15,0),Vec3f(-5,-15,5),Vec3f(-5,-5,5)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2),Vec3i32(3,1,0),Vec3i32(1,3,4),Vec3i32(2,1,5),Vec3i32(6,7,8),Vec3i32(2,7,6),Vec3i32(7,2,5),Vec3i32(8,7,9),Vec3i32(8,10,6),Vec3i32(10,8,11),Vec3i32(10,2,6),Vec3i32(2,10,0),Vec3i32(3,10,11),Vec3i32(10,3,0),Vec3i32(4,3,12),Vec3i32(12,8,9),Vec3i32(11,12,3),Vec3i32(12,11,8),
                Vec3i32(12,7,13),Vec3i32(7,12,9),Vec3i32(1,7,5),Vec3i32(7,1,13),Vec3i32(1,12,13),Vec3i32(12,1,4)
            };
            break;
        case TestMesh::di_20mm_notch:
            vertices = std::vector<Vec3f>{
                Vec3f(-15,15,0),Vec3f(-15,5,5),Vec3f(-15,15,10),Vec3f(-15,-15,0),Vec3f(-15,-15,5),Vec3f(-15,5,10),Vec3f(15,15,10),Vec3f(5,5,10),Vec3f(15,-15,10),Vec3f(5,-15,10),Vec3f(15,15,0),Vec3f(15,-15,0),Vec3f(5,-15,5),Vec3f(5,5,5)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2),Vec3i32(3,1,0),Vec3i32(1,3,4),Vec3i32(2,1,5),Vec3i32(6,7,8),Vec3i32(2,7,6),Vec3i32(7,2,5),Vec3i32(8,7,9),Vec3i32(8,10,6),Vec3i32(10,8,11),Vec3i32(3,10,11),Vec3i32(10,3,0),Vec3i32(4,3,12),Vec3i32(12,8,9),Vec3i32(12,11,8),Vec3i32(11,12,3),Vec3i32(10,2,6),Vec3i32(2,10,0),
                Vec3i32(12,7,13),Vec3i32(7,12,9),Vec3i32(1,12,13),Vec3i32(12,1,4),Vec3i32(1,7,5),Vec3i32(7,1,13)
            };
            break;
        case TestMesh::di_25mm_notch:
            vertices = std::vector<Vec3f>{
                Vec3f(-15,15,0),Vec3f(-15,10,5),Vec3f(-15,15,10),Vec3f(-15,-15,0),Vec3f(-15,-15,5),Vec3f(-15,10,10),Vec3f(15,15,10),Vec3f(10,10,10),Vec3f(15,-15,10),Vec3f(10,-15,10),Vec3f(15,15,0),Vec3f(15,-15,0),Vec3f(10,-15,5),Vec3f(10,10,5)
            };
            facets = std::vector<Vec3i32>{
                Vec3i32(0,1,2),Vec3i32(3,1,0),Vec3i32(1,3,4),Vec3i32(2,1,5),Vec3i32(6,7,8),Vec3i32(2,7,6),Vec3i32(7,2,5),Vec3i32(8,7,9),Vec3i32(8,10,6),Vec3i32(10,8,11),Vec3i32(3,10,11),Vec3i32(10,3,0),Vec3i32(4,3,12),Vec3i32(12,8,9),Vec3i32(12,11,8),Vec3i32(11,12,3),Vec3i32(10,2,6),Vec3i32(2,10,0),
                Vec3i32(12,7,13),Vec3i32(7,12,9),Vec3i32(1,7,5),Vec3i32(7,1,13),Vec3i32(1,12,13),Vec3i32(12,1,4)
            };
            break;
        default:
            break;        
    }
    TriangleMesh _mesh;
    if (vertices.size() == 0) {
        switch(m) {
            case TestMesh::cube_20x20x20:
                _mesh = Slic3r::make_cube(20,20,20);
                break;
            case TestMesh::sphere_50mm:
                _mesh = Slic3r::make_sphere(50, PI / 243.0);
                break;
            default:
                break;
        }
    } else {
        _mesh = TriangleMesh(vertices, facets);
    }

    //_mesh.repair();
    return _mesh;
}


void init_print(Print& print, std::initializer_list<TestMesh> meshes, Slic3r::Model& model, DynamicPrintConfig* _config, bool comments) {
	DynamicPrintConfig &config = Slic3r::DynamicPrintConfig::full_print_config();
    config.apply(*_config);
    
    //remove print of status
    print.set_status_callback([](const PrintBase::SlicingStatus &) {});
    //const std::string v {std::getenv("SLIC3R_TESTS_GCODE")};
    //auto tests_gcode {(v == "" ? ""s : std::string(v))};

    //if (tests_gcode != ""s)
    //    config->set_key_value("gcode_comments", new ConfigOptionBool(true));

    //print.apply_config_perl_tests_only(*config);
    for (const TestMesh& t : meshes) {
        ModelObject* object {model.add_object()};
        object->name += std::string(mesh_names.at(t)) + ".stl"s;
        object->add_volume(mesh(t));

        ModelInstance* inst {object->add_instance()};
        inst->set_rotation(Vec3d(0,0,0));
        inst->set_scaling_factor(Vec3d(1, 1, 1));
    }

    print.apply(model, config); // apply config for the arrange_objects
    arrange_objects(model, InfiniteBed{}, ArrangeParams{ scale_t(10)});//print.config().min_object_distance()) });
    model.center_instances_around_point(Slic3r::Vec2d(100,100));
    for (auto* mo : model.objects) {
        print.auto_assign_extruders(mo);
        //print.add_model_object(mo);
    }
    print.apply(model, config);

    std::pair<PrintBase::PrintValidationError, std::string> err = print.validate();
    //std::cout << "validate result : " << err << ", mempty print? " << print.empty() << "\n";

}

void init_print(Print& print, std::vector<TriangleMesh> meshes, Slic3r::Model& model, DynamicPrintConfig* _config, bool comments) {
	DynamicPrintConfig &config = Slic3r::DynamicPrintConfig::full_print_config();
    config.apply(*_config);
    
    //remove print of status
    print.set_status_callback([](const PrintBase::SlicingStatus &) {});
    //const std::string v {std::getenv("SLIC3R_TESTS_GCODE")};
    //std::string tests_gcode {(v == "" ? "" : v)};

    //if (tests_gcode != ""s)
        //config->set_key_value("gcode_comments", new ConfigOptionBool(true));

    for (TriangleMesh& t : meshes) {
        //if(!t.repaired())
            //t.repair();
		ModelObject* object {model.add_object()};
		object->name += "object.stl"s;
        object->add_volume(t);

        ModelInstance* inst {object->add_instance()};
		inst->set_rotation(Vec3d(0, 0, 0));
		inst->set_scaling_factor(Vec3d(1, 1, 1));
    }

    print.apply(model, config); // apply config for the arrange_objects
    arrange_objects(model, InfiniteBed{}, ArrangeParams{scale_t(10)} );//print.config().min_object_distance())});
    model.center_instances_around_point(Slic3r::Vec2d(100,100));
	print.apply(model, config);
	for (ModelObject* mo : model.objects) {
        print.auto_assign_extruders(mo);
    }
	
    print.validate();

}

void gcode(std::string& gcode_path, Print& _print) {
    _print.process();
    gcode_path = _print.export_gcode(gcode_path, nullptr);
}

std::string read_to_string(const std::string& name) {
    std::stringstream buf;
    std::ifstream f{ get_model_path(name) };
    if (!f.good()) f = std::ifstream{ name };
    if (!f.good()) return ""s;
    std::copy(std::istreambuf_iterator<char>(f),
        std::istreambuf_iterator<char>(),
        std::ostreambuf_iterator<char>(buf));
    f.close();
    return buf.str();
}

void clean_file(const std::string& name, const std::string& ext, bool glob) {
    std::string filename{ "" };
    filename.append(name);
    filename.append(".");
    filename.append(ext);

    bool file_exist = false;
    {
        std::ifstream f{ get_model_path(filename) };
        file_exist = f.good();
        f.close();
    }
    if (file_exist) std::remove(get_model_path(filename).c_str());
    else {
        std::ifstream f{ filename };
        file_exist = f.good();
        f.close();
        if (file_exist) std::remove(filename.c_str());
    }
}

Slic3r::Model model(const std::string& model_name, TriangleMesh&& _mesh) {
    Slic3r::Model result;

	ModelObject* object {result.add_object()};
    object->name += model_name + ".stl"s;
    object->add_volume(_mesh);

	ModelInstance* inst {object->add_instance()};
    inst->set_rotation(Vec3d{ 0, 0, 0 });
	inst->set_scaling_factor(Vec3d{ 1, 1, 1 });

    return result;
}

void add_testmesh_to_model(Slic3r::Model& result, const std::string& model_name, TriangleMesh&& _mesh) {
	ModelObject* object {result.add_object()};
    object->name += model_name + ".stl"s;
    object->add_volume(_mesh);

	ModelInstance* inst {object->add_instance()};
    inst->set_rotation(Vec3d{ 0, 0, 0 });
    inst->set_scaling_factor(Vec3d{ 1, 1, 1 });
}

} } // namespace Slic3r::Test
