/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.dependents.internal.DependentComponentsUtils;
import org.gradle.api.reporting.dependents.internal.TextDependentComponentsReportRenderer;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;
import org.gradle.work.DisableCachingByDefault;

@Deprecated
@DisableCachingByDefault(because="Produces only non-cacheable console output")
public abstract class DependentComponentsReport
extends DefaultTask {
    private boolean showNonBuildable;
    private boolean showTestSuites;
    private List<String> components;

    public DependentComponentsReport() {
        this.notCompatibleWithConfigurationCache("Requires access to the component model at execution time.");
    }

    @Console
    public boolean isShowNonBuildable() {
        return this.showNonBuildable;
    }

    @Option(option="non-buildable", description="Show non-buildable components.")
    public void setShowNonBuildable(boolean showNonBuildable) {
        this.showNonBuildable = showNonBuildable;
    }

    @Console
    public boolean isShowTestSuites() {
        return this.showTestSuites;
    }

    @Option(option="test-suites", description="Show test suites components.")
    public void setShowTestSuites(boolean showTestSuites) {
        this.showTestSuites = showTestSuites;
    }

    @Console
    public boolean getShowAll() {
        return this.showNonBuildable && this.showTestSuites;
    }

    @Option(option="all", description="Show all components (non-buildable and test suites).")
    public void setShowAll(boolean showAll) {
        this.showNonBuildable = showAll;
        this.showTestSuites = showAll;
    }

    @Console
    public List<String> getComponents() {
        return this.components;
    }

    @Option(option="component", description="Component to generate the report for (can be specified more than once).")
    public void setComponents(List<String> components) {
        this.components = components;
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected WorkerLeaseService getWorkerLeaseService() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        this.getWorkerLeaseService().runAsIsolatedTask(() -> {
            Class<DependentComponentsReport> clazz = DependentComponentsReport.class;
            synchronized (DependentComponentsReport.class) {
                ((ProjectInternal)this.getProject()).getOwner().applyToMutableState(project -> {
                    ModelRegistry modelRegistry = this.getModelRegistry();
                    DependentBinariesResolver dependentBinariesResolver = (DependentBinariesResolver)modelRegistry.find("dependentBinariesResolver", DependentBinariesResolver.class);
                    StyledTextOutput textOutput = this.getTextOutputFactory().create(DependentComponentsReport.class);
                    TextDependentComponentsReportRenderer reportRenderer = new TextDependentComponentsReportRenderer(dependentBinariesResolver, this.showNonBuildable, this.showTestSuites);
                    reportRenderer.setOutput(textOutput);
                    ProjectDetails projectDetails = ProjectDetails.of((Project)project);
                    reportRenderer.startProject(projectDetails);
                    Set<ComponentSpec> allComponents = DependentComponentsUtils.getAllComponents(modelRegistry);
                    if (this.showTestSuites) {
                        allComponents.addAll(DependentComponentsUtils.getAllTestSuites(modelRegistry));
                    }
                    reportRenderer.renderComponents(this.getReportedComponents(allComponents));
                    reportRenderer.renderLegend();
                    reportRenderer.completeProject(projectDetails);
                    reportRenderer.complete();
                });
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }

    private Set<ComponentSpec> getReportedComponents(Set<ComponentSpec> allComponents) {
        if (this.components == null || this.components.isEmpty()) {
            return allComponents;
        }
        LinkedHashSet<ComponentSpec> reportedComponents = new LinkedHashSet<ComponentSpec>();
        ArrayList notFound = Lists.newArrayList(this.components);
        for (ComponentSpec candidate : allComponents) {
            String candidateName = candidate.getName();
            if (!this.components.contains(candidateName)) continue;
            reportedComponents.add(candidate);
            notFound.remove(candidateName);
        }
        if (!notFound.isEmpty()) {
            this.onComponentsNotFound(notFound);
        }
        return reportedComponents;
    }

    private void onComponentsNotFound(List<String> notFound) {
        StringBuilder error = new StringBuilder("Component");
        if (notFound.size() == 1) {
            error.append(" '").append(notFound.get(0));
        } else {
            String last = notFound.remove(notFound.size() - 1);
            error.append("s '").append(Joiner.on((String)"', '").join(notFound)).append("' and '").append(last);
        }
        error.append("' not found.");
        throw new InvalidUserDataException(error.toString());
    }
}

