/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.fenix.onboarding.redesign.view.sync

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.height
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.PreviewLightDark
import androidx.compose.ui.unit.dp
import org.mozilla.fenix.R
import org.mozilla.fenix.theme.FirefoxTheme

private val IMAGE_HEIGHT = 150.dp

/**
 * Renders the main image for the "Sync" onboarding screen.
 *
 * **This is a non-interactive, static image view only**.
 */
@Composable
fun SyncMainImage() {
    Image(
        painter = painterResource(R.drawable.android_sync_illustration),
        contentDescription = null, // Decorative only
        modifier = Modifier.height(IMAGE_HEIGHT),
    )
}

@PreviewLightDark
@Composable
private fun SyncMainImagePreview() {
    FirefoxTheme {
        Box(Modifier.background(FirefoxTheme.colors.layer1)) {
            SyncMainImage()
        }
    }
}
