// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package traces

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteTracesAcceptedCode is the HTTP code returned for type DeleteTracesAccepted
const DeleteTracesAcceptedCode int = 202

/*
DeleteTracesAccepted Configuration change accepted and reload requested

swagger:response deleteTracesAccepted
*/
type DeleteTracesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteTracesAccepted creates DeleteTracesAccepted with default headers values
func NewDeleteTracesAccepted() *DeleteTracesAccepted {

	return &DeleteTracesAccepted{}
}

// WithReloadID adds the reloadId to the delete traces accepted response
func (o *DeleteTracesAccepted) WithReloadID(reloadID string) *DeleteTracesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete traces accepted response
func (o *DeleteTracesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteTracesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteTracesNoContentCode is the HTTP code returned for type DeleteTracesNoContent
const DeleteTracesNoContentCode int = 204

/*
DeleteTracesNoContent Traces section deleted

swagger:response deleteTracesNoContent
*/
type DeleteTracesNoContent struct {
}

// NewDeleteTracesNoContent creates DeleteTracesNoContent with default headers values
func NewDeleteTracesNoContent() *DeleteTracesNoContent {

	return &DeleteTracesNoContent{}
}

// WriteResponse to the client
func (o *DeleteTracesNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteTracesNotFoundCode is the HTTP code returned for type DeleteTracesNotFound
const DeleteTracesNotFoundCode int = 404

/*
DeleteTracesNotFound The specified resource was not found

swagger:response deleteTracesNotFound
*/
type DeleteTracesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTracesNotFound creates DeleteTracesNotFound with default headers values
func NewDeleteTracesNotFound() *DeleteTracesNotFound {

	return &DeleteTracesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete traces not found response
func (o *DeleteTracesNotFound) WithConfigurationVersion(configurationVersion string) *DeleteTracesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete traces not found response
func (o *DeleteTracesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete traces not found response
func (o *DeleteTracesNotFound) WithPayload(payload *models.Error) *DeleteTracesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete traces not found response
func (o *DeleteTracesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTracesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteTracesDefault General Error

swagger:response deleteTracesDefault
*/
type DeleteTracesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTracesDefault creates DeleteTracesDefault with default headers values
func NewDeleteTracesDefault(code int) *DeleteTracesDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteTracesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete traces default response
func (o *DeleteTracesDefault) WithStatusCode(code int) *DeleteTracesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete traces default response
func (o *DeleteTracesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete traces default response
func (o *DeleteTracesDefault) WithConfigurationVersion(configurationVersion string) *DeleteTracesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete traces default response
func (o *DeleteTracesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete traces default response
func (o *DeleteTracesDefault) WithPayload(payload *models.Error) *DeleteTracesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete traces default response
func (o *DeleteTracesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTracesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
