// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_load

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetCrtLoadsOKCode is the HTTP code returned for type GetCrtLoadsOK
const GetCrtLoadsOKCode int = 200

/*
GetCrtLoadsOK Successful operation

swagger:response getCrtLoadsOK
*/
type GetCrtLoadsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.CrtLoads `json:"body,omitempty"`
}

// NewGetCrtLoadsOK creates GetCrtLoadsOK with default headers values
func NewGetCrtLoadsOK() *GetCrtLoadsOK {

	return &GetCrtLoadsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt loads o k response
func (o *GetCrtLoadsOK) WithConfigurationVersion(configurationVersion string) *GetCrtLoadsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt loads o k response
func (o *GetCrtLoadsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt loads o k response
func (o *GetCrtLoadsOK) WithPayload(payload models.CrtLoads) *GetCrtLoadsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt loads o k response
func (o *GetCrtLoadsOK) SetPayload(payload models.CrtLoads) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtLoadsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.CrtLoads{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetCrtLoadsDefault General Error

swagger:response getCrtLoadsDefault
*/
type GetCrtLoadsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtLoadsDefault creates GetCrtLoadsDefault with default headers values
func NewGetCrtLoadsDefault(code int) *GetCrtLoadsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetCrtLoadsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get crt loads default response
func (o *GetCrtLoadsDefault) WithStatusCode(code int) *GetCrtLoadsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get crt loads default response
func (o *GetCrtLoadsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get crt loads default response
func (o *GetCrtLoadsDefault) WithConfigurationVersion(configurationVersion string) *GetCrtLoadsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt loads default response
func (o *GetCrtLoadsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt loads default response
func (o *GetCrtLoadsDefault) WithPayload(payload *models.Error) *GetCrtLoadsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt loads default response
func (o *GetCrtLoadsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtLoadsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
