// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetBindFrontendOKCode is the HTTP code returned for type GetBindFrontendOK
const GetBindFrontendOKCode int = 200

/*
GetBindFrontendOK Successful operation

swagger:response getBindFrontendOK
*/
type GetBindFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewGetBindFrontendOK creates GetBindFrontendOK with default headers values
func NewGetBindFrontendOK() *GetBindFrontendOK {

	return &GetBindFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind frontend o k response
func (o *GetBindFrontendOK) WithConfigurationVersion(configurationVersion string) *GetBindFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind frontend o k response
func (o *GetBindFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind frontend o k response
func (o *GetBindFrontendOK) WithPayload(payload *models.Bind) *GetBindFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind frontend o k response
func (o *GetBindFrontendOK) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetBindFrontendNotFoundCode is the HTTP code returned for type GetBindFrontendNotFound
const GetBindFrontendNotFoundCode int = 404

/*
GetBindFrontendNotFound The specified resource already exists

swagger:response getBindFrontendNotFound
*/
type GetBindFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindFrontendNotFound creates GetBindFrontendNotFound with default headers values
func NewGetBindFrontendNotFound() *GetBindFrontendNotFound {

	return &GetBindFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind frontend not found response
func (o *GetBindFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetBindFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind frontend not found response
func (o *GetBindFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind frontend not found response
func (o *GetBindFrontendNotFound) WithPayload(payload *models.Error) *GetBindFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind frontend not found response
func (o *GetBindFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetBindFrontendDefault General Error

swagger:response getBindFrontendDefault
*/
type GetBindFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindFrontendDefault creates GetBindFrontendDefault with default headers values
func NewGetBindFrontendDefault(code int) *GetBindFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetBindFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get bind frontend default response
func (o *GetBindFrontendDefault) WithStatusCode(code int) *GetBindFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get bind frontend default response
func (o *GetBindFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get bind frontend default response
func (o *GetBindFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetBindFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind frontend default response
func (o *GetBindFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind frontend default response
func (o *GetBindFrontendDefault) WithPayload(payload *models.Error) *GetBindFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind frontend default response
func (o *GetBindFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
